// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::describe_limits::_describe_limits_output::DescribeLimitsOutputBuilder;

pub use crate::operation::describe_limits::_describe_limits_input::DescribeLimitsInputBuilder;

impl crate::operation::describe_limits::builders::DescribeLimitsInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::describe_limits::DescribeLimitsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_limits::DescribeLimitsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.describe_limits();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `DescribeLimits`.
///
/// <p>Describes the shard limits and usage for the account.</p>
/// <p>If you update your account limits, the old limits might be returned for a few minutes.</p>
/// <p>This operation has a limit of one transaction per second per account.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct DescribeLimitsFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::describe_limits::builders::DescribeLimitsInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::describe_limits::DescribeLimitsOutput,
        crate::operation::describe_limits::DescribeLimitsError,
    > for DescribeLimitsFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::describe_limits::DescribeLimitsOutput,
            crate::operation::describe_limits::DescribeLimitsError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl DescribeLimitsFluentBuilder {
    /// Creates a new `DescribeLimitsFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the DescribeLimits as a reference.
    pub fn as_input(&self) -> &crate::operation::describe_limits::builders::DescribeLimitsInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::describe_limits::DescribeLimitsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_limits::DescribeLimitsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::describe_limits::DescribeLimits::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::describe_limits::DescribeLimits::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::describe_limits::DescribeLimitsOutput,
        crate::operation::describe_limits::DescribeLimitsError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
}
