/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.DataHolder;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.util.Map;

public class CustomObjectInputStream
extends ObjectInputStream {
    private StreamCallback callback;
    private static final String DATA_HOLDER_KEY = (class$com$thoughtworks$xstream$core$util$CustomObjectInputStream == null ? (class$com$thoughtworks$xstream$core$util$CustomObjectInputStream = CustomObjectInputStream.class$("com.thoughtworks.xstream.core.util.CustomObjectInputStream")) : class$com$thoughtworks$xstream$core$util$CustomObjectInputStream).getName();
    static /* synthetic */ Class class$com$thoughtworks$xstream$core$util$CustomObjectInputStream;

    public static synchronized CustomObjectInputStream getInstance(DataHolder whereFrom, StreamCallback callback) {
        try {
            CustomObjectInputStream result = (CustomObjectInputStream)whereFrom.get(DATA_HOLDER_KEY);
            if (result == null) {
                result = new CustomObjectInputStream(callback);
                whereFrom.put(DATA_HOLDER_KEY, result);
            } else {
                result.setCallback(callback);
            }
            return result;
        }
        catch (IOException e) {
            throw new ConversionException("Cannot create CustomObjectStream", e);
        }
    }

    public CustomObjectInputStream(StreamCallback callback) throws IOException, SecurityException {
        this.callback = callback;
    }

    public void setCallback(StreamCallback callback) {
        this.callback = callback;
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException {
        this.callback.defaultReadObject();
    }

    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        return this.callback.readFromStream();
    }

    public boolean readBoolean() throws IOException {
        return (Boolean)this.callback.readFromStream();
    }

    public byte readByte() throws IOException {
        return (Byte)this.callback.readFromStream();
    }

    public int readInt() throws IOException {
        return (Integer)this.callback.readFromStream();
    }

    public char readChar() throws IOException {
        return ((Character)this.callback.readFromStream()).charValue();
    }

    public float readFloat() throws IOException {
        return ((Float)this.callback.readFromStream()).floatValue();
    }

    public double readDouble() throws IOException {
        return (Double)this.callback.readFromStream();
    }

    public long readLong() throws IOException {
        return (Long)this.callback.readFromStream();
    }

    public short readShort() throws IOException {
        return (Short)this.callback.readFromStream();
    }

    public String readUTF() throws IOException {
        return (String)this.callback.readFromStream();
    }

    public void readFully(byte[] buf) throws IOException {
        this.readFully(buf, 0, buf.length);
    }

    public void readFully(byte[] buf, int off, int len) throws IOException {
        byte[] b = (byte[])this.callback.readFromStream();
        System.arraycopy(b, 0, buf, off, len);
    }

    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
        return new CustomGetField(this.callback.readFieldsFromStream());
    }

    public void registerValidation(ObjectInputValidation validation, int priority) throws NotActiveException, InvalidObjectException {
        this.callback.registerValidation(validation, priority);
    }

    public int available() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        this.callback.close();
    }

    public int readUnsignedByte() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    public Object readUnshared() throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    public int readUnsignedShort() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int skipBytes(int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] b) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    public void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean markSupported() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CustomGetField
    extends ObjectInputStream.GetField {
        private Map fields;

        public CustomGetField(Map fields) {
            this.fields = fields;
        }

        public ObjectStreamClass getObjectStreamClass() {
            throw new UnsupportedOperationException();
        }

        private Object get(String name) {
            return this.fields.get(name);
        }

        public boolean defaulted(String name) throws IOException {
            return !this.fields.containsKey(name);
        }

        public byte get(String name, byte val) throws IOException {
            return this.defaulted(name) ? val : (Byte)this.get(name);
        }

        public char get(String name, char val) throws IOException {
            return this.defaulted(name) ? val : ((Character)this.get(name)).charValue();
        }

        public double get(String name, double val) throws IOException {
            return this.defaulted(name) ? val : (Double)this.get(name);
        }

        public float get(String name, float val) throws IOException {
            return this.defaulted(name) ? val : ((Float)this.get(name)).floatValue();
        }

        public int get(String name, int val) throws IOException {
            return this.defaulted(name) ? val : (Integer)this.get(name);
        }

        public long get(String name, long val) throws IOException {
            return this.defaulted(name) ? val : (Long)this.get(name);
        }

        public short get(String name, short val) throws IOException {
            return this.defaulted(name) ? val : (Short)this.get(name);
        }

        public boolean get(String name, boolean val) throws IOException {
            return this.defaulted(name) ? val : (Boolean)this.get(name);
        }

        public Object get(String name, Object val) throws IOException {
            return this.defaulted(name) ? val : this.get(name);
        }
    }

    public static interface StreamCallback {
        public Object readFromStream() throws IOException;

        public Map readFieldsFromStream() throws IOException;

        public void defaultReadObject() throws IOException;

        public void registerValidation(ObjectInputValidation var1, int var2) throws NotActiveException, InvalidObjectException;

        public void close() throws IOException;
    }
}

