/*
 * Copyright (c) 2023 Balazs Scheidler <balazs.scheidler@axoflow.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * As an additional exemption you are allowed to compile & link against the
 * OpenSSL libraries as published by the OpenSSL project. See the file
 * COPYING for details.
 *
 */
#include "object-null.h"

static gboolean
_truthy(FilterXObject *s)
{
  return FALSE;
}

static gboolean
_marshal(FilterXObject *s, GString *repr, LogMessageValueType *t)
{
  *t = LM_VT_NULL;
  return TRUE;
}

static gboolean
_map_to_json(FilterXObject *s, struct json_object **object)
{
  *object = NULL;
  return TRUE;
}

static gboolean
_null_repr(FilterXObject *s, GString *repr)
{
  g_string_append_len(repr, "null", 4);
  return TRUE;
}

FilterXObject *
filterx_null_new(void)
{
  FilterXObject *self = filterx_object_new(&FILTERX_TYPE_NAME(null));
  return self;
}

FILTERX_DEFINE_TYPE(null, FILTERX_TYPE_NAME(object),
                    .map_to_json = _map_to_json,
                    .marshal = _marshal,
                    .repr = _null_repr,
                    .truthy = _truthy,
                   );
