/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.security.cert.CertViewer;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.X509Certificate;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class EvaluateCertGUI {
    public static final int REJECT = 0;
    public static final int ACCEPT_ONCE = 1;
    public static final int ACCEPT_ALWAYS = 2;
    CBButton View;
    CBButton Reject;
    CBButton Accept_Once;
    CBButton Accept_Always;
    CBPanel display;
    CertViewer viewer;
    Frame owner;

    public EvaluateCertGUI(Frame rootFrame) {
        this.owner = rootFrame;
    }

    public int isTrusted(X509Certificate cert) {
        final X509Certificate certificate = cert;
        this.display = new CBPanel();
        this.display.addWide(new JLabel("The ldap server you are connecting to is using"), 3);
        this.display.newLine();
        this.display.addWide(new JLabel("an unknown security certificate."), 3);
        this.display.newLine();
        this.display.newLine();
        this.display.add(new JLabel("Subject: "));
        this.display.addWide(new JLabel(certificate.getSubjectDN().getName()), 2);
        this.display.newLine();
        this.display.add(new JLabel("Valid from: "));
        this.display.addWide(new JLabel(certificate.getNotBefore().toString()), 2);
        this.display.newLine();
        this.display.add(new JLabel("Valid to: "));
        this.display.addWide(new JLabel(certificate.getNotAfter().toString()), 2);
        this.display.newLine();
        this.display.add(new JLabel(""));
        this.display.newLine();
        this.display.addWide(new JLabel("Would you like to continue anyway?"), 3);
        this.display.newLine();
        this.View = new CBButton("View Certificate", "Examine the Certificate Details");
        this.display.add(this.View);
        this.display.newLine();
        this.View.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EvaluateCertGUI.this.viewer = new CertViewer(EvaluateCertGUI.this.owner, certificate, 0);
                EvaluateCertGUI.this.viewer.setVisible(true);
            }
        });
        this.Reject = new CBButton("End Connection", "Reject the certificate");
        this.Accept_Once = new CBButton("This Session Only", "Allow, but do not add to your trusted keystore.");
        this.Accept_Always = new CBButton("Always", "Add the server certificate to your trusted keystore");
        Object[] optionButtons = new CBButton[]{this.Reject, this.Accept_Once, this.Accept_Always};
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                Component sourceButton = (Component)a.getSource();
                ((JOptionPane)sourceButton.getParent().getParent()).setValue(sourceButton);
            }
        };
        this.Reject.addActionListener(buttonListener);
        this.Accept_Once.addActionListener(buttonListener);
        this.Accept_Always.addActionListener(buttonListener);
        int v = JOptionPane.showOptionDialog(null, this.display, "Server CA Certificate missing", -1, 1, null, optionButtons, optionButtons[0]);
        if (v == -1) {
            v = 0;
        }
        return v;
    }
}

