/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.cert.extensions;

import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.cert.extensions.V3Extension;

public class PolicyConstraints
implements V3Extension {
    String value = null;

    @Override
    public void init(ASN1Object asn1object) throws Exception {
        if (!asn1object.isASN1Type(ASN1Type.SEQUENCE)) {
            throw new Exception("Wrong ASN.1 type for PolicyConstraints");
        }
        if (asn1object.size() >= 1) {
            ASN1Object requireExplicitPolicy = asn1object.getComponent(0);
            if (requireExplicitPolicy.getValue() == null) {
                throw new Exception("Wrong ASN.1 type for PolicyConstraints.requireExplicitPolicy");
            }
            this.value = "requireExplicitPolicy: " + requireExplicitPolicy.getValue();
        }
        if (asn1object.size() >= 2) {
            ASN1Object inhibitPolicyMapping = asn1object.getComponent(1);
            if (inhibitPolicyMapping.getValue() == null) {
                throw new Exception("Wrong ASN.1 type for PolicyConstraints.inhibitPolicyMapping");
            }
            this.value = this.value + "\ninhibitPolicyMapping: " + inhibitPolicyMapping.getValue();
        }
    }

    public String toString() {
        return this.value;
    }
}

