/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;

public class ButtonRegister {
    ButtonContainer buttonRegister = null;
    public static final String CONNECT = "CONNECT";
    public static final String DISCONNECT = "DISCONNECT";
    public static final String PRINT = "PRINT";
    public static final String CUT = "CUT";
    public static final String COPY = "COPY";
    public static final String COPY_DN = "COPY_DN";
    public static final String PASTE = "PASTE";
    public static final String PASTE_ALIAS = "PASTE_ALIAS";
    public static final String DELETE = "DELETE";
    public static final String NEW = "NEW";
    public static final String NEW_WINDOW = "NEW_WINDOW";
    public static final String RENAME = "RENAME";
    public static final String REFRESH = "REFRESH";
    public static final String REFRESH_TREE = "REFRESH_TREE";
    public static final String BOOKMARKS = "BOOKMARKS";
    public static final String SEARCH = "SEARCH";
    public static final String STOP = "STOP";
    public static final String LDIF = "LDIF";
    private final ArrayList<String> components = new ArrayList<String>(Arrays.asList("CONNECT", "DISCONNECT", "PRINT", "CUT", "COPY", "COPY_DN", "PASTE", "PASTE_ALIAS", "DELETE", "NEW", "NEW_WINDOW", "RENAME", "REFRESH", "REFRESH_TREE", "BOOKMARKS", "SEARCH", "STOP", "LDIF"));
    private ArrayList<String> editingButtons = new ArrayList<String>(Arrays.asList("COPY", "COPY_DN", "CUT", "DELETE", "NEW", "RENAME", "LDIF"));
    private List<String> searchButtons = Arrays.asList("BOOKMARKS", "SEARCH");

    public void registerItem(String key, Component comp) {
        if (this.buttonRegister == null) {
            this.buttonRegister = new ButtonContainer();
        }
        if (!this.components.contains(key)) {
            this.components.add(key);
        }
        this.buttonRegister.put(key, comp);
    }

    public void setItemEnabled(String key, boolean enabled) {
        ArrayList temp;
        if (this.buttonRegister != null && (temp = this.buttonRegister.get(key)) != null) {
            for (int i = 0; i < temp.size(); ++i) {
                ((Component)temp.get(i)).setEnabled(enabled);
            }
        }
    }

    public void setAsEditingButton(String key) {
        this.editingButtons.add(key);
    }

    public void setEditingButtons(boolean state) {
        for (String editingButton : this.editingButtons) {
            if ((editingButton.equals(PASTE) || editingButton.equals(PASTE_ALIAS)) && !state) {
                this.setItemEnabled(editingButton, false);
            }
            this.setItemEnabled(editingButton, state);
        }
    }

    public void setDisconnectState() {
        for (String component : this.components) {
            if (component.equals(CONNECT)) {
                this.setItemEnabled(component, true);
                continue;
            }
            this.setItemEnabled(component, false);
        }
    }

    public void setConnectedState(boolean readOnly) {
        for (String component : this.components) {
            if (component.equals(STOP) || component.equals(PASTE) || component.equals(PASTE_ALIAS)) {
                this.setItemEnabled(component, false);
                continue;
            }
            if (readOnly && this.editingButtons.contains(component)) {
                this.setItemEnabled(component, false);
                continue;
            }
            this.setItemEnabled(component, true);
        }
    }

    class ButtonContainer
    extends Hashtable<String, ArrayList> {
        @Override
        public void put(String key, Component comp) {
            ArrayList<Component> temp = (ArrayList<Component>)super.get(key);
            if (temp == null) {
                temp = new ArrayList<Component>();
            }
            if (!temp.contains(comp)) {
                temp.add(comp);
            }
            super.put(key, temp);
        }

        public ArrayList get(String key) {
            return (ArrayList)super.get(key);
        }
    }
}

