/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.editor;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBCache;
import com.ca.commons.cbutil.CBHelpSystem;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.cbutil.Theme;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.editor.audioaccessory;
import com.ca.directory.jxplorer.editor.basicbinaryeditor;
import com.ca.directory.jxplorer.editor.editablebinary;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import sun.audio.AudioPlayer;
import sun.audio.AudioStream;

public class audioeditor
extends basicbinaryeditor {
    protected CBButton btnPlay;
    protected CBButton btnStop;
    protected JLabel label;
    protected File file;
    protected AudioStream audioStream;
    protected audioaccessory audioAccess;
    private static Logger log = Logger.getLogger(audioeditor.class.getName());

    public audioeditor(Frame owner) {
        this(owner, false);
    }

    public audioeditor(Frame owner, boolean viewable) {
        super(owner);
        this.setModal(true);
        this.setTitle(CBIntText.get("Audio"));
        this.display = new CBPanel();
        this.label = new JLabel(new ImageIcon(Theme.getInstance().getDirImages() + "audio.gif"));
        this.label.setOpaque(true);
        this.label.setBackground(Color.white);
        this.btnPlay = new CBButton(CBIntText.get("Play"), CBIntText.get("Click here to play the audio clip."));
        this.btnPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                audioeditor.this.audioStop();
                audioeditor.this.audioPlay();
            }
        });
        this.btnStop = new CBButton(CBIntText.get("Stop"), CBIntText.get("Click here to stop playing the audio clip."));
        this.btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                audioeditor.this.audioStop();
            }
        });
        this.btnLoad = new CBButton(CBIntText.get("Load"), CBIntText.get("Click here to load an external audio file."));
        this.btnLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                audioeditor.this.audioStop();
                audioeditor.this.load();
            }
        });
        this.btnSave = new CBButton(CBIntText.get("Save"), CBIntText.get("Click here to save the audio clip to an external file."));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                audioeditor.this.audioStop();
                audioeditor.this.save();
            }
        });
        this.btnOK = new CBButton(CBIntText.get("OK"), CBIntText.get("Click here to make the changes (remember to click Submit in the table editor)."));
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                audioeditor.this.audioStop();
                audioeditor.this.setValue();
            }
        });
        this.btnCancel = new CBButton(CBIntText.get("Cancel"), CBIntText.get("Click here to exit."));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                audioeditor.this.audioStop();
                audioeditor.this.quit();
            }
        });
        this.btnHelp = new CBButton(CBIntText.get("Help"), CBIntText.get("Click here for Help."));
        CBHelpSystem.useDefaultHelp(this.btnHelp, "edit.audio");
        this.display.makeHeavy();
        this.display.addln(this.label);
        this.display.makeLight();
        JPanel buttonPanelTop = new JPanel();
        JPanel buttonPanelBottom = new JPanel();
        buttonPanelTop.add(this.btnPlay);
        buttonPanelTop.add(this.btnStop);
        buttonPanelTop.add(this.btnHelp);
        buttonPanelBottom.add(this.btnLoad);
        buttonPanelBottom.add(this.btnSave);
        buttonPanelBottom.add(this.btnOK);
        buttonPanelBottom.add(this.btnCancel);
        this.display.addln(buttonPanelTop);
        this.display.addln(buttonPanelBottom);
        this.getContentPane().add(this.display);
        this.setSize(300, 320);
        CBUtility.center(this, owner);
    }

    public void audioPlay() {
        try {
            this.audioStream = new AudioStream((InputStream)new ByteArrayInputStream(this.bytes));
        }
        catch (IOException e) {
            CBUtility.error(CBIntText.get("Error with audio file") + ": " + e);
        }
        catch (NullPointerException ee) {
            log.log(Level.WARNING, CBIntText.get("No data available") + ": ", ee);
        }
        AudioPlayer.player.start((InputStream)this.audioStream);
    }

    public void audioStop() {
        AudioPlayer.player.stop((InputStream)this.audioStream);
    }

    @Override
    public void setValue(editablebinary editMe) {
        this.editMe = editMe;
        this.bytes = editMe.getValue();
        this.oldBytes = this.bytes;
        if (this.bytes == null) {
            this.setButtons(false);
        }
    }

    @Override
    protected void load() {
        if (this.currentDN != null) {
            CBCache.cleanCache(this.currentDN.toString());
        }
        JFileChooser chooser = new JFileChooser(JXConfig.getProperty("binary.homeDir"));
        this.audioAccess = new audioaccessory();
        chooser.setAccessory(this.audioAccess);
        chooser.addPropertyChangeListener(this.audioAccess);
        if (chooser.showOpenDialog(this) != 0) {
            this.audioAccess.stopPlay();
            return;
        }
        this.audioAccess.stopPlay();
        this.file = chooser.getSelectedFile();
        JXConfig.setProperty("binary.homeDir", chooser.getSelectedFile().getParent());
        try {
            FileInputStream input = new FileInputStream(this.file);
            int length = (int)this.file.length();
            if (length > 0) {
                this.bytes = new byte[length];
                int read = input.read(this.bytes);
                this.setButtons(true);
            }
            input.close();
        }
        catch (IOException e) {
            CBUtility.error(CBIntText.get("Error writing to the file") + ": " + e);
        }
    }

    @Override
    protected void save() {
        JFileChooser chooser = new JFileChooser();
        if (chooser.showSaveDialog(this.frame) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        try {
            FileOutputStream output = new FileOutputStream(file);
            output.write(this.bytes);
            output.close();
        }
        catch (IOException e) {
            CBUtility.error(CBIntText.get("Error writing to the file") + ": " + e);
        }
    }

    @Override
    public void setButtons(boolean enabled) {
        this.btnStop.setEnabled(enabled);
        this.btnPlay.setEnabled(enabled);
        this.btnSave.setEnabled(enabled);
        this.btnOK.setEnabled(enabled);
    }

    @Override
    public byte[] getNewValue() {
        if (this.bytes != null && this.bytes.length != 0) {
            return this.bytes;
        }
        return null;
    }

    @Override
    public void setValue() {
        if (this.isChanged()) {
            this.editMe.setValue(this.getNewValue());
        }
        this.quit();
    }
}

