/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.editor;

import com.ca.commons.cbutil.CBAction;
import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBCache;
import com.ca.commons.cbutil.CBHelpSystem;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBParse;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.naming.DN;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.editor.abstractbinaryeditor;
import com.ca.directory.jxplorer.editor.editablebinary;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class basicbinaryeditor
extends JDialog
implements abstractbinaryeditor {
    protected editablebinary editMe = null;
    protected JTextArea field;
    protected CBButton btnLoad;
    protected CBButton btnSave;
    protected CBButton btnView;
    protected CBButton btnOK;
    protected CBButton btnCancel;
    protected CBButton btnHelp;
    protected CBButton btnEdit;
    protected Frame frame;
    protected CBPanel display;
    protected boolean editHex;
    protected StringBuffer hex;
    protected byte[] bytes;
    protected byte[] oldBytes;
    protected DN currentDN = null;
    private static final String NODATAMSG = "No data available";
    private String viewCommand = "rundll32.exe cryptext.dll,CryptExtOpenCER ";
    private static final Logger log = Logger.getLogger(basicbinaryeditor.class.getName());

    public basicbinaryeditor(Frame owner) {
        this(owner, false);
    }

    public basicbinaryeditor(Frame owner, boolean viewable) {
        super(owner);
        this.setModal(true);
        this.setTitle(CBIntText.get("Binary Data"));
        this.editHex = false;
        this.display = new CBPanel();
        this.addMainViewComponent();
        this.btnView = new CBButton(CBIntText.get("View"), CBIntText.get(""));
        this.btnView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                basicbinaryeditor.this.view();
            }
        });
        this.btnLoad = new CBButton(CBIntText.get("Load"), CBIntText.get("Click here to load an external file."));
        this.btnLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                basicbinaryeditor.this.load();
            }
        });
        this.btnSave = new CBButton(CBIntText.get("Save"), CBIntText.get("Click here to save the data to an external file."));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                basicbinaryeditor.this.save();
            }
        });
        this.btnOK = new CBButton(CBIntText.get("OK"), CBIntText.get("Click here to make the changes (remember to click Submit in the table editor)."));
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                basicbinaryeditor.this.setValue();
            }
        });
        this.btnEdit = new CBButton(CBIntText.get("Edit"), CBIntText.get("Edit the file data in Hex."));
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                basicbinaryeditor.this.setCursor(Cursor.getPredefinedCursor(3));
                basicbinaryeditor.this.btnEdit.setEnabled(false);
                basicbinaryeditor.this.field.setText(basicbinaryeditor.this.bytes2HexString(basicbinaryeditor.this.bytes));
                basicbinaryeditor.this.field.setEnabled(true);
                basicbinaryeditor.this.editHex = true;
                basicbinaryeditor.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.btnCancel = new CBButton(CBIntText.get("Cancel"), CBIntText.get("Click here to exit."));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                basicbinaryeditor.this.quit();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.btnLoad);
        buttonPanel.add(this.btnSave);
        if (viewable) {
            buttonPanel.add(this.btnView);
        }
        buttonPanel.add(this.btnEdit);
        buttonPanel.add(this.btnOK);
        buttonPanel.add(this.btnCancel);
        buttonPanel.add(this.addHelp());
        this.display.add(buttonPanel);
        this.display.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "enter");
        this.display.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "escape");
        this.display.getActionMap().put("enter", new MyAction(10));
        this.display.getActionMap().put("escape", new MyAction(27));
        this.getContentPane().add(this.display);
        this.setSize(435, 300);
    }

    public void addMainViewComponent() {
        this.field = new JTextArea();
        this.field.setLineWrap(true);
        this.field.setEnabled(false);
        this.field.setDisabledTextColor(Color.black);
        JScrollPane scrollPane = new JScrollPane(this.field);
        scrollPane.setPreferredSize(new Dimension(310, 60));
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.display.makeHeavy();
        this.display.addln(scrollPane);
        this.display.makeLight();
    }

    public CBButton addHelp() {
        this.btnHelp = new CBButton(CBIntText.get("Help"), CBIntText.get("Click here for Help."));
        CBHelpSystem.useDefaultHelp(this.btnHelp, "edit.binary");
        return this.btnHelp;
    }

    @Override
    public void setValue(editablebinary editMe) {
        this.editHex = false;
        this.editMe = editMe;
        this.bytes = editMe.getValue();
        this.oldBytes = this.bytes;
        if (this.bytes == null || this.bytes.length == 0) {
            this.field.setText(NODATAMSG);
        } else {
            byte[] shortBytes;
            this.setButtons(true);
            if (this.bytes.length < 1000) {
                shortBytes = this.bytes;
            } else {
                shortBytes = new byte[1000];
                System.arraycopy(this.bytes, 0, shortBytes, 0, 1000);
            }
            this.field.setText(this.bytes2HexString(shortBytes));
        }
    }

    protected void load() {
        this.editHex = false;
        CBCache.cleanCache(this.currentDN.toString());
        JFileChooser chooser = new JFileChooser(JXConfig.getProperty("binary.homeDir"));
        if (chooser.showOpenDialog(this.frame) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        JXConfig.setProperty("binary.homeDir", chooser.getSelectedFile().getParent());
        try {
            FileInputStream input = new FileInputStream(file);
            int length = (int)file.length();
            if (length > 0) {
                byte[] shortBytes;
                this.setButtons(true);
                this.bytes = new byte[length];
                int read = input.read(this.bytes);
                if (this.bytes.length < 1000) {
                    shortBytes = this.bytes;
                } else {
                    shortBytes = new byte[1000];
                    System.arraycopy(this.bytes, 0, shortBytes, 0, 1000);
                }
                if (read > 0) {
                    this.field.setText(this.bytes2HexString(shortBytes));
                }
            }
            input.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error opening the file!", e);
        }
    }

    protected void save() {
        JFileChooser chooser = new JFileChooser();
        if (chooser.showSaveDialog(this.frame) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        try {
            FileOutputStream output = new FileOutputStream(file);
            if (this.editHex) {
                output.write(CBParse.hex2bytes(this.field.getText()));
            } else {
                output.write(this.bytes);
            }
            output.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error writing the file!", e);
        }
    }

    public void view() {
    }

    public void setViewCommand(String viewCommand) {
        this.viewCommand = viewCommand;
    }

    public void setButtons(boolean enabled) {
        this.btnOK.setEnabled(enabled);
        this.btnEdit.setEnabled(enabled);
        this.btnSave.setEnabled(enabled);
    }

    public boolean isChanged() {
        return !Arrays.equals(this.bytes, this.oldBytes);
    }

    @Override
    public boolean isValid() {
        if (this.field == null) {
            return false;
        }
        String newValue = this.field.getText();
        return newValue != null && newValue.length() > 0;
    }

    public byte[] getNewValue() {
        if (this.editHex) {
            String newvalue = this.field.getText();
            if (newvalue != null && newvalue.length() != 0) {
                return CBParse.hex2bytes(newvalue);
            }
            return null;
        }
        return this.bytes;
    }

    public byte[] getOldValue() {
        return this.oldBytes;
    }

    public void setValue() {
        if (this.isChanged()) {
            this.editMe.setValue(this.getNewValue());
        }
        this.quit();
    }

    public String bytes2HexString(byte[] bytesForConversion) {
        if (bytesForConversion != null) {
            this.setEnabled(true);
            this.hex = new StringBuffer(bytesForConversion.length * 2);
            try {
                for (int i = 0; i < bytesForConversion.length; ++i) {
                    this.hex.append(CBParse.byte2Hex(bytesForConversion[i]));
                }
                return this.hex.toString();
            }
            catch (Exception e) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                CBUtility.error("Problem parsing byte to hex: " + e);
            }
        }
        this.setButtons(false);
        return NODATAMSG;
    }

    public void quit() {
        this.setVisible(false);
        this.dispose();
    }

    public void setDN(DN dn) {
        this.currentDN = dn;
    }

    private class MyAction
    extends CBAction {
        public MyAction(int key) {
            super(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.getKey() == 27) {
                basicbinaryeditor.this.quit();
            } else if (this.getKey() == 10) {
                basicbinaryeditor.this.setValue();
            }
        }
    }
}

