/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.jxworkbench.reports;

import com.ca.commons.naming.DN;
import com.ca.directory.jxplorer.broker.JNDIDataBroker;
import com.pegacat.jxworkbench.reports.JRLDAPDataSource;
import com.pegacat.jxworkbench.reports.JRLDAPQueryExecuter;
import com.pegacat.jxworkbench.reports.JXWReport;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXhtmlExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.oasis.JROdsExporter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JasperViewer;

public class JasperApplication {
    private File reportFile;
    private File compiledFile;
    private String reportFileNameStem;
    private File outputDirectory;
    private File outputPrintFile;
    private String[] outputFormats;
    private DN reportDN;
    private JNDIDataBroker broker;
    private JRLDAPDataSource dataSource = null;
    private static Logger log = Logger.getLogger(JXWReport.class.getName());

    public JasperApplication(JNDIDataBroker JNDIbroker, File report, File outputDir, String[] outputs, DN reportDN) {
        this.reportFile = report;
        this.outputDirectory = outputDir;
        this.reportFileNameStem = report.getName().substring(0, report.getName().indexOf(46));
        System.out.println("XXX Got report file name as: " + this.reportFileNameStem);
        this.outputPrintFile = new File(this.outputDirectory, this.reportFileNameStem + ".jrprint");
        this.outputFormats = outputs;
        this.broker = JNDIbroker;
        JRLDAPQueryExecuter.setDefaultJNDIBroker(this.broker);
        JRLDAPQueryExecuter.setDefaultDN(reportDN);
    }

    public JasperApplication(JRLDAPDataSource forcedDataSource, File report, File outputDir, String[] outputs) {
        this.reportFile = report;
        this.outputDirectory = outputDir;
        this.reportFileNameStem = report.getName().substring(0, report.getName().indexOf(46));
        this.outputPrintFile = new File(this.outputDirectory, this.reportFileNameStem + ".jrprint");
        this.outputFormats = outputs;
        this.dataSource = forcedDataSource;
    }

    public static void initJasperProperties() {
        DefaultJasperReportsContext reportsContext = null;
        if (new File("jasperreportsX.properties").exists()) {
            System.setProperty("net.sf.jasperreports.properties", "jasperreports.properties");
            try {
                reportsContext = DefaultJasperReportsContext.getInstance();
            }
            catch (ExceptionInInitializerError e) {
                log.severe("unable to initialise jasper reports");
                e.printStackTrace();
            }
        } else {
            System.clearProperty("net.sf.jasperreports.properties");
            reportsContext = DefaultJasperReportsContext.getInstance();
            reportsContext.setProperty("net.sf.jasperreports.query.executer.factory.ldap", "com.pegacat.jxworkbench.reports.JRLDAPQueryExecuterFactory");
            reportsContext.setProperty("net.sf.jasperreports.query.executer.factory.LDAP", "com.pegacat.jxworkbench.reports.JRLDAPQueryExecuterFactory");
        }
    }

    protected Map<String, String> setupParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("ReportTitle", "User Report");
        parameters.put("DataFile", "JRLDAPDataSource.java");
        SimpleDateFormat ldapFormat = new SimpleDateFormat("yyyyMMddkkmmss'Z'");
        long currentTime = System.currentTimeMillis();
        long day = 86400000L;
        parameters.put("today", ldapFormat.format(new Date(currentTime)));
        parameters.put("day_prior", ldapFormat.format(new Date(currentTime - day)));
        parameters.put("week_prior", ldapFormat.format(new Date(currentTime - 7L * day)));
        parameters.put("thirty_days_prior", ldapFormat.format(new Date(currentTime - 30L * day)));
        parameters.put("year_prior", ldapFormat.format(new Date(currentTime - 365L * day)));
        for (String key : parameters.keySet()) {
            System.out.println("  parameters: " + key + " : " + (String)parameters.get(key));
        }
        return parameters;
    }

    public boolean doesCompiledReportExist() throws JRException {
        if (!this.reportFile.exists()) {
            throw new JRException("report file: " + this.reportFile.getAbsolutePath() + " does not exist");
        }
        String reportFileName = this.reportFile.getName();
        if (reportFileName.toLowerCase().endsWith(".jasper")) {
            this.setCompiledReportDirectly();
            return false;
        }
        if (this.reportFile.getName().toLowerCase().endsWith(".jrxml")) {
            String destFileName = this.outputDirectory + File.separator + reportFileName.substring(0, reportFileName.length() - 6) + ".jasper";
            this.compiledFile = new File(destFileName);
            if (this.compiledFile.exists() && this.compiledFile.lastModified() > this.reportFile.lastModified()) {
                log.info("skipping compilation for report File: " + reportFileName + " as compiled .jasper file is more recent");
                return false;
            }
            return true;
        }
        throw new JRException("unknown file type for report file: " + this.reportFile.getName());
    }

    public void compile() throws JRException {
        String reportFileName = this.reportFile.getName();
        String destFileName = this.outputDirectory + File.separator + reportFileName.substring(0, reportFileName.length() - 6) + ".jasper";
        this.compiledFile = new File(destFileName);
        JasperCompileManager.compileReportToFile((String)this.reportFile.getAbsolutePath(), (String)destFileName);
        if (!this.compiledFile.exists()) {
            throw new JRException("unable to compile " + reportFileName + " into .jasper report");
        }
    }

    public void setCompiledReportDirectly() throws JRException {
        if (!this.reportFile.getName().toLowerCase().endsWith(".jasper")) {
            throw new JRException("attempt to set a non '.jasper' file as the compiled report file");
        }
        this.compiledFile = this.reportFile;
    }

    public void fill() throws JRException {
        long start = System.currentTimeMillis();
        Map<String, String> parameters = this.setupParameters();
        if (this.dataSource != null) {
            JasperFillManager.fillReportToFile((String)this.compiledFile.getAbsolutePath(), (String)this.outputPrintFile.getAbsolutePath(), parameters, (JRDataSource)this.dataSource);
        } else {
            JasperFillManager.fillReportToFile((String)this.compiledFile.getAbsolutePath(), (String)this.outputPrintFile.getAbsolutePath(), parameters);
        }
        System.err.println("Filling time : " + (System.currentTimeMillis() - start) + " output to: " + this.outputPrintFile.getAbsolutePath());
    }

    public void runReport() throws JRException {
        this.fill();
        this.optionallyShowViewer();
        JRLDAPDataSource.setProgress(75);
        JRLDAPDataSource.setNote("exporting reports");
        this.exportReport();
    }

    public void optionallyShowViewer() throws JRException {
        boolean showViewer = false;
        for (String format : this.outputFormats) {
            if (!"VIEWER".equals(format)) continue;
            showViewer = true;
        }
        if (showViewer) {
            JasperViewer.viewReport((String)this.outputPrintFile.getAbsolutePath(), (boolean)false, (boolean)false);
        }
    }

    public void exportReport() throws JRException {
        for (String format : this.outputFormats) {
            if (format == null) continue;
            if (format.equals("PDF")) {
                this.pdf();
                continue;
            }
            if (format.equals("XML")) {
                this.xml();
                continue;
            }
            if (format.equals("HTML")) {
                this.html();
                continue;
            }
            if (format.equals("RTF")) {
                this.rtf();
                continue;
            }
            if (format.equals("XLS")) {
                this.xls();
                continue;
            }
            if (format.equals("JXL")) {
                this.jxl();
                continue;
            }
            if (format.equals("CSV")) {
                this.csv();
                continue;
            }
            if (format.equals("ODT")) {
                this.odt();
                continue;
            }
            if (format.equals("ODS")) {
                this.ods();
                continue;
            }
            if (format.equals("DOCX")) {
                this.docx();
                continue;
            }
            if (format.equals("XLSX")) {
                this.xlsx();
                continue;
            }
            if (format.equals("PPTX")) {
                this.pptx();
                continue;
            }
            if (format.equals("XHTML")) {
                this.xhtml();
                continue;
            }
            if (format.equals("VIEWER")) continue;
            log.severe("Export Format " + format + " not handled in JXWorkBench com.pegacat.jxworkbench.reports.JasperApplication.exportReports()");
        }
    }

    public void print() throws JRException {
        long start = System.currentTimeMillis();
        JasperPrintManager.printReport((String)this.outputPrintFile.getAbsolutePath(), (boolean)true);
        System.err.println("Printing time : " + (System.currentTimeMillis() - start));
    }

    public void pdf() throws JRException {
        long start = System.currentTimeMillis();
        File outputReportFile = new File(this.outputDirectory, this.reportFileNameStem + ".pdf");
        System.out.println("output file: " + outputReportFile.getAbsolutePath());
        JasperExportManager.exportReportToPdfFile((String)this.outputPrintFile.getAbsolutePath(), (String)outputReportFile.getAbsolutePath());
        System.err.println("PDF creation time : " + (System.currentTimeMillis() - start));
    }

    public void xml() throws JRException {
        long start = System.currentTimeMillis();
        File outputReportFile = new File(this.outputDirectory, this.reportFileNameStem + ".xml");
        JasperExportManager.exportReportToXmlFile((String)this.outputPrintFile.getAbsolutePath(), (String)outputReportFile.getAbsolutePath(), (boolean)false);
        System.err.println("XML creation time : " + (System.currentTimeMillis() - start));
    }

    public void xmlEmbed() throws JRException {
        long start = System.currentTimeMillis();
        File outputReportFile = new File(this.outputDirectory, this.reportFileNameStem + ".xml_embed");
        JasperExportManager.exportReportToXmlFile((String)this.outputPrintFile.getAbsolutePath(), (String)outputReportFile.getAbsolutePath(), (boolean)true);
        System.err.println("XML creation time : " + (System.currentTimeMillis() - start));
    }

    public void html() throws JRException {
        long start = System.currentTimeMillis();
        File outputReportFile = new File(this.outputDirectory, this.reportFileNameStem + ".pdf");
        JasperExportManager.exportReportToHtmlFile((String)this.outputPrintFile.getAbsolutePath(), (String)outputReportFile.getAbsolutePath());
        System.err.println("HTML creation time : " + (System.currentTimeMillis() - start));
    }

    public void rtf() throws JRException {
        long start = System.currentTimeMillis();
        File sourceFile = new File(this.outputPrintFile.getAbsolutePath());
        File outputReportFile = new File(this.outputDirectory, this.reportFileNameStem + ".rtf");
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject((File)sourceFile);
        JRRtfExporter exporter = new JRRtfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outputReportFile.toString());
        exporter.exportReport();
        System.err.println("RTF creation time : " + (System.currentTimeMillis() - start));
    }

    public void xls() throws JRException {
        long start = System.currentTimeMillis();
        File sourceFile = new File(this.outputPrintFile.getAbsolutePath());
        File outputReportFile = new File(this.outputDirectory, this.reportFileNameStem + ".xls");
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject((File)sourceFile);
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outputReportFile.toString());
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
        exporter.exportReport();
        System.err.println("XLS creation time : " + (System.currentTimeMillis() - start));
    }

    public void jxl() throws JRException {
        long start = System.currentTimeMillis();
        File sourceFile = new File(this.outputPrintFile.getAbsolutePath());
        File outputReportFile = new File(this.outputDirectory, this.reportFileNameStem + ".jxl.xls");
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject((File)sourceFile);
        JExcelApiExporter exporter = new JExcelApiExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outputReportFile.toString());
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.TRUE);
        exporter.exportReport();
        System.err.println("XLS creation time : " + (System.currentTimeMillis() - start));
    }

    public void csv() throws JRException {
        long start = System.currentTimeMillis();
        File sourceFile = new File(this.outputPrintFile.getAbsolutePath());
        File outputReportFile = new File(this.outputDirectory, this.reportFileNameStem + ".csv");
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject((File)sourceFile);
        JRCsvExporter exporter = new JRCsvExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outputReportFile.toString());
        exporter.exportReport();
        System.err.println("CSV creation time : " + (System.currentTimeMillis() - start));
    }

    public void odt() throws JRException {
        long start = System.currentTimeMillis();
        File sourceFile = new File(this.outputPrintFile.getAbsolutePath());
        File outputReportFile = new File(this.outputDirectory, this.reportFileNameStem + ".odt");
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject((File)sourceFile);
        JROdtExporter exporter = new JROdtExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outputReportFile.toString());
        exporter.exportReport();
        System.err.println("ODT creation time : " + (System.currentTimeMillis() - start));
    }

    public void ods() throws JRException {
        long start = System.currentTimeMillis();
        File sourceFile = new File(this.outputPrintFile.getAbsolutePath());
        File outputReportFile = new File(this.outputDirectory, this.reportFileNameStem + ".ods");
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject((File)sourceFile);
        JROdsExporter exporter = new JROdsExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outputReportFile.toString());
        exporter.exportReport();
        System.err.println("ODS creation time : " + (System.currentTimeMillis() - start));
    }

    public void docx() throws JRException {
        long start = System.currentTimeMillis();
        File sourceFile = new File(this.outputPrintFile.getAbsolutePath());
        File outputReportFile = new File(this.outputDirectory, this.reportFileNameStem + ".docx");
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject((File)sourceFile);
        JRDocxExporter exporter = new JRDocxExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outputReportFile.toString());
        exporter.exportReport();
        System.err.println("DOCX creation time : " + (System.currentTimeMillis() - start));
    }

    public void xlsx() throws JRException {
        long start = System.currentTimeMillis();
        File sourceFile = new File(this.outputPrintFile.getAbsolutePath());
        File outputReportFile = new File(this.outputDirectory, this.reportFileNameStem + ".xlsx");
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject((File)sourceFile);
        JRXlsxExporter exporter = new JRXlsxExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outputReportFile.toString());
        exporter.exportReport();
        System.err.println("XLSX creation time : " + (System.currentTimeMillis() - start));
    }

    public void pptx() throws JRException {
        long start = System.currentTimeMillis();
        File sourceFile = new File(this.outputPrintFile.getAbsolutePath());
        File outputReportFile = new File(this.outputDirectory, this.reportFileNameStem + ".pptx");
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject((File)sourceFile);
        JRPptxExporter exporter = new JRPptxExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outputReportFile.toString());
        exporter.exportReport();
        System.err.println("PPTX creation time : " + (System.currentTimeMillis() - start));
    }

    public void xhtml() throws JRException {
        long start = System.currentTimeMillis();
        File sourceFile = new File(this.outputPrintFile.getAbsolutePath());
        File outputReportFile = new File(this.outputDirectory, this.reportFileNameStem + ".xhtml");
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject((File)sourceFile);
        JRXhtmlExporter exporter = new JRXhtmlExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)outputReportFile.toString());
        exporter.exportReport();
        System.err.println("XHTML creation time : " + (System.currentTimeMillis() - start));
    }
}

