/*
 * Copyright 2004 Gentoo Foundation
 * Distributed under the terms of the GNU General Public License v2
 * $Header: /var/cvsroot/gentoo-projects/hardened/policycoreutils-extra/src/rmfilecon.c,v 1.4 2005/02/12 15:24:52 pebenito Exp $
 */

/*
 * Why is this here?  For converting selinux systems back to default profile.
 * This will always fail on a SELinux system that is enabled, regardless
 * of permissive/enforcing.  But it saves users from having to merge
 * sys-apps/attr just to use setfattr -x.
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/xattr.h>

#define XATTR_NAME_SELINUX "security.selinux"

int lrmfilecon(const char *path)
{
        return lremovexattr(path, XATTR_NAME_SELINUX);
}

int main(int argc, char **argv) 
{
	int i;

	if(argc < 2) {
		fprintf(stderr, "Usage:  %s path1 [path2 ...]\n", argv[0]);
		return 1;
	}

	for(i = 1; i < argc; i++) {
		if (lrmfilecon(argv[i])) {
			fprintf(stderr, "%s: %s: %s\n", argv[0], argv[i], strerror(errno));
			return 1;
		}
	}

	return 0;
}
