/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.api;

import org.whispersystems.signalservice.api.messages.multidevice.VerifiedMessage;

public enum TrustLevel {
    UNTRUSTED,
    TRUSTED_UNVERIFIED,
    TRUSTED_VERIFIED;

    private static TrustLevel[] cachedValues;

    public static TrustLevel fromInt(int i) {
        if (cachedValues == null) {
            cachedValues = TrustLevel.values();
        }
        return cachedValues[i];
    }

    public static TrustLevel fromVerifiedState(VerifiedMessage.VerifiedState verifiedState) {
        return switch (verifiedState) {
            default -> throw new MatchException(null, null);
            case VerifiedMessage.VerifiedState.DEFAULT -> TRUSTED_UNVERIFIED;
            case VerifiedMessage.VerifiedState.UNVERIFIED -> UNTRUSTED;
            case VerifiedMessage.VerifiedState.VERIFIED -> TRUSTED_VERIFIED;
        };
    }

    public VerifiedMessage.VerifiedState toVerifiedState() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> VerifiedMessage.VerifiedState.DEFAULT;
            case 0 -> VerifiedMessage.VerifiedState.UNVERIFIED;
            case 2 -> VerifiedMessage.VerifiedState.VERIFIED;
        };
    }

    public boolean isTrusted() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1, 2 -> true;
            case 0 -> false;
        };
    }

    static {
        cachedValues = null;
    }
}

