/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.asamk.signal.manager.storage.Utils;
import org.whispersystems.signalservice.api.storage.StorageId;

public class UnknownStorageIdStore {
    private static final String TABLE_STORAGE_ID = "storage_id";

    public static void createSql(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE storage_id (\n  _id INTEGER PRIMARY KEY,\n  type INTEGER NOT NULL,\n  storage_id BLOB UNIQUE NOT NULL\n) STRICT;\n");
        }
    }

    public Set<StorageId> getUnknownStorageIds(Connection connection) throws SQLException {
        String sql = "SELECT s.type, s.storage_id\nFROM %s s\n".formatted(TABLE_STORAGE_ID);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            Set<StorageId> set;
            block12: {
                Stream<StorageId> result = Utils.executeQueryForStream(statement, this::getStorageIdFromResultSet);
                try {
                    set = result.collect(Collectors.toSet());
                    if (result == null) break block12;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return set;
        }
    }

    public List<StorageId> getUnknownStorageIds(Connection connection, Collection<Integer> types) throws SQLException {
        String typesCommaSeparated = types.stream().map(String::valueOf).collect(Collectors.joining(","));
        String sql = "SELECT s.type, s.storage_id\nFROM %s s\nWHERE s.type IN (%s)\n".formatted(TABLE_STORAGE_ID, typesCommaSeparated);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            List<StorageId> list;
            block12: {
                Stream<StorageId> result = Utils.executeQueryForStream(statement, this::getStorageIdFromResultSet);
                try {
                    list = result.toList();
                    if (result == null) break block12;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return list;
        }
    }

    public void addUnknownStorageIds(Connection connection, Collection<StorageId> storageIds) throws SQLException {
        this.deleteUnknownStorageIds(connection, storageIds);
        String sql = "INSERT INTO %s (type, storage_id)\nVALUES (?, ?)\n".formatted(TABLE_STORAGE_ID);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            for (StorageId storageId : storageIds) {
                statement.setInt(1, storageId.getType());
                statement.setBytes(2, storageId.getRaw());
                statement.executeUpdate();
            }
        }
    }

    public void deleteUnknownStorageIds(Connection connection, Collection<StorageId> storageIds) throws SQLException {
        String sql = "DELETE FROM %s\nWHERE storage_id = ?\n".formatted(TABLE_STORAGE_ID);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            for (StorageId storageId : storageIds) {
                statement.setBytes(1, storageId.getRaw());
                statement.executeUpdate();
            }
        }
    }

    public void deleteAllUnknownStorageIds(Connection connection) throws SQLException {
        String sql = "DELETE FROM %s".formatted(TABLE_STORAGE_ID);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.executeUpdate();
        }
    }

    private StorageId getStorageIdFromResultSet(ResultSet resultSet) throws SQLException {
        int type = resultSet.getInt("type");
        byte[] storageId = resultSet.getBytes(TABLE_STORAGE_ID);
        return StorageId.forType((byte[])storageId, (int)type);
    }
}

