/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.sessions;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.storage.Database;
import org.asamk.signal.manager.storage.Utils;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.state.SessionRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.SignalServiceSessionStore;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.ServiceIdType;

public class SessionStore
implements SignalServiceSessionStore {
    private static final String TABLE_SESSION = "session";
    private static final Logger logger = LoggerFactory.getLogger(SessionStore.class);
    private final Map<Key, SessionRecord> cachedSessions = new HashMap<Key, SessionRecord>();
    private final Database database;
    private final int accountIdType;

    public static void createSql(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE session (\n  _id INTEGER PRIMARY KEY,\n  account_id_type INTEGER NOT NULL,\n  address TEXT NOT NULL,\n  device_id INTEGER NOT NULL,\n  record BLOB NOT NULL,\n  UNIQUE(account_id_type, address, device_id)\n) STRICT;\n");
        }
    }

    public SessionStore(Database database, ServiceIdType serviceIdType) {
        this.database = database;
        this.accountIdType = Utils.getAccountIdType(serviceIdType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionRecord loadSession(SignalProtocolAddress address) {
        SessionRecord sessionRecord;
        block11: {
            Key key = this.getKey(address);
            Connection connection = this.database.getConnection();
            try {
                SessionRecord sessionRecord2 = Objects.requireNonNullElseGet(this.loadSession(connection, key), SessionRecord::new);
                sessionRecord = this.cachedSessions;
                synchronized (sessionRecord) {
                    this.cachedSessions.put(key, sessionRecord2);
                }
                sessionRecord = sessionRecord2;
                if (connection == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed read from session store", e);
                }
            }
            connection.close();
        }
        return sessionRecord;
    }

    public List<SessionRecord> loadExistingSessions(List<SignalProtocolAddress> addresses) throws NoSessionException {
        ArrayList<SessionRecord> arrayList;
        block10: {
            List<Key> keys = addresses.stream().map(this::getKey).toList();
            Connection connection = this.database.getConnection();
            try {
                ArrayList<SessionRecord> sessions = new ArrayList<SessionRecord>();
                for (Key key : keys) {
                    SessionRecord sessionRecord = this.loadSession(connection, key);
                    if (sessionRecord == null) continue;
                    sessions.add(sessionRecord);
                }
                if (sessions.size() != addresses.size()) {
                    String message = "Mismatch! Asked for " + addresses.size() + " sessions, but only found " + sessions.size() + "!";
                    logger.warn(message);
                    throw new NoSessionException(message);
                }
                arrayList = sessions;
                if (connection == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed read from session store", e);
                }
            }
            connection.close();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<Integer> getSubDeviceSessions(String name) {
        ServiceId serviceId = ServiceId.parseOrThrow((String)name);
        String sql = "SELECT s.device_id\nFROM %s AS s\nWHERE s.account_id_type = ? AND s.address = ? AND s.device_id != 1\n".formatted(TABLE_SESSION);
        try (Connection connection = this.database.getConnection();){
            List<Integer> list;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setInt(1, this.accountIdType);
                    statement.setString(2, serviceId.toString());
                    list = Utils.executeQueryForStream(statement, res -> res.getInt("device_id")).toList();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from session store", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCurrentRatchetKey(ServiceId serviceId, int deviceId, ECPublicKey ratchetKey) {
        Key key = new Key(serviceId.toString(), deviceId);
        try (Connection connection = this.database.getConnection();){
            SessionRecord session = this.loadSession(connection, key);
            if (session == null) {
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = session.currentRatchetKeyMatches(ratchetKey);
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from session store", e);
        }
    }

    public void storeSession(SignalProtocolAddress address, SessionRecord session) {
        Key key = this.getKey(address);
        try (Connection connection = this.database.getConnection();){
            this.storeSession(connection, key, session);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from session store", e);
        }
    }

    public boolean containsSession(SignalProtocolAddress address) {
        boolean bl;
        block8: {
            Key key = this.getKey(address);
            Connection connection = this.database.getConnection();
            try {
                SessionRecord session = this.loadSession(connection, key);
                boolean active = SessionStore.isActive(session);
                logger.trace("Contains session {}: {} (active: {})", new Object[]{address, session != null, active});
                bl = active;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed read from session store", e);
                }
            }
            connection.close();
        }
        return bl;
    }

    public void deleteSession(SignalProtocolAddress address) {
        Key key = this.getKey(address);
        try (Connection connection = this.database.getConnection();){
            this.deleteSession(connection, key);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update session store", e);
        }
    }

    public void deleteAllSessions(String name) {
        ServiceId serviceId = ServiceId.parseOrThrow((String)name);
        this.deleteAllSessions(serviceId);
    }

    public void deleteAllSessions(ServiceId serviceId) {
        try (Connection connection = this.database.getConnection();){
            this.deleteAllSessions(connection, serviceId.toString());
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update session store", e);
        }
    }

    public void archiveSession(SignalProtocolAddress address) {
        Key key = this.getKey(address);
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            SessionRecord session = this.loadSession(connection, key);
            if (session != null) {
                session.archiveCurrentState();
                this.storeSession(connection, key, session);
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update session store", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<SignalProtocolAddress, SessionRecord> getAllAddressesWithActiveSessions(List<String> addressNames) {
        String serviceIdsCommaSeparated = addressNames.stream().map(address -> "'" + address.replaceAll("'", "''") + "'").collect(Collectors.joining(","));
        String sql = "SELECT s.address, s.device_id, s.record\nFROM %s AS s\nWHERE s.account_id_type = ? AND s.address IN (%s)\n".formatted(TABLE_SESSION, serviceIdsCommaSeparated);
        try (Connection connection = this.database.getConnection();){
            Map<SignalProtocolAddress, SessionRecord> map;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setInt(1, this.accountIdType);
                    map = Utils.executeQueryForStream(statement, res -> new Pair<Key, SessionRecord>(this.getKeyFromResultSet(res), this.getSessionRecordFromResultSet(res))).filter(pair -> SessionStore.isActive((SessionRecord)pair.second())).collect(Collectors.toMap(pair -> new SignalProtocolAddress(((Key)pair.first()).address(), ((Key)pair.first()).deviceId()), Pair::second));
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return map;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from session store", e);
        }
    }

    public void archiveAllSessions() {
        String sql = "SELECT s.address, s.device_id, s.record\nFROM %s AS s\nWHERE s.account_id_type = ?\n".formatted(TABLE_SESSION);
        try (Connection connection = this.database.getConnection();){
            List<Pair> records;
            connection.setAutoCommit(false);
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setInt(1, this.accountIdType);
                records = Utils.executeQueryForStream(statement, res -> new Pair<Key, SessionRecord>(this.getKeyFromResultSet(res), this.getSessionRecordFromResultSet(res))).filter(Objects::nonNull).toList();
            }
            for (Pair record : records) {
                ((SessionRecord)record.second()).archiveCurrentState();
                this.storeSession(connection, (Key)record.first(), (SessionRecord)record.second());
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update session store", e);
        }
    }

    public void archiveSessions(ServiceId serviceId) {
        String sql = "SELECT s.address, s.device_id, s.record\nFROM %s AS s\nWHERE s.account_id_type = ? AND s.address = ?\n".formatted(TABLE_SESSION);
        try (Connection connection = this.database.getConnection();){
            List<Pair> records;
            connection.setAutoCommit(false);
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setInt(1, this.accountIdType);
                statement.setString(2, serviceId.toString());
                records = Utils.executeQueryForStream(statement, res -> new Pair<Key, SessionRecord>(this.getKeyFromResultSet(res), this.getSessionRecordFromResultSet(res))).filter(Objects::nonNull).toList();
            }
            for (Pair record : records) {
                ((SessionRecord)record.second()).archiveCurrentState();
                this.storeSession(connection, (Key)record.first(), (SessionRecord)record.second());
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update session store", e);
        }
    }

    void addLegacySessions(Collection<Pair<Key, SessionRecord>> sessions) {
        logger.debug("Migrating legacy sessions to database");
        long start = System.nanoTime();
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            for (Pair<Key, SessionRecord> pair : sessions) {
                this.storeSession(connection, pair.first(), pair.second());
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update session store", e);
        }
        logger.debug("Complete sessions migration took {}ms", (Object)((System.nanoTime() - start) / 1000000L));
    }

    private Key getKey(SignalProtocolAddress address) {
        return new Key(address.getName(), address.getDeviceId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionRecord loadSession(Connection connection, Key key) throws SQLException {
        Map<Key, SessionRecord> map = this.cachedSessions;
        synchronized (map) {
            SessionRecord session = this.cachedSessions.get(key);
            if (session != null) {
                return session;
            }
        }
        String sql = "SELECT s.record\nFROM %s AS s\nWHERE s.account_id_type = ? AND s.address = ? AND s.device_id = ?\n".formatted(TABLE_SESSION);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, this.accountIdType);
            statement.setString(2, key.address());
            statement.setInt(3, key.deviceId());
            SessionRecord sessionRecord = Utils.executeQueryForOptional(statement, this::getSessionRecordFromResultSet).orElse(null);
            return sessionRecord;
        }
    }

    private Key getKeyFromResultSet(ResultSet resultSet) throws SQLException {
        String address = resultSet.getString("address");
        int deviceId = resultSet.getInt("device_id");
        return new Key(address, deviceId);
    }

    private SessionRecord getSessionRecordFromResultSet(ResultSet resultSet) {
        try {
            byte[] record = resultSet.getBytes("record");
            return new SessionRecord(record);
        }
        catch (Exception e) {
            logger.warn("Failed to load session, resetting session: {}", (Object)e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSession(Connection connection, Key key, SessionRecord session) throws SQLException {
        Map<Key, SessionRecord> map = this.cachedSessions;
        synchronized (map) {
            this.cachedSessions.put(key, session);
        }
        String sql = "INSERT INTO %s (account_id_type, address, device_id, record)\nVALUES (?, ?, ?, ?)\nON CONFLICT (account_id_type, address, device_id) DO UPDATE SET record=excluded.record\n".formatted(TABLE_SESSION);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, this.accountIdType);
            statement.setString(2, key.address());
            statement.setInt(3, key.deviceId());
            statement.setBytes(4, session.serialize());
            statement.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAllSessions(Connection connection, String address) throws SQLException {
        Map<Key, SessionRecord> map = this.cachedSessions;
        synchronized (map) {
            this.cachedSessions.clear();
        }
        String sql = "DELETE FROM %s AS s\nWHERE s.account_id_type = ? AND s.address = ?\n".formatted(TABLE_SESSION);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, this.accountIdType);
            statement.setString(2, address);
            statement.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSession(Connection connection, Key key) throws SQLException {
        Map<Key, SessionRecord> map = this.cachedSessions;
        synchronized (map) {
            this.cachedSessions.remove(key);
        }
        String sql = "DELETE FROM %s AS s\nWHERE s.account_id_type = ? AND s.address = ? AND s.device_id = ?\n".formatted(TABLE_SESSION);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, this.accountIdType);
            statement.setString(2, key.address());
            statement.setInt(3, key.deviceId());
            statement.executeUpdate();
        }
    }

    private static boolean isActive(SessionRecord record) {
        return record != null && record.hasSenderChain();
    }

    record Key(String address, int deviceId) {
    }
}

