/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.push.exceptions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.reactivex.rxjava3.annotations.NonNull;
import org.whispersystems.signalservice.api.push.exceptions.MalformedResponseException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.internal.util.JsonUtil;

public class NonNormalizedPhoneNumberException
extends NonSuccessfulResponseCodeException {
    private final String originalNumber;
    private final String normalizedNumber;

    public static NonNormalizedPhoneNumberException forResponse(@NonNull String responseBody) throws MalformedResponseException {
        JsonResponse response = JsonUtil.fromJsonResponse(responseBody, JsonResponse.class);
        return new NonNormalizedPhoneNumberException(response.originalNumber, response.normalizedNumber);
    }

    public NonNormalizedPhoneNumberException(String originalNumber, String normalizedNumber) {
        super(400);
        this.originalNumber = originalNumber;
        this.normalizedNumber = normalizedNumber;
    }

    public String getOriginalNumber() {
        return this.originalNumber;
    }

    public String getNormalizedNumber() {
        return this.normalizedNumber;
    }

    private static class JsonResponse {
        @JsonProperty
        private String originalNumber;
        @JsonProperty
        private String normalizedNumber;

        @JsonCreator
        public JsonResponse(@JsonProperty(required=true, value="originalNumber") String originalNumber, @JsonProperty(required=true, value="normalizedNumber") String normalizedNumber) {
            this.originalNumber = originalNumber;
            this.normalizedNumber = normalizedNumber;
        }
    }
}

