/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.ProtoUtil;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.storage.IAPSubscriptionId;
import org.whispersystems.signalservice.api.storage.StorageRecordProtoUtil;
import org.whispersystems.signalservice.internal.storage.protos.AccountRecord;
import org.whispersystems.signalservice.internal.storage.protos.Payments;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u001a\u0010\u0006\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u001c\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0010\u00a8\u0006\u0011"}, d2={"safeSetPayments", "Lorg/whispersystems/signalservice/internal/storage/protos/AccountRecord$Builder;", "enabled", "", "entropy", "", "safeSetSubscriber", "subscriberId", "Lokio/ByteString;", "subscriberCurrencyCode", "", "safeSetBackupsSubscriber", "iapSubscriptionId", "Lorg/whispersystems/signalservice/api/storage/IAPSubscriptionId;", "toSignalServiceAddress", "Lorg/whispersystems/signalservice/api/push/SignalServiceAddress;", "Lorg/whispersystems/signalservice/internal/storage/protos/AccountRecord$PinnedConversation$Contact;", "signal-service-java"})
public final class AccountRecordExtensionsKt {
    @NotNull
    public static final AccountRecord.Builder safeSetPayments(@NotNull AccountRecord.Builder $this$safeSetPayments, boolean enabled, @Nullable byte[] entropy) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$safeSetPayments), (String)"<this>");
        Payments.Builder paymentsBuilder = new Payments.Builder();
        boolean entropyPresent = entropy != null && entropy.length == 32;
        paymentsBuilder.enabled(enabled && entropyPresent);
        if (entropyPresent) {
            Intrinsics.checkNotNull((Object)entropy);
            paymentsBuilder.entropy(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])entropy, (int)0, (int)0, (int)3, null));
        }
        $this$safeSetPayments.payments = paymentsBuilder.build();
        return $this$safeSetPayments;
    }

    @NotNull
    public static final AccountRecord.Builder safeSetSubscriber(@NotNull AccountRecord.Builder $this$safeSetSubscriber, @NotNull ByteString subscriberId, @NotNull String subscriberCurrencyCode) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$safeSetSubscriber), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)subscriberId, (String)"subscriberId");
        Intrinsics.checkNotNullParameter((Object)subscriberCurrencyCode, (String)"subscriberCurrencyCode");
        if (ProtoUtil.isNotEmpty((ByteString)subscriberId) && subscriberId.size() == 32 && !StringsKt.isBlank((CharSequence)subscriberCurrencyCode)) {
            $this$safeSetSubscriber.subscriberId = subscriberId;
            $this$safeSetSubscriber.subscriberCurrencyCode = subscriberCurrencyCode;
        } else {
            $this$safeSetSubscriber.subscriberId = StorageRecordProtoUtil.getDefaultAccountRecord().subscriberId;
            $this$safeSetSubscriber.subscriberCurrencyCode = StorageRecordProtoUtil.getDefaultAccountRecord().subscriberCurrencyCode;
        }
        return $this$safeSetSubscriber;
    }

    @NotNull
    public static final AccountRecord.Builder safeSetBackupsSubscriber(@NotNull AccountRecord.Builder $this$safeSetBackupsSubscriber, @NotNull ByteString subscriberId, @Nullable IAPSubscriptionId iapSubscriptionId) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$safeSetBackupsSubscriber), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)subscriberId, (String)"subscriberId");
        $this$safeSetBackupsSubscriber.backupSubscriberData = ProtoUtil.isNotEmpty((ByteString)subscriberId) && subscriberId.size() == 32 && IAPSubscriptionId.Companion.isNotNullOrBlank(iapSubscriptionId) ? new AccountRecord.IAPSubscriberData(subscriberId, iapSubscriptionId.getPurchaseToken(), iapSubscriptionId.getOriginalTransactionId(), null, 8, null) : StorageRecordProtoUtil.getDefaultAccountRecord().backupSubscriberData;
        return $this$safeSetBackupsSubscriber;
    }

    @NotNull
    public static final SignalServiceAddress toSignalServiceAddress(@NotNull AccountRecord.PinnedConversation.Contact $this$toSignalServiceAddress) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toSignalServiceAddress), (String)"<this>");
        ServiceId serviceId = ServiceId.Companion.parseOrNull$default(ServiceId.Companion, $this$toSignalServiceAddress.serviceId, false, 2, null);
        return new SignalServiceAddress(serviceId, $this$toSignalServiceAddress.e164);
    }
}

