/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.util;

import java.math.BigInteger;
import org.signal.libsignal.protocol.util.ByteUtil;
import org.whispersystems.signalservice.api.util.Uint64RangeException;

public final class Uint64Util {
    private static final BigInteger MAX_UINT64 = Uint64Util.uint64ToBigInteger(-1L);

    private Uint64Util() {
    }

    public static BigInteger uint64ToBigInteger(long uint64) {
        if (uint64 < 0L) {
            return new BigInteger(1, ByteUtil.longToByteArray((long)uint64));
        }
        return BigInteger.valueOf(uint64);
    }

    public static long bigIntegerToUInt64(BigInteger value) throws Uint64RangeException {
        if (value.signum() < 0) {
            throw new Uint64RangeException("BigInteger out of uint64 range (negative)");
        }
        if (value.compareTo(MAX_UINT64) > 0) {
            throw new Uint64RangeException("BigInteger out of uint64 range (> MAX)");
        }
        return value.longValue();
    }
}

