/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.whispersystems.signalservice.internal.util.Util;

public class PaddingInputStream
extends FilterInputStream {
    private long paddingRemaining;

    public PaddingInputStream(InputStream inputStream, long plaintextLength) {
        super(inputStream);
        this.paddingRemaining = PaddingInputStream.getPaddedSize(plaintextLength) - plaintextLength;
    }

    @Override
    public int read() throws IOException {
        int result2 = super.read();
        if (result2 != -1) {
            return result2;
        }
        if (this.paddingRemaining > 0L) {
            --this.paddingRemaining;
            return 0;
        }
        return -1;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int result2 = super.read(buffer, offset, length);
        if (result2 != -1) {
            return result2;
        }
        if (this.paddingRemaining > 0L) {
            length = Math.min(length, Util.toIntExact(this.paddingRemaining));
            Arrays.fill(buffer, offset, length, (byte)0);
            this.paddingRemaining -= (long)length;
            return length;
        }
        return -1;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int available() throws IOException {
        return super.available() + Util.toIntExact(this.paddingRemaining);
    }

    public static long getPaddedSize(long size) {
        return (int)Math.max(541.0, Math.floor(Math.pow(1.05, Math.ceil(Math.log(size) / Math.log(1.05)))));
    }

    public static long getMaxUnpaddedSize(long maxPaddedSize) {
        return (int)Math.floor(Math.pow(1.05, Math.floor(Math.log(maxPaddedSize) / Math.log(1.05))));
    }
}

