/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.signal.libsignal.protocol.util.Pair;
import org.whispersystems.signalservice.api.push.TrustStore;

public class BlacklistingTrustManager
implements X509TrustManager {
    private static final List<Pair<String, BigInteger>> BLACKLIST = new LinkedList<Pair<String, BigInteger>>(){
        {
            this.add(new Pair((Object)"Open Whisper Systems", (Object)new BigInteger("4098")));
        }
    };
    private final X509TrustManager trustManager;

    public static TrustManager[] createFor(TrustManager[] trustManagers) {
        for (TrustManager trustManager : trustManagers) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            TrustManager[] results = new BlacklistingTrustManager[]{new BlacklistingTrustManager((X509TrustManager)trustManager)};
            return results;
        }
        throw new AssertionError((Object)"No X509 Trust Managers!");
    }

    public static TrustManager[] createFor(TrustStore trustStore) {
        try {
            InputStream keyStoreInputStream = trustStore.getKeyStoreInputStream();
            KeyStore keyStore = KeyStore.getInstance("BKS");
            keyStore.load(keyStoreInputStream, trustStore.getKeyStorePassword().toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X509");
            trustManagerFactory.init(keyStore);
            return BlacklistingTrustManager.createFor(trustManagerFactory.getTrustManagers());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new AssertionError((Object)e);
        }
    }

    public BlacklistingTrustManager(X509TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkServerTrusted(chain, authType);
        for (X509Certificate certificate : chain) {
            for (Pair<String, BigInteger> blacklistedSerial : BLACKLIST) {
                if (!certificate.getIssuerDN().getName().equals(blacklistedSerial.first()) || !certificate.getSerialNumber().equals(blacklistedSerial.second())) continue;
                throw new CertificateException("Blacklisted Serial: " + String.valueOf(certificate.getSerialNumber()));
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }
}

