/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.security.Security;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.platform.BouncyCastlePlatform;
import okhttp3.internal.platform.ConscryptPlatform;
import okhttp3.internal.platform.Jdk8WithJettyBootPlatform;
import okhttp3.internal.platform.Jdk9Platform;
import okhttp3.internal.platform.OpenJSSEPlatform;
import okhttp3.internal.platform.Platform;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0006\u00a8\u0006\f"}, d2={"Lokhttp3/internal/platform/PlatformRegistry;", "", "<init>", "()V", "isConscryptPreferred", "", "()Z", "isOpenJSSEPreferred", "isBouncyCastlePreferred", "findPlatform", "Lokhttp3/internal/platform/Platform;", "isAndroid", "okhttp"})
public final class PlatformRegistry {
    @NotNull
    public static final PlatformRegistry INSTANCE = new PlatformRegistry();

    private PlatformRegistry() {
    }

    private final boolean isConscryptPreferred() {
        String preferredProvider = Security.getProviders()[0].getName();
        return Intrinsics.areEqual((Object)"Conscrypt", (Object)preferredProvider);
    }

    private final boolean isOpenJSSEPreferred() {
        String preferredProvider = Security.getProviders()[0].getName();
        return Intrinsics.areEqual((Object)"OpenJSSE", (Object)preferredProvider);
    }

    private final boolean isBouncyCastlePreferred() {
        String preferredProvider = Security.getProviders()[0].getName();
        return Intrinsics.areEqual((Object)"BC", (Object)preferredProvider);
    }

    @NotNull
    public final Platform findPlatform() {
        OpenJSSEPlatform openJSSE;
        BouncyCastlePlatform bc;
        ConscryptPlatform conscrypt;
        if (this.isConscryptPreferred() && (conscrypt = ConscryptPlatform.Companion.buildIfSupported()) != null) {
            return conscrypt;
        }
        if (this.isBouncyCastlePreferred() && (bc = BouncyCastlePlatform.Companion.buildIfSupported()) != null) {
            return bc;
        }
        if (this.isOpenJSSEPreferred() && (openJSSE = OpenJSSEPlatform.Companion.buildIfSupported()) != null) {
            return openJSSE;
        }
        Jdk9Platform jdk9 = Jdk9Platform.Companion.buildIfSupported();
        if (jdk9 != null) {
            return jdk9;
        }
        Platform jdkWithJettyBoot = Jdk8WithJettyBootPlatform.Companion.buildIfSupported();
        if (jdkWithJettyBoot != null) {
            return jdkWithJettyBoot;
        }
        return new Platform();
    }

    public final boolean isAndroid() {
        return false;
    }
}

