/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.RateLimitErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.RateLimitException;
import org.asamk.signal.manager.api.UserStatus;
import org.asamk.signal.manager.api.UsernameStatus;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;
import org.asamk.signal.util.CommandUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetUserStatusCommand
implements JsonRpcLocalCommand {
    private static final Logger logger = LoggerFactory.getLogger(GetUserStatusCommand.class);

    @Override
    public String getName() {
        return "getUserStatus";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Check if the specified phone number/s have been registered");
        subparser.addArgument(new String[]{"recipient"}).help("Phone number").nargs("*");
        subparser.addArgument(new String[]{"--username"}).help("Specify the recipient username or username link.").nargs("*");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        Map registeredUsernames;
        Map registered;
        try {
            List recipient = ns.getList("recipient");
            registered = m.getUserStatus((Set)(recipient == null ? Set.of() : new HashSet(recipient)));
        }
        catch (RateLimitException e) {
            String message = CommandUtil.getRateLimitMessage(e);
            throw new RateLimitErrorException(message, e);
        }
        catch (IOException e) {
            throw new IOErrorException("Unable to check if users are registered: " + e.getMessage() + " (" + e.getClass().getSimpleName() + ")", e);
        }
        List usernames = ns.getList("username");
        try {
            registeredUsernames = usernames == null ? Map.of() : m.getUsernameStatus(new HashSet(usernames));
        }
        catch (IOException e) {
            throw new IOErrorException("Unable to check if users are registered: " + e.getMessage() + " (" + e.getClass().getSimpleName() + ")", e);
        }
        OutputWriter outputWriter2 = outputWriter;
        Objects.requireNonNull(outputWriter2);
        OutputWriter outputWriter3 = outputWriter2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonWriter.class, PlainTextWriter.class}, (Object)outputWriter3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                JsonWriter writer = (JsonWriter)outputWriter3;
                List<JsonUserStatus> jsonUserStatuses = Stream.concat(registered.entrySet().stream().map(entry -> {
                    String number = ((UserStatus)entry.getValue()).number();
                    UUID uuid = ((UserStatus)entry.getValue()).uuid();
                    return new JsonUserStatus((String)entry.getKey(), number, null, uuid == null ? null : uuid.toString(), uuid != null);
                }), registeredUsernames.entrySet().stream().map(entry -> {
                    String username = ((UsernameStatus)entry.getValue()).username();
                    UUID uuid = ((UsernameStatus)entry.getValue()).uuid();
                    return new JsonUserStatus((String)entry.getKey(), null, username, uuid == null ? null : uuid.toString(), uuid != null);
                })).toList();
                writer.write(jsonUserStatuses);
                break;
            }
            case 1: {
                UserStatus userStatus;
                PlainTextWriter writer = (PlainTextWriter)outputWriter3;
                for (Map.Entry entry2 : registered.entrySet()) {
                    userStatus = (UserStatus)entry2.getValue();
                    writer.println("{}: {}{}", entry2.getKey(), userStatus.uuid() != null, userStatus.unrestrictedUnidentifiedAccess() ? " (unrestricted sealed sender)" : "");
                }
                for (Map.Entry entry2 : registeredUsernames.entrySet()) {
                    userStatus = (UsernameStatus)entry2.getValue();
                    writer.println("{}: {}{}", entry2.getKey(), userStatus.uuid() != null, userStatus.unrestrictedUnidentifiedAccess() ? " (unrestricted sealed sender)" : "");
                }
            }
        }
    }

    private record JsonUserStatus(String recipient, @JsonInclude(value=JsonInclude.Include.NON_NULL) String number, @JsonInclude(value=JsonInclude.Include.NON_NULL) String username, String uuid, boolean isRegistered) {
    }
}

