/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.crypto;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidKeyException;

public class Aes256GcmDecryption
extends NativeHandleGuard.SimpleOwner {
    public static final int TAG_SIZE_IN_BYTES = 16;

    public Aes256GcmDecryption(byte[] key, byte[] nonce, byte[] associatedData) throws InvalidKeyException {
        super(FilterExceptions.filterExceptions(InvalidKeyException.class, () -> Native.Aes256GcmDecryption_New(key, nonce, associatedData)));
    }

    @Override
    protected void release(long nativeHandle) {
        Native.Aes256GcmDecryption_Destroy(nativeHandle);
    }

    public void decrypt(byte[] plaintext) {
        this.guardedRun(nativeHandle -> Native.Aes256GcmDecryption_Update(nativeHandle, plaintext, 0, plaintext.length));
    }

    public void decrypt(byte[] plaintext, int offset, int length) {
        this.guardedRun(nativeHandle -> Native.Aes256GcmDecryption_Update(nativeHandle, plaintext, offset, length));
    }

    public boolean verifyTag(byte[] tag) {
        return this.guardedMap(nativeHandle -> FilterExceptions.filterExceptions(() -> Native.Aes256GcmDecryption_VerifyTag(nativeHandle, tag)));
    }
}

