// Tencent is pleased to support the open source community by making ncnn available.
//
// Copyright (C) 2020 THL A29 Limited, a Tencent company. All rights reserved.
//
// Licensed under the BSD 3-Clause License (the "License"); you may not use this file except
// in compliance with the License. You may obtain a copy of the License at
//
// https://opensource.org/licenses/BSD-3-Clause
//
// Unless required by applicable law or agreed to in writing, software distributed
// under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
// CONDITIONS OF ANY KIND, either express or implied. See the License for the
// specific language governing permissions and limitations under the License.

static void conv5x5s1_pack4_bf16s_neon(const Mat& bottom_blob, Mat& top_blob, const Mat& kernel, const Mat& _bias, const Option& opt)
{
    int inch = bottom_blob.c;
    int outw = top_blob.w;
    int outh = top_blob.h;
    int outch = top_blob.c;

    Mat top_blob_fp32(outw, outh, opt.num_threads, (size_t)4u * 4, 4, opt.workspace_allocator);

    const float* bias = _bias;

    #pragma omp parallel for num_threads(opt.num_threads)
    for (int p = 0; p < outch; p++)
    {
        Mat out0 = top_blob_fp32.channel(get_omp_thread_num());

        float32x4_t _bias0 = bias ? vld1q_f32((const float*)bias + p * 4) : vdupq_n_f32(0.f);
        out0.fill(_bias0);

        int q = 0;
        for (; q < inch - 1; q++)
        {
            float* outptr0 = out0.row(0);

            const Mat img0 = bottom_blob.channel(q);

            const unsigned short* r0 = img0.row<const unsigned short>(0);
            const unsigned short* r1 = img0.row<const unsigned short>(1);
            const unsigned short* r2 = img0.row<const unsigned short>(2);
            const unsigned short* r3 = img0.row<const unsigned short>(3);
            const unsigned short* r4 = img0.row<const unsigned short>(4);

            const unsigned short* kptr = kernel.channel(p).row<const unsigned short>(q);

            int i = 0;
            for (; i < outh; i++)
            {
                int j = 0;
                for (; j + 3 < outw; j += 4)
                {
#if __aarch64__
                    asm volatile(
                        "prfm   pldl1keep, [%0, #512]       \n"
                        "ld1    {v20.4s, v21.4s, v22.4s, v23.4s}, [%0] \n" // sum0 sum1 sum2 sum3

                        "prfm   pldl1keep, [%1, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%1], #32 \n" // r00 r01 r02 r03

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v16.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v1.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v1.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v3.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v1.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v3.s[3]     \n"

                        "prfm   pldl1keep, [%1, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%1] \n" // r04 r05 r06 r07

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "fmla   v20.4s, v24.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v4.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v4.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v5.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v5.s[3]     \n"

                        "fmla   v20.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v6.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v6.s[3]     \n"

                        "prfm   pldl1keep, [%2, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%2], #32 \n" // r10 r11 r12 r13

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v20.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v7.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v7.s[3]     \n"

                        "fmla   v20.4s, v24.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v1.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v3.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v3.s[3]     \n"

                        "prfm   pldl1keep, [%2, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%2] \n" // r14 r15 r16 r17

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "fmla   v20.4s, v16.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v4.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v4.s[3]     \n"

                        "fmla   v20.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v5.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v5.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v6.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v6.s[3]     \n"

                        "prfm   pldl1keep, [%3, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%3], #32 \n" // r20 r21 r22 r23

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v20.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v7.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v7.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v1.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v1.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v3.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v1.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v3.s[3]     \n"

                        "prfm   pldl1keep, [%3, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%3] \n" // r24 r25 r26 r27

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "fmla   v20.4s, v24.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v4.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v4.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v5.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v5.s[3]     \n"

                        "fmla   v20.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v6.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v6.s[3]     \n"

                        "prfm   pldl1keep, [%4, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%4], #32 \n" // r30 r31 r32 r33

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v20.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v7.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v7.s[3]     \n"

                        "fmla   v20.4s, v24.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v1.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v3.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v3.s[3]     \n"

                        "prfm   pldl1keep, [%4, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%4] \n" // r34 r35 r36 r37

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "fmla   v20.4s, v16.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v4.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v4.s[3]     \n"

                        "fmla   v20.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v5.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v5.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v6.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v6.s[3]     \n"

                        "prfm   pldl1keep, [%5, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%5], #32 \n" // r40 r41 r42 r43

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v20.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v7.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v7.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v1.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v1.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v3.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v1.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v3.s[3]     \n"

                        "prfm   pldl1keep, [%5, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%5] \n" // r44 r45 r46 r47

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "fmla   v20.4s, v24.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v4.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v4.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v5.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v5.s[3]     \n"

                        "fmla   v20.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v6.s[1]     \n"

                        //                         "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6] \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v6.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v7.s[1]     \n"
                        "fmla   v20.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v7.s[3]     \n"

                        "sub    %6, %6, #768                \n" // kptr -= 24 * 16;

                        "st1    {v20.4s, v21.4s, v22.4s, v23.4s}, [%0], #64 \n"

                        : "=r"(outptr0), // %0
                        "=r"(r0),      // %1
                        "=r"(r1),      // %2
                        "=r"(r2),      // %3
                        "=r"(r3),      // %4
                        "=r"(r4),      // %5
                        "=r"(kptr)     // %6
                        : "0"(outptr0),
                        "1"(r0),
                        "2"(r1),
                        "3"(r2),
                        "4"(r3),
                        "5"(r4),
                        "6"(kptr)
                        : "memory", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27");
#else  // __aarch64__
                    asm volatile(
                        "pld        [%0, #512]          \n"
                        "vldm       %0, {d24-d31}       \n" // sum0 sum1 sum2 sum3

                        "pld        [%1, #256]          \n"
                        "vld1.u16   {d4-d7}, [%1 :64]!  \n" // r00 r01 r02 r03

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d0[0]      \n"
                        "vmla.f32   q13, q8, d2[0]      \n"
                        "vmla.f32   q14, q8, d4[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d2[1]      \n"
                        "vmla.f32   q14, q9, d4[1]      \n"
                        "vmla.f32   q15, q9, d6[1]      \n"
                        "vmla.f32   q12, q10, d1[0]     \n"
                        "vmla.f32   q13, q10, d3[0]     \n"
                        "vmla.f32   q14, q10, d5[0]     \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vmla.f32   q13, q11, d3[1]     \n"
                        "vmla.f32   q14, q11, d5[1]     \n"
                        "vmla.f32   q15, q11, d7[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%1, #256]          \n"
                        "vld1.u16   {d12-d15}, [%1 :64] \n" // r04 r05 r06 r07

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q12, q10, d2[0]     \n"
                        "vmla.f32   q13, q10, d4[0]     \n"
                        "vmla.f32   q14, q10, d6[0]     \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "vmla.f32   q14, q11, d6[1]     \n"
                        "vmla.f32   q15, q11, d8[1]     \n"
                        "vmla.f32   q12, q8, d3[0]      \n"
                        "vmla.f32   q13, q8, d5[0]      \n"
                        "vmla.f32   q14, q8, d7[0]      \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vmla.f32   q13, q9, d5[1]      \n"
                        "vmla.f32   q14, q9, d7[1]      \n"
                        "vmla.f32   q15, q9, d9[1]      \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d4[0]      \n"
                        "vmla.f32   q13, q8, d6[0]      \n"
                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d6[1]      \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "vmla.f32   q15, q9, d10[1]     \n"
                        "vmla.f32   q12, q10, d5[0]     \n"
                        "vmla.f32   q13, q10, d7[0]     \n"
                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vmla.f32   q13, q11, d7[1]     \n"
                        "vmla.f32   q14, q11, d9[1]     \n"
                        "vmla.f32   q15, q11, d11[1]    \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d6[0]     \n"
                        "vmla.f32   q13, q10, d8[0]     \n"
                        "vmla.f32   q14, q10, d10[0]    \n"
                        "vmla.f32   q15, q10, d12[0]    \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d8[1]     \n"
                        "vmla.f32   q14, q11, d10[1]    \n"
                        "vmla.f32   q15, q11, d12[1]    \n"
                        "vmla.f32   q12, q8, d7[0]      \n"
                        "vmla.f32   q13, q8, d9[0]      \n"
                        "vmla.f32   q14, q8, d11[0]     \n"
                        "vmla.f32   q15, q8, d13[0]     \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vmla.f32   q13, q9, d9[1]      \n"
                        "vmla.f32   q14, q9, d11[1]     \n"
                        "vmla.f32   q15, q9, d13[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%2, #256]          \n"
                        "vld1.u16   {d4-d7}, [%2 :64]!  \n" // r10 r11 r12 r13

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q12, q8, d8[0]      \n"
                        "vmla.f32   q13, q8, d10[0]     \n"
                        "vmla.f32   q14, q8, d12[0]     \n"
                        "vmla.f32   q15, q8, d14[0]     \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d10[1]     \n"
                        "vmla.f32   q14, q9, d12[1]     \n"
                        "vmla.f32   q15, q9, d14[1]     \n"
                        "vmla.f32   q12, q10, d9[0]     \n"
                        "vmla.f32   q13, q10, d11[0]    \n"
                        "vmla.f32   q14, q10, d13[0]    \n"
                        "vmla.f32   q15, q10, d15[0]    \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d11[1]    \n"
                        "vmla.f32   q14, q11, d13[1]    \n"
                        "vmla.f32   q15, q11, d15[1]    \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d0[0]     \n"
                        "vmla.f32   q13, q10, d2[0]     \n"
                        "vmla.f32   q14, q10, d4[0]     \n"
                        "vmla.f32   q15, q10, d6[0]     \n"
                        "vmla.f32   q12, q11, d0[1]     \n"
                        "vmla.f32   q13, q11, d2[1]     \n"
                        "vmla.f32   q14, q11, d4[1]     \n"
                        "vmla.f32   q15, q11, d6[1]     \n"
                        "vmla.f32   q12, q8, d1[0]      \n"
                        "vmla.f32   q13, q8, d3[0]      \n"
                        "vmla.f32   q14, q8, d5[0]      \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "vmla.f32   q13, q9, d3[1]      \n"
                        "vmla.f32   q14, q9, d5[1]      \n"
                        "vmla.f32   q15, q9, d7[1]      \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%2, #256]          \n"
                        "vld1.u16   {d12-d15}, [%2 :64] \n" // r14 r15 r16 r17

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q12, q8, d2[0]      \n"
                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vmla.f32   q14, q8, d6[0]      \n"
                        "vmla.f32   q15, q8, d8[0]      \n"
                        "vmla.f32   q12, q9, d2[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "vmla.f32   q14, q9, d6[1]      \n"
                        "vmla.f32   q15, q9, d8[1]      \n"
                        "vmla.f32   q12, q10, d3[0]     \n"
                        "vmla.f32   q13, q10, d5[0]     \n"
                        "vmla.f32   q14, q10, d7[0]     \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "vmla.f32   q14, q11, d7[1]     \n"
                        "vmla.f32   q15, q11, d9[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d4[0]     \n"
                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vmla.f32   q14, q10, d8[0]     \n"
                        "vmla.f32   q15, q10, d10[0]    \n"
                        "vmla.f32   q12, q11, d4[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "vmla.f32   q14, q11, d8[1]     \n"
                        "vmla.f32   q15, q11, d10[1]    \n"
                        "vmla.f32   q12, q8, d5[0]      \n"
                        "vmla.f32   q13, q8, d7[0]      \n"
                        "vmla.f32   q14, q8, d9[0]      \n"
                        "vmla.f32   q15, q8, d11[0]     \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "vmla.f32   q14, q9, d9[1]      \n"
                        "vmla.f32   q15, q9, d11[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d6[0]      \n"
                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vmla.f32   q14, q8, d10[0]     \n"
                        "vmla.f32   q15, q8, d12[0]     \n"
                        "vmla.f32   q12, q9, d6[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "vmla.f32   q14, q9, d10[1]     \n"
                        "vmla.f32   q15, q9, d12[1]     \n"
                        "vmla.f32   q12, q10, d7[0]     \n"
                        "vmla.f32   q13, q10, d9[0]     \n"
                        "vmla.f32   q14, q10, d11[0]    \n"
                        "vmla.f32   q15, q10, d13[0]    \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vmla.f32   q14, q11, d11[1]    \n"
                        "vmla.f32   q15, q11, d13[1]    \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%3, #256]          \n"
                        "vld1.u16   {d4-d7}, [%3 :64]!  \n" // r20 r21 r22 r23

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q12, q10, d8[0]     \n"
                        "vmla.f32   q13, q10, d10[0]    \n"
                        "vmla.f32   q14, q10, d12[0]    \n"
                        "vmla.f32   q15, q10, d14[0]    \n"
                        "vmla.f32   q12, q11, d8[1]     \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        "vmla.f32   q14, q11, d12[1]    \n"
                        "vmla.f32   q15, q11, d14[1]    \n"
                        "vmla.f32   q12, q8, d9[0]      \n"
                        "vmla.f32   q13, q8, d11[0]     \n"
                        "vmla.f32   q14, q8, d13[0]     \n"
                        "vmla.f32   q15, q8, d15[0]     \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "vmla.f32   q14, q9, d13[1]     \n"
                        "vmla.f32   q15, q9, d15[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d0[0]      \n"
                        "vmla.f32   q13, q8, d2[0]      \n"
                        "vmla.f32   q14, q8, d4[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d2[1]      \n"
                        "vmla.f32   q14, q9, d4[1]      \n"
                        "vmla.f32   q15, q9, d6[1]      \n"
                        "vmla.f32   q12, q10, d1[0]     \n"
                        "vmla.f32   q13, q10, d3[0]     \n"
                        "vmla.f32   q14, q10, d5[0]     \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vmla.f32   q13, q11, d3[1]     \n"
                        "vmla.f32   q14, q11, d5[1]     \n"
                        "vmla.f32   q15, q11, d7[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%3, #256]          \n"
                        "vld1.u16   {d12-d15}, [%3 :64] \n" // r24 r25 r26 r27

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q12, q10, d2[0]     \n"
                        "vmla.f32   q13, q10, d4[0]     \n"
                        "vmla.f32   q14, q10, d6[0]     \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "vmla.f32   q14, q11, d6[1]     \n"
                        "vmla.f32   q15, q11, d8[1]     \n"
                        "vmla.f32   q12, q8, d3[0]      \n"
                        "vmla.f32   q13, q8, d5[0]      \n"
                        "vmla.f32   q14, q8, d7[0]      \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vmla.f32   q13, q9, d5[1]      \n"
                        "vmla.f32   q14, q9, d7[1]      \n"
                        "vmla.f32   q15, q9, d9[1]      \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d4[0]      \n"
                        "vmla.f32   q13, q8, d6[0]      \n"
                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d6[1]      \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "vmla.f32   q15, q9, d10[1]     \n"
                        "vmla.f32   q12, q10, d5[0]     \n"
                        "vmla.f32   q13, q10, d7[0]     \n"
                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vmla.f32   q13, q11, d7[1]     \n"
                        "vmla.f32   q14, q11, d9[1]     \n"
                        "vmla.f32   q15, q11, d11[1]    \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d6[0]     \n"
                        "vmla.f32   q13, q10, d8[0]     \n"
                        "vmla.f32   q14, q10, d10[0]    \n"
                        "vmla.f32   q15, q10, d12[0]    \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d8[1]     \n"
                        "vmla.f32   q14, q11, d10[1]    \n"
                        "vmla.f32   q15, q11, d12[1]    \n"
                        "vmla.f32   q12, q8, d7[0]      \n"
                        "vmla.f32   q13, q8, d9[0]      \n"
                        "vmla.f32   q14, q8, d11[0]     \n"
                        "vmla.f32   q15, q8, d13[0]     \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vmla.f32   q13, q9, d9[1]      \n"
                        "vmla.f32   q14, q9, d11[1]     \n"
                        "vmla.f32   q15, q9, d13[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%4, #256]          \n"
                        "vld1.u16   {d4-d7}, [%4 :64]!  \n" // r30 r31 r32 r33

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q12, q8, d8[0]      \n"
                        "vmla.f32   q13, q8, d10[0]     \n"
                        "vmla.f32   q14, q8, d12[0]     \n"
                        "vmla.f32   q15, q8, d14[0]     \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d10[1]     \n"
                        "vmla.f32   q14, q9, d12[1]     \n"
                        "vmla.f32   q15, q9, d14[1]     \n"
                        "vmla.f32   q12, q10, d9[0]     \n"
                        "vmla.f32   q13, q10, d11[0]    \n"
                        "vmla.f32   q14, q10, d13[0]    \n"
                        "vmla.f32   q15, q10, d15[0]    \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d11[1]    \n"
                        "vmla.f32   q14, q11, d13[1]    \n"
                        "vmla.f32   q15, q11, d15[1]    \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d0[0]     \n"
                        "vmla.f32   q13, q10, d2[0]     \n"
                        "vmla.f32   q14, q10, d4[0]     \n"
                        "vmla.f32   q15, q10, d6[0]     \n"
                        "vmla.f32   q12, q11, d0[1]     \n"
                        "vmla.f32   q13, q11, d2[1]     \n"
                        "vmla.f32   q14, q11, d4[1]     \n"
                        "vmla.f32   q15, q11, d6[1]     \n"
                        "vmla.f32   q12, q8, d1[0]      \n"
                        "vmla.f32   q13, q8, d3[0]      \n"
                        "vmla.f32   q14, q8, d5[0]      \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "vmla.f32   q13, q9, d3[1]      \n"
                        "vmla.f32   q14, q9, d5[1]      \n"
                        "vmla.f32   q15, q9, d7[1]      \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%4, #256]          \n"
                        "vld1.u16   {d12-d15}, [%4 :64] \n" // r34 r35 r36 r37

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q12, q8, d2[0]      \n"
                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vmla.f32   q14, q8, d6[0]      \n"
                        "vmla.f32   q15, q8, d8[0]      \n"
                        "vmla.f32   q12, q9, d2[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "vmla.f32   q14, q9, d6[1]      \n"
                        "vmla.f32   q15, q9, d8[1]      \n"
                        "vmla.f32   q12, q10, d3[0]     \n"
                        "vmla.f32   q13, q10, d5[0]     \n"
                        "vmla.f32   q14, q10, d7[0]     \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "vmla.f32   q14, q11, d7[1]     \n"
                        "vmla.f32   q15, q11, d9[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d4[0]     \n"
                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vmla.f32   q14, q10, d8[0]     \n"
                        "vmla.f32   q15, q10, d10[0]    \n"
                        "vmla.f32   q12, q11, d4[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "vmla.f32   q14, q11, d8[1]     \n"
                        "vmla.f32   q15, q11, d10[1]    \n"
                        "vmla.f32   q12, q8, d5[0]      \n"
                        "vmla.f32   q13, q8, d7[0]      \n"
                        "vmla.f32   q14, q8, d9[0]      \n"
                        "vmla.f32   q15, q8, d11[0]     \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "vmla.f32   q14, q9, d9[1]      \n"
                        "vmla.f32   q15, q9, d11[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d6[0]      \n"
                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vmla.f32   q14, q8, d10[0]     \n"
                        "vmla.f32   q15, q8, d12[0]     \n"
                        "vmla.f32   q12, q9, d6[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "vmla.f32   q14, q9, d10[1]     \n"
                        "vmla.f32   q15, q9, d12[1]     \n"
                        "vmla.f32   q12, q10, d7[0]     \n"
                        "vmla.f32   q13, q10, d9[0]     \n"
                        "vmla.f32   q14, q10, d11[0]    \n"
                        "vmla.f32   q15, q10, d13[0]    \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vmla.f32   q14, q11, d11[1]    \n"
                        "vmla.f32   q15, q11, d13[1]    \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%5, #256]          \n"
                        "vld1.u16   {d4-d7}, [%5 :64]!  \n" // r40 r41 r42 r43

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q12, q10, d8[0]     \n"
                        "vmla.f32   q13, q10, d10[0]    \n"
                        "vmla.f32   q14, q10, d12[0]    \n"
                        "vmla.f32   q15, q10, d14[0]    \n"
                        "vmla.f32   q12, q11, d8[1]     \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        "vmla.f32   q14, q11, d12[1]    \n"
                        "vmla.f32   q15, q11, d14[1]    \n"
                        "vmla.f32   q12, q8, d9[0]      \n"
                        "vmla.f32   q13, q8, d11[0]     \n"
                        "vmla.f32   q14, q8, d13[0]     \n"
                        "vmla.f32   q15, q8, d15[0]     \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "vmla.f32   q14, q9, d13[1]     \n"
                        "vmla.f32   q15, q9, d15[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d0[0]      \n"
                        "vmla.f32   q13, q8, d2[0]      \n"
                        "vmla.f32   q14, q8, d4[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d2[1]      \n"
                        "vmla.f32   q14, q9, d4[1]      \n"
                        "vmla.f32   q15, q9, d6[1]      \n"
                        "vmla.f32   q12, q10, d1[0]     \n"
                        "vmla.f32   q13, q10, d3[0]     \n"
                        "vmla.f32   q14, q10, d5[0]     \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vmla.f32   q13, q11, d3[1]     \n"
                        "vmla.f32   q14, q11, d5[1]     \n"
                        "vmla.f32   q15, q11, d7[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%5, #256]          \n"
                        "vld1.u16   {d12-d15}, [%5 :64] \n" // r44 r45 r46 r47

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q12, q10, d2[0]     \n"
                        "vmla.f32   q13, q10, d4[0]     \n"
                        "vmla.f32   q14, q10, d6[0]     \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "vmla.f32   q14, q11, d6[1]     \n"
                        "vmla.f32   q15, q11, d8[1]     \n"
                        "vmla.f32   q12, q8, d3[0]      \n"
                        "vmla.f32   q13, q8, d5[0]      \n"
                        "vmla.f32   q14, q8, d7[0]      \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vmla.f32   q13, q9, d5[1]      \n"
                        "vmla.f32   q14, q9, d7[1]      \n"
                        "vmla.f32   q15, q9, d9[1]      \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d4[0]      \n"
                        "vmla.f32   q13, q8, d6[0]      \n"
                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d6[1]      \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "vmla.f32   q15, q9, d10[1]     \n"
                        "vmla.f32   q12, q10, d5[0]     \n"
                        "vmla.f32   q13, q10, d7[0]     \n"
                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vmla.f32   q13, q11, d7[1]     \n"
                        "vmla.f32   q14, q11, d9[1]     \n"
                        "vmla.f32   q15, q11, d11[1]    \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d6[0]     \n"
                        "vmla.f32   q13, q10, d8[0]     \n"
                        "vmla.f32   q14, q10, d10[0]    \n"
                        "vmla.f32   q15, q10, d12[0]    \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d8[1]     \n"
                        "vmla.f32   q14, q11, d10[1]    \n"
                        "vmla.f32   q15, q11, d12[1]    \n"
                        "vmla.f32   q12, q8, d7[0]      \n"
                        "vmla.f32   q13, q8, d9[0]      \n"
                        "vmla.f32   q14, q8, d11[0]     \n"
                        "vmla.f32   q15, q8, d13[0]     \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vmla.f32   q13, q9, d9[1]      \n"
                        "vmla.f32   q14, q9, d11[1]     \n"
                        "vmla.f32   q15, q9, d13[1]     \n"

                        //                         "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :64] \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d8[0]      \n"
                        "vmla.f32   q13, q8, d10[0]     \n"
                        "vmla.f32   q14, q8, d12[0]     \n"
                        "vmla.f32   q15, q8, d14[0]     \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d10[1]     \n"
                        "vmla.f32   q14, q9, d12[1]     \n"
                        "vmla.f32   q15, q9, d14[1]     \n"
                        "vmla.f32   q12, q10, d9[0]     \n"
                        "vmla.f32   q13, q10, d11[0]    \n"
                        "vmla.f32   q14, q10, d13[0]    \n"
                        "vmla.f32   q15, q10, d15[0]    \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d11[1]    \n"
                        "vmla.f32   q14, q11, d13[1]    \n"
                        "vmla.f32   q15, q11, d15[1]    \n"

                        "sub        %6, %6, #768        \n" // kptr -= 24 * 16;

                        "vstm       %0!, {d24-d31}      \n"

                        : "=r"(outptr0), // %0
                        "=r"(r0),      // %1
                        "=r"(r1),      // %2
                        "=r"(r2),      // %3
                        "=r"(r3),      // %4
                        "=r"(r4),      // %5
                        "=r"(kptr)     // %6
                        : "0"(outptr0),
                        "1"(r0),
                        "2"(r1),
                        "3"(r2),
                        "4"(r3),
                        "5"(r4),
                        "6"(kptr)
                        : "memory", "q0", "q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12", "q13", "q14", "q15");
#endif // __aarch64__
                }
                for (; j + 1 < outw; j += 2)
                {
#if __aarch64__
                    asm volatile(
                        "prfm   pldl1keep, [%1, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%1], #16   \n" // r00 r01

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "prfm   pldl1keep, [%0, #256]       \n"
                        "ld1    {v20.4s, v21.4s}, [%0]      \n" // sum0 sum1

                        "fmul   v22.4s, v16.4s, v0.s[0]     \n"
                        "fmul   v23.4s, v16.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v17.4s, v1.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v22.4s, v18.4s, v0.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v1.s[2]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%1, #256]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h, v5.4h}, [%1] \n" // r02 r03 r04 r05
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v19.4s, v1.s[3]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v1.s[0]     \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmla   v23.4s, v24.4s, v2.s[0]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmla   v22.4s, v26.4s, v1.s[2]     \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "fmla   v23.4s, v26.4s, v2.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v22.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%2, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%2], #16   \n" // r10 r11
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v16.4s, v5.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v5.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v22.4s, v24.4s, v0.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v20.4s, v25.4s, v0.s[1]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v25.4s, v1.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v22.4s, v26.4s, v0.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v1.s[2]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%2, #256]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h, v5.4h}, [%2] \n" // r12 r13 r14 r15
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v27.4s, v1.s[3]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v1.s[0]     \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmla   v23.4s, v16.4s, v2.s[0]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "fmla   v20.4s, v17.4s, v1.s[1]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmla   v22.4s, v18.4s, v1.s[2]     \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v20.4s, v25.4s, v2.s[1]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v20.4s, v17.4s, v3.s[1]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v22.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%3, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%3], #16   \n" // r20 r21
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v4.s[0]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v24.4s, v5.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v20.4s, v25.4s, v4.s[1]     \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "fmla   v22.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v5.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v0.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v17.4s, v1.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v22.4s, v18.4s, v0.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v1.s[2]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%3, #256]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h, v5.4h}, [%3] \n" // r22 r23 r24 r25
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v19.4s, v1.s[3]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v1.s[0]     \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmla   v23.4s, v24.4s, v2.s[0]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmla   v22.4s, v26.4s, v1.s[2]     \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "fmla   v23.4s, v26.4s, v2.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v22.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%4, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%4], #16   \n" // r30 r31
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v16.4s, v5.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v5.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v22.4s, v24.4s, v0.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v20.4s, v25.4s, v0.s[1]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v25.4s, v1.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v22.4s, v26.4s, v0.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v1.s[2]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%4, #256]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h, v5.4h}, [%4] \n" // r32 r33 r34 r35
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v27.4s, v1.s[3]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v1.s[0]     \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmla   v23.4s, v16.4s, v2.s[0]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "fmla   v20.4s, v17.4s, v1.s[1]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmla   v22.4s, v18.4s, v1.s[2]     \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v20.4s, v25.4s, v2.s[1]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v20.4s, v17.4s, v3.s[1]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v22.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%5, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%5], #16   \n" // r40 r41
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v4.s[0]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v24.4s, v5.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v20.4s, v25.4s, v4.s[1]     \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "fmla   v22.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v5.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v0.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v17.4s, v1.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v22.4s, v18.4s, v0.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v1.s[2]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%5, #256]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h, v5.4h}, [%5] \n" // r42 r43 r44 r45
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v19.4s, v1.s[3]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v1.s[0]     \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmla   v23.4s, v24.4s, v2.s[0]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmla   v22.4s, v26.4s, v1.s[2]     \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "fmla   v23.4s, v26.4s, v2.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v4.s[0]     \n"
                        //                         "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6] \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v22.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v5.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"

                        "fadd   v20.4s, v20.4s, v22.4s      \n"
                        "fadd   v21.4s, v21.4s, v23.4s      \n"

                        "sub    %6, %6, #768                \n" // kptr -= 24 * 16;

                        "st1    {v20.4s, v21.4s}, [%0], #32 \n"

                        : "=r"(outptr0), // %0
                        "=r"(r0),      // %1
                        "=r"(r1),      // %2
                        "=r"(r2),      // %3
                        "=r"(r3),      // %4
                        "=r"(r4),      // %5
                        "=r"(kptr)     // %6
                        : "0"(outptr0),
                        "1"(r0),
                        "2"(r1),
                        "3"(r2),
                        "4"(r3),
                        "5"(r4),
                        "6"(kptr)
                        : "memory", "v0", "v1", "v2", "v3", "v4", "v5", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27");
#else  // __aarch64__
                    asm volatile(
                        "pld        [%1, #128]          \n"
                        "vld1.u16   {d2-d3}, [%1 :64]!  \n" // r00 r01

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vshll.u16  q0, d2, #16         \n"
                        "vshll.u16  q1, d3, #16         \n"

                        "pld        [%1, #256]          \n"
                        "vld1.u16   {d8-d11}, [%1 :64]  \n" // r02 r03 r04 r05

                        "vshll.u16  q8, d20, #16        \n"

                        "pld        [%0, #256]          \n"
                        "vld1.f32   {d24-d27}, [%0 :128] \n" // sum0 sum1

                        "vmul.f32   q14, q8, d0[0]      \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vmul.f32   q15, q8, d2[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d2[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d1[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d3[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vshll.u16  q2, d8, #16         \n"
                        "vmla.f32   q13, q11, d3[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d2[0]     \n"
                        "vmla.f32   q15, q10, d4[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d3[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vshll.u16  q3, d9, #16         \n"
                        "vmla.f32   q13, q9, d5[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d4[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d6[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d5[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vmla.f32   q13, q11, d7[1]     \n"
                        "pld        [%2, #128]          \n"
                        "vld1.u16   {d2-d3}, [%2 :64]!  \n" // r10 r11

                        "vmla.f32   q14, q10, d6[0]     \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d8[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d7[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vmla.f32   q13, q9, d9[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vshll.u16  q0, d2, #16         \n"
                        "vmla.f32   q13, q9, d10[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vshll.u16  q1, d3, #16         \n"
                        "vmla.f32   q13, q11, d11[1]    \n"
                        "pld        [%2, #256]          \n"
                        "vld1.u16   {d8-d11}, [%2 :64]  \n" // r12 r13 r14 r15

                        "vmla.f32   q14, q10, d0[0]     \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vmla.f32   q15, q10, d2[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d0[1]     \n"
                        "vmla.f32   q13, q11, d2[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d1[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "vshll.u16  q2, d8, #16         \n"
                        "vmla.f32   q13, q9, d3[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d2[0]      \n"
                        "vmla.f32   q15, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d2[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d3[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vshll.u16  q3, d9, #16         \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d4[0]     \n"
                        "vmla.f32   q15, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d4[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d5[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "pld        [%3, #128]          \n"
                        "vld1.u16   {d2-d3}, [%3 :64]!  \n" // r20 r21

                        "vmla.f32   q14, q8, d6[0]      \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vmla.f32   q15, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d6[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d7[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d8[0]     \n"
                        "vmla.f32   q15, q10, d10[0]    \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d8[1]     \n"
                        "vshll.u16  q0, d2, #16         \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d9[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d11[0]     \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vshll.u16  q1, d3, #16         \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "pld        [%3, #256]          \n"
                        "vld1.u16   {d8-d11}, [%3 :64]  \n" // r22 r23 r24 r25

                        "vmla.f32   q14, q8, d0[0]      \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vmla.f32   q15, q8, d2[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d2[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d1[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d3[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vshll.u16  q2, d8, #16         \n"
                        "vmla.f32   q13, q11, d3[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d2[0]     \n"
                        "vmla.f32   q15, q10, d4[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d3[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vshll.u16  q3, d9, #16         \n"
                        "vmla.f32   q13, q9, d5[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d4[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d6[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d5[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vmla.f32   q13, q11, d7[1]     \n"
                        "pld        [%4, #128]          \n"
                        "vld1.u16   {d2-d3}, [%4 :64]!  \n" // r30 r31

                        "vmla.f32   q14, q10, d6[0]     \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d8[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d7[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vmla.f32   q13, q9, d9[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vshll.u16  q0, d2, #16         \n"
                        "vmla.f32   q13, q9, d10[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vshll.u16  q1, d3, #16         \n"
                        "vmla.f32   q13, q11, d11[1]    \n"
                        "pld        [%4, #256]          \n"
                        "vld1.u16   {d8-d11}, [%4 :64]  \n" // r32 r33 r34 r35

                        "vmla.f32   q14, q10, d0[0]     \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vmla.f32   q15, q10, d2[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d0[1]     \n"
                        "vmla.f32   q13, q11, d2[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d1[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "vshll.u16  q2, d8, #16         \n"
                        "vmla.f32   q13, q9, d3[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d2[0]      \n"
                        "vmla.f32   q15, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d2[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d3[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vshll.u16  q3, d9, #16         \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d4[0]     \n"
                        "vmla.f32   q15, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d4[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d5[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "pld        [%5, #128]          \n"
                        "vld1.u16   {d2-d3}, [%5 :64]!  \n" // r40 r41

                        "vmla.f32   q14, q8, d6[0]      \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vmla.f32   q15, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d6[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d7[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d8[0]     \n"
                        "vmla.f32   q15, q10, d10[0]    \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d8[1]     \n"
                        "vshll.u16  q0, d2, #16         \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d9[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d11[0]     \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vshll.u16  q1, d3, #16         \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "pld        [%5, #256]          \n"
                        "vld1.u16   {d8-d11}, [%5 :64]  \n" // r42 r43 r44 r45

                        "vmla.f32   q14, q8, d0[0]      \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vmla.f32   q15, q8, d2[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d2[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d1[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d3[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vshll.u16  q2, d8, #16         \n"
                        "vmla.f32   q13, q11, d3[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d2[0]     \n"
                        "vmla.f32   q15, q10, d4[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d3[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vshll.u16  q3, d9, #16         \n"
                        "vmla.f32   q13, q9, d5[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d4[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d6[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d5[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vmla.f32   q13, q11, d7[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d6[0]     \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d8[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128] \n"

                        "vmla.f32   q14, q8, d7[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vmla.f32   q13, q9, d9[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d10[1]     \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d11[1]    \n"

                        "vadd.f32   q12, q12, q14       \n"
                        "vadd.f32   q13, q13, q15       \n"

                        "sub        %6, %6, #768        \n" // kptr -= 24 * 16;

                        "vst1.f32   {d24-d27}, [%0 :128]! \n"

                        : "=r"(outptr0), // %0
                        "=r"(r0),      // %1
                        "=r"(r1),      // %2
                        "=r"(r2),      // %3
                        "=r"(r3),      // %4
                        "=r"(r4),      // %5
                        "=r"(kptr)     // %6
                        : "0"(outptr0),
                        "1"(r0),
                        "2"(r1),
                        "3"(r2),
                        "4"(r3),
                        "5"(r4),
                        "6"(kptr)
                        : "memory", "q0", "q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12", "q13", "q14", "q15");
#endif // __aarch64__
                }
                for (; j < outw; j++)
                {
#if __aarch64__
                    asm volatile(
                        "prfm   pldl1keep, [%1, #64]        \n"
                        "ld1    {v0.4h}, [%1], #8           \n" // r00

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v0.4s, v0.4h, #16           \n"

                        "prfm   pldl1keep, [%1, #256]       \n"
                        "ld1    {v1.4h, v2.4h, v3.4h, v4.4h}, [%1] \n" // r01 r02 r03 r04

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "prfm   pldl1keep, [%0, #128]       \n"
                        "ld1    {v20.4s}, [%0]              \n" // sum0

                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmul   v21.4s, v16.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmul   v22.4s, v17.4s, v0.s[1]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmul   v23.4s, v18.4s, v0.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v1.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v1.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v2.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%2, #64]        \n"
                        "ld1    {v0.4h}, [%2], #8           \n" // r10
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "prfm   pldl1keep, [%2, #256]       \n"
                        "ld1    {v1.4h, v2.4h, v3.4h, v4.4h}, [%2] \n" // r11 r12 r13 r14
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v21.4s, v24.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmla   v22.4s, v25.4s, v0.s[1]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmla   v23.4s, v26.4s, v0.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v1.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v1.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v2.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v2.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v3.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%3, #64]        \n"
                        "ld1    {v0.4h}, [%3], #8           \n" // r20
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v22.4s, v25.4s, v4.s[1]     \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "prfm   pldl1keep, [%3, #256]       \n"
                        "ld1    {v1.4h, v2.4h, v3.4h, v4.4h}, [%3] \n" // r21 r22 r23 r24
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmla   v22.4s, v17.4s, v0.s[1]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmla   v23.4s, v18.4s, v0.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v1.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v1.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v2.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%4, #64]        \n"
                        "ld1    {v0.4h}, [%4], #8           \n" // r30
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "prfm   pldl1keep, [%4, #256]       \n"
                        "ld1    {v1.4h, v2.4h, v3.4h, v4.4h}, [%4] \n" // r31 r32 r33 r34
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v21.4s, v24.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmla   v22.4s, v25.4s, v0.s[1]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmla   v23.4s, v26.4s, v0.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v1.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v1.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v2.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v2.s[1]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v2.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v3.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%5, #64]        \n"
                        "ld1    {v0.4h}, [%5], #8           \n" // r40
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v22.4s, v25.4s, v4.s[1]     \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "prfm   pldl1keep, [%5, #256]       \n"
                        "ld1    {v1.4h, v2.4h, v3.4h, v4.4h}, [%5] \n" // r41 r42 r43 r44
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmla   v22.4s, v17.4s, v0.s[1]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmla   v23.4s, v18.4s, v0.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v1.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v1.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v2.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        //                         "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6] \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"

                        "fadd   v22.4s, v21.4s, v22.4s      \n"
                        "fadd   v23.4s, v22.4s, v23.4s      \n"
                        "fadd   v20.4s, v20.4s, v23.4s      \n"

                        "sub    %6, %6, #768                \n" // kptr -= 24 * 16;

                        "st1    {v20.4s}, [%0], #16         \n"

                        : "=r"(outptr0), // %0
                        "=r"(r0),      // %1
                        "=r"(r1),      // %2
                        "=r"(r2),      // %3
                        "=r"(r3),      // %4
                        "=r"(r4),      // %5
                        "=r"(kptr)     // %6
                        : "0"(outptr0),
                        "1"(r0),
                        "2"(r1),
                        "3"(r2),
                        "4"(r3),
                        "5"(r4),
                        "6"(kptr)
                        : "memory", "v0", "v1", "v2", "v3", "v4", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27");
#else  // __aarch64__
                    asm volatile(
                        "pld        [%1, #64]           \n"
                        "vld1.u16   {d1}, [%1 :64]!     \n" // r00

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vshll.u16  q0, d1, #16         \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "pld        [%0, #128]          \n"
                        "vld1.f32   {d24-d25}, [%0 :128] \n" // sum0

                        "vmul.f32   q13, q8, d0[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmul.f32   q14, q9, d0[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmul.f32   q15, q10, d1[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "pld        [%1, #256]          \n"
                        "vld1.u16   {d6-d9}, [%1 :64]   \n" // r01 r02 r03 r04
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q1, d6, #16         \n"
                        "vshll.u16  q2, d7, #16         \n"
                        "vshll.u16  q3, d8, #16         \n"
                        "vshll.u16  q4, d9, #16         \n"

                        "vmla.f32   q13, q10, d2[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d2[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d4[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d6[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "pld        [%2, #64]           \n"
                        "vld1.u16   {d1}, [%2 :64]!     \n" // r10
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q0, d1, #16         \n"

                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d0[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d0[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d1[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "pld        [%2, #256]          \n"
                        "vld1.u16   {d6-d9}, [%2 :64]   \n" // r11 r12 r13 r14
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q1, d6, #16         \n"
                        "vshll.u16  q2, d7, #16         \n"
                        "vshll.u16  q3, d8, #16         \n"
                        "vshll.u16  q4, d9, #16         \n"

                        "vmla.f32   q13, q8, d2[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d2[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d3[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d4[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d4[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d6[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d6[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "pld        [%3, #64]           \n"
                        "vld1.u16   {d1}, [%3 :64]!     \n" // r20
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q0, d1, #16         \n"

                        "vmla.f32   q13, q10, d8[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d8[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d0[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d0[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d1[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "pld        [%3, #256]          \n"
                        "vld1.u16   {d6-d9}, [%3 :64]   \n" // r21 r22 r23 r24
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q1, d6, #16         \n"
                        "vshll.u16  q2, d7, #16         \n"
                        "vshll.u16  q3, d8, #16         \n"
                        "vshll.u16  q4, d9, #16         \n"

                        "vmla.f32   q13, q10, d2[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d2[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d4[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d6[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "pld        [%4, #64]           \n"
                        "vld1.u16   {d1}, [%4 :64]!     \n" // r30
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q0, d1, #16         \n"

                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d0[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d0[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d1[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "pld        [%4, #256]          \n"
                        "vld1.u16   {d6-d9}, [%4 :64]   \n" // r31 r32 r33 r34
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q1, d6, #16         \n"
                        "vshll.u16  q2, d7, #16         \n"
                        "vshll.u16  q3, d8, #16         \n"
                        "vshll.u16  q4, d9, #16         \n"

                        "vmla.f32   q13, q8, d2[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d2[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d3[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d4[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d4[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d6[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d6[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "pld        [%5, #64]           \n"
                        "vld1.u16   {d1}, [%5 :64]!     \n" // r40
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q0, d1, #16         \n"

                        "vmla.f32   q13, q10, d8[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d8[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d0[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d0[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d1[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "pld        [%5, #256]          \n"
                        "vld1.u16   {d6-d9}, [%5 :64]   \n" // r41 r42 r43 r44
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q1, d6, #16         \n"
                        "vshll.u16  q2, d7, #16         \n"
                        "vshll.u16  q3, d8, #16         \n"
                        "vshll.u16  q4, d9, #16         \n"

                        "vmla.f32   q13, q10, d2[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d2[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d4[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d6[1]     \n"
                        //                         "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128] \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vmla.f32   q12, q11, d9[1]     \n"

                        "vadd.f32   q13, q13, q14       \n"
                        "vadd.f32   q12, q12, q15       \n"
                        "vadd.f32   q12, q12, q13       \n"

                        "sub        %6, %6, #768        \n" // kptr -= 24 * 16;

                        "vst1.f32   {d24-d25}, [%0 :128]! \n"

                        : "=r"(outptr0), // %0
                        "=r"(r0),      // %1
                        "=r"(r1),      // %2
                        "=r"(r2),      // %3
                        "=r"(r3),      // %4
                        "=r"(r4),      // %5
                        "=r"(kptr)     // %6
                        : "0"(outptr0),
                        "1"(r0),
                        "2"(r1),
                        "3"(r2),
                        "4"(r3),
                        "5"(r4),
                        "6"(kptr)
                        : "memory", "q0", "q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12", "q13", "q14", "q15");
#endif // __aarch64__
                }

                r0 += 4 * 4;
                r1 += 4 * 4;
                r2 += 4 * 4;
                r3 += 4 * 4;
                r4 += 4 * 4;
            }
        }
        for (; q < inch; q++)
        {
            unsigned short* outptr0_bf16 = top_blob.channel(p);

            const float* outptr0 = out0.row(0);

            const Mat img0 = bottom_blob.channel(q);

            const unsigned short* r0 = img0.row<const unsigned short>(0);
            const unsigned short* r1 = img0.row<const unsigned short>(1);
            const unsigned short* r2 = img0.row<const unsigned short>(2);
            const unsigned short* r3 = img0.row<const unsigned short>(3);
            const unsigned short* r4 = img0.row<const unsigned short>(4);

            const unsigned short* kptr = kernel.channel(p).row<const unsigned short>(q);

            int i = 0;
            for (; i < outh; i++)
            {
                int j = 0;
                for (; j + 3 < outw; j += 4)
                {
#if __aarch64__
                    asm volatile(
                        "prfm   pldl1keep, [%1, #512]       \n"
                        "ld1    {v20.4s, v21.4s, v22.4s, v23.4s}, [%1], #64 \n" // sum0 sum1 sum2 sum3

                        "prfm   pldl1keep, [%2, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%2], #32 \n" // r00 r01 r02 r03

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v16.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v1.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v1.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v3.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v1.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v3.s[3]     \n"

                        "prfm   pldl1keep, [%2, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%2] \n" // r04 r05 r06 r07

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "fmla   v20.4s, v24.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v4.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v4.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v5.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v5.s[3]     \n"

                        "fmla   v20.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v6.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v6.s[3]     \n"

                        "prfm   pldl1keep, [%3, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%3], #32 \n" // r10 r11 r12 r13

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v20.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v7.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v7.s[3]     \n"

                        "fmla   v20.4s, v24.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v1.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v3.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v3.s[3]     \n"

                        "prfm   pldl1keep, [%3, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%3] \n" // r14 r15 r16 r17

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "fmla   v20.4s, v16.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v4.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v4.s[3]     \n"

                        "fmla   v20.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v5.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v5.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v6.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v6.s[3]     \n"

                        "prfm   pldl1keep, [%4, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%4], #32 \n" // r20 r21 r22 r23

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v20.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v7.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v7.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v1.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v1.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v3.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v1.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v3.s[3]     \n"

                        "prfm   pldl1keep, [%4, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%4] \n" // r24 r25 r26 r27

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "fmla   v20.4s, v24.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v4.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v4.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v5.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v5.s[3]     \n"

                        "fmla   v20.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v6.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v6.s[3]     \n"

                        "prfm   pldl1keep, [%5, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%5], #32 \n" // r30 r31 r32 r33

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v20.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v7.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v7.s[3]     \n"

                        "fmla   v20.4s, v24.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v1.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v3.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v3.s[3]     \n"

                        "prfm   pldl1keep, [%5, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%5] \n" // r34 r35 r36 r37

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "fmla   v20.4s, v16.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v4.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v4.s[3]     \n"

                        "fmla   v20.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v5.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v5.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v6.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v6.s[3]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%6], #32 \n" // r40 r41 r42 r43

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v20.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v7.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v7.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v1.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v1.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v3.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v1.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v3.s[3]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%6] \n" // r44 r45 r46 r47

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "fmla   v20.4s, v24.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v4.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v4.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v5.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v5.s[3]     \n"

                        "fmla   v20.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v6.s[1]     \n"

                        //                         "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7] \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v6.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v7.s[1]     \n"
                        "fmla   v20.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v7.s[3]     \n"

                        "sub    %7, %7, #768                \n" // kptr -= 24 * 16;

                        "shrn   v20.4h, v20.4s, #16         \n"
                        "shrn   v21.4h, v21.4s, #16         \n"
                        "shrn   v22.4h, v22.4s, #16         \n"
                        "shrn   v23.4h, v23.4s, #16         \n"

                        "st1    {v20.4h, v21.4h, v22.4h, v23.4h}, [%0], #32 \n"

                        : "=r"(outptr0_bf16), // %0
                        "=r"(outptr0),      // %1
                        "=r"(r0),           // %2
                        "=r"(r1),           // %3
                        "=r"(r2),           // %4
                        "=r"(r3),           // %5
                        "=r"(r4),           // %6
                        "=r"(kptr)          // %7
                        : "0"(outptr0_bf16),
                        "1"(outptr0),
                        "2"(r0),
                        "3"(r1),
                        "4"(r2),
                        "5"(r3),
                        "6"(r4),
                        "7"(kptr)
                        : "memory", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27");
#else  // __aarch64__
                    asm volatile(
                        "pld        [%1, #512]          \n"
                        "vldm       %1!, {d24-d31}      \n" // sum0 sum1 sum2 sum3

                        "pld        [%2, #256]          \n"
                        "vld1.u16   {d4-d7}, [%2 :64]!  \n" // r00 r01 r02 r03

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d0[0]      \n"
                        "vmla.f32   q13, q8, d2[0]      \n"
                        "vmla.f32   q14, q8, d4[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d2[1]      \n"
                        "vmla.f32   q14, q9, d4[1]      \n"
                        "vmla.f32   q15, q9, d6[1]      \n"
                        "vmla.f32   q12, q10, d1[0]     \n"
                        "vmla.f32   q13, q10, d3[0]     \n"
                        "vmla.f32   q14, q10, d5[0]     \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vmla.f32   q13, q11, d3[1]     \n"
                        "vmla.f32   q14, q11, d5[1]     \n"
                        "vmla.f32   q15, q11, d7[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%2, #256]          \n"
                        "vld1.u16   {d12-d15}, [%2 :64] \n" // r04 r05 r06 r07

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q12, q10, d2[0]     \n"
                        "vmla.f32   q13, q10, d4[0]     \n"
                        "vmla.f32   q14, q10, d6[0]     \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "vmla.f32   q14, q11, d6[1]     \n"
                        "vmla.f32   q15, q11, d8[1]     \n"
                        "vmla.f32   q12, q8, d3[0]      \n"
                        "vmla.f32   q13, q8, d5[0]      \n"
                        "vmla.f32   q14, q8, d7[0]      \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vmla.f32   q13, q9, d5[1]      \n"
                        "vmla.f32   q14, q9, d7[1]      \n"
                        "vmla.f32   q15, q9, d9[1]      \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d4[0]      \n"
                        "vmla.f32   q13, q8, d6[0]      \n"
                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d6[1]      \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "vmla.f32   q15, q9, d10[1]     \n"
                        "vmla.f32   q12, q10, d5[0]     \n"
                        "vmla.f32   q13, q10, d7[0]     \n"
                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vmla.f32   q13, q11, d7[1]     \n"
                        "vmla.f32   q14, q11, d9[1]     \n"
                        "vmla.f32   q15, q11, d11[1]    \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d6[0]     \n"
                        "vmla.f32   q13, q10, d8[0]     \n"
                        "vmla.f32   q14, q10, d10[0]    \n"
                        "vmla.f32   q15, q10, d12[0]    \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d8[1]     \n"
                        "vmla.f32   q14, q11, d10[1]    \n"
                        "vmla.f32   q15, q11, d12[1]    \n"
                        "vmla.f32   q12, q8, d7[0]      \n"
                        "vmla.f32   q13, q8, d9[0]      \n"
                        "vmla.f32   q14, q8, d11[0]     \n"
                        "vmla.f32   q15, q8, d13[0]     \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vmla.f32   q13, q9, d9[1]      \n"
                        "vmla.f32   q14, q9, d11[1]     \n"
                        "vmla.f32   q15, q9, d13[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%3, #256]          \n"
                        "vld1.u16   {d4-d7}, [%3 :64]!  \n" // r10 r11 r12 r13

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q12, q8, d8[0]      \n"
                        "vmla.f32   q13, q8, d10[0]     \n"
                        "vmla.f32   q14, q8, d12[0]     \n"
                        "vmla.f32   q15, q8, d14[0]     \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d10[1]     \n"
                        "vmla.f32   q14, q9, d12[1]     \n"
                        "vmla.f32   q15, q9, d14[1]     \n"
                        "vmla.f32   q12, q10, d9[0]     \n"
                        "vmla.f32   q13, q10, d11[0]    \n"
                        "vmla.f32   q14, q10, d13[0]    \n"
                        "vmla.f32   q15, q10, d15[0]    \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d11[1]    \n"
                        "vmla.f32   q14, q11, d13[1]    \n"
                        "vmla.f32   q15, q11, d15[1]    \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d0[0]     \n"
                        "vmla.f32   q13, q10, d2[0]     \n"
                        "vmla.f32   q14, q10, d4[0]     \n"
                        "vmla.f32   q15, q10, d6[0]     \n"
                        "vmla.f32   q12, q11, d0[1]     \n"
                        "vmla.f32   q13, q11, d2[1]     \n"
                        "vmla.f32   q14, q11, d4[1]     \n"
                        "vmla.f32   q15, q11, d6[1]     \n"
                        "vmla.f32   q12, q8, d1[0]      \n"
                        "vmla.f32   q13, q8, d3[0]      \n"
                        "vmla.f32   q14, q8, d5[0]      \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "vmla.f32   q13, q9, d3[1]      \n"
                        "vmla.f32   q14, q9, d5[1]      \n"
                        "vmla.f32   q15, q9, d7[1]      \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%3, #256]          \n"
                        "vld1.u16   {d12-d15}, [%3 :64] \n" // r14 r15 r16 r17

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q12, q8, d2[0]      \n"
                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vmla.f32   q14, q8, d6[0]      \n"
                        "vmla.f32   q15, q8, d8[0]      \n"
                        "vmla.f32   q12, q9, d2[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "vmla.f32   q14, q9, d6[1]      \n"
                        "vmla.f32   q15, q9, d8[1]      \n"
                        "vmla.f32   q12, q10, d3[0]     \n"
                        "vmla.f32   q13, q10, d5[0]     \n"
                        "vmla.f32   q14, q10, d7[0]     \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "vmla.f32   q14, q11, d7[1]     \n"
                        "vmla.f32   q15, q11, d9[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d4[0]     \n"
                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vmla.f32   q14, q10, d8[0]     \n"
                        "vmla.f32   q15, q10, d10[0]    \n"
                        "vmla.f32   q12, q11, d4[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "vmla.f32   q14, q11, d8[1]     \n"
                        "vmla.f32   q15, q11, d10[1]    \n"
                        "vmla.f32   q12, q8, d5[0]      \n"
                        "vmla.f32   q13, q8, d7[0]      \n"
                        "vmla.f32   q14, q8, d9[0]      \n"
                        "vmla.f32   q15, q8, d11[0]     \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "vmla.f32   q14, q9, d9[1]      \n"
                        "vmla.f32   q15, q9, d11[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d6[0]      \n"
                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vmla.f32   q14, q8, d10[0]     \n"
                        "vmla.f32   q15, q8, d12[0]     \n"
                        "vmla.f32   q12, q9, d6[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "vmla.f32   q14, q9, d10[1]     \n"
                        "vmla.f32   q15, q9, d12[1]     \n"
                        "vmla.f32   q12, q10, d7[0]     \n"
                        "vmla.f32   q13, q10, d9[0]     \n"
                        "vmla.f32   q14, q10, d11[0]    \n"
                        "vmla.f32   q15, q10, d13[0]    \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vmla.f32   q14, q11, d11[1]    \n"
                        "vmla.f32   q15, q11, d13[1]    \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%4, #256]          \n"
                        "vld1.u16   {d4-d7}, [%4 :64]!  \n" // r20 r21 r22 r23

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q12, q10, d8[0]     \n"
                        "vmla.f32   q13, q10, d10[0]    \n"
                        "vmla.f32   q14, q10, d12[0]    \n"
                        "vmla.f32   q15, q10, d14[0]    \n"
                        "vmla.f32   q12, q11, d8[1]     \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        "vmla.f32   q14, q11, d12[1]    \n"
                        "vmla.f32   q15, q11, d14[1]    \n"
                        "vmla.f32   q12, q8, d9[0]      \n"
                        "vmla.f32   q13, q8, d11[0]     \n"
                        "vmla.f32   q14, q8, d13[0]     \n"
                        "vmla.f32   q15, q8, d15[0]     \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "vmla.f32   q14, q9, d13[1]     \n"
                        "vmla.f32   q15, q9, d15[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d0[0]      \n"
                        "vmla.f32   q13, q8, d2[0]      \n"
                        "vmla.f32   q14, q8, d4[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d2[1]      \n"
                        "vmla.f32   q14, q9, d4[1]      \n"
                        "vmla.f32   q15, q9, d6[1]      \n"
                        "vmla.f32   q12, q10, d1[0]     \n"
                        "vmla.f32   q13, q10, d3[0]     \n"
                        "vmla.f32   q14, q10, d5[0]     \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vmla.f32   q13, q11, d3[1]     \n"
                        "vmla.f32   q14, q11, d5[1]     \n"
                        "vmla.f32   q15, q11, d7[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%4, #256]          \n"
                        "vld1.u16   {d12-d15}, [%4 :64] \n" // r24 r25 r26 r27

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q12, q10, d2[0]     \n"
                        "vmla.f32   q13, q10, d4[0]     \n"
                        "vmla.f32   q14, q10, d6[0]     \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "vmla.f32   q14, q11, d6[1]     \n"
                        "vmla.f32   q15, q11, d8[1]     \n"
                        "vmla.f32   q12, q8, d3[0]      \n"
                        "vmla.f32   q13, q8, d5[0]      \n"
                        "vmla.f32   q14, q8, d7[0]      \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vmla.f32   q13, q9, d5[1]      \n"
                        "vmla.f32   q14, q9, d7[1]      \n"
                        "vmla.f32   q15, q9, d9[1]      \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d4[0]      \n"
                        "vmla.f32   q13, q8, d6[0]      \n"
                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d6[1]      \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "vmla.f32   q15, q9, d10[1]     \n"
                        "vmla.f32   q12, q10, d5[0]     \n"
                        "vmla.f32   q13, q10, d7[0]     \n"
                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vmla.f32   q13, q11, d7[1]     \n"
                        "vmla.f32   q14, q11, d9[1]     \n"
                        "vmla.f32   q15, q11, d11[1]    \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d6[0]     \n"
                        "vmla.f32   q13, q10, d8[0]     \n"
                        "vmla.f32   q14, q10, d10[0]    \n"
                        "vmla.f32   q15, q10, d12[0]    \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d8[1]     \n"
                        "vmla.f32   q14, q11, d10[1]    \n"
                        "vmla.f32   q15, q11, d12[1]    \n"
                        "vmla.f32   q12, q8, d7[0]      \n"
                        "vmla.f32   q13, q8, d9[0]      \n"
                        "vmla.f32   q14, q8, d11[0]     \n"
                        "vmla.f32   q15, q8, d13[0]     \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vmla.f32   q13, q9, d9[1]      \n"
                        "vmla.f32   q14, q9, d11[1]     \n"
                        "vmla.f32   q15, q9, d13[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%5, #256]          \n"
                        "vld1.u16   {d4-d7}, [%5 :64]!  \n" // r30 r31 r32 r33

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q12, q8, d8[0]      \n"
                        "vmla.f32   q13, q8, d10[0]     \n"
                        "vmla.f32   q14, q8, d12[0]     \n"
                        "vmla.f32   q15, q8, d14[0]     \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d10[1]     \n"
                        "vmla.f32   q14, q9, d12[1]     \n"
                        "vmla.f32   q15, q9, d14[1]     \n"
                        "vmla.f32   q12, q10, d9[0]     \n"
                        "vmla.f32   q13, q10, d11[0]    \n"
                        "vmla.f32   q14, q10, d13[0]    \n"
                        "vmla.f32   q15, q10, d15[0]    \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d11[1]    \n"
                        "vmla.f32   q14, q11, d13[1]    \n"
                        "vmla.f32   q15, q11, d15[1]    \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d0[0]     \n"
                        "vmla.f32   q13, q10, d2[0]     \n"
                        "vmla.f32   q14, q10, d4[0]     \n"
                        "vmla.f32   q15, q10, d6[0]     \n"
                        "vmla.f32   q12, q11, d0[1]     \n"
                        "vmla.f32   q13, q11, d2[1]     \n"
                        "vmla.f32   q14, q11, d4[1]     \n"
                        "vmla.f32   q15, q11, d6[1]     \n"
                        "vmla.f32   q12, q8, d1[0]      \n"
                        "vmla.f32   q13, q8, d3[0]      \n"
                        "vmla.f32   q14, q8, d5[0]      \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "vmla.f32   q13, q9, d3[1]      \n"
                        "vmla.f32   q14, q9, d5[1]      \n"
                        "vmla.f32   q15, q9, d7[1]      \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%5, #256]          \n"
                        "vld1.u16   {d12-d15}, [%5 :64] \n" // r34 r35 r36 r37

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q12, q8, d2[0]      \n"
                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vmla.f32   q14, q8, d6[0]      \n"
                        "vmla.f32   q15, q8, d8[0]      \n"
                        "vmla.f32   q12, q9, d2[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "vmla.f32   q14, q9, d6[1]      \n"
                        "vmla.f32   q15, q9, d8[1]      \n"
                        "vmla.f32   q12, q10, d3[0]     \n"
                        "vmla.f32   q13, q10, d5[0]     \n"
                        "vmla.f32   q14, q10, d7[0]     \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "vmla.f32   q14, q11, d7[1]     \n"
                        "vmla.f32   q15, q11, d9[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d4[0]     \n"
                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vmla.f32   q14, q10, d8[0]     \n"
                        "vmla.f32   q15, q10, d10[0]    \n"
                        "vmla.f32   q12, q11, d4[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "vmla.f32   q14, q11, d8[1]     \n"
                        "vmla.f32   q15, q11, d10[1]    \n"
                        "vmla.f32   q12, q8, d5[0]      \n"
                        "vmla.f32   q13, q8, d7[0]      \n"
                        "vmla.f32   q14, q8, d9[0]      \n"
                        "vmla.f32   q15, q8, d11[0]     \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "vmla.f32   q14, q9, d9[1]      \n"
                        "vmla.f32   q15, q9, d11[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d6[0]      \n"
                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vmla.f32   q14, q8, d10[0]     \n"
                        "vmla.f32   q15, q8, d12[0]     \n"
                        "vmla.f32   q12, q9, d6[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "vmla.f32   q14, q9, d10[1]     \n"
                        "vmla.f32   q15, q9, d12[1]     \n"
                        "vmla.f32   q12, q10, d7[0]     \n"
                        "vmla.f32   q13, q10, d9[0]     \n"
                        "vmla.f32   q14, q10, d11[0]    \n"
                        "vmla.f32   q15, q10, d13[0]    \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vmla.f32   q14, q11, d11[1]    \n"
                        "vmla.f32   q15, q11, d13[1]    \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d4-d7}, [%6 :64]!  \n" // r40 r41 r42 r43

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q12, q10, d8[0]     \n"
                        "vmla.f32   q13, q10, d10[0]    \n"
                        "vmla.f32   q14, q10, d12[0]    \n"
                        "vmla.f32   q15, q10, d14[0]    \n"
                        "vmla.f32   q12, q11, d8[1]     \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        "vmla.f32   q14, q11, d12[1]    \n"
                        "vmla.f32   q15, q11, d14[1]    \n"
                        "vmla.f32   q12, q8, d9[0]      \n"
                        "vmla.f32   q13, q8, d11[0]     \n"
                        "vmla.f32   q14, q8, d13[0]     \n"
                        "vmla.f32   q15, q8, d15[0]     \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "vmla.f32   q14, q9, d13[1]     \n"
                        "vmla.f32   q15, q9, d15[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d0[0]      \n"
                        "vmla.f32   q13, q8, d2[0]      \n"
                        "vmla.f32   q14, q8, d4[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d2[1]      \n"
                        "vmla.f32   q14, q9, d4[1]      \n"
                        "vmla.f32   q15, q9, d6[1]      \n"
                        "vmla.f32   q12, q10, d1[0]     \n"
                        "vmla.f32   q13, q10, d3[0]     \n"
                        "vmla.f32   q14, q10, d5[0]     \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vmla.f32   q13, q11, d3[1]     \n"
                        "vmla.f32   q14, q11, d5[1]     \n"
                        "vmla.f32   q15, q11, d7[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d12-d15}, [%6 :64] \n" // r44 r45 r46 r47

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q12, q10, d2[0]     \n"
                        "vmla.f32   q13, q10, d4[0]     \n"
                        "vmla.f32   q14, q10, d6[0]     \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "vmla.f32   q14, q11, d6[1]     \n"
                        "vmla.f32   q15, q11, d8[1]     \n"
                        "vmla.f32   q12, q8, d3[0]      \n"
                        "vmla.f32   q13, q8, d5[0]      \n"
                        "vmla.f32   q14, q8, d7[0]      \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vmla.f32   q13, q9, d5[1]      \n"
                        "vmla.f32   q14, q9, d7[1]      \n"
                        "vmla.f32   q15, q9, d9[1]      \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :64]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d4[0]      \n"
                        "vmla.f32   q13, q8, d6[0]      \n"
                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d6[1]      \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "vmla.f32   q15, q9, d10[1]     \n"
                        "vmla.f32   q12, q10, d5[0]     \n"
                        "vmla.f32   q13, q10, d7[0]     \n"
                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vmla.f32   q13, q11, d7[1]     \n"
                        "vmla.f32   q14, q11, d9[1]     \n"
                        "vmla.f32   q15, q11, d11[1]    \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :64]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d6[0]     \n"
                        "vmla.f32   q13, q10, d8[0]     \n"
                        "vmla.f32   q14, q10, d10[0]    \n"
                        "vmla.f32   q15, q10, d12[0]    \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d8[1]     \n"
                        "vmla.f32   q14, q11, d10[1]    \n"
                        "vmla.f32   q15, q11, d12[1]    \n"
                        "vmla.f32   q12, q8, d7[0]      \n"
                        "vmla.f32   q13, q8, d9[0]      \n"
                        "vmla.f32   q14, q8, d11[0]     \n"
                        "vmla.f32   q15, q8, d13[0]     \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vmla.f32   q13, q9, d9[1]      \n"
                        "vmla.f32   q14, q9, d11[1]     \n"
                        "vmla.f32   q15, q9, d13[1]     \n"

                        //                         "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :64] \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d8[0]      \n"
                        "vmla.f32   q13, q8, d10[0]     \n"
                        "vmla.f32   q14, q8, d12[0]     \n"
                        "vmla.f32   q15, q8, d14[0]     \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d10[1]     \n"
                        "vmla.f32   q14, q9, d12[1]     \n"
                        "vmla.f32   q15, q9, d14[1]     \n"
                        "vmla.f32   q12, q10, d9[0]     \n"
                        "vmla.f32   q13, q10, d11[0]    \n"
                        "vmla.f32   q14, q10, d13[0]    \n"
                        "vmla.f32   q15, q10, d15[0]    \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d11[1]    \n"
                        "vmla.f32   q14, q11, d13[1]    \n"
                        "vmla.f32   q15, q11, d15[1]    \n"

                        "sub        %7, %7, #768        \n" // kptr -= 24 * 16;

                        "vshrn.u32  d24, q12, #16       \n"
                        "vshrn.u32  d25, q13, #16       \n"
                        "vshrn.u32  d26, q14, #16       \n"
                        "vshrn.u32  d27, q15, #16       \n"

                        "vst1.u16   {d24-d27}, [%0 :64]! \n"

                        : "=r"(outptr0_bf16), // %0
                        "=r"(outptr0),      // %1
                        "=r"(r0),           // %2
                        "=r"(r1),           // %3
                        "=r"(r2),           // %4
                        "=r"(r3),           // %5
                        "=r"(r4),           // %6
                        "=r"(kptr)          // %7
                        : "0"(outptr0_bf16),
                        "1"(outptr0),
                        "2"(r0),
                        "3"(r1),
                        "4"(r2),
                        "5"(r3),
                        "6"(r4),
                        "7"(kptr)
                        : "memory", "q0", "q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12", "q13", "q14", "q15");
#endif // __aarch64__
                }
                for (; j + 1 < outw; j += 2)
                {
#if __aarch64__
                    asm volatile(
                        "prfm   pldl1keep, [%2, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%2], #16   \n" // r00 r01

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "prfm   pldl1keep, [%1, #256]       \n"
                        "ld1    {v20.4s, v21.4s}, [%1], #32 \n" // sum0 sum1

                        "fmul   v22.4s, v16.4s, v0.s[0]     \n"
                        "fmul   v23.4s, v16.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v17.4s, v1.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v22.4s, v18.4s, v0.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v1.s[2]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%2, #256]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h, v5.4h}, [%2] \n" // r02 r03 r04 r05
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v19.4s, v1.s[3]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v1.s[0]     \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmla   v23.4s, v24.4s, v2.s[0]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmla   v22.4s, v26.4s, v1.s[2]     \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "fmla   v23.4s, v26.4s, v2.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v22.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%3, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%3], #16   \n" // r10 r11
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v16.4s, v5.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v5.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v22.4s, v24.4s, v0.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v20.4s, v25.4s, v0.s[1]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v25.4s, v1.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v22.4s, v26.4s, v0.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v1.s[2]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%3, #256]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h, v5.4h}, [%3] \n" // r12 r13 r14 r15
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v27.4s, v1.s[3]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v1.s[0]     \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmla   v23.4s, v16.4s, v2.s[0]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "fmla   v20.4s, v17.4s, v1.s[1]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmla   v22.4s, v18.4s, v1.s[2]     \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v20.4s, v25.4s, v2.s[1]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v20.4s, v17.4s, v3.s[1]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v22.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%4, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%4], #16   \n" // r20 r21
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v4.s[0]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v24.4s, v5.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v20.4s, v25.4s, v4.s[1]     \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "fmla   v22.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v5.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v0.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v17.4s, v1.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v22.4s, v18.4s, v0.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v1.s[2]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%4, #256]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h, v5.4h}, [%4] \n" // r22 r23 r24 r25
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v19.4s, v1.s[3]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v1.s[0]     \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmla   v23.4s, v24.4s, v2.s[0]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmla   v22.4s, v26.4s, v1.s[2]     \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "fmla   v23.4s, v26.4s, v2.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v22.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%5, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%5], #16   \n" // r30 r31
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v16.4s, v5.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v5.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v22.4s, v24.4s, v0.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v20.4s, v25.4s, v0.s[1]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v25.4s, v1.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v22.4s, v26.4s, v0.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v1.s[2]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%5, #256]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h, v5.4h}, [%5] \n" // r32 r33 r34 r35
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v27.4s, v1.s[3]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v1.s[0]     \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmla   v23.4s, v16.4s, v2.s[0]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "fmla   v20.4s, v17.4s, v1.s[1]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmla   v22.4s, v18.4s, v1.s[2]     \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v20.4s, v25.4s, v2.s[1]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v20.4s, v17.4s, v3.s[1]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v22.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%6, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%6], #16   \n" // r40 r41
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v4.s[0]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v24.4s, v5.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v20.4s, v25.4s, v4.s[1]     \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "fmla   v22.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v5.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v0.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v17.4s, v1.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v22.4s, v18.4s, v0.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v1.s[2]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h, v5.4h}, [%6] \n" // r42 r43 r44 r45
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v19.4s, v1.s[3]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v1.s[0]     \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmla   v23.4s, v24.4s, v2.s[0]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmla   v22.4s, v26.4s, v1.s[2]     \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "fmla   v23.4s, v26.4s, v2.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v22.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v4.s[0]     \n"
                        //                         "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7] \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v22.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v5.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"

                        "fadd   v20.4s, v20.4s, v22.4s      \n"
                        "fadd   v21.4s, v21.4s, v23.4s      \n"

                        "sub    %7, %7, #768                \n" // kptr -= 24 * 16;

                        "shrn   v20.4h, v20.4s, #16         \n"
                        "shrn   v21.4h, v21.4s, #16         \n"

                        "st1    {v20.4h, v21.4h}, [%0], #16 \n"

                        : "=r"(outptr0_bf16), // %0
                        "=r"(outptr0),      // %1
                        "=r"(r0),           // %2
                        "=r"(r1),           // %3
                        "=r"(r2),           // %4
                        "=r"(r3),           // %5
                        "=r"(r4),           // %6
                        "=r"(kptr)          // %7
                        : "0"(outptr0_bf16),
                        "1"(outptr0),
                        "2"(r0),
                        "3"(r1),
                        "4"(r2),
                        "5"(r3),
                        "6"(r4),
                        "7"(kptr)
                        : "memory", "v0", "v1", "v2", "v3", "v4", "v5", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27");
#else  // __aarch64__
                    asm volatile(
                        "pld        [%2, #128]          \n"
                        "vld1.u16   {d2-d3}, [%2 :64]!  \n" // r00 r01

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vshll.u16  q0, d2, #16         \n"
                        "vshll.u16  q1, d3, #16         \n"

                        "pld        [%2, #256]          \n"
                        "vld1.u16   {d8-d11}, [%2 :64]  \n" // r02 r03 r04 r05

                        "vshll.u16  q8, d20, #16        \n"

                        "pld        [%1, #256]          \n"
                        "vld1.f32   {d24-d27}, [%1 :128]! \n" // sum0 sum1

                        "vmul.f32   q14, q8, d0[0]      \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vmul.f32   q15, q8, d2[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d2[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d1[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d3[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vshll.u16  q2, d8, #16         \n"
                        "vmla.f32   q13, q11, d3[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d2[0]     \n"
                        "vmla.f32   q15, q10, d4[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d3[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vshll.u16  q3, d9, #16         \n"
                        "vmla.f32   q13, q9, d5[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d4[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d6[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d5[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vmla.f32   q13, q11, d7[1]     \n"
                        "pld        [%3, #128]          \n"
                        "vld1.u16   {d2-d3}, [%3 :64]!  \n" // r10 r11

                        "vmla.f32   q14, q10, d6[0]     \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d8[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d7[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vmla.f32   q13, q9, d9[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vshll.u16  q0, d2, #16         \n"
                        "vmla.f32   q13, q9, d10[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vshll.u16  q1, d3, #16         \n"
                        "vmla.f32   q13, q11, d11[1]    \n"
                        "pld        [%3, #256]          \n"
                        "vld1.u16   {d8-d11}, [%3 :64]  \n" // r12 r13 r14 r15

                        "vmla.f32   q14, q10, d0[0]     \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vmla.f32   q15, q10, d2[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d0[1]     \n"
                        "vmla.f32   q13, q11, d2[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d1[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "vshll.u16  q2, d8, #16         \n"
                        "vmla.f32   q13, q9, d3[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d2[0]      \n"
                        "vmla.f32   q15, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d2[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d3[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vshll.u16  q3, d9, #16         \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d4[0]     \n"
                        "vmla.f32   q15, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d4[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d5[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "pld        [%4, #128]          \n"
                        "vld1.u16   {d2-d3}, [%4 :64]!  \n" // r20 r21

                        "vmla.f32   q14, q8, d6[0]      \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vmla.f32   q15, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d6[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d7[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d8[0]     \n"
                        "vmla.f32   q15, q10, d10[0]    \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d8[1]     \n"
                        "vshll.u16  q0, d2, #16         \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d9[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d11[0]     \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vshll.u16  q1, d3, #16         \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "pld        [%4, #256]          \n"
                        "vld1.u16   {d8-d11}, [%4 :64]  \n" // r22 r23 r24 r25

                        "vmla.f32   q14, q8, d0[0]      \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vmla.f32   q15, q8, d2[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d2[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d1[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d3[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vshll.u16  q2, d8, #16         \n"
                        "vmla.f32   q13, q11, d3[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d2[0]     \n"
                        "vmla.f32   q15, q10, d4[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d3[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vshll.u16  q3, d9, #16         \n"
                        "vmla.f32   q13, q9, d5[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d4[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d6[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d5[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vmla.f32   q13, q11, d7[1]     \n"
                        "pld        [%5, #128]          \n"
                        "vld1.u16   {d2-d3}, [%5 :64]!  \n" // r30 r31

                        "vmla.f32   q14, q10, d6[0]     \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d8[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d7[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vmla.f32   q13, q9, d9[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vshll.u16  q0, d2, #16         \n"
                        "vmla.f32   q13, q9, d10[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vshll.u16  q1, d3, #16         \n"
                        "vmla.f32   q13, q11, d11[1]    \n"
                        "pld        [%5, #256]          \n"
                        "vld1.u16   {d8-d11}, [%5 :64]  \n" // r32 r33 r34 r35

                        "vmla.f32   q14, q10, d0[0]     \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vmla.f32   q15, q10, d2[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d0[1]     \n"
                        "vmla.f32   q13, q11, d2[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d1[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "vshll.u16  q2, d8, #16         \n"
                        "vmla.f32   q13, q9, d3[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d2[0]      \n"
                        "vmla.f32   q15, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d2[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d3[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vshll.u16  q3, d9, #16         \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d4[0]     \n"
                        "vmla.f32   q15, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d4[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d5[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "pld        [%6, #128]          \n"
                        "vld1.u16   {d2-d3}, [%6 :64]!  \n" // r40 r41

                        "vmla.f32   q14, q8, d6[0]      \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vmla.f32   q15, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d6[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d7[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d8[0]     \n"
                        "vmla.f32   q15, q10, d10[0]    \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d8[1]     \n"
                        "vshll.u16  q0, d2, #16         \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d9[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d11[0]     \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vshll.u16  q1, d3, #16         \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d8-d11}, [%6 :64]  \n" // r42 r43 r44 r45

                        "vmla.f32   q14, q8, d0[0]      \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vmla.f32   q15, q8, d2[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d2[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d1[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d3[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vshll.u16  q2, d8, #16         \n"
                        "vmla.f32   q13, q11, d3[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d2[0]     \n"
                        "vmla.f32   q15, q10, d4[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d3[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vshll.u16  q3, d9, #16         \n"
                        "vmla.f32   q13, q9, d5[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d4[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d6[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d5[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vmla.f32   q13, q11, d7[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d6[0]     \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d8[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128] \n"

                        "vmla.f32   q14, q8, d7[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vmla.f32   q13, q9, d9[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d10[1]     \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d11[1]    \n"

                        "vadd.f32   q12, q12, q14       \n"
                        "vadd.f32   q13, q13, q15       \n"

                        "sub        %7, %7, #768        \n" // kptr -= 24 * 16;

                        "vshrn.u32  d24, q12, #16       \n"
                        "vshrn.u32  d25, q13, #16       \n"

                        "vst1.u16   {d24-d25}, [%0 :64]! \n"

                        : "=r"(outptr0_bf16), // %0
                        "=r"(outptr0),      // %1
                        "=r"(r0),           // %2
                        "=r"(r1),           // %3
                        "=r"(r2),           // %4
                        "=r"(r3),           // %5
                        "=r"(r4),           // %6
                        "=r"(kptr)          // %7
                        : "0"(outptr0_bf16),
                        "1"(outptr0),
                        "2"(r0),
                        "3"(r1),
                        "4"(r2),
                        "5"(r3),
                        "6"(r4),
                        "7"(kptr)
                        : "memory", "q0", "q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12", "q13", "q14", "q15");
#endif // __aarch64__
                }
                for (; j < outw; j++)
                {
#if __aarch64__
                    asm volatile(
                        "prfm   pldl1keep, [%2, #64]        \n"
                        "ld1    {v0.4h}, [%2], #8           \n" // r00

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v0.4s, v0.4h, #16           \n"

                        "prfm   pldl1keep, [%2, #256]       \n"
                        "ld1    {v1.4h, v2.4h, v3.4h, v4.4h}, [%2] \n" // r01 r02 r03 r04

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "prfm   pldl1keep, [%1, #128]       \n"
                        "ld1    {v20.4s}, [%1], #16         \n" // sum0

                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmul   v21.4s, v16.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmul   v22.4s, v17.4s, v0.s[1]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmul   v23.4s, v18.4s, v0.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v1.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v1.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v2.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%3, #64]        \n"
                        "ld1    {v0.4h}, [%3], #8           \n" // r10
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "prfm   pldl1keep, [%3, #256]       \n"
                        "ld1    {v1.4h, v2.4h, v3.4h, v4.4h}, [%3] \n" // r11 r12 r13 r14
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v21.4s, v24.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmla   v22.4s, v25.4s, v0.s[1]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmla   v23.4s, v26.4s, v0.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v1.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v1.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v2.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v2.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v3.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%4, #64]        \n"
                        "ld1    {v0.4h}, [%4], #8           \n" // r20
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v22.4s, v25.4s, v4.s[1]     \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "prfm   pldl1keep, [%4, #256]       \n"
                        "ld1    {v1.4h, v2.4h, v3.4h, v4.4h}, [%4] \n" // r21 r22 r23 r24
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmla   v22.4s, v17.4s, v0.s[1]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmla   v23.4s, v18.4s, v0.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v1.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v1.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v2.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%5, #64]        \n"
                        "ld1    {v0.4h}, [%5], #8           \n" // r30
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "prfm   pldl1keep, [%5, #256]       \n"
                        "ld1    {v1.4h, v2.4h, v3.4h, v4.4h}, [%5] \n" // r31 r32 r33 r34
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v21.4s, v24.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmla   v22.4s, v25.4s, v0.s[1]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmla   v23.4s, v26.4s, v0.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v1.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v1.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v2.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v2.s[1]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v2.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v3.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%6, #64]        \n"
                        "ld1    {v0.4h}, [%6], #8           \n" // r40
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v22.4s, v25.4s, v4.s[1]     \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v1.4h, v2.4h, v3.4h, v4.4h}, [%6] \n" // r41 r42 r43 r44
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "fmla   v22.4s, v17.4s, v0.s[1]     \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "fmla   v23.4s, v18.4s, v0.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v1.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v1.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v2.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        //                         "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7] \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"

                        "fadd   v22.4s, v21.4s, v22.4s      \n"
                        "fadd   v23.4s, v22.4s, v23.4s      \n"
                        "fadd   v20.4s, v20.4s, v23.4s      \n"

                        "sub    %7, %7, #768                \n" // kptr -= 24 * 16;

                        "shrn   v20.4h, v20.4s, #16         \n"

                        "st1    {v20.4h}, [%0], #8          \n"

                        : "=r"(outptr0_bf16), // %0
                        "=r"(outptr0),      // %1
                        "=r"(r0),           // %2
                        "=r"(r1),           // %3
                        "=r"(r2),           // %4
                        "=r"(r3),           // %5
                        "=r"(r4),           // %6
                        "=r"(kptr)          // %7
                        : "0"(outptr0_bf16),
                        "1"(outptr0),
                        "2"(r0),
                        "3"(r1),
                        "4"(r2),
                        "5"(r3),
                        "6"(r4),
                        "7"(kptr)
                        : "memory", "v0", "v1", "v2", "v3", "v4", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27");
#else  // __aarch64__
                    asm volatile(
                        "pld        [%2, #64]           \n"
                        "vld1.u16   {d1}, [%2 :64]!     \n" // r00

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vshll.u16  q0, d1, #16         \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "pld        [%1, #128]          \n"
                        "vld1.f32   {d24-d25}, [%1 :128]! \n" // sum0

                        "vmul.f32   q13, q8, d0[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmul.f32   q14, q9, d0[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmul.f32   q15, q10, d1[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "pld        [%2, #256]          \n"
                        "vld1.u16   {d6-d9}, [%2 :64]   \n" // r01 r02 r03 r04
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q1, d6, #16         \n"
                        "vshll.u16  q2, d7, #16         \n"
                        "vshll.u16  q3, d8, #16         \n"
                        "vshll.u16  q4, d9, #16         \n"

                        "vmla.f32   q13, q10, d2[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d2[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d4[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d6[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "pld        [%3, #64]           \n"
                        "vld1.u16   {d1}, [%3 :64]!     \n" // r10
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q0, d1, #16         \n"

                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d0[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d0[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d1[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "pld        [%3, #256]          \n"
                        "vld1.u16   {d6-d9}, [%3 :64]   \n" // r11 r12 r13 r14
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q1, d6, #16         \n"
                        "vshll.u16  q2, d7, #16         \n"
                        "vshll.u16  q3, d8, #16         \n"
                        "vshll.u16  q4, d9, #16         \n"

                        "vmla.f32   q13, q8, d2[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d2[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d3[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d4[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d4[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d6[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d6[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "pld        [%4, #64]           \n"
                        "vld1.u16   {d1}, [%4 :64]!     \n" // r20
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q0, d1, #16         \n"

                        "vmla.f32   q13, q10, d8[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d8[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d0[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d0[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d1[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "pld        [%4, #256]          \n"
                        "vld1.u16   {d6-d9}, [%4 :64]   \n" // r21 r22 r23 r24
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q1, d6, #16         \n"
                        "vshll.u16  q2, d7, #16         \n"
                        "vshll.u16  q3, d8, #16         \n"
                        "vshll.u16  q4, d9, #16         \n"

                        "vmla.f32   q13, q10, d2[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d2[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d4[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d6[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "pld        [%5, #64]           \n"
                        "vld1.u16   {d1}, [%5 :64]!     \n" // r30
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q0, d1, #16         \n"

                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d0[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d0[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d1[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "pld        [%5, #256]          \n"
                        "vld1.u16   {d6-d9}, [%5 :64]   \n" // r31 r32 r33 r34
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q1, d6, #16         \n"
                        "vshll.u16  q2, d7, #16         \n"
                        "vshll.u16  q3, d8, #16         \n"
                        "vshll.u16  q4, d9, #16         \n"

                        "vmla.f32   q13, q8, d2[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d2[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d3[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d4[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d4[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d6[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d6[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "pld        [%6, #64]           \n"
                        "vld1.u16   {d1}, [%6 :64]!     \n" // r40
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q0, d1, #16         \n"

                        "vmla.f32   q13, q10, d8[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d8[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d0[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d0[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d1[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d6-d9}, [%6 :64]   \n" // r41 r42 r43 r44
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q1, d6, #16         \n"
                        "vshll.u16  q2, d7, #16         \n"
                        "vshll.u16  q3, d8, #16         \n"
                        "vshll.u16  q4, d9, #16         \n"

                        "vmla.f32   q13, q10, d2[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d2[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d4[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d6[1]     \n"
                        //                         "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128] \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vmla.f32   q12, q11, d9[1]     \n"

                        "vadd.f32   q13, q13, q14       \n"
                        "vadd.f32   q12, q12, q15       \n"
                        "vadd.f32   q12, q12, q13       \n"

                        "sub        %7, %7, #768        \n" // kptr -= 24 * 16;

                        "vshrn.u32  d24, q12, #16       \n"

                        "vst1.u16   {d24}, [%0 :64]!    \n"

                        : "=r"(outptr0_bf16), // %0
                        "=r"(outptr0),      // %1
                        "=r"(r0),           // %2
                        "=r"(r1),           // %3
                        "=r"(r2),           // %4
                        "=r"(r3),           // %5
                        "=r"(r4),           // %6
                        "=r"(kptr)          // %7
                        : "0"(outptr0_bf16),
                        "1"(outptr0),
                        "2"(r0),
                        "3"(r1),
                        "4"(r2),
                        "5"(r3),
                        "6"(r4),
                        "7"(kptr)
                        : "memory", "q0", "q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12", "q13", "q14", "q15");
#endif // __aarch64__
                }

                r0 += 4 * 4;
                r1 += 4 * 4;
                r2 += 4 * 4;
                r3 += 4 * 4;
                r4 += 4 * 4;
            }
        }
    }
}

static void conv5x5s2_pack4_bf16s_neon(const Mat& bottom_blob, Mat& top_blob, const Mat& kernel, const Mat& _bias, const Option& opt)
{
    int w = bottom_blob.w;
    int inch = bottom_blob.c;
    int outw = top_blob.w;
    int outh = top_blob.h;
    int outch = top_blob.c;

    Mat top_blob_fp32(outw, outh, opt.num_threads, (size_t)4u * 4, 4, opt.workspace_allocator);

    const int tailstep = (w - 2 * outw + w) * 4;

    const float* bias = _bias;

    #pragma omp parallel for num_threads(opt.num_threads)
    for (int p = 0; p < outch; p++)
    {
        Mat out0 = top_blob_fp32.channel(get_omp_thread_num());

        float32x4_t _bias0 = bias ? vld1q_f32((const float*)bias + p * 4) : vdupq_n_f32(0.f);
        out0.fill(_bias0);

        int q = 0;
        for (; q < inch - 1; q++)
        {
            float* outptr0 = out0.row(0);

            const Mat img0 = bottom_blob.channel(q);

            const unsigned short* r0 = img0.row<const unsigned short>(0);
            const unsigned short* r1 = img0.row<const unsigned short>(1);
            const unsigned short* r2 = img0.row<const unsigned short>(2);
            const unsigned short* r3 = img0.row<const unsigned short>(3);
            const unsigned short* r4 = img0.row<const unsigned short>(4);

            const unsigned short* kptr = kernel.channel(p).row<const unsigned short>(q);

            int i = 0;
            for (; i < outh; i++)
            {
                int j = 0;
                for (; j + 3 < outw; j += 4)
                {
#if __aarch64__
                    asm volatile(
                        "prfm   pldl1keep, [%1, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%1], #32 \n" // r00 r01 r02 r03

                        "prfm   pldl1keep, [%1, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%1], #32 \n" // r04 r05 r06 r07

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "prfm   pldl1keep, [%0, #512]       \n"
                        "ld1    {v20.4s, v21.4s, v22.4s, v23.4s}, [%0] \n" // sum0 sum1 sum2 sum3

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v16.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v6.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v6.s[3]     \n"

                        "prfm   pldl1keep, [%1, #192]       \n"
                        "ld1    {v28.4h, v29.4h, v30.4h}, [%1] \n" // r08 r09 r010

                        "shll   v28.4s, v28.4h, #16         \n"
                        "shll   v29.4s, v29.4h, #16         \n"
                        "shll   v30.4s, v30.4h, #16         \n"

                        "fmla   v20.4s, v24.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v7.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v7.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v28.s[0]    \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v28.s[1]    \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v28.s[2]    \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v28.s[3]    \n"

                        "fmla   v20.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v7.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v29.s[0]    \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v7.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v29.s[1]    \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v7.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v29.s[2]    \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v7.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v29.s[3]    \n"

                        "prfm   pldl1keep, [%2, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%2], #32 \n" // r10 r11 r12 r13

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v20.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v28.s[0]    \n"
                        "fmla   v23.4s, v16.4s, v30.s[0]    \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v6.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v28.s[1]    \n"
                        "fmla   v23.4s, v17.4s, v30.s[1]    \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v28.s[2]    \n"
                        "fmla   v23.4s, v18.4s, v30.s[2]    \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v6.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v28.s[3]    \n"
                        "fmla   v23.4s, v19.4s, v30.s[3]    \n"

                        "prfm   pldl1keep, [%2, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%2], #32 \n" // r14 r15 r16 r17

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "fmla   v20.4s, v24.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v6.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v6.s[3]     \n"

                        "prfm   pldl1keep, [%2, #192]       \n"
                        "ld1    {v28.4h, v29.4h, v30.4h}, [%2] \n" // r18 r19 r110

                        "shll   v28.4s, v28.4h, #16         \n"
                        "shll   v29.4s, v29.4h, #16         \n"
                        "shll   v30.4s, v30.4h, #16         \n"

                        "fmla   v20.4s, v16.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v7.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v7.s[3]     \n"

                        "fmla   v20.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v28.s[0]    \n"
                        "fmla   v20.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v28.s[1]    \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v28.s[2]    \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v28.s[3]    \n"

                        "fmla   v20.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v7.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v29.s[0]    \n"
                        "fmla   v20.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v7.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v29.s[1]    \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v7.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v29.s[2]    \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v7.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v29.s[3]    \n"

                        "prfm   pldl1keep, [%3, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%3], #32 \n" // r20 r21 r22 r23

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v20.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v28.s[0]    \n"
                        "fmla   v23.4s, v24.4s, v30.s[0]    \n"
                        "fmla   v20.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v6.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v28.s[1]    \n"
                        "fmla   v23.4s, v25.4s, v30.s[1]    \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v28.s[2]    \n"
                        "fmla   v23.4s, v26.4s, v30.s[2]    \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v6.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v28.s[3]    \n"
                        "fmla   v23.4s, v27.4s, v30.s[3]    \n"

                        "prfm   pldl1keep, [%3, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%3], #32 \n" // r24 r25 r26 r27

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "fmla   v20.4s, v16.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v6.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v6.s[3]     \n"

                        "prfm   pldl1keep, [%3, #192]       \n"
                        "ld1    {v28.4h, v29.4h, v30.4h}, [%3] \n" // r28 r29 r210

                        "shll   v28.4s, v28.4h, #16         \n"
                        "shll   v29.4s, v29.4h, #16         \n"
                        "shll   v30.4s, v30.4h, #16         \n"

                        "fmla   v20.4s, v24.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v7.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v7.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v28.s[0]    \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v28.s[1]    \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v28.s[2]    \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v28.s[3]    \n"

                        "fmla   v20.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v7.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v29.s[0]    \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v7.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v29.s[1]    \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v7.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v29.s[2]    \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v7.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v29.s[3]    \n"

                        "prfm   pldl1keep, [%4, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%4], #32 \n" // r30 r31 r32 r33

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v20.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v28.s[0]    \n"
                        "fmla   v23.4s, v16.4s, v30.s[0]    \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v6.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v28.s[1]    \n"
                        "fmla   v23.4s, v17.4s, v30.s[1]    \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v28.s[2]    \n"
                        "fmla   v23.4s, v18.4s, v30.s[2]    \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v6.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v28.s[3]    \n"
                        "fmla   v23.4s, v19.4s, v30.s[3]    \n"

                        "prfm   pldl1keep, [%4, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%4], #32 \n" // r34 r35 r36 r37

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "fmla   v20.4s, v24.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v6.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v6.s[3]     \n"

                        "prfm   pldl1keep, [%4, #192]       \n"
                        "ld1    {v28.4h, v29.4h, v30.4h}, [%4] \n" // r38 r39 r310

                        "shll   v28.4s, v28.4h, #16         \n"
                        "shll   v29.4s, v29.4h, #16         \n"
                        "shll   v30.4s, v30.4h, #16         \n"

                        "fmla   v20.4s, v16.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v7.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v7.s[3]     \n"

                        "fmla   v20.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v28.s[0]    \n"
                        "fmla   v20.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v28.s[1]    \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v28.s[2]    \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v28.s[3]    \n"

                        "fmla   v20.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v7.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v29.s[0]    \n"
                        "fmla   v20.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v7.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v29.s[1]    \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v7.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v29.s[2]    \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v7.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v29.s[3]    \n"

                        "prfm   pldl1keep, [%5, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%5], #32 \n" // r40 r41 r42 r43

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v20.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v28.s[0]    \n"
                        "fmla   v23.4s, v24.4s, v30.s[0]    \n"
                        "fmla   v20.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v6.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v28.s[1]    \n"
                        "fmla   v23.4s, v25.4s, v30.s[1]    \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v28.s[2]    \n"
                        "fmla   v23.4s, v26.4s, v30.s[2]    \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v6.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v28.s[3]    \n"
                        "fmla   v23.4s, v27.4s, v30.s[3]    \n"

                        "prfm   pldl1keep, [%5, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%5], #32 \n" // r44 r45 r46 r47

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "fmla   v20.4s, v16.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v6.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v6.s[3]     \n"

                        "prfm   pldl1keep, [%5, #192]       \n"
                        "ld1    {v28.4h, v29.4h, v30.4h}, [%5] \n" // r48 r49 r410

                        "shll   v28.4s, v28.4h, #16         \n"
                        "shll   v29.4s, v29.4h, #16         \n"
                        "shll   v30.4s, v30.4h, #16         \n"

                        "fmla   v20.4s, v24.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v7.s[1]     \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v7.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v28.s[0]    \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v28.s[1]    \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v28.s[2]    \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v28.s[3]    \n"

                        "fmla   v20.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v7.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v29.s[0]    \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v7.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v29.s[1]    \n"

                        //                         "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6] \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v7.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v29.s[2]    \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v7.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v29.s[3]    \n"

                        "fmla   v20.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v28.s[0]    \n"
                        "fmla   v23.4s, v16.4s, v30.s[0]    \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v6.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v28.s[1]    \n"
                        "fmla   v23.4s, v17.4s, v30.s[1]    \n"
                        "fmla   v20.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v28.s[2]    \n"
                        "fmla   v23.4s, v18.4s, v30.s[2]    \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v6.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v28.s[3]    \n"
                        "fmla   v23.4s, v19.4s, v30.s[3]    \n"

                        "sub    %6, %6, #768                \n" // kptr -= 24 * 16;

                        "st1    {v20.4s, v21.4s, v22.4s, v23.4s}, [%0], #64 \n"

                        : "=r"(outptr0), // %0
                        "=r"(r0),      // %1
                        "=r"(r1),      // %2
                        "=r"(r2),      // %3
                        "=r"(r3),      // %4
                        "=r"(r4),      // %5
                        "=r"(kptr)     // %6
                        : "0"(outptr0),
                        "1"(r0),
                        "2"(r1),
                        "3"(r2),
                        "4"(r3),
                        "5"(r4),
                        "6"(kptr)
                        : "memory", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27", "v28", "v29", "v30");
#else  // __aarch64__
                    asm volatile(
                        "pld        [%0, #512]          \n"
                        "vldm       %0, {d24-d31}       \n" // sum0 sum1 sum2 sum3

                        "pld        [%1, #256]          \n"
                        "vld1.u16   {d4-d7}, [%1 :64]!  \n" // r00 r01 r02 r03

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%1, #256]          \n"
                        "vld1.u16   {d12-d15}, [%1 :64]! \n" // r04 r05 r06 r07

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q12, q8, d0[0]      \n"
                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d12[0]     \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "vmla.f32   q15, q9, d12[1]     \n"
                        "vmla.f32   q12, q10, d1[0]     \n"
                        "vmla.f32   q13, q10, d5[0]     \n"
                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vmla.f32   q15, q10, d13[0]    \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "vmla.f32   q14, q11, d9[1]     \n"
                        "vmla.f32   q15, q11, d13[1]    \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d2[0]     \n"
                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vmla.f32   q14, q10, d10[0]    \n"
                        "vmla.f32   q15, q10, d14[0]    \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "vmla.f32   q14, q11, d10[1]    \n"
                        "vmla.f32   q15, q11, d14[1]    \n"
                        "vmla.f32   q12, q8, d3[0]      \n"
                        "vmla.f32   q13, q8, d7[0]      \n"
                        "vmla.f32   q14, q8, d11[0]     \n"
                        "vmla.f32   q15, q8, d15[0]     \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "vmla.f32   q14, q9, d11[1]     \n"
                        "vmla.f32   q15, q9, d15[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%1, #128]          \n"
                        "vld1.u16   {d2-d3}, [%1 :64]!  \n" // r08 r09

                        "vshll.u16  q0, d2, #16         \n"
                        "vshll.u16  q1, d3, #16         \n"

                        "vmla.f32   q12, q8, d4[0]      \n"
                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vmla.f32   q14, q8, d12[0]     \n"
                        "vmla.f32   q15, q8, d0[0]      \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "vmla.f32   q14, q9, d12[1]     \n"
                        "vmla.f32   q15, q9, d0[1]      \n"
                        "vmla.f32   q12, q10, d5[0]     \n"
                        "vmla.f32   q13, q10, d9[0]     \n"
                        "vmla.f32   q14, q10, d13[0]    \n"
                        "vmla.f32   q15, q10, d1[0]     \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vmla.f32   q14, q11, d13[1]    \n"
                        "vmla.f32   q15, q11, d1[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d6[0]     \n"
                        "vmla.f32   q13, q10, d10[0]    \n"
                        "vmla.f32   q14, q10, d14[0]    \n"
                        "vmla.f32   q15, q10, d2[0]     \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        "vmla.f32   q14, q11, d14[1]    \n"
                        "vmla.f32   q15, q11, d2[1]     \n"
                        "vmla.f32   q12, q8, d7[0]      \n"
                        "vmla.f32   q13, q8, d11[0]     \n"
                        "vmla.f32   q14, q8, d15[0]     \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "vmla.f32   q14, q9, d15[1]     \n"
                        "vmla.f32   q15, q9, d3[1]      \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%1, #64]           \n"
                        "vld1.u16   {d5}, [%1 :64]      \n" // r010

                        "vshll.u16  q2, d5, #16         \n"

                        "vmla.f32   q12, q8, d8[0]      \n"
                        "vmla.f32   q13, q8, d12[0]     \n"
                        "vmla.f32   q14, q8, d0[0]      \n"
                        "vmla.f32   q15, q8, d4[0]      \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d12[1]     \n"
                        "vmla.f32   q14, q9, d0[1]      \n"
                        "vmla.f32   q15, q9, d4[1]      \n"
                        "vmla.f32   q12, q10, d9[0]     \n"
                        "vmla.f32   q13, q10, d13[0]    \n"
                        "vmla.f32   q14, q10, d1[0]     \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d13[1]    \n"

                        "pld        [%2, #256]          \n"
                        "vld1.u16   {d12-d15}, [%2 :64]! \n" // r10 r11 r12 r13

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q14, q11, d1[1]     \n"
                        "vmla.f32   q15, q11, d5[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%2, #256]          \n"
                        "vld1.u16   {d4-d7}, [%2 :64]!  \n" // r14 r15 r16 r17

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q12, q10, d8[0]     \n"
                        "vmla.f32   q13, q10, d12[0]    \n"
                        "vmla.f32   q14, q10, d0[0]     \n"
                        "vmla.f32   q15, q10, d4[0]     \n"
                        "vmla.f32   q12, q11, d8[1]     \n"
                        "vmla.f32   q13, q11, d12[1]    \n"
                        "vmla.f32   q14, q11, d0[1]     \n"
                        "vmla.f32   q15, q11, d4[1]     \n"
                        "vmla.f32   q12, q8, d9[0]      \n"
                        "vmla.f32   q13, q8, d13[0]     \n"
                        "vmla.f32   q14, q8, d1[0]      \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vmla.f32   q13, q9, d13[1]     \n"
                        "vmla.f32   q14, q9, d1[1]      \n"
                        "vmla.f32   q15, q9, d5[1]      \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d10[0]     \n"
                        "vmla.f32   q13, q8, d14[0]     \n"
                        "vmla.f32   q14, q8, d2[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vmla.f32   q12, q9, d10[1]     \n"
                        "vmla.f32   q13, q9, d14[1]     \n"
                        "vmla.f32   q14, q9, d2[1]      \n"
                        "vmla.f32   q15, q9, d6[1]      \n"
                        "vmla.f32   q12, q10, d11[0]    \n"
                        "vmla.f32   q13, q10, d15[0]    \n"
                        "vmla.f32   q14, q10, d3[0]     \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vmla.f32   q12, q11, d11[1]    \n"
                        "vmla.f32   q13, q11, d15[1]    \n"
                        "vmla.f32   q14, q11, d3[1]     \n"
                        "vmla.f32   q15, q11, d7[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%2, #128]          \n"
                        "vld1.u16   {d10-d11}, [%2 :64]! \n" // r18 r19

                        "vshll.u16  q4, d10, #16        \n"
                        "vshll.u16  q5, d11, #16        \n"

                        "vmla.f32   q12, q10, d12[0]    \n"
                        "vmla.f32   q13, q10, d0[0]     \n"
                        "vmla.f32   q14, q10, d4[0]     \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vmla.f32   q12, q11, d12[1]    \n"
                        "vmla.f32   q13, q11, d0[1]     \n"
                        "vmla.f32   q14, q11, d4[1]     \n"
                        "vmla.f32   q15, q11, d8[1]     \n"
                        "vmla.f32   q12, q8, d13[0]     \n"
                        "vmla.f32   q13, q8, d1[0]      \n"
                        "vmla.f32   q14, q8, d5[0]      \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vmla.f32   q12, q9, d13[1]     \n"
                        "vmla.f32   q13, q9, d1[1]      \n"
                        "vmla.f32   q14, q9, d5[1]      \n"
                        "vmla.f32   q15, q9, d9[1]      \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d14[0]     \n"
                        "vmla.f32   q13, q8, d2[0]      \n"
                        "vmla.f32   q14, q8, d6[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vmla.f32   q12, q9, d14[1]     \n"
                        "vmla.f32   q13, q9, d2[1]      \n"
                        "vmla.f32   q14, q9, d6[1]      \n"
                        "vmla.f32   q15, q9, d10[1]     \n"
                        "vmla.f32   q12, q10, d15[0]    \n"
                        "vmla.f32   q13, q10, d3[0]     \n"
                        "vmla.f32   q14, q10, d7[0]     \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vmla.f32   q12, q11, d15[1]    \n"
                        "vmla.f32   q13, q11, d3[1]     \n"
                        "vmla.f32   q14, q11, d7[1]     \n"
                        "vmla.f32   q15, q11, d11[1]    \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%2, #64]           \n"
                        "vld1.u16   {d13}, [%2 :64]     \n" // r110

                        "vshll.u16  q6, d13, #16        \n"

                        "vmla.f32   q12, q10, d0[0]     \n"
                        "vmla.f32   q13, q10, d4[0]     \n"
                        "vmla.f32   q14, q10, d8[0]     \n"
                        "vmla.f32   q15, q10, d12[0]    \n"
                        "vmla.f32   q12, q11, d0[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "vmla.f32   q14, q11, d8[1]     \n"
                        "vmla.f32   q15, q11, d12[1]    \n"
                        "vmla.f32   q12, q8, d1[0]      \n"
                        "vmla.f32   q13, q8, d5[0]      \n"
                        "vmla.f32   q14, q8, d9[0]      \n"
                        "vmla.f32   q15, q8, d13[0]     \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "vmla.f32   q13, q9, d5[1]      \n"

                        "pld        [%3, #256]          \n"
                        "vld1.u16   {d4-d7}, [%3 :64]!  \n" // r20 r21 r22 r23

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q14, q9, d9[1]      \n"
                        "vmla.f32   q15, q9, d13[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%3, #256]          \n"
                        "vld1.u16   {d12-d15}, [%3 :64]! \n" // r24 r25 r26 r27

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q12, q8, d0[0]      \n"
                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d12[0]     \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "vmla.f32   q15, q9, d12[1]     \n"
                        "vmla.f32   q12, q10, d1[0]     \n"
                        "vmla.f32   q13, q10, d5[0]     \n"
                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vmla.f32   q15, q10, d13[0]    \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "vmla.f32   q14, q11, d9[1]     \n"
                        "vmla.f32   q15, q11, d13[1]    \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d2[0]     \n"
                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vmla.f32   q14, q10, d10[0]    \n"
                        "vmla.f32   q15, q10, d14[0]    \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "vmla.f32   q14, q11, d10[1]    \n"
                        "vmla.f32   q15, q11, d14[1]    \n"
                        "vmla.f32   q12, q8, d3[0]      \n"
                        "vmla.f32   q13, q8, d7[0]      \n"
                        "vmla.f32   q14, q8, d11[0]     \n"
                        "vmla.f32   q15, q8, d15[0]     \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "vmla.f32   q14, q9, d11[1]     \n"
                        "vmla.f32   q15, q9, d15[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%3, #128]          \n"
                        "vld1.u16   {d2-d3}, [%3 :64]!  \n" // r28 r29

                        "vshll.u16  q0, d2, #16         \n"
                        "vshll.u16  q1, d3, #16         \n"

                        "vmla.f32   q12, q8, d4[0]      \n"
                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vmla.f32   q14, q8, d12[0]     \n"
                        "vmla.f32   q15, q8, d0[0]      \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "vmla.f32   q14, q9, d12[1]     \n"
                        "vmla.f32   q15, q9, d0[1]      \n"
                        "vmla.f32   q12, q10, d5[0]     \n"
                        "vmla.f32   q13, q10, d9[0]     \n"
                        "vmla.f32   q14, q10, d13[0]    \n"
                        "vmla.f32   q15, q10, d1[0]     \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vmla.f32   q14, q11, d13[1]    \n"
                        "vmla.f32   q15, q11, d1[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d6[0]     \n"
                        "vmla.f32   q13, q10, d10[0]    \n"
                        "vmla.f32   q14, q10, d14[0]    \n"
                        "vmla.f32   q15, q10, d2[0]     \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        "vmla.f32   q14, q11, d14[1]    \n"
                        "vmla.f32   q15, q11, d2[1]     \n"
                        "vmla.f32   q12, q8, d7[0]      \n"
                        "vmla.f32   q13, q8, d11[0]     \n"
                        "vmla.f32   q14, q8, d15[0]     \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "vmla.f32   q14, q9, d15[1]     \n"
                        "vmla.f32   q15, q9, d3[1]      \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%3, #64]           \n"
                        "vld1.u16   {d5}, [%3 :64]      \n" // r210

                        "vshll.u16  q2, d5, #16         \n"

                        "vmla.f32   q12, q8, d8[0]      \n"
                        "vmla.f32   q13, q8, d12[0]     \n"
                        "vmla.f32   q14, q8, d0[0]      \n"
                        "vmla.f32   q15, q8, d4[0]      \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d12[1]     \n"
                        "vmla.f32   q14, q9, d0[1]      \n"
                        "vmla.f32   q15, q9, d4[1]      \n"
                        "vmla.f32   q12, q10, d9[0]     \n"
                        "vmla.f32   q13, q10, d13[0]    \n"
                        "vmla.f32   q14, q10, d1[0]     \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d13[1]    \n"

                        "pld        [%4, #256]          \n"
                        "vld1.u16   {d12-d15}, [%4 :64]! \n" // r30 r31 r32 r33

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q14, q11, d1[1]     \n"
                        "vmla.f32   q15, q11, d5[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%4, #256]          \n"
                        "vld1.u16   {d4-d7}, [%4 :64]!  \n" // r34 r35 r36 r37

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q12, q10, d8[0]     \n"
                        "vmla.f32   q13, q10, d12[0]    \n"
                        "vmla.f32   q14, q10, d0[0]     \n"
                        "vmla.f32   q15, q10, d4[0]     \n"
                        "vmla.f32   q12, q11, d8[1]     \n"
                        "vmla.f32   q13, q11, d12[1]    \n"
                        "vmla.f32   q14, q11, d0[1]     \n"
                        "vmla.f32   q15, q11, d4[1]     \n"
                        "vmla.f32   q12, q8, d9[0]      \n"
                        "vmla.f32   q13, q8, d13[0]     \n"
                        "vmla.f32   q14, q8, d1[0]      \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vmla.f32   q13, q9, d13[1]     \n"
                        "vmla.f32   q14, q9, d1[1]      \n"
                        "vmla.f32   q15, q9, d5[1]      \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d10[0]     \n"
                        "vmla.f32   q13, q8, d14[0]     \n"
                        "vmla.f32   q14, q8, d2[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vmla.f32   q12, q9, d10[1]     \n"
                        "vmla.f32   q13, q9, d14[1]     \n"
                        "vmla.f32   q14, q9, d2[1]      \n"
                        "vmla.f32   q15, q9, d6[1]      \n"
                        "vmla.f32   q12, q10, d11[0]    \n"
                        "vmla.f32   q13, q10, d15[0]    \n"
                        "vmla.f32   q14, q10, d3[0]     \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vmla.f32   q12, q11, d11[1]    \n"
                        "vmla.f32   q13, q11, d15[1]    \n"
                        "vmla.f32   q14, q11, d3[1]     \n"
                        "vmla.f32   q15, q11, d7[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%4, #128]          \n"
                        "vld1.u16   {d10-d11}, [%4 :64]! \n" // r38 r39

                        "vshll.u16  q4, d10, #16        \n"
                        "vshll.u16  q5, d11, #16        \n"

                        "vmla.f32   q12, q10, d12[0]    \n"
                        "vmla.f32   q13, q10, d0[0]     \n"
                        "vmla.f32   q14, q10, d4[0]     \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vmla.f32   q12, q11, d12[1]    \n"
                        "vmla.f32   q13, q11, d0[1]     \n"
                        "vmla.f32   q14, q11, d4[1]     \n"
                        "vmla.f32   q15, q11, d8[1]     \n"
                        "vmla.f32   q12, q8, d13[0]     \n"
                        "vmla.f32   q13, q8, d1[0]      \n"
                        "vmla.f32   q14, q8, d5[0]      \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vmla.f32   q12, q9, d13[1]     \n"
                        "vmla.f32   q13, q9, d1[1]      \n"
                        "vmla.f32   q14, q9, d5[1]      \n"
                        "vmla.f32   q15, q9, d9[1]      \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d14[0]     \n"
                        "vmla.f32   q13, q8, d2[0]      \n"
                        "vmla.f32   q14, q8, d6[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vmla.f32   q12, q9, d14[1]     \n"
                        "vmla.f32   q13, q9, d2[1]      \n"
                        "vmla.f32   q14, q9, d6[1]      \n"
                        "vmla.f32   q15, q9, d10[1]     \n"
                        "vmla.f32   q12, q10, d15[0]    \n"
                        "vmla.f32   q13, q10, d3[0]     \n"
                        "vmla.f32   q14, q10, d7[0]     \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vmla.f32   q12, q11, d15[1]    \n"
                        "vmla.f32   q13, q11, d3[1]     \n"
                        "vmla.f32   q14, q11, d7[1]     \n"
                        "vmla.f32   q15, q11, d11[1]    \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%4, #64]           \n"
                        "vld1.u16   {d13}, [%4 :64]     \n" // r310

                        "vshll.u16  q6, d13, #16        \n"

                        "vmla.f32   q12, q10, d0[0]     \n"
                        "vmla.f32   q13, q10, d4[0]     \n"
                        "vmla.f32   q14, q10, d8[0]     \n"
                        "vmla.f32   q15, q10, d12[0]    \n"
                        "vmla.f32   q12, q11, d0[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "vmla.f32   q14, q11, d8[1]     \n"
                        "vmla.f32   q15, q11, d12[1]    \n"
                        "vmla.f32   q12, q8, d1[0]      \n"
                        "vmla.f32   q13, q8, d5[0]      \n"
                        "vmla.f32   q14, q8, d9[0]      \n"
                        "vmla.f32   q15, q8, d13[0]     \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "vmla.f32   q13, q9, d5[1]      \n"

                        "pld        [%5, #256]          \n"
                        "vld1.u16   {d4-d7}, [%5 :64]!  \n" // r40 r41 r42 r43

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q14, q9, d9[1]      \n"
                        "vmla.f32   q15, q9, d13[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%5, #256]          \n"
                        "vld1.u16   {d12-d15}, [%5 :64]! \n" // r44 r45 r46 r47

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q12, q8, d0[0]      \n"
                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d12[0]     \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "vmla.f32   q15, q9, d12[1]     \n"
                        "vmla.f32   q12, q10, d1[0]     \n"
                        "vmla.f32   q13, q10, d5[0]     \n"
                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vmla.f32   q15, q10, d13[0]    \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "vmla.f32   q14, q11, d9[1]     \n"
                        "vmla.f32   q15, q11, d13[1]    \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d2[0]     \n"
                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vmla.f32   q14, q10, d10[0]    \n"
                        "vmla.f32   q15, q10, d14[0]    \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "vmla.f32   q14, q11, d10[1]    \n"
                        "vmla.f32   q15, q11, d14[1]    \n"
                        "vmla.f32   q12, q8, d3[0]      \n"
                        "vmla.f32   q13, q8, d7[0]      \n"
                        "vmla.f32   q14, q8, d11[0]     \n"
                        "vmla.f32   q15, q8, d15[0]     \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "vmla.f32   q14, q9, d11[1]     \n"
                        "vmla.f32   q15, q9, d15[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%5, #128]          \n"
                        "vld1.u16   {d2-d3}, [%5 :64]!  \n" // r48 r49

                        "vshll.u16  q0, d2, #16         \n"
                        "vshll.u16  q1, d3, #16         \n"

                        "vmla.f32   q12, q8, d4[0]      \n"
                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vmla.f32   q14, q8, d12[0]     \n"
                        "vmla.f32   q15, q8, d0[0]      \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "vmla.f32   q14, q9, d12[1]     \n"
                        "vmla.f32   q15, q9, d0[1]      \n"
                        "vmla.f32   q12, q10, d5[0]     \n"
                        "vmla.f32   q13, q10, d9[0]     \n"
                        "vmla.f32   q14, q10, d13[0]    \n"
                        "vmla.f32   q15, q10, d1[0]     \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vmla.f32   q14, q11, d13[1]    \n"
                        "vmla.f32   q15, q11, d1[1]     \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d6[0]     \n"
                        "vmla.f32   q13, q10, d10[0]    \n"
                        "vmla.f32   q14, q10, d14[0]    \n"
                        "vmla.f32   q15, q10, d2[0]     \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        "vmla.f32   q14, q11, d14[1]    \n"
                        "vmla.f32   q15, q11, d2[1]     \n"
                        "vmla.f32   q12, q8, d7[0]      \n"
                        "vmla.f32   q13, q8, d11[0]     \n"
                        "vmla.f32   q14, q8, d15[0]     \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "vmla.f32   q14, q9, d15[1]     \n"
                        "vmla.f32   q15, q9, d3[1]      \n"

                        //                         "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128] \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%5, #64]           \n"
                        "vld1.u16   {d5}, [%5 :64]      \n" // r410

                        "vshll.u16  q2, d5, #16         \n"

                        "vmla.f32   q12, q8, d8[0]      \n"
                        "vmla.f32   q13, q8, d12[0]     \n"
                        "vmla.f32   q14, q8, d0[0]      \n"
                        "vmla.f32   q15, q8, d4[0]      \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d12[1]     \n"
                        "vmla.f32   q14, q9, d0[1]      \n"
                        "vmla.f32   q15, q9, d4[1]      \n"
                        "vmla.f32   q12, q10, d9[0]     \n"
                        "vmla.f32   q13, q10, d13[0]    \n"
                        "vmla.f32   q14, q10, d1[0]     \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d13[1]    \n"
                        "vmla.f32   q14, q11, d1[1]     \n"
                        "vmla.f32   q15, q11, d5[1]     \n"

                        "sub        %6, %6, #768        \n" // kptr -= 24 * 16;

                        "sub        %1, %1, #16         \n"
                        "sub        %2, %2, #16         \n"
                        "sub        %3, %3, #16         \n"
                        "sub        %4, %4, #16         \n"
                        "sub        %5, %5, #16         \n"

                        "vstm       %0!, {d24-d31}      \n"

                        : "=r"(outptr0), // %0
                        "=r"(r0),      // %1
                        "=r"(r1),      // %2
                        "=r"(r2),      // %3
                        "=r"(r3),      // %4
                        "=r"(r4),      // %5
                        "=r"(kptr)     // %6
                        : "0"(outptr0),
                        "1"(r0),
                        "2"(r1),
                        "3"(r2),
                        "4"(r3),
                        "5"(r4),
                        "6"(kptr)
                        : "memory", "q0", "q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12", "q13", "q14", "q15");
#endif // __aarch64__
                }
                for (; j + 1 < outw; j += 2)
                {
#if __aarch64__
                    asm volatile(
                        "prfm   pldl1keep, [%1, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%1], #32 \n" // r00 r01 r02 r03

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"

                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v16.4s, v16.4h, #16         \n"

                        "prfm   pldl1keep, [%0, #256]       \n"
                        "ld1    {v20.4s, v21.4s}, [%0]      \n" // sum0 sum1

                        "fmul   v22.4s, v16.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmul   v23.4s, v16.4s, v2.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v0.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "prfm   pldl1keep, [%1, #192]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h}, [%1] \n" // r04 r05 r06
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"

                        "fmla   v22.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v24.4s, v3.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v16.4s, v4.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v22.4s, v24.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v24.4s, v5.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v5.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "prfm   pldl1keep, [%2, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%2], #32 \n" // r10 r11 r12 r13
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v16.4s, v6.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v6.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v6.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v6.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v22.4s, v24.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v24.4s, v2.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v0.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v2.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "prfm   pldl1keep, [%2, #192]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h}, [%2] \n" // r14 r15 r16
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"

                        "fmla   v22.4s, v16.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v16.4s, v3.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v1.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v22.4s, v24.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v24.4s, v4.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v16.4s, v5.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v5.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"
                        "prfm   pldl1keep, [%3, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%3], #32 \n" // r20 r21 r22 r23
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v22.4s, v24.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v24.4s, v6.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v6.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v6.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v6.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v16.4s, v2.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v0.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "prfm   pldl1keep, [%3, #192]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h}, [%3] \n" // r24 r25 r26
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"

                        "fmla   v22.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v24.4s, v3.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v16.4s, v4.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v22.4s, v24.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v24.4s, v5.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v5.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "prfm   pldl1keep, [%4, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%4], #32 \n" // r30 r31 r32 r33
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v16.4s, v6.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v6.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v6.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v6.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v22.4s, v24.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v24.4s, v2.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v0.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v2.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "prfm   pldl1keep, [%4, #192]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h}, [%4] \n" // r34 r35 r36
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"

                        "fmla   v22.4s, v16.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v16.4s, v3.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v1.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v22.4s, v24.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v24.4s, v4.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v16.4s, v5.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v5.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"
                        "prfm   pldl1keep, [%5, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%5], #32 \n" // r40 r41 r42 r43
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v22.4s, v24.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v24.4s, v6.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v6.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v6.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v6.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v16.4s, v2.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v0.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "prfm   pldl1keep, [%5, #192]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h}, [%5] \n" // r44 r45 r46
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"

                        "fmla   v22.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v24.4s, v3.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "fmla   v23.4s, v16.4s, v4.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v22.4s, v24.4s, v3.s[0]     \n"
                        //                         "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6] \n"
                        "fmla   v23.4s, v24.4s, v5.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v5.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v6.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v6.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v6.s[3]     \n"

                        "fadd   v20.4s, v20.4s, v22.4s      \n"
                        "fadd   v21.4s, v21.4s, v23.4s      \n"

                        "sub    %6, %6, #768                \n" // kptr -= 24 * 16;

                        "st1    {v20.4s, v21.4s}, [%0], #32 \n"

                        : "=r"(outptr0), // %0
                        "=r"(r0),      // %1
                        "=r"(r1),      // %2
                        "=r"(r2),      // %3
                        "=r"(r3),      // %4
                        "=r"(r4),      // %5
                        "=r"(kptr)     // %6
                        : "0"(outptr0),
                        "1"(r0),
                        "2"(r1),
                        "3"(r2),
                        "4"(r3),
                        "5"(r4),
                        "6"(kptr)
                        : "memory", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27");
#else  // __aarch64__
                    asm volatile(
                        "pld        [%1, #256]          \n"
                        "vld1.u16   {d4-d7}, [%1 :64]!  \n" // r00 r01 r02 r03

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "pld        [%0, #256]          \n"
                        "vld1.f32   {d24-d27}, [%0 :128] \n" // sum0 sum1

                        "vmul.f32   q14, q8, d0[0]      \n"
                        "vmul.f32   q15, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d1[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "pld        [%1, #192]          \n"
                        "vld1.u16   {d10-d12}, [%1 :64] \n" // r04 r05 r06
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vshll.u16  q6, d12, #16        \n"

                        "vmla.f32   q14, q10, d2[0]     \n"
                        "vmla.f32   q15, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d3[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d4[0]      \n"
                        "vmla.f32   q15, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d5[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d6[0]     \n"
                        "vmla.f32   q15, q10, d10[0]    \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d7[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d11[0]     \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "pld        [%2, #256]          \n"
                        "vld1.u16   {d4-d7}, [%2 :64]!  \n" // r10 r11 r12 r13
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d12[0]     \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d12[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d13[0]    \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d13[1]    \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d0[0]     \n"
                        "vmla.f32   q15, q10, d4[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d0[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d1[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "vmla.f32   q13, q9, d5[1]      \n"
                        "pld        [%2, #192]          \n"
                        "vld1.u16   {d10-d12}, [%2 :64] \n" // r14 r15 r16
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vshll.u16  q6, d12, #16        \n"

                        "vmla.f32   q14, q8, d2[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d2[1]      \n"
                        "vmla.f32   q13, q9, d6[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d3[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vmla.f32   q13, q11, d7[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d4[0]     \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d4[1]     \n"
                        "vmla.f32   q13, q11, d8[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d5[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vmla.f32   q13, q9, d9[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d6[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d6[1]      \n"
                        "vmla.f32   q13, q9, d10[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d7[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "vmla.f32   q13, q11, d11[1]    \n"
                        "pld        [%3, #256]          \n"
                        "vld1.u16   {d4-d7}, [%3 :64]!  \n" // r20 r21 r22 r23
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q14, q10, d8[0]     \n"
                        "vmla.f32   q15, q10, d12[0]    \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d8[1]     \n"
                        "vmla.f32   q13, q11, d12[1]    \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d9[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d13[0]     \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vmla.f32   q13, q9, d13[1]     \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d0[0]      \n"
                        "vmla.f32   q15, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d1[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "pld        [%3, #192]          \n"
                        "vld1.u16   {d10-d12}, [%3 :64] \n" // r24 r25 r26
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vshll.u16  q6, d12, #16        \n"

                        "vmla.f32   q14, q10, d2[0]     \n"
                        "vmla.f32   q15, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d3[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d4[0]      \n"
                        "vmla.f32   q15, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d5[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d6[0]     \n"
                        "vmla.f32   q15, q10, d10[0]    \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d7[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d11[0]     \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "pld        [%4, #256]          \n"
                        "vld1.u16   {d4-d7}, [%4 :64]!  \n" // r30 r31 r32 r33
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d12[0]     \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d12[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d13[0]    \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d13[1]    \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d0[0]     \n"
                        "vmla.f32   q15, q10, d4[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d0[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d1[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "vmla.f32   q13, q9, d5[1]      \n"
                        "pld        [%4, #192]          \n"
                        "vld1.u16   {d10-d12}, [%4 :64] \n" // r34 r35 r36
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vshll.u16  q6, d12, #16        \n"

                        "vmla.f32   q14, q8, d2[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d2[1]      \n"
                        "vmla.f32   q13, q9, d6[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d3[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vmla.f32   q13, q11, d7[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d4[0]     \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d4[1]     \n"
                        "vmla.f32   q13, q11, d8[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d5[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vmla.f32   q13, q9, d9[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d6[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d6[1]      \n"
                        "vmla.f32   q13, q9, d10[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d7[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "vmla.f32   q13, q11, d11[1]    \n"
                        "pld        [%5, #256]          \n"
                        "vld1.u16   {d4-d7}, [%5 :64]!  \n" // r40 r41 r42 r43
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q14, q10, d8[0]     \n"
                        "vmla.f32   q15, q10, d12[0]    \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d8[1]     \n"
                        "vmla.f32   q13, q11, d12[1]    \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d9[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d13[0]     \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vmla.f32   q13, q9, d13[1]     \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d0[0]      \n"
                        "vmla.f32   q15, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d1[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "pld        [%5, #192]          \n"
                        "vld1.u16   {d10-d12}, [%5 :64] \n" // r44 r45 r46
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vshll.u16  q6, d12, #16        \n"

                        "vmla.f32   q14, q10, d2[0]     \n"
                        "vmla.f32   q15, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vmla.f32   q14, q8, d3[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d4[0]      \n"
                        "vmla.f32   q15, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"

                        "vmla.f32   q14, q10, d5[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d6[0]     \n"
                        "vmla.f32   q15, q10, d10[0]    \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        //                         "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128] \n"

                        "vmla.f32   q14, q8, d7[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d11[0]     \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d12[0]     \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d12[1]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vmla.f32   q15, q10, d13[0]    \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d13[1]    \n"

                        "vadd.f32   q12, q12, q14       \n"
                        "vadd.f32   q13, q13, q15       \n"

                        "sub        %6, %6, #768        \n" // kptr -= 24 * 16;

                        "vst1.f32   {d24-d27}, [%0 :128]! \n"

                        : "=r"(outptr0), // %0
                        "=r"(r0),      // %1
                        "=r"(r1),      // %2
                        "=r"(r2),      // %3
                        "=r"(r3),      // %4
                        "=r"(r4),      // %5
                        "=r"(kptr)     // %6
                        : "0"(outptr0),
                        "1"(r0),
                        "2"(r1),
                        "3"(r2),
                        "4"(r3),
                        "5"(r4),
                        "6"(kptr)
                        : "memory", "q0", "q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12", "q13", "q14", "q15");
#endif // __aarch64__
                }
                for (; j < outw; j++)
                {
#if __aarch64__
                    asm volatile(
                        "prfm   pldl1keep, [%0, #128]       \n"
                        "ld1    {v20.4s}, [%0]              \n" // sum0

                        "prfm   pldl1keep, [%1, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%1], #16   \n" // r00 r01

                        "shll   v0.4s, v0.4h, #16           \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v1.4s, v1.4h, #16           \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmul   v21.4s, v16.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmul   v22.4s, v17.4s, v0.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmul   v23.4s, v18.4s, v0.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%1, #192]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h}, [%1] \n" // r02 r03 r04
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"

                        "fmla   v21.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v1.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v1.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v2.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%2, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%2], #16   \n" // r10 r11
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"

                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v21.4s, v24.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v0.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v0.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%2, #192]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h}, [%2] \n" // r12 r13 r14
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"

                        "fmla   v21.4s, v16.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v1.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v1.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v21.4s, v24.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v2.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v2.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v3.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%3, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%3], #16   \n" // r20 r21
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"

                        "fmla   v21.4s, v24.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v4.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v0.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v0.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%3, #192]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h}, [%3] \n" // r22 r23 r24
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"

                        "fmla   v21.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v1.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v1.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v2.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%4, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%4], #16   \n" // r30 r31
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"

                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v21.4s, v24.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v0.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v0.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%4, #192]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h}, [%4] \n" // r32 r33 r34
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"

                        "fmla   v21.4s, v16.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v1.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v1.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v21.4s, v24.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v2.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v2.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v3.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%5, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%5], #16   \n" // r40 r41
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"

                        "fmla   v21.4s, v24.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v4.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v0.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v0.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%5, #192]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h}, [%5] \n" // r42 r43 r44
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"

                        "fmla   v21.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v1.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v1.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%6], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v2.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        //                         "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%6] \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"

                        "fadd   v22.4s, v21.4s, v22.4s      \n"
                        "fadd   v23.4s, v22.4s, v23.4s      \n"
                        "fadd   v20.4s, v20.4s, v23.4s      \n"

                        "sub    %6, %6, #768                \n" // kptr -= 24 * 16;

                        "st1    {v20.4s}, [%0], #16         \n"

                        : "=r"(outptr0), // %0
                        "=r"(r0),      // %1
                        "=r"(r1),      // %2
                        "=r"(r2),      // %3
                        "=r"(r3),      // %4
                        "=r"(r4),      // %5
                        "=r"(kptr)     // %6
                        : "0"(outptr0),
                        "1"(r0),
                        "2"(r1),
                        "3"(r2),
                        "4"(r3),
                        "5"(r4),
                        "6"(kptr)
                        : "memory", "v0", "v1", "v2", "v3", "v4", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27");
#else  // __aarch64__
                    asm volatile(
                        "pld        [%1, #128]          \n"
                        "vld1.u16   {d2-d3}, [%1 :64]!  \n" // r00 r01

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"

                        "vshll.u16  q0, d2, #16         \n"
                        "vshll.u16  q1, d3, #16         \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "pld        [%0, #128]          \n"
                        "vld1.f32   {d24-d25}, [%0 :128] \n" // sum0

                        "vmul.f32   q13, q8, d0[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmul.f32   q14, q9, d0[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmul.f32   q15, q10, d1[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "pld        [%1, #192]          \n"
                        "vld1.u16   {d6-d8}, [%1 :64]   \n" // r02 r03 r04
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"
                        "vshll.u16  q4, d8, #16         \n"

                        "vmla.f32   q13, q10, d2[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d2[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d4[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d6[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "pld        [%2, #128]          \n"
                        "vld1.u16   {d2-d3}, [%2 :64]!  \n" // r10 r11
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q0, d2, #16         \n"
                        "vshll.u16  q1, d3, #16         \n"

                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d0[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d0[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d1[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "pld        [%2, #192]          \n"
                        "vld1.u16   {d6-d8}, [%2 :64]   \n" // r12 r13 r14
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"
                        "vshll.u16  q4, d8, #16         \n"

                        "vmla.f32   q13, q8, d2[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d2[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d3[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d4[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d4[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d6[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d6[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "pld        [%3, #128]          \n"
                        "vld1.u16   {d2-d3}, [%3 :64]!  \n" // r20 r21
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q0, d2, #16         \n"
                        "vshll.u16  q1, d3, #16         \n"

                        "vmla.f32   q13, q10, d8[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d8[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d0[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d0[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d1[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "pld        [%3, #192]          \n"
                        "vld1.u16   {d6-d8}, [%3 :64]   \n" // r22 r23 r24
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"
                        "vshll.u16  q4, d8, #16         \n"

                        "vmla.f32   q13, q10, d2[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d2[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d4[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d6[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "pld        [%4, #128]          \n"
                        "vld1.u16   {d2-d3}, [%4 :64]!  \n" // r30 r31
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q0, d2, #16         \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q1, d3, #16         \n"

                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d0[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d0[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d1[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "pld        [%4, #192]          \n"
                        "vld1.u16   {d6-d8}, [%4 :64]   \n" // r32 r33 r34
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"
                        "vshll.u16  q4, d8, #16         \n"

                        "vmla.f32   q13, q8, d2[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d2[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d3[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d4[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d4[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d6[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d6[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "pld        [%5, #128]          \n"
                        "vld1.u16   {d2-d3}, [%5 :64]!  \n" // r40 r41
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q0, d2, #16         \n"
                        "vshll.u16  q1, d3, #16         \n"

                        "vmla.f32   q13, q10, d8[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d8[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d0[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d0[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d1[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "pld        [%5, #192]          \n"
                        "vld1.u16   {d6-d8}, [%5 :64]   \n" // r42 r43 r44
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"
                        "vshll.u16  q4, d8, #16         \n"

                        "vmla.f32   q13, q10, d2[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d2[1]     \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d4[1]      \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d16-d19}, [%6 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d6[1]     \n"
                        //                         "pld        [%6, #256]          \n"
                        "vld1.u16   {d20-d23}, [%6 :128] \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vmla.f32   q12, q11, d9[1]     \n"

                        "vadd.f32   q14, q13, q14       \n"
                        "vadd.f32   q15, q14, q15       \n"
                        "vadd.f32   q12, q12, q15       \n"

                        "sub        %6, %6, #768        \n" // kptr -= 24 * 16;

                        "vst1.f32   {d24-d25}, [%0 :128]! \n"

                        : "=r"(outptr0), // %0
                        "=r"(r0),      // %1
                        "=r"(r1),      // %2
                        "=r"(r2),      // %3
                        "=r"(r3),      // %4
                        "=r"(r4),      // %5
                        "=r"(kptr)     // %6
                        : "0"(outptr0),
                        "1"(r0),
                        "2"(r1),
                        "3"(r2),
                        "4"(r3),
                        "5"(r4),
                        "6"(kptr)
                        : "memory", "q0", "q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12", "q13", "q14", "q15");
#endif // __aarch64__
                }

                r0 += tailstep;
                r1 += tailstep;
                r2 += tailstep;
                r3 += tailstep;
                r4 += tailstep;
            }
        }
        for (; q < inch; q++)
        {
            unsigned short* outptr0_bf16 = top_blob.channel(p);

            const float* outptr0 = out0.row(0);

            const Mat img0 = bottom_blob.channel(q);

            const unsigned short* r0 = img0.row<const unsigned short>(0);
            const unsigned short* r1 = img0.row<const unsigned short>(1);
            const unsigned short* r2 = img0.row<const unsigned short>(2);
            const unsigned short* r3 = img0.row<const unsigned short>(3);
            const unsigned short* r4 = img0.row<const unsigned short>(4);

            const unsigned short* kptr = kernel.channel(p).row<const unsigned short>(q);

            int i = 0;
            for (; i < outh; i++)
            {
                int j = 0;
                for (; j + 3 < outw; j += 4)
                {
#if __aarch64__
                    asm volatile(
                        "prfm   pldl1keep, [%2, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%2], #32 \n" // r00 r01 r02 r03

                        "prfm   pldl1keep, [%2, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%2], #32 \n" // r04 r05 r06 r07

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "prfm   pldl1keep, [%1, #512]       \n"
                        "ld1    {v20.4s, v21.4s, v22.4s, v23.4s}, [%1], #64 \n" // sum0 sum1 sum2 sum3

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v16.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v6.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v6.s[3]     \n"

                        "prfm   pldl1keep, [%2, #192]       \n"
                        "ld1    {v28.4h, v29.4h, v30.4h}, [%2] \n" // r08 r09 r010

                        "shll   v28.4s, v28.4h, #16         \n"
                        "shll   v29.4s, v29.4h, #16         \n"
                        "shll   v30.4s, v30.4h, #16         \n"

                        "fmla   v20.4s, v24.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v7.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v7.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v28.s[0]    \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v28.s[1]    \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v28.s[2]    \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v28.s[3]    \n"

                        "fmla   v20.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v7.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v29.s[0]    \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v7.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v29.s[1]    \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v7.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v29.s[2]    \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v7.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v29.s[3]    \n"

                        "prfm   pldl1keep, [%3, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%3], #32 \n" // r10 r11 r12 r13

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v20.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v28.s[0]    \n"
                        "fmla   v23.4s, v16.4s, v30.s[0]    \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v6.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v28.s[1]    \n"
                        "fmla   v23.4s, v17.4s, v30.s[1]    \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v28.s[2]    \n"
                        "fmla   v23.4s, v18.4s, v30.s[2]    \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v6.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v28.s[3]    \n"
                        "fmla   v23.4s, v19.4s, v30.s[3]    \n"

                        "prfm   pldl1keep, [%3, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%3], #32 \n" // r14 r15 r16 r17

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "fmla   v20.4s, v24.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v6.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v6.s[3]     \n"

                        "prfm   pldl1keep, [%3, #192]       \n"
                        "ld1    {v28.4h, v29.4h, v30.4h}, [%3] \n" // r18 r19 r110

                        "shll   v28.4s, v28.4h, #16         \n"
                        "shll   v29.4s, v29.4h, #16         \n"
                        "shll   v30.4s, v30.4h, #16         \n"

                        "fmla   v20.4s, v16.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v7.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v7.s[3]     \n"

                        "fmla   v20.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v28.s[0]    \n"
                        "fmla   v20.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v28.s[1]    \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v28.s[2]    \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v28.s[3]    \n"

                        "fmla   v20.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v7.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v29.s[0]    \n"
                        "fmla   v20.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v7.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v29.s[1]    \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v7.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v29.s[2]    \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v7.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v29.s[3]    \n"

                        "prfm   pldl1keep, [%4, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%4], #32 \n" // r20 r21 r22 r23

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v20.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v28.s[0]    \n"
                        "fmla   v23.4s, v24.4s, v30.s[0]    \n"
                        "fmla   v20.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v6.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v28.s[1]    \n"
                        "fmla   v23.4s, v25.4s, v30.s[1]    \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v28.s[2]    \n"
                        "fmla   v23.4s, v26.4s, v30.s[2]    \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v6.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v28.s[3]    \n"
                        "fmla   v23.4s, v27.4s, v30.s[3]    \n"

                        "prfm   pldl1keep, [%4, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%4], #32 \n" // r24 r25 r26 r27

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "fmla   v20.4s, v16.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v6.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v6.s[3]     \n"

                        "prfm   pldl1keep, [%4, #192]       \n"
                        "ld1    {v28.4h, v29.4h, v30.4h}, [%4] \n" // r28 r29 r210

                        "shll   v28.4s, v28.4h, #16         \n"
                        "shll   v29.4s, v29.4h, #16         \n"
                        "shll   v30.4s, v30.4h, #16         \n"

                        "fmla   v20.4s, v24.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v7.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v7.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v28.s[0]    \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v28.s[1]    \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v28.s[2]    \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v28.s[3]    \n"

                        "fmla   v20.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v7.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v29.s[0]    \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v7.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v29.s[1]    \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v7.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v29.s[2]    \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v7.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v29.s[3]    \n"

                        "prfm   pldl1keep, [%5, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%5], #32 \n" // r30 r31 r32 r33

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v20.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v28.s[0]    \n"
                        "fmla   v23.4s, v16.4s, v30.s[0]    \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v6.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v28.s[1]    \n"
                        "fmla   v23.4s, v17.4s, v30.s[1]    \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v28.s[2]    \n"
                        "fmla   v23.4s, v18.4s, v30.s[2]    \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v6.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v28.s[3]    \n"
                        "fmla   v23.4s, v19.4s, v30.s[3]    \n"

                        "prfm   pldl1keep, [%5, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%5], #32 \n" // r34 r35 r36 r37

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "fmla   v20.4s, v24.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v6.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v6.s[3]     \n"

                        "prfm   pldl1keep, [%5, #192]       \n"
                        "ld1    {v28.4h, v29.4h, v30.4h}, [%5] \n" // r38 r39 r310

                        "shll   v28.4s, v28.4h, #16         \n"
                        "shll   v29.4s, v29.4h, #16         \n"
                        "shll   v30.4s, v30.4h, #16         \n"

                        "fmla   v20.4s, v16.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v7.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v7.s[3]     \n"

                        "fmla   v20.4s, v24.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v28.s[0]    \n"
                        "fmla   v20.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v28.s[1]    \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v28.s[2]    \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v28.s[3]    \n"

                        "fmla   v20.4s, v16.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v7.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v29.s[0]    \n"
                        "fmla   v20.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v7.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v29.s[1]    \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v7.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v29.s[2]    \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v7.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v29.s[3]    \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%6], #32 \n" // r40 r41 r42 r43

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v20.4s, v24.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v6.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v28.s[0]    \n"
                        "fmla   v23.4s, v24.4s, v30.s[0]    \n"
                        "fmla   v20.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v6.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v28.s[1]    \n"
                        "fmla   v23.4s, v25.4s, v30.s[1]    \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v6.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v28.s[2]    \n"
                        "fmla   v23.4s, v26.4s, v30.s[2]    \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v6.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v28.s[3]    \n"
                        "fmla   v23.4s, v27.4s, v30.s[3]    \n"

                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h, v7.4h}, [%6], #32 \n" // r44 r45 r46 r47

                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"
                        "shll   v7.4s, v7.4h, #16           \n"

                        "fmla   v20.4s, v16.4s, v0.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v6.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v0.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v6.s[3]     \n"

                        "prfm   pldl1keep, [%6, #192]       \n"
                        "ld1    {v28.4h, v29.4h, v30.4h}, [%6] \n" // r48 r49 r410

                        "shll   v28.4s, v28.4h, #16         \n"
                        "shll   v29.4s, v29.4h, #16         \n"
                        "shll   v30.4s, v30.4h, #16         \n"

                        "fmla   v20.4s, v24.4s, v1.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v7.s[0]     \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v7.s[1]     \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v7.s[2]     \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v7.s[3]     \n"

                        "fmla   v20.4s, v16.4s, v2.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v28.s[0]    \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v6.s[1]     \n"
                        "fmla   v23.4s, v17.4s, v28.s[1]    \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"

                        "shll   v24.4s, v24.4h, #16         \n"
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v20.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v28.s[2]    \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v6.s[3]     \n"
                        "fmla   v23.4s, v19.4s, v28.s[3]    \n"

                        "fmla   v20.4s, v24.4s, v3.s[0]     \n"
                        "fmla   v21.4s, v24.4s, v5.s[0]     \n"
                        "fmla   v22.4s, v24.4s, v7.s[0]     \n"
                        "fmla   v23.4s, v24.4s, v29.s[0]    \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "fmla   v22.4s, v25.4s, v7.s[1]     \n"
                        "fmla   v23.4s, v25.4s, v29.s[1]    \n"

                        //                         "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7] \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v20.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v21.4s, v26.4s, v5.s[2]     \n"
                        "fmla   v22.4s, v26.4s, v7.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v29.s[2]    \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "fmla   v22.4s, v27.4s, v7.s[3]     \n"
                        "fmla   v23.4s, v27.4s, v29.s[3]    \n"

                        "fmla   v20.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v21.4s, v16.4s, v6.s[0]     \n"
                        "fmla   v22.4s, v16.4s, v28.s[0]    \n"
                        "fmla   v23.4s, v16.4s, v30.s[0]    \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v6.s[1]     \n"
                        "fmla   v22.4s, v17.4s, v28.s[1]    \n"
                        "fmla   v23.4s, v17.4s, v30.s[1]    \n"
                        "fmla   v20.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v21.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v22.4s, v18.4s, v28.s[2]    \n"
                        "fmla   v23.4s, v18.4s, v30.s[2]    \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v6.s[3]     \n"
                        "fmla   v22.4s, v19.4s, v28.s[3]    \n"
                        "fmla   v23.4s, v19.4s, v30.s[3]    \n"

                        "sub    %7, %7, #768                \n" // kptr -= 24 * 16;

                        "shrn   v20.4h, v20.4s, #16         \n"
                        "shrn   v21.4h, v21.4s, #16         \n"
                        "shrn   v22.4h, v22.4s, #16         \n"
                        "shrn   v23.4h, v23.4s, #16         \n"

                        "st1    {v20.4h, v21.4h, v22.4h, v23.4h}, [%0], #32 \n"

                        : "=r"(outptr0_bf16), // %0
                        "=r"(outptr0),      // %1
                        "=r"(r0),           // %2
                        "=r"(r1),           // %3
                        "=r"(r2),           // %4
                        "=r"(r3),           // %5
                        "=r"(r4),           // %6
                        "=r"(kptr)          // %7
                        : "0"(outptr0_bf16),
                        "1"(outptr0),
                        "2"(r0),
                        "3"(r1),
                        "4"(r2),
                        "5"(r3),
                        "6"(r4),
                        "7"(kptr)
                        : "memory", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27", "v28", "v29", "v30");
#else  // __aarch64__
                    asm volatile(
                        "pld        [%1, #512]          \n"
                        "vldm       %1!, {d24-d31}      \n" // sum0 sum1 sum2 sum3

                        "pld        [%2, #256]          \n"
                        "vld1.u16   {d4-d7}, [%2 :64]!  \n" // r00 r01 r02 r03

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%2, #256]          \n"
                        "vld1.u16   {d12-d15}, [%2 :64]! \n" // r04 r05 r06 r07

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q12, q8, d0[0]      \n"
                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d12[0]     \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "vmla.f32   q15, q9, d12[1]     \n"
                        "vmla.f32   q12, q10, d1[0]     \n"
                        "vmla.f32   q13, q10, d5[0]     \n"
                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vmla.f32   q15, q10, d13[0]    \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "vmla.f32   q14, q11, d9[1]     \n"
                        "vmla.f32   q15, q11, d13[1]    \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d2[0]     \n"
                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vmla.f32   q14, q10, d10[0]    \n"
                        "vmla.f32   q15, q10, d14[0]    \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "vmla.f32   q14, q11, d10[1]    \n"
                        "vmla.f32   q15, q11, d14[1]    \n"
                        "vmla.f32   q12, q8, d3[0]      \n"
                        "vmla.f32   q13, q8, d7[0]      \n"
                        "vmla.f32   q14, q8, d11[0]     \n"
                        "vmla.f32   q15, q8, d15[0]     \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "vmla.f32   q14, q9, d11[1]     \n"
                        "vmla.f32   q15, q9, d15[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%2, #128]          \n"
                        "vld1.u16   {d2-d3}, [%2 :64]!  \n" // r08 r09

                        "vshll.u16  q0, d2, #16         \n"
                        "vshll.u16  q1, d3, #16         \n"

                        "vmla.f32   q12, q8, d4[0]      \n"
                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vmla.f32   q14, q8, d12[0]     \n"
                        "vmla.f32   q15, q8, d0[0]      \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "vmla.f32   q14, q9, d12[1]     \n"
                        "vmla.f32   q15, q9, d0[1]      \n"
                        "vmla.f32   q12, q10, d5[0]     \n"
                        "vmla.f32   q13, q10, d9[0]     \n"
                        "vmla.f32   q14, q10, d13[0]    \n"
                        "vmla.f32   q15, q10, d1[0]     \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vmla.f32   q14, q11, d13[1]    \n"
                        "vmla.f32   q15, q11, d1[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d6[0]     \n"
                        "vmla.f32   q13, q10, d10[0]    \n"
                        "vmla.f32   q14, q10, d14[0]    \n"
                        "vmla.f32   q15, q10, d2[0]     \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        "vmla.f32   q14, q11, d14[1]    \n"
                        "vmla.f32   q15, q11, d2[1]     \n"
                        "vmla.f32   q12, q8, d7[0]      \n"
                        "vmla.f32   q13, q8, d11[0]     \n"
                        "vmla.f32   q14, q8, d15[0]     \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "vmla.f32   q14, q9, d15[1]     \n"
                        "vmla.f32   q15, q9, d3[1]      \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%2, #64]           \n"
                        "vld1.u16   {d5}, [%2 :64]      \n" // r010

                        "vshll.u16  q2, d5, #16         \n"

                        "vmla.f32   q12, q8, d8[0]      \n"
                        "vmla.f32   q13, q8, d12[0]     \n"
                        "vmla.f32   q14, q8, d0[0]      \n"
                        "vmla.f32   q15, q8, d4[0]      \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d12[1]     \n"
                        "vmla.f32   q14, q9, d0[1]      \n"
                        "vmla.f32   q15, q9, d4[1]      \n"
                        "vmla.f32   q12, q10, d9[0]     \n"
                        "vmla.f32   q13, q10, d13[0]    \n"
                        "vmla.f32   q14, q10, d1[0]     \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d13[1]    \n"

                        "pld        [%3, #256]          \n"
                        "vld1.u16   {d12-d15}, [%3 :64]! \n" // r10 r11 r12 r13

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q14, q11, d1[1]     \n"
                        "vmla.f32   q15, q11, d5[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%3, #256]          \n"
                        "vld1.u16   {d4-d7}, [%3 :64]!  \n" // r14 r15 r16 r17

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q12, q10, d8[0]     \n"
                        "vmla.f32   q13, q10, d12[0]    \n"
                        "vmla.f32   q14, q10, d0[0]     \n"
                        "vmla.f32   q15, q10, d4[0]     \n"
                        "vmla.f32   q12, q11, d8[1]     \n"
                        "vmla.f32   q13, q11, d12[1]    \n"
                        "vmla.f32   q14, q11, d0[1]     \n"
                        "vmla.f32   q15, q11, d4[1]     \n"
                        "vmla.f32   q12, q8, d9[0]      \n"
                        "vmla.f32   q13, q8, d13[0]     \n"
                        "vmla.f32   q14, q8, d1[0]      \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vmla.f32   q13, q9, d13[1]     \n"
                        "vmla.f32   q14, q9, d1[1]      \n"
                        "vmla.f32   q15, q9, d5[1]      \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d10[0]     \n"
                        "vmla.f32   q13, q8, d14[0]     \n"
                        "vmla.f32   q14, q8, d2[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vmla.f32   q12, q9, d10[1]     \n"
                        "vmla.f32   q13, q9, d14[1]     \n"
                        "vmla.f32   q14, q9, d2[1]      \n"
                        "vmla.f32   q15, q9, d6[1]      \n"
                        "vmla.f32   q12, q10, d11[0]    \n"
                        "vmla.f32   q13, q10, d15[0]    \n"
                        "vmla.f32   q14, q10, d3[0]     \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vmla.f32   q12, q11, d11[1]    \n"
                        "vmla.f32   q13, q11, d15[1]    \n"
                        "vmla.f32   q14, q11, d3[1]     \n"
                        "vmla.f32   q15, q11, d7[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%3, #128]          \n"
                        "vld1.u16   {d10-d11}, [%3 :64]! \n" // r18 r19

                        "vshll.u16  q4, d10, #16        \n"
                        "vshll.u16  q5, d11, #16        \n"

                        "vmla.f32   q12, q10, d12[0]    \n"
                        "vmla.f32   q13, q10, d0[0]     \n"
                        "vmla.f32   q14, q10, d4[0]     \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vmla.f32   q12, q11, d12[1]    \n"
                        "vmla.f32   q13, q11, d0[1]     \n"
                        "vmla.f32   q14, q11, d4[1]     \n"
                        "vmla.f32   q15, q11, d8[1]     \n"
                        "vmla.f32   q12, q8, d13[0]     \n"
                        "vmla.f32   q13, q8, d1[0]      \n"
                        "vmla.f32   q14, q8, d5[0]      \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vmla.f32   q12, q9, d13[1]     \n"
                        "vmla.f32   q13, q9, d1[1]      \n"
                        "vmla.f32   q14, q9, d5[1]      \n"
                        "vmla.f32   q15, q9, d9[1]      \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d14[0]     \n"
                        "vmla.f32   q13, q8, d2[0]      \n"
                        "vmla.f32   q14, q8, d6[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vmla.f32   q12, q9, d14[1]     \n"
                        "vmla.f32   q13, q9, d2[1]      \n"
                        "vmla.f32   q14, q9, d6[1]      \n"
                        "vmla.f32   q15, q9, d10[1]     \n"
                        "vmla.f32   q12, q10, d15[0]    \n"
                        "vmla.f32   q13, q10, d3[0]     \n"
                        "vmla.f32   q14, q10, d7[0]     \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vmla.f32   q12, q11, d15[1]    \n"
                        "vmla.f32   q13, q11, d3[1]     \n"
                        "vmla.f32   q14, q11, d7[1]     \n"
                        "vmla.f32   q15, q11, d11[1]    \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%3, #64]           \n"
                        "vld1.u16   {d13}, [%3 :64]     \n" // r110

                        "vshll.u16  q6, d13, #16        \n"

                        "vmla.f32   q12, q10, d0[0]     \n"
                        "vmla.f32   q13, q10, d4[0]     \n"
                        "vmla.f32   q14, q10, d8[0]     \n"
                        "vmla.f32   q15, q10, d12[0]    \n"
                        "vmla.f32   q12, q11, d0[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "vmla.f32   q14, q11, d8[1]     \n"
                        "vmla.f32   q15, q11, d12[1]    \n"
                        "vmla.f32   q12, q8, d1[0]      \n"
                        "vmla.f32   q13, q8, d5[0]      \n"
                        "vmla.f32   q14, q8, d9[0]      \n"
                        "vmla.f32   q15, q8, d13[0]     \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "vmla.f32   q13, q9, d5[1]      \n"

                        "pld        [%4, #256]          \n"
                        "vld1.u16   {d4-d7}, [%4 :64]!  \n" // r20 r21 r22 r23

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q14, q9, d9[1]      \n"
                        "vmla.f32   q15, q9, d13[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%4, #256]          \n"
                        "vld1.u16   {d12-d15}, [%4 :64]! \n" // r24 r25 r26 r27

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q12, q8, d0[0]      \n"
                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d12[0]     \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "vmla.f32   q15, q9, d12[1]     \n"
                        "vmla.f32   q12, q10, d1[0]     \n"
                        "vmla.f32   q13, q10, d5[0]     \n"
                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vmla.f32   q15, q10, d13[0]    \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "vmla.f32   q14, q11, d9[1]     \n"
                        "vmla.f32   q15, q11, d13[1]    \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d2[0]     \n"
                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vmla.f32   q14, q10, d10[0]    \n"
                        "vmla.f32   q15, q10, d14[0]    \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "vmla.f32   q14, q11, d10[1]    \n"
                        "vmla.f32   q15, q11, d14[1]    \n"
                        "vmla.f32   q12, q8, d3[0]      \n"
                        "vmla.f32   q13, q8, d7[0]      \n"
                        "vmla.f32   q14, q8, d11[0]     \n"
                        "vmla.f32   q15, q8, d15[0]     \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "vmla.f32   q14, q9, d11[1]     \n"
                        "vmla.f32   q15, q9, d15[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%4, #128]          \n"
                        "vld1.u16   {d2-d3}, [%4 :64]!  \n" // r28 r29

                        "vshll.u16  q0, d2, #16         \n"
                        "vshll.u16  q1, d3, #16         \n"

                        "vmla.f32   q12, q8, d4[0]      \n"
                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vmla.f32   q14, q8, d12[0]     \n"
                        "vmla.f32   q15, q8, d0[0]      \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "vmla.f32   q14, q9, d12[1]     \n"
                        "vmla.f32   q15, q9, d0[1]      \n"
                        "vmla.f32   q12, q10, d5[0]     \n"
                        "vmla.f32   q13, q10, d9[0]     \n"
                        "vmla.f32   q14, q10, d13[0]    \n"
                        "vmla.f32   q15, q10, d1[0]     \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vmla.f32   q14, q11, d13[1]    \n"
                        "vmla.f32   q15, q11, d1[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d6[0]     \n"
                        "vmla.f32   q13, q10, d10[0]    \n"
                        "vmla.f32   q14, q10, d14[0]    \n"
                        "vmla.f32   q15, q10, d2[0]     \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        "vmla.f32   q14, q11, d14[1]    \n"
                        "vmla.f32   q15, q11, d2[1]     \n"
                        "vmla.f32   q12, q8, d7[0]      \n"
                        "vmla.f32   q13, q8, d11[0]     \n"
                        "vmla.f32   q14, q8, d15[0]     \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "vmla.f32   q14, q9, d15[1]     \n"
                        "vmla.f32   q15, q9, d3[1]      \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%4, #64]           \n"
                        "vld1.u16   {d5}, [%4 :64]      \n" // r210

                        "vshll.u16  q2, d5, #16         \n"

                        "vmla.f32   q12, q8, d8[0]      \n"
                        "vmla.f32   q13, q8, d12[0]     \n"
                        "vmla.f32   q14, q8, d0[0]      \n"
                        "vmla.f32   q15, q8, d4[0]      \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d12[1]     \n"
                        "vmla.f32   q14, q9, d0[1]      \n"
                        "vmla.f32   q15, q9, d4[1]      \n"
                        "vmla.f32   q12, q10, d9[0]     \n"
                        "vmla.f32   q13, q10, d13[0]    \n"
                        "vmla.f32   q14, q10, d1[0]     \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d13[1]    \n"

                        "pld        [%5, #256]          \n"
                        "vld1.u16   {d12-d15}, [%5 :64]! \n" // r30 r31 r32 r33

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q14, q11, d1[1]     \n"
                        "vmla.f32   q15, q11, d5[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%5, #256]          \n"
                        "vld1.u16   {d4-d7}, [%5 :64]!  \n" // r34 r35 r36 r37

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q12, q10, d8[0]     \n"
                        "vmla.f32   q13, q10, d12[0]    \n"
                        "vmla.f32   q14, q10, d0[0]     \n"
                        "vmla.f32   q15, q10, d4[0]     \n"
                        "vmla.f32   q12, q11, d8[1]     \n"
                        "vmla.f32   q13, q11, d12[1]    \n"
                        "vmla.f32   q14, q11, d0[1]     \n"
                        "vmla.f32   q15, q11, d4[1]     \n"
                        "vmla.f32   q12, q8, d9[0]      \n"
                        "vmla.f32   q13, q8, d13[0]     \n"
                        "vmla.f32   q14, q8, d1[0]      \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vmla.f32   q13, q9, d13[1]     \n"
                        "vmla.f32   q14, q9, d1[1]      \n"
                        "vmla.f32   q15, q9, d5[1]      \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d10[0]     \n"
                        "vmla.f32   q13, q8, d14[0]     \n"
                        "vmla.f32   q14, q8, d2[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vmla.f32   q12, q9, d10[1]     \n"
                        "vmla.f32   q13, q9, d14[1]     \n"
                        "vmla.f32   q14, q9, d2[1]      \n"
                        "vmla.f32   q15, q9, d6[1]      \n"
                        "vmla.f32   q12, q10, d11[0]    \n"
                        "vmla.f32   q13, q10, d15[0]    \n"
                        "vmla.f32   q14, q10, d3[0]     \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vmla.f32   q12, q11, d11[1]    \n"
                        "vmla.f32   q13, q11, d15[1]    \n"
                        "vmla.f32   q14, q11, d3[1]     \n"
                        "vmla.f32   q15, q11, d7[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%5, #128]          \n"
                        "vld1.u16   {d10-d11}, [%5 :64]! \n" // r38 r39

                        "vshll.u16  q4, d10, #16        \n"
                        "vshll.u16  q5, d11, #16        \n"

                        "vmla.f32   q12, q10, d12[0]    \n"
                        "vmla.f32   q13, q10, d0[0]     \n"
                        "vmla.f32   q14, q10, d4[0]     \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vmla.f32   q12, q11, d12[1]    \n"
                        "vmla.f32   q13, q11, d0[1]     \n"
                        "vmla.f32   q14, q11, d4[1]     \n"
                        "vmla.f32   q15, q11, d8[1]     \n"
                        "vmla.f32   q12, q8, d13[0]     \n"
                        "vmla.f32   q13, q8, d1[0]      \n"
                        "vmla.f32   q14, q8, d5[0]      \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vmla.f32   q12, q9, d13[1]     \n"
                        "vmla.f32   q13, q9, d1[1]      \n"
                        "vmla.f32   q14, q9, d5[1]      \n"
                        "vmla.f32   q15, q9, d9[1]      \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "vmla.f32   q12, q8, d14[0]     \n"
                        "vmla.f32   q13, q8, d2[0]      \n"
                        "vmla.f32   q14, q8, d6[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vmla.f32   q12, q9, d14[1]     \n"
                        "vmla.f32   q13, q9, d2[1]      \n"
                        "vmla.f32   q14, q9, d6[1]      \n"
                        "vmla.f32   q15, q9, d10[1]     \n"
                        "vmla.f32   q12, q10, d15[0]    \n"
                        "vmla.f32   q13, q10, d3[0]     \n"
                        "vmla.f32   q14, q10, d7[0]     \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vmla.f32   q12, q11, d15[1]    \n"
                        "vmla.f32   q13, q11, d3[1]     \n"
                        "vmla.f32   q14, q11, d7[1]     \n"
                        "vmla.f32   q15, q11, d11[1]    \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "pld        [%5, #64]           \n"
                        "vld1.u16   {d13}, [%5 :64]     \n" // r310

                        "vshll.u16  q6, d13, #16        \n"

                        "vmla.f32   q12, q10, d0[0]     \n"
                        "vmla.f32   q13, q10, d4[0]     \n"
                        "vmla.f32   q14, q10, d8[0]     \n"
                        "vmla.f32   q15, q10, d12[0]    \n"
                        "vmla.f32   q12, q11, d0[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "vmla.f32   q14, q11, d8[1]     \n"
                        "vmla.f32   q15, q11, d12[1]    \n"
                        "vmla.f32   q12, q8, d1[0]      \n"
                        "vmla.f32   q13, q8, d5[0]      \n"
                        "vmla.f32   q14, q8, d9[0]      \n"
                        "vmla.f32   q15, q8, d13[0]     \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "vmla.f32   q13, q9, d5[1]      \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d4-d7}, [%6 :64]!  \n" // r40 r41 r42 r43

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q14, q9, d9[1]      \n"
                        "vmla.f32   q15, q9, d13[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d12-d15}, [%6 :64]! \n" // r44 r45 r46 r47

                        "vshll.u16  q4, d12, #16        \n"
                        "vshll.u16  q5, d13, #16        \n"
                        "vshll.u16  q6, d14, #16        \n"
                        "vshll.u16  q7, d15, #16        \n"

                        "vmla.f32   q12, q8, d0[0]      \n"
                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d12[0]     \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "vmla.f32   q15, q9, d12[1]     \n"
                        "vmla.f32   q12, q10, d1[0]     \n"
                        "vmla.f32   q13, q10, d5[0]     \n"
                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vmla.f32   q15, q10, d13[0]    \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "vmla.f32   q14, q11, d9[1]     \n"
                        "vmla.f32   q15, q11, d13[1]    \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d2[0]     \n"
                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vmla.f32   q14, q10, d10[0]    \n"
                        "vmla.f32   q15, q10, d14[0]    \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "vmla.f32   q14, q11, d10[1]    \n"
                        "vmla.f32   q15, q11, d14[1]    \n"
                        "vmla.f32   q12, q8, d3[0]      \n"
                        "vmla.f32   q13, q8, d7[0]      \n"
                        "vmla.f32   q14, q8, d11[0]     \n"
                        "vmla.f32   q15, q8, d15[0]     \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "vmla.f32   q14, q9, d11[1]     \n"
                        "vmla.f32   q15, q9, d15[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%6, #128]          \n"
                        "vld1.u16   {d2-d3}, [%6 :64]!  \n" // r48 r49

                        "vshll.u16  q0, d2, #16         \n"
                        "vshll.u16  q1, d3, #16         \n"

                        "vmla.f32   q12, q8, d4[0]      \n"
                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vmla.f32   q14, q8, d12[0]     \n"
                        "vmla.f32   q15, q8, d0[0]      \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "vmla.f32   q14, q9, d12[1]     \n"
                        "vmla.f32   q15, q9, d0[1]      \n"
                        "vmla.f32   q12, q10, d5[0]     \n"
                        "vmla.f32   q13, q10, d9[0]     \n"
                        "vmla.f32   q14, q10, d13[0]    \n"
                        "vmla.f32   q15, q10, d1[0]     \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vmla.f32   q14, q11, d13[1]    \n"
                        "vmla.f32   q15, q11, d1[1]     \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vshll.u16  q10, d16, #16       \n"
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vshll.u16  q9, d19, #16        \n"

                        "vmla.f32   q12, q10, d6[0]     \n"
                        "vmla.f32   q13, q10, d10[0]    \n"
                        "vmla.f32   q14, q10, d14[0]    \n"
                        "vmla.f32   q15, q10, d2[0]     \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        "vmla.f32   q14, q11, d14[1]    \n"
                        "vmla.f32   q15, q11, d2[1]     \n"
                        "vmla.f32   q12, q8, d7[0]      \n"
                        "vmla.f32   q13, q8, d11[0]     \n"
                        "vmla.f32   q14, q8, d15[0]     \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "vmla.f32   q14, q9, d15[1]     \n"
                        "vmla.f32   q15, q9, d3[1]      \n"

                        //                         "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128] \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q11, d23, #16       \n"

                        "pld        [%6, #64]           \n"
                        "vld1.u16   {d5}, [%6 :64]      \n" // r410

                        "vshll.u16  q2, d5, #16         \n"

                        "vmla.f32   q12, q8, d8[0]      \n"
                        "vmla.f32   q13, q8, d12[0]     \n"
                        "vmla.f32   q14, q8, d0[0]      \n"
                        "vmla.f32   q15, q8, d4[0]      \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d12[1]     \n"
                        "vmla.f32   q14, q9, d0[1]      \n"
                        "vmla.f32   q15, q9, d4[1]      \n"
                        "vmla.f32   q12, q10, d9[0]     \n"
                        "vmla.f32   q13, q10, d13[0]    \n"
                        "vmla.f32   q14, q10, d1[0]     \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d13[1]    \n"
                        "vmla.f32   q14, q11, d1[1]     \n"
                        "vmla.f32   q15, q11, d5[1]     \n"

                        "sub        %7, %7, #768        \n" // kptr -= 24 * 16;

                        "sub        %2, %2, #16         \n"
                        "sub        %3, %3, #16         \n"
                        "sub        %4, %4, #16         \n"
                        "sub        %5, %5, #16         \n"
                        "sub        %6, %6, #16         \n"

                        "vshrn.u32  d24, q12, #16       \n"
                        "vshrn.u32  d25, q13, #16       \n"
                        "vshrn.u32  d26, q14, #16       \n"
                        "vshrn.u32  d27, q15, #16       \n"

                        "vst1.u16   {d24-d27}, [%0 :64]! \n"

                        : "=r"(outptr0_bf16), // %0
                        "=r"(outptr0),      // %1
                        "=r"(r0),           // %2
                        "=r"(r1),           // %3
                        "=r"(r2),           // %4
                        "=r"(r3),           // %5
                        "=r"(r4),           // %6
                        "=r"(kptr)          // %7
                        : "0"(outptr0_bf16),
                        "1"(outptr0),
                        "2"(r0),
                        "3"(r1),
                        "4"(r2),
                        "5"(r3),
                        "6"(r4),
                        "7"(kptr)
                        : "memory", "q0", "q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12", "q13", "q14", "q15");
#endif // __aarch64__
                }
                for (; j + 1 < outw; j += 2)
                {
#if __aarch64__
                    asm volatile(
                        "prfm   pldl1keep, [%2, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%2], #32 \n" // r00 r01 r02 r03

                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"

                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"

                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v16.4s, v16.4h, #16         \n"

                        "prfm   pldl1keep, [%1, #256]       \n"
                        "ld1    {v20.4s, v21.4s}, [%1], #32 \n" // sum0 sum1

                        "fmul   v22.4s, v16.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v17.4s, v17.4h, #16         \n"
                        "fmul   v23.4s, v16.4s, v2.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v0.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "prfm   pldl1keep, [%2, #192]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h}, [%2] \n" // r04 r05 r06
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"

                        "fmla   v22.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v24.4s, v3.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v16.4s, v4.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v22.4s, v24.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v24.4s, v5.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v5.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "prfm   pldl1keep, [%3, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%3], #32 \n" // r10 r11 r12 r13
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v16.4s, v6.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v6.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v6.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v6.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v22.4s, v24.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v24.4s, v2.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v0.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v2.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "prfm   pldl1keep, [%3, #192]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h}, [%3] \n" // r14 r15 r16
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"

                        "fmla   v22.4s, v16.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v16.4s, v3.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v1.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v22.4s, v24.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v24.4s, v4.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v16.4s, v5.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v5.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"
                        "prfm   pldl1keep, [%4, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%4], #32 \n" // r20 r21 r22 r23
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v22.4s, v24.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v24.4s, v6.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v6.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v6.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v6.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v16.4s, v2.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v0.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "prfm   pldl1keep, [%4, #192]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h}, [%4] \n" // r24 r25 r26
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"

                        "fmla   v22.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v24.4s, v3.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v16.4s, v4.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v22.4s, v24.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v24.4s, v5.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v5.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "prfm   pldl1keep, [%5, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%5], #32 \n" // r30 r31 r32 r33
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v16.4s, v6.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v6.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v6.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v6.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v22.4s, v24.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v24.4s, v2.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v2.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v0.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v2.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v2.s[3]     \n"
                        "prfm   pldl1keep, [%5, #192]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h}, [%5] \n" // r34 r35 r36
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"

                        "fmla   v22.4s, v16.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v16.4s, v3.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v3.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v1.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v3.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v22.4s, v24.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v24.4s, v4.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v4.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v4.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v16.4s, v5.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v5.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v5.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v5.s[3]     \n"
                        "prfm   pldl1keep, [%6, #256]       \n"
                        "ld1    {v0.4h, v1.4h, v2.4h, v3.4h}, [%6], #32 \n" // r40 r41 r42 r43
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"

                        "fmla   v22.4s, v24.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v24.4s, v6.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v6.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v6.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v6.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v16.4s, v2.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v0.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v2.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v0.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v2.s[3]     \n"
                        "prfm   pldl1keep, [%6, #192]       \n"
                        "ld1    {v4.4h, v5.4h, v6.4h}, [%6] \n" // r44 r45 r46
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v4.4s, v4.4h, #16           \n"
                        "shll   v5.4s, v5.4h, #16           \n"
                        "shll   v6.4s, v6.4h, #16           \n"

                        "fmla   v22.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v24.4s, v3.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v1.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v1.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v3.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "fmla   v23.4s, v16.4s, v4.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v2.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v4.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"

                        "fmla   v22.4s, v18.4s, v2.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v4.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v22.4s, v24.4s, v3.s[0]     \n"
                        //                         "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7] \n"
                        "fmla   v23.4s, v24.4s, v5.s[0]     \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v20.4s, v25.4s, v3.s[1]     \n"
                        "fmla   v21.4s, v25.4s, v5.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"

                        "fmla   v22.4s, v26.4s, v3.s[2]     \n"
                        "fmla   v23.4s, v26.4s, v5.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "fmla   v21.4s, v27.4s, v5.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v22.4s, v16.4s, v4.s[0]     \n"
                        "fmla   v23.4s, v16.4s, v6.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v20.4s, v17.4s, v4.s[1]     \n"
                        "fmla   v21.4s, v17.4s, v6.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v22.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v23.4s, v18.4s, v6.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "fmla   v21.4s, v19.4s, v6.s[3]     \n"

                        "fadd   v20.4s, v20.4s, v22.4s      \n"
                        "fadd   v21.4s, v21.4s, v23.4s      \n"

                        "sub    %7, %7, #768                \n" // kptr -= 24 * 16;

                        "shrn   v20.4h, v20.4s, #16         \n"
                        "shrn   v21.4h, v21.4s, #16         \n"

                        "st1    {v20.4h, v21.4h}, [%0], #16 \n"

                        : "=r"(outptr0_bf16), // %0
                        "=r"(outptr0),      // %1
                        "=r"(r0),           // %2
                        "=r"(r1),           // %3
                        "=r"(r2),           // %4
                        "=r"(r3),           // %5
                        "=r"(r4),           // %6
                        "=r"(kptr)          // %7
                        : "0"(outptr0_bf16),
                        "1"(outptr0),
                        "2"(r0),
                        "3"(r1),
                        "4"(r2),
                        "5"(r3),
                        "6"(r4),
                        "7"(kptr)
                        : "memory", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27");
#else  // __aarch64__
                    asm volatile(
                        "pld        [%2, #256]          \n"
                        "vld1.u16   {d4-d7}, [%2 :64]!  \n" // r00 r01 r02 r03

                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "pld        [%1, #256]          \n"
                        "vld1.f32   {d24-d27}, [%1 :128]! \n" // sum0 sum1

                        "vmul.f32   q14, q8, d0[0]      \n"
                        "vmul.f32   q15, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d1[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "pld        [%2, #192]          \n"
                        "vld1.u16   {d10-d12}, [%2 :64] \n" // r04 r05 r06
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vshll.u16  q6, d12, #16        \n"

                        "vmla.f32   q14, q10, d2[0]     \n"
                        "vmla.f32   q15, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d3[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d4[0]      \n"
                        "vmla.f32   q15, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d5[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d6[0]     \n"
                        "vmla.f32   q15, q10, d10[0]    \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d7[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d11[0]     \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "pld        [%3, #256]          \n"
                        "vld1.u16   {d4-d7}, [%3 :64]!  \n" // r10 r11 r12 r13
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d12[0]     \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d12[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d13[0]    \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d13[1]    \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d0[0]     \n"
                        "vmla.f32   q15, q10, d4[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d0[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d1[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "vmla.f32   q13, q9, d5[1]      \n"
                        "pld        [%3, #192]          \n"
                        "vld1.u16   {d10-d12}, [%3 :64] \n" // r14 r15 r16
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vshll.u16  q6, d12, #16        \n"

                        "vmla.f32   q14, q8, d2[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d2[1]      \n"
                        "vmla.f32   q13, q9, d6[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d3[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vmla.f32   q13, q11, d7[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d4[0]     \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d4[1]     \n"
                        "vmla.f32   q13, q11, d8[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d5[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vmla.f32   q13, q9, d9[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d6[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d6[1]      \n"
                        "vmla.f32   q13, q9, d10[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d7[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "vmla.f32   q13, q11, d11[1]    \n"
                        "pld        [%4, #256]          \n"
                        "vld1.u16   {d4-d7}, [%4 :64]!  \n" // r20 r21 r22 r23
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q14, q10, d8[0]     \n"
                        "vmla.f32   q15, q10, d12[0]    \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d8[1]     \n"
                        "vmla.f32   q13, q11, d12[1]    \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d9[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d13[0]     \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vmla.f32   q13, q9, d13[1]     \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d0[0]      \n"
                        "vmla.f32   q15, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d1[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "pld        [%4, #192]          \n"
                        "vld1.u16   {d10-d12}, [%4 :64] \n" // r24 r25 r26
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vshll.u16  q6, d12, #16        \n"

                        "vmla.f32   q14, q10, d2[0]     \n"
                        "vmla.f32   q15, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d3[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d4[0]      \n"
                        "vmla.f32   q15, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d5[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d6[0]     \n"
                        "vmla.f32   q15, q10, d10[0]    \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d7[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d11[0]     \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "pld        [%5, #256]          \n"
                        "vld1.u16   {d4-d7}, [%5 :64]!  \n" // r30 r31 r32 r33
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d12[0]     \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d12[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d13[0]    \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d13[1]    \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d0[0]     \n"
                        "vmla.f32   q15, q10, d4[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d0[1]     \n"
                        "vmla.f32   q13, q11, d4[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d1[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "vmla.f32   q13, q9, d5[1]      \n"
                        "pld        [%5, #192]          \n"
                        "vld1.u16   {d10-d12}, [%5 :64] \n" // r34 r35 r36
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vshll.u16  q6, d12, #16        \n"

                        "vmla.f32   q14, q8, d2[0]      \n"
                        "vmla.f32   q15, q8, d6[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d2[1]      \n"
                        "vmla.f32   q13, q9, d6[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d3[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vmla.f32   q13, q11, d7[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d4[0]     \n"
                        "vmla.f32   q15, q10, d8[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d4[1]     \n"
                        "vmla.f32   q13, q11, d8[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d5[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vmla.f32   q13, q9, d9[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d6[0]      \n"
                        "vmla.f32   q15, q8, d10[0]     \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d6[1]      \n"
                        "vmla.f32   q13, q9, d10[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d7[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d11[0]    \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "vmla.f32   q13, q11, d11[1]    \n"
                        "pld        [%6, #256]          \n"
                        "vld1.u16   {d4-d7}, [%6 :64]!  \n" // r40 r41 r42 r43
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q0, d4, #16         \n"
                        "vshll.u16  q1, d5, #16         \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"

                        "vmla.f32   q14, q10, d8[0]     \n"
                        "vmla.f32   q15, q10, d12[0]    \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d8[1]     \n"
                        "vmla.f32   q13, q11, d12[1]    \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d9[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d13[0]     \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vmla.f32   q13, q9, d13[1]     \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d0[0]      \n"
                        "vmla.f32   q15, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d0[1]      \n"
                        "vmla.f32   q13, q9, d4[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d1[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "vmla.f32   q13, q11, d5[1]     \n"
                        "pld        [%6, #192]          \n"
                        "vld1.u16   {d10-d12}, [%6 :64] \n" // r44 r45 r46
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q4, d10, #16        \n"
                        "vshll.u16  q5, d11, #16        \n"
                        "vshll.u16  q6, d12, #16        \n"

                        "vmla.f32   q14, q10, d2[0]     \n"
                        "vmla.f32   q15, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d2[1]     \n"
                        "vmla.f32   q13, q11, d6[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vmla.f32   q14, q8, d3[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vmla.f32   q13, q9, d7[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d4[0]      \n"
                        "vmla.f32   q15, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d4[1]      \n"
                        "vmla.f32   q13, q9, d8[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"

                        "vmla.f32   q14, q10, d5[0]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vmla.f32   q13, q11, d9[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q14, q10, d6[0]     \n"
                        "vmla.f32   q15, q10, d10[0]    \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q12, q11, d6[1]     \n"
                        "vmla.f32   q13, q11, d10[1]    \n"
                        //                         "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128] \n"

                        "vmla.f32   q14, q8, d7[0]      \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d11[0]     \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vmla.f32   q13, q9, d11[1]     \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q14, q8, d8[0]      \n"
                        "vmla.f32   q15, q8, d12[0]     \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q12, q9, d8[1]      \n"
                        "vmla.f32   q13, q9, d12[1]     \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q14, q10, d9[0]     \n"
                        "vmla.f32   q15, q10, d13[0]    \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vmla.f32   q13, q11, d13[1]    \n"

                        "vadd.f32   q12, q12, q14       \n"
                        "vadd.f32   q13, q13, q15       \n"

                        "sub        %7, %7, #768        \n" // kptr -= 24 * 16;

                        "vshrn.u32  d24, q12, #16       \n"
                        "vshrn.u32  d25, q13, #16       \n"

                        "vst1.u16   {d24-d25}, [%0 :64]! \n"

                        : "=r"(outptr0_bf16), // %0
                        "=r"(outptr0),      // %1
                        "=r"(r0),           // %2
                        "=r"(r1),           // %3
                        "=r"(r2),           // %4
                        "=r"(r3),           // %5
                        "=r"(r4),           // %6
                        "=r"(kptr)          // %7
                        : "0"(outptr0_bf16),
                        "1"(outptr0),
                        "2"(r0),
                        "3"(r1),
                        "4"(r2),
                        "5"(r3),
                        "6"(r4),
                        "7"(kptr)
                        : "memory", "q0", "q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12", "q13", "q14", "q15");
#endif // __aarch64__
                }
                for (; j < outw; j++)
                {
#if __aarch64__
                    asm volatile(
                        "prfm   pldl1keep, [%1, #128]       \n"
                        "ld1    {v20.4s}, [%1], #16         \n" // sum0

                        "prfm   pldl1keep, [%2, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%2], #16   \n" // r00 r01

                        "shll   v0.4s, v0.4h, #16           \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v1.4s, v1.4h, #16           \n"

                        "shll   v16.4s, v16.4h, #16         \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmul   v21.4s, v16.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmul   v22.4s, v17.4s, v0.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmul   v23.4s, v18.4s, v0.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%2, #192]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h}, [%2] \n" // r02 r03 r04
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"

                        "fmla   v21.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v1.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v1.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v2.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%3, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%3], #16   \n" // r10 r11
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"

                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v21.4s, v24.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v0.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v0.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%3, #192]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h}, [%3] \n" // r12 r13 r14
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"

                        "fmla   v21.4s, v16.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v1.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v1.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v21.4s, v24.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v2.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v2.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v3.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%4, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%4], #16   \n" // r20 r21
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"

                        "fmla   v21.4s, v24.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v4.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v0.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v0.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%4, #192]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h}, [%4] \n" // r22 r23 r24
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"

                        "fmla   v21.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v1.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v1.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v2.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%5, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%5], #16   \n" // r30 r31
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"

                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v21.4s, v24.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v0.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v0.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%5, #192]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h}, [%5] \n" // r32 r33 r34
                        "shll   v17.4s, v17.4h, #16         \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"

                        "fmla   v21.4s, v16.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v1.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v1.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v1.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v21.4s, v24.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v2.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v2.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v2.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v3.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v3.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v3.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v3.s[3]     \n"
                        "prfm   pldl1keep, [%6, #128]       \n"
                        "ld1    {v0.4h, v1.4h}, [%6], #16   \n" // r40 r41
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v0.4s, v0.4h, #16           \n"
                        "shll   v1.4s, v1.4h, #16           \n"

                        "fmla   v21.4s, v24.4s, v4.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v4.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v4.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v4.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v0.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v0.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v0.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v0.s[3]     \n"
                        "prfm   pldl1keep, [%6, #192]       \n"
                        "ld1    {v2.4h, v3.4h, v4.4h}, [%6] \n" // r42 r43 r44
                        "shll   v25.4s, v25.4h, #16         \n"
                        "shll   v2.4s, v2.4h, #16           \n"
                        "shll   v3.4s, v3.4h, #16           \n"
                        "shll   v4.4s, v4.4h, #16           \n"

                        "fmla   v21.4s, v24.4s, v1.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7], #32 \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v1.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v1.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v1.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v2.s[0]     \n"
                        "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v24.4h, v25.4h, v26.4h, v27.4h}, [%7], #32 \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v2.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v2.s[2]     \n"
                        "shll   v24.4s, v24.4h, #16         \n"
                        "fmla   v20.4s, v19.4s, v2.s[3]     \n"
                        "shll   v25.4s, v25.4h, #16         \n"

                        "fmla   v21.4s, v24.4s, v3.s[0]     \n"
                        //                         "prfm   pldl1keep, [%7, #256]       \n"
                        "ld1    {v16.4h, v17.4h, v18.4h, v19.4h}, [%7] \n"
                        "shll   v26.4s, v26.4h, #16         \n"
                        "fmla   v22.4s, v25.4s, v3.s[1]     \n"
                        "shll   v27.4s, v27.4h, #16         \n"
                        "fmla   v23.4s, v26.4s, v3.s[2]     \n"
                        "shll   v16.4s, v16.4h, #16         \n"
                        "fmla   v20.4s, v27.4s, v3.s[3]     \n"
                        "shll   v17.4s, v17.4h, #16         \n"

                        "fmla   v21.4s, v16.4s, v4.s[0]     \n"
                        "shll   v18.4s, v18.4h, #16         \n"
                        "fmla   v22.4s, v17.4s, v4.s[1]     \n"
                        "shll   v19.4s, v19.4h, #16         \n"
                        "fmla   v23.4s, v18.4s, v4.s[2]     \n"
                        "fmla   v20.4s, v19.4s, v4.s[3]     \n"

                        "fadd   v22.4s, v21.4s, v22.4s      \n"
                        "fadd   v23.4s, v22.4s, v23.4s      \n"
                        "fadd   v20.4s, v20.4s, v23.4s      \n"

                        "sub    %7, %7, #768                \n" // kptr -= 24 * 16;

                        "shrn   v20.4h, v20.4s, #16         \n"

                        "st1    {v20.4h}, [%0], #8          \n"

                        : "=r"(outptr0_bf16), // %0
                        "=r"(outptr0),      // %1
                        "=r"(r0),           // %2
                        "=r"(r1),           // %3
                        "=r"(r2),           // %4
                        "=r"(r3),           // %5
                        "=r"(r4),           // %6
                        "=r"(kptr)          // %7
                        : "0"(outptr0_bf16),
                        "1"(outptr0),
                        "2"(r0),
                        "3"(r1),
                        "4"(r2),
                        "5"(r3),
                        "6"(r4),
                        "7"(kptr)
                        : "memory", "v0", "v1", "v2", "v3", "v4", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27");
#else  // __aarch64__
                    asm volatile(
                        "pld        [%2, #128]          \n"
                        "vld1.u16   {d2-d3}, [%2 :64]!  \n" // r00 r01

                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"

                        "vshll.u16  q0, d2, #16         \n"
                        "vshll.u16  q1, d3, #16         \n"

                        "vshll.u16  q8, d20, #16        \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "pld        [%1, #128]          \n"
                        "vld1.f32   {d24-d25}, [%1 :128]! \n" // sum0

                        "vmul.f32   q13, q8, d0[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmul.f32   q14, q9, d0[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmul.f32   q15, q10, d1[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "pld        [%2, #192]          \n"
                        "vld1.u16   {d6-d8}, [%2 :64]   \n" // r02 r03 r04
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"
                        "vshll.u16  q4, d8, #16         \n"

                        "vmla.f32   q13, q10, d2[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d2[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d4[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d6[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "pld        [%3, #128]          \n"
                        "vld1.u16   {d2-d3}, [%3 :64]!  \n" // r10 r11
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q0, d2, #16         \n"
                        "vshll.u16  q1, d3, #16         \n"

                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d0[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d0[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d1[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "pld        [%3, #192]          \n"
                        "vld1.u16   {d6-d8}, [%3 :64]   \n" // r12 r13 r14
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"
                        "vshll.u16  q4, d8, #16         \n"

                        "vmla.f32   q13, q8, d2[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d2[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d3[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d4[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d4[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d6[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d6[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "pld        [%4, #128]          \n"
                        "vld1.u16   {d2-d3}, [%4 :64]!  \n" // r20 r21
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q0, d2, #16         \n"
                        "vshll.u16  q1, d3, #16         \n"

                        "vmla.f32   q13, q10, d8[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d8[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d0[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d0[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d1[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "pld        [%4, #192]          \n"
                        "vld1.u16   {d6-d8}, [%4 :64]   \n" // r22 r23 r24
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"
                        "vshll.u16  q4, d8, #16         \n"

                        "vmla.f32   q13, q10, d2[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d2[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d4[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d6[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "pld        [%5, #128]          \n"
                        "vld1.u16   {d2-d3}, [%5 :64]!  \n" // r30 r31
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q0, d2, #16         \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vshll.u16  q1, d3, #16         \n"

                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d9[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d0[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d0[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d1[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d1[1]      \n"
                        "pld        [%5, #192]          \n"
                        "vld1.u16   {d6-d8}, [%5 :64]   \n" // r32 r33 r34
                        "vshll.u16  q9, d21, #16        \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"
                        "vshll.u16  q4, d8, #16         \n"

                        "vmla.f32   q13, q8, d2[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d2[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d3[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d3[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d4[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d4[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d5[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d5[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d6[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d6[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d7[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d7[1]     \n"
                        "pld        [%6, #128]          \n"
                        "vld1.u16   {d2-d3}, [%6 :64]!  \n" // r40 r41
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q0, d2, #16         \n"
                        "vshll.u16  q1, d3, #16         \n"

                        "vmla.f32   q13, q10, d8[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d8[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d9[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d9[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d0[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d0[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d1[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d1[1]     \n"
                        "pld        [%6, #192]          \n"
                        "vld1.u16   {d6-d8}, [%6 :64]   \n" // r42 r43 r44
                        "vshll.u16  q11, d17, #16       \n"
                        "vshll.u16  q2, d6, #16         \n"
                        "vshll.u16  q3, d7, #16         \n"
                        "vshll.u16  q4, d8, #16         \n"

                        "vmla.f32   q13, q10, d2[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d2[1]     \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128]! \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d3[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d3[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d4[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d4[1]      \n"
                        "pld        [%7, #256]          \n"
                        "vld1.u16   {d16-d19}, [%7 :128]! \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d5[0]     \n"
                        "vshll.u16  q10, d16, #16       \n"
                        "vmla.f32   q12, q11, d5[1]     \n"
                        "vshll.u16  q11, d17, #16       \n"

                        "vmla.f32   q13, q10, d6[0]     \n"
                        "vshll.u16  q8, d18, #16        \n"
                        "vmla.f32   q14, q11, d6[1]     \n"
                        //                         "pld        [%7, #256]          \n"
                        "vld1.u16   {d20-d23}, [%7 :128] \n"
                        "vshll.u16  q9, d19, #16        \n"
                        "vmla.f32   q15, q8, d7[0]      \n"
                        "vshll.u16  q8, d20, #16        \n"
                        "vmla.f32   q12, q9, d7[1]      \n"
                        "vshll.u16  q9, d21, #16        \n"

                        "vmla.f32   q13, q8, d8[0]      \n"
                        "vshll.u16  q10, d22, #16       \n"
                        "vmla.f32   q14, q9, d8[1]      \n"
                        "vshll.u16  q11, d23, #16       \n"
                        "vmla.f32   q15, q10, d9[0]     \n"
                        "vmla.f32   q12, q11, d9[1]     \n"

                        "vadd.f32   q14, q13, q14       \n"
                        "vadd.f32   q15, q14, q15       \n"
                        "vadd.f32   q12, q12, q15       \n"

                        "sub        %7, %7, #768        \n" // kptr -= 24 * 16;

                        "vshrn.u32  d24, q12, #16       \n"

                        "vst1.u16   {d24}, [%0 :64]!    \n"

                        : "=r"(outptr0_bf16), // %0
                        "=r"(outptr0),      // %1
                        "=r"(r0),           // %2
                        "=r"(r1),           // %3
                        "=r"(r2),           // %4
                        "=r"(r3),           // %5
                        "=r"(r4),           // %6
                        "=r"(kptr)          // %7
                        : "0"(outptr0_bf16),
                        "1"(outptr0),
                        "2"(r0),
                        "3"(r1),
                        "4"(r2),
                        "5"(r3),
                        "6"(r4),
                        "7"(kptr)
                        : "memory", "q0", "q1", "q2", "q3", "q4", "q5", "q6", "q7", "q8", "q9", "q10", "q11", "q12", "q13", "q14", "q15");
#endif // __aarch64__
                }

                r0 += tailstep;
                r1 += tailstep;
                r2 += tailstep;
                r3 += tailstep;
                r4 += tailstep;
            }
        }
    }
}
