/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.karaf.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.karaf.log.core.Level;
import org.apache.karaf.log.core.LogService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.karaf.internal.LoggerBean;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="logging")
@RolesAllowed(value={"administrator"})
@SecurityRequirement(name="oauth2", scopes={"admin"})
@Tag(name="logging")
@Component
@JaxrsResource
@JaxrsName(value="logging")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class LoggerResource
implements RESTResource {
    public static final String PATH_LOGGING = "logging";
    private static final Set<String> LOG_LEVELS = Set.of(Level.strings());
    private static final Pattern BUNDLE_REGEX = Pattern.compile("\\w[\\w. -]*");
    private final LogService logService;

    @Activate
    public LoggerResource(@Reference LogService logService) {
        this.logService = logService;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @Operation(operationId="getLogger", summary="Get all loggers", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoggerBean.class))})})
    public Response getLoggers(@Context UriInfo uriInfo) {
        LoggerBean bean = new LoggerBean(this.logService.getLevel("ALL"));
        return Response.ok((Object)bean).build();
    }

    @PUT
    @Path(value="/{loggerName: \\w(%20|[\\w.-])*}")
    @Consumes(value={"application/json"})
    @Operation(operationId="putLogger", summary="Modify or add logger", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Payload is invalid.")})
    public Response putLoggers(@PathParam(value="loggerName") @Parameter(description="logger name") String loggerName, @Parameter(description="logger", required=true) @Nullable LoggerBean.LoggerInfo logger, @Context UriInfo uriInfo) {
        if (!(logger != null && BUNDLE_REGEX.matcher(logger.loggerName).matches() && LOG_LEVELS.contains(logger.level) && logger.loggerName.equals(loggerName))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.logService.setLevel(logger.loggerName, logger.level);
        return Response.ok(null, (String)"text/plain").build();
    }

    @GET
    @Path(value="/{loggerName: \\w(%20|[\\w.-])*}")
    @Produces(value={"application/json"})
    @Operation(operationId="getLogger", summary="Get a single logger.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoggerBean.LoggerInfo.class))})})
    public Response getLogger(@PathParam(value="loggerName") @Parameter(description="logger name") String loggerName, @Context UriInfo uriInfo) {
        LoggerBean bean = new LoggerBean(this.logService.getLevel(loggerName));
        return Response.ok((Object)bean).build();
    }

    @DELETE
    @Path(value="/{loggerName: \\w(%20|[\\w.-])*}")
    @Operation(operationId="removeLogger", summary="Remove a single logger.", responses={@ApiResponse(responseCode="200", description="OK")})
    public Response removeLogger(@PathParam(value="loggerName") @Parameter(description="logger name") String loggerName, @Context UriInfo uriInfo) {
        this.logService.setLevel(loggerName, "DEFAULT");
        return Response.ok(null, (String)"text/plain").build();
    }
}

