/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SubstitutedFileType
extends LanguageFileType {
    @NotNull
    private final FileType myOriginalFileType;
    @NotNull
    private final FileType myFileType;

    private SubstitutedFileType(@NotNull FileType originalFileType, @NotNull LanguageFileType substitutionFileType, @NotNull Language substitutedLanguage) {
        if (originalFileType == null) {
            SubstitutedFileType.$$$reportNull$$$0(0);
        }
        if (substitutionFileType == null) {
            SubstitutedFileType.$$$reportNull$$$0(1);
        }
        if (substitutedLanguage == null) {
            SubstitutedFileType.$$$reportNull$$$0(2);
        }
        super(substitutedLanguage);
        this.myOriginalFileType = originalFileType;
        this.myFileType = substitutionFileType;
    }

    @NotNull
    public static FileType substituteFileType(@NotNull VirtualFile file, @NotNull FileType fileType, @Nullable Project project) {
        if (file == null) {
            SubstitutedFileType.$$$reportNull$$$0(3);
        }
        if (fileType == null) {
            SubstitutedFileType.$$$reportNull$$$0(4);
        }
        if (project == null) {
            FileType fileType2 = fileType;
            if (fileType2 == null) {
                SubstitutedFileType.$$$reportNull$$$0(5);
            }
            return fileType2;
        }
        if (fileType instanceof LanguageFileType) {
            LanguageFileType substFileType;
            Language substLang = LanguageUtil.getLanguageForPsi(project, file, fileType);
            LanguageFileType languageFileType = substFileType = substLang != null && substLang != ((LanguageFileType)fileType).getLanguage() ? substLang.getAssociatedFileType() : null;
            if (substFileType != null) {
                return new SubstitutedFileType(fileType, substFileType, substLang);
            }
        }
        FileType fileType3 = fileType;
        if (fileType3 == null) {
            SubstitutedFileType.$$$reportNull$$$0(6);
        }
        return fileType3;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myFileType.getName();
        if (string == null) {
            SubstitutedFileType.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.myFileType.getDescription();
        if (string == null) {
            SubstitutedFileType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDefaultExtension() {
        String string = this.myFileType.getDefaultExtension();
        if (string == null) {
            SubstitutedFileType.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public Icon getIcon() {
        return this.myFileType.getIcon();
    }

    @Override
    public String getCharset(@NotNull VirtualFile file, byte @NotNull [] content) {
        if (file == null) {
            SubstitutedFileType.$$$reportNull$$$0(10);
        }
        if (content == null) {
            SubstitutedFileType.$$$reportNull$$$0(11);
        }
        return this.myFileType.getCharset(file, content);
    }

    @NotNull
    public FileType getOriginalFileType() {
        FileType fileType = this.myOriginalFileType;
        if (fileType == null) {
            SubstitutedFileType.$$$reportNull$$$0(12);
        }
        return fileType;
    }

    public String toString() {
        return "SubstitutedFileType: original=" + this.myOriginalFileType + "; substituted=" + this.myFileType;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SubstitutedFileType type = (SubstitutedFileType)o2;
        if (!this.myOriginalFileType.equals(type.myOriginalFileType)) {
            return false;
        }
        return this.myFileType.equals(type.myFileType);
    }

    public int hashCode() {
        int result2 = this.myOriginalFileType.hashCode();
        result2 = 31 * result2 + this.myFileType.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutionFileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutedLanguage";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/SubstitutedFileType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/SubstitutedFileType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteFileType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExtension";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalFileType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "substituteFileType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCharset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

