import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["analyticsId", "analyticsData"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
import React, { Component } from 'react';
import PropTypes from 'prop-types';
/**
 * The withAnalytics HOC wraps a component and provides the `fireAnalyticsEvent`
 * and `firePrivateAnalyticsEvent` methods to it as props. It contains the logic
 * for how to fire events, including handling the analyticsId and analyticsData
 * props. The `map` argument may be an object or a function that returns an object.
 * The properties of the `map` object/result can be strings (the name of the event
 * that will be fired) or functions (which are responsible for firing the event).
 * You can specify a default `analyticsId` and `analyticsData` with the `defaultProps`
 * param. Please be aware that specifying a default `analyticsId` will cause public
 * events to always fire for your component unless it has been set to a falsy by
 * the component consumer.
 *
 * @param WrappedComponent
 * @param map
 * @param defaultProps
 * @param withDelegation
 */
var withAnalytics = function withAnalytics(WrappedComponent) {
  var _WithAnalytics;
  var map = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var defaultProps = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var withDelegation = arguments.length > 3 ? arguments[3] : undefined;
  return _WithAnalytics = /*#__PURE__*/function (_Component) {
    function WithAnalytics(props) {
      var _this;
      _classCallCheck(this, WithAnalytics);
      _this = _callSuper(this, WithAnalytics, [props]);
      _defineProperty(_this, "delegateAnalyticsEvent", function (analyticsId, data, isPrivate) {
        var _ref = _this.context,
          onAnalyticsEvent = _ref.onAnalyticsEvent;
        if (!onAnalyticsEvent) {
          return;
        }
        onAnalyticsEvent(analyticsId, data, isPrivate);
      });
      _defineProperty(_this, "fireAnalyticsEvent", function (name, data) {
        var _this$props = _this.props,
          analyticsData = _this$props.analyticsData,
          analyticsId = _this$props.analyticsId;
        var _ref2 = _this.context,
          onAnalyticsEvent = _ref2.onAnalyticsEvent;
        if (!analyticsId || !onAnalyticsEvent) {
          return;
        }
        var eventData = _objectSpread(_objectSpread({}, analyticsData), data);
        onAnalyticsEvent("".concat(analyticsId, ".").concat(name), eventData, false);
      });
      _defineProperty(_this, "privateAnalyticsEvent", function (name, data) {
        var _ref3 = _this.context,
          onAnalyticsEvent = _ref3.onAnalyticsEvent;
        if (!onAnalyticsEvent) {
          return;
        }
        onAnalyticsEvent("".concat(name), data, true);
      });
      _defineProperty(_this, "getParentAnalyticsData", function (name) {
        var _ref4 = _this.context,
          getParentAnalyticsData = _ref4.getParentAnalyticsData;
        var parentData = {};
        if (typeof getParentAnalyticsData === 'function' && _this.props.analyticsId) {
          var analyticsId = _this.props.analyticsId;
          parentData = getParentAnalyticsData("".concat(analyticsId, ".").concat(name), false);
        }
        return parentData;
      });
      _this.state = {
        evaluatedMap: {}
      };
      return _this;
    }
    _inherits(WithAnalytics, _Component);
    return _createClass(WithAnalytics, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.setState({
          evaluatedMap: typeof map === 'function' ? map(this.fireAnalyticsEvent) : map
        });
      }
    }, {
      key: "render",
      value: function render() {
        var _this2 = this;
        var _this$props2 = this.props,
          analyticsId = _this$props2.analyticsId,
          analyticsData = _this$props2.analyticsData,
          componentProps = _objectWithoutProperties(_this$props2, _excluded);
        Object.keys(this.state.evaluatedMap).forEach(function (prop) {
          var handler = _this2.state.evaluatedMap[prop];
          var originalProp = componentProps[prop];
          componentProps[prop] = function () {
            if (typeof handler === 'function') {
              handler.apply(void 0, arguments);
            } else {
              _this2.fireAnalyticsEvent(handler);
            }
            if (typeof originalProp === 'function') {
              originalProp.apply(void 0, arguments);
            }
          };
        });
        return /*#__PURE__*/React.createElement(WrappedComponent, _extends({
          fireAnalyticsEvent: this.fireAnalyticsEvent,
          firePrivateAnalyticsEvent: this.privateAnalyticsEvent,
          getParentAnalyticsData: this.getParentAnalyticsData,
          delegateAnalyticsEvent: withDelegation ? this.delegateAnalyticsEvent : undefined,
          analyticsId: analyticsId,
          ref: this.props.innerRef
        }, componentProps));
      }
    }]);
  }(Component), _defineProperty(_WithAnalytics, "displayName", "WithAnalytics(".concat(WrappedComponent.displayName || WrappedComponent.name, ")")), _defineProperty(_WithAnalytics, "contextTypes", {
    onAnalyticsEvent: PropTypes.func,
    getParentAnalyticsData: PropTypes.func
  }), _defineProperty(_WithAnalytics, "defaultProps", {
    analyticsId: defaultProps.analyticsId,
    analyticsData: defaultProps.analyticsData
  }), _WithAnalytics;
};
export default withAnalytics;