/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import { forwardRef, memo } from 'react';

// eslint-disable-next-line @atlaskit/ui-styling-standard/use-compiled -- Ignored via go/DSP-18766
import { jsx } from '@emotion/react';
import { xcss } from '../xcss/xcss';
import Flex from './flex';
const flexGrowMap = {
  hug: xcss({
    flexGrow: 0
  }),
  fill: xcss({
    width: '100%',
    flexGrow: 1
  })
};

/**
 * __Stack__
 *
 * Stack is a primitive component based on flexbox that manages the block layout of direct children.
 *
 * @example
 * ```tsx
 *  <Stack>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *  </Stack>
 * ```
 *
 */
const Stack = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(({
  as,
  alignInline: alignItems,
  alignBlock = 'stretch',
  spread,
  grow,
  space,
  children,
  testId,
  xcss,
  role
}, ref) => {
  const justifyContent = spread || alignBlock;

  // We're type coercing this as Compiled styles in an array isn't supported by the types
  // But the runtime accepts it none-the-wiser. We can remove this entire block and replace
  // it with cx(defaultStyles, focusRingStyles, xcssStyles) when we've moved away from Emotion.
  const styles = grow ? [flexGrowMap[grow], ...(Array.isArray(xcss) ? xcss : [xcss])] : xcss;
  return jsx(Flex, {
    as: as,
    role: role,
    gap: space,
    direction: "column",
    alignItems: alignItems,
    justifyContent: justifyContent
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    ,
    xcss: styles,
    testId: testId,
    ref: ref
  }, children);
}));
Stack.displayName = 'Stack';
export default Stack;