/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import { type ElementType, type ReactNode } from 'react';
import { type FlexProps } from './flex';
import type { AlignBlock, AlignInline, BasePrimitiveProps, Grow, Spread } from './types';
export type InlineProps<T extends ElementType = 'div'> = {
    /**
     * The DOM element to render as the Inline. Defaults to `div`.
     */
    as?: 'div' | 'span' | 'ul' | 'ol' | 'li' | 'dl';
    /**
     * Used to align children along the block axis (typically vertical).
     */
    alignBlock?: AlignBlock;
    /**
     * Used to align children along the inline axis (typically horizontal).
     */
    alignInline?: AlignInline;
    /**
     * Used to set whether children are forced onto one line or will wrap onto multiple lines.
     */
    shouldWrap?: boolean;
    /**
     * Used to distribute the children along the main axis.
     */
    spread?: Spread;
    /**
     * Used to set whether the container should grow to fill the available space.
     */
    grow?: Grow;
    /**
     * Represents the space between each child.
     */
    space?: FlexProps['gap'];
    /**
     * Represents the space between rows when content wraps.
     * Used to override the `space` value in between rows.
     */
    rowSpace?: FlexProps['rowGap'];
    /**
     * Renders a separator string between each child. Avoid using `separator="•"` when `as="ul" | "ol" | "dl"` to preserve proper list semantics.
     */
    separator?: ReactNode;
    /**
     * Elements to be rendered inside the Inline.
     */
    children: ReactNode;
    /**
     * Forwarded ref element.
     */
    ref?: React.ComponentPropsWithRef<T>['ref'];
} & BasePrimitiveProps;
/**
 * __Inline__
 *
 * Inline is a primitive component based on CSS Flexbox that manages the horizontal layout of direct children.
 *
 * @example
 * ```tsx
 *  <Inline>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *  </Inline>
 * ```
 *
 */
declare const Inline: import("react").MemoExoticComponent<import("react").ForwardRefExoticComponent<Omit<InlineProps<ElementType>, "ref"> & import("react").RefAttributes<any>>>;
export default Inline;
