/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderer.BaseInputControl;
import org.lobobrowser.util.gui.WrapperLayout;

class InputRadioControl
extends BaseInputControl {
    private final JRadioButton widget;
    private ButtonGroup buttonGroup;

    public InputRadioControl(HTMLBaseInputElement modelNode) {
        super(modelNode);
        this.setLayout(WrapperLayout.getInstance());
        JRadioButton radio = new JRadioButton();
        radio.setOpaque(false);
        this.widget = radio;
        HTMLElementImpl controlElement = this.controlElement;
        String name = controlElement.getAttribute("name");
        ButtonGroup prevGroup = this.buttonGroup;
        if (prevGroup != null) {
            prevGroup.remove(radio);
        }
        if (name != null) {
            String key = "cobra.radio.group." + name;
            ButtonGroup group = (ButtonGroup)controlElement.getDocumentItem(key);
            if (group == null) {
                group = new ButtonGroup();
                controlElement.setDocumentItem(key, group);
            }
            group.add(radio);
            this.buttonGroup = group;
        } else {
            this.buttonGroup = null;
        }
        radio.setSelected(controlElement.getAttributeAsBoolean("checked"));
        this.add(radio);
    }

    public void reset(int availWidth, int availHeight) {
        super.reset(availWidth, availHeight);
    }

    public void click() {
        this.widget.doClick();
    }

    public boolean getChecked() {
        return this.widget.isSelected();
    }

    public void setChecked(boolean checked) {
        this.widget.setSelected(checked);
    }

    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        this.widget.setEnabled(!disabled);
    }

    public void resetInput() {
        this.widget.setSelected(this.controlElement.getAttributeAsBoolean("checked"));
    }

    public String getValue() {
        return this.controlElement.getAttribute("value");
    }
}

