/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.paper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import pcgen.core.PaperInfo;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.rules.persistence.token.PostValidationToken;
import pcgen.util.Logging;

public class SortKeyToken
extends AbstractNonEmptyToken<PaperInfo>
implements CDOMPrimaryToken<PaperInfo>,
PostValidationToken<PaperInfo> {
    public String getTokenName() {
        return "SORTKEY";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, PaperInfo pi, String value) {
        pi.setSortKey(value);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PaperInfo pi) {
        String info = pi.getSortKey();
        if (info == null) {
            return null;
        }
        return new String[]{info};
    }

    public Class<PaperInfo> getTokenClass() {
        return PaperInfo.class;
    }

    public boolean process(LoadContext context, Collection<? extends PaperInfo> c) {
        List list;
        boolean returnValue = true;
        TreeMap<String, PaperInfo> keys = new TreeMap<String, PaperInfo>(String.CASE_INSENSITIVE_ORDER);
        for (PaperInfo paperInfo : c) {
            String keyName = paperInfo.getKeyName();
            if (keyName == null) {
                Logging.errorPrint((String)("PaperInfo: " + paperInfo.getDisplayName() + " requires a SortKey, but was null"), (LoadContext)context);
                returnValue = false;
                continue;
            }
            if (keys.put(keyName, paperInfo) == null) continue;
            Logging.errorPrint((String)("Found more than one PaperInfo with (case insensitive) Sort Key: " + keyName), (LoadContext)context);
            returnValue = false;
        }
        ArrayList coll = new ArrayList(keys.values());
        if (!coll.equals(list = context.getReferenceContext().getOrderSortedCDOMObjects(PaperInfo.class))) {
            Logging.errorPrint((String)"SORTKEY sorting in PaperInfo did not match file order", (LoadContext)context);
            returnValue = false;
        }
        return returnValue;
    }

    public Class<PaperInfo> getValidationTokenClass() {
        return PaperInfo.class;
    }

    public int getPriority() {
        return 0;
    }
}

