/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.content.ChangeProf;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.WeaponProf;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;

public class ChangeprofLst
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMPrimaryToken<CDOMObject> {
    private static final Class<WeaponProf> WEAPONPROF_CLASS = WeaponProf.class;

    public String getTokenName() {
        return "CHANGEPROF";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        StringTokenizer tok = new StringTokenizer(value, "|");
        ArrayList<ChangeProf> list = new ArrayList<ChangeProf>();
        while (tok.hasMoreTokens()) {
            ComplexParseResult cpr;
            ComplexParseResult cpr2;
            String tokText = tok.nextToken();
            int equalLoc = tokText.indexOf(61);
            if (equalLoc < 0) {
                cpr2 = new ComplexParseResult();
                cpr2.addErrorMessage("Improper " + this.getTokenName() + ": No = found. " + "Expect format to be <Prof>,<Prof>=<Prof Type>");
                cpr2.addErrorMessage("  Token was: " + tokText);
                cpr2.addErrorMessage("  Tag was: " + value);
                return cpr2;
            }
            if (equalLoc != tokText.lastIndexOf(61)) {
                cpr2 = new ComplexParseResult();
                cpr2.addErrorMessage("Improper " + this.getTokenName() + ": Two = found.  " + "Expect format to be <Prof>,<Prof>=<Prof Type>");
                cpr2.addErrorMessage("  Token was: " + tokText);
                cpr2.addErrorMessage("  Tag was: " + value);
                return cpr2;
            }
            String newType = tokText.substring(equalLoc + 1);
            if (newType.length() == 0) {
                cpr = new ComplexParseResult();
                cpr.addErrorMessage("Improper " + this.getTokenName() + ": Empty Result Type.  " + "Expect format to be <Prof>,<Prof>=<Prof Type>");
                cpr.addErrorMessage("  Token was: " + tokText);
                cpr.addErrorMessage("  Tag was: " + value);
                return cpr;
            }
            if (newType.indexOf(".") != -1) {
                cpr = new ComplexParseResult();
                cpr.addErrorMessage("Improper " + this.getTokenName() + ": Invalid (Compound) Result Type: cannot contain a period (.)  " + "Expect format to be <Prof>,<Prof>=<Prof Type>");
                cpr.addErrorMessage("  Token was: " + tokText);
                cpr.addErrorMessage("  Tag was: " + value);
                return cpr;
            }
            String[] val = new String[]{newType};
            CDOMGroupRef newTypeProf = context.getReferenceContext().getCDOMTypeReference(WEAPONPROF_CLASS, val);
            String profs = tokText.substring(0, equalLoc);
            if (profs.length() == 0) {
                ComplexParseResult cpr3 = new ComplexParseResult();
                cpr3.addErrorMessage("Improper " + this.getTokenName() + ": Empty Source Prof.  " + "Expect format to be <Prof>,<Prof>=<Prof Type>");
                cpr3.addErrorMessage("  Token was: " + tokText);
                cpr3.addErrorMessage("  Tag was: " + value);
                return cpr3;
            }
            StringTokenizer pTok = new StringTokenizer(profs, ",");
            while (pTok.hasMoreTokens()) {
                CDOMReference wp = TokenUtilities.getTypeOrPrimitive((LoadContext)context, WEAPONPROF_CLASS, (String)pTok.nextToken());
                list.add(new ChangeProf(wp, newTypeProf));
            }
        }
        for (ChangeProf cp : list) {
            context.getObjectContext().addToList(obj, ListKey.CHANGEPROF, (Object)cp);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes changes = context.getObjectContext().getListChanges(obj, ListKey.CHANGEPROF);
        Collection added = changes.getAdded();
        if (added == null || added.isEmpty()) {
            return null;
        }
        HashMapToList m = new HashMapToList();
        for (ChangeProf cp : added) {
            CDOMReference source = cp.getSource();
            CDOMGroupRef result = cp.getResult();
            m.addToListFor((Object)result, (Object)source);
        }
        TreeSet set = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
        TreeSet<String> returnSet = new TreeSet<String>();
        for (CDOMGroupRef result : m.getKeySet()) {
            StringBuilder sb = new StringBuilder();
            boolean needComma = false;
            set.clear();
            set.addAll(m.getListFor((Object)result));
            for (CDOMReference source : set) {
                if (needComma) {
                    sb.append(",");
                }
                needComma = true;
                String sourceLst = source.getLSTformat(false);
                if (sourceLst.startsWith("TYPE=")) {
                    sb.append("TYPE.");
                    sb.append(sourceLst.substring(5));
                    continue;
                }
                sb.append(sourceLst);
            }
            sb.append("=").append(result.getLSTformat(false).substring(5));
            returnSet.add(sb.toString());
        }
        return new String[]{StringUtil.join(returnSet, (String)"|")};
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

