/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import pcgen.base.lang.StringUtil;

public class FixedStringList
extends AbstractList<String>
implements List<String>,
RandomAccess {
    public static final Comparator<FixedStringList> CASE_SENSITIVE_ORDER = new Comparator<FixedStringList>(){

        @Override
        public int compare(FixedStringList fsl1, FixedStringList fsl2) {
            return FixedStringList.compare(fsl1, fsl2, StringUtil.CASE_SENSITIVE_ORDER);
        }
    };
    public static final Comparator<FixedStringList> CASE_INSENSITIVE_ORDER = new Comparator<FixedStringList>(){

        @Override
        public int compare(FixedStringList fsl1, FixedStringList fsl2) {
            return FixedStringList.compare(fsl1, fsl2, String.CASE_INSENSITIVE_ORDER);
        }
    };
    private final String[] array;

    public FixedStringList(int size) {
        this.array = new String[size];
    }

    public FixedStringList(Collection<String> collection) {
        this.array = collection.toArray(new String[collection.size()]);
    }

    public FixedStringList(String ... stringArray) {
        this.array = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.array, 0, stringArray.length);
    }

    @Override
    public boolean add(String element) {
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] != null) continue;
            this.array[i] = element;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> collection) {
        for (String string : collection) {
            if (this.add(string)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String remove(int index) {
        String old = this.array[index];
        this.array[index] = null;
        return old;
    }

    @Override
    public String set(int index, String element) {
        String old = this.array[index];
        this.array[index] = element;
        return old;
    }

    @Override
    public String get(int index) {
        return this.array[index];
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FixedStringList) {
            FixedStringList other = (FixedStringList)obj;
            return Arrays.deepEquals(this.array, other.array);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        if (this.array.length == 0) {
            return 0;
        }
        return this.array.length + 29 * (this.array[0] == null ? 0 : this.array[0].hashCode());
    }

    public boolean equalsIgnoreCase(FixedStringList fsl) {
        String[] otherArray = fsl.array;
        int thisArrayLength = this.array.length;
        if (otherArray.length != thisArrayLength) {
            return false;
        }
        for (int i = 0; i < thisArrayLength; ++i) {
            String element = this.array[i];
            if (!(element == null ? otherArray[i] != null : !element.equalsIgnoreCase(otherArray[i]))) continue;
            return false;
        }
        return true;
    }

    public static int compare(FixedStringList fsl1, FixedStringList fsl2, Comparator<String> comparator) {
        String[] thisArray = fsl1.array;
        int thisArrayLength = thisArray.length;
        String[] otherArray = fsl2.array;
        int otherArrayLength = otherArray.length;
        if (thisArrayLength < otherArrayLength) {
            return -1;
        }
        if (thisArrayLength > otherArrayLength) {
            return 1;
        }
        for (int i = 0; i < thisArrayLength; ++i) {
            String thisElement = thisArray[i];
            String otherElement = otherArray[i];
            if (thisElement == null) {
                if (otherElement == null) continue;
                return -1;
            }
            if (otherElement == null) {
                return 1;
            }
            int compare = comparator.compare(thisElement, otherElement);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

