/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.List;
import pcgen.cdom.content.ACControl;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.PlayerCharacterTrackingFacet;
import pcgen.cdom.facet.PrerequisiteFacet;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.io.exporttoken.BonusToken;
import pcgen.util.Logging;

public class ArmorClassFacet {
    private PrerequisiteFacet prerequisiteFacet;
    private PlayerCharacterTrackingFacet trackingFacet = FacetLibrary.getFacet(PlayerCharacterTrackingFacet.class);

    public int calcACOfType(CharID id, String type) {
        PlayerCharacter pc;
        List<ACControl> addList = SettingsHandler.getGame().getACTypeAddString(type);
        List<ACControl> removeList = SettingsHandler.getGame().getACTypeRemoveString(type);
        if (addList == null && removeList == null) {
            Logging.errorPrint("Invalid ACType: " + type);
            return 0;
        }
        int armorClass = 0;
        if (addList != null) {
            pc = this.trackingFacet.getPC(id);
            for (ACControl acc : addList) {
                if (!this.prerequisiteFacet.qualifies(id, acc, null)) continue;
                armorClass += Integer.parseInt(BonusToken.getBonusToken("BONUS.COMBAT.AC." + acc.getType(), pc));
            }
        }
        if (removeList != null) {
            pc = this.trackingFacet.getPC(id);
            for (ACControl acc : removeList) {
                if (!this.prerequisiteFacet.qualifies(id, acc, null)) continue;
                armorClass -= Integer.parseInt(BonusToken.getBonusToken("BONUS.COMBAT.AC." + acc.getType(), pc));
            }
        }
        return armorClass;
    }

    public void setPrerequisiteFacet(PrerequisiteFacet prerequisiteFacet) {
        this.prerequisiteFacet = prerequisiteFacet;
    }
}

