/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.math.BigDecimal;
import pcgen.base.math.OrderedPair;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ItemFacet;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.facet.base.AbstractItemFacet;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.cdom.facet.model.TemplateFacet;
import pcgen.core.PCTemplate;
import pcgen.core.Race;
import pcgen.output.publish.OutputDB;

public class FaceFacet
implements ItemFacet<CharID, OrderedPair> {
    private static final Integer ZERO = 0;
    private static final Integer FIVE = 5;
    private TemplateFacet templateFacet;
    private RaceFacet raceFacet;

    @Override
    public OrderedPair get(CharID id) {
        OrderedPair rf;
        Race aRace = (Race)((AbstractItemFacet)this.raceFacet).get(id);
        OrderedPair face = new OrderedPair((Number)FIVE, (Number)ZERO);
        if (aRace != null && (rf = this.getFace(aRace)) != null) {
            face = rf;
        }
        for (PCTemplate template : this.templateFacet.getSet(id)) {
            OrderedPair tf = this.getFace(template);
            if (tf == null) continue;
            face = tf;
        }
        return face;
    }

    private OrderedPair getFace(CDOMObject cdo) {
        BigDecimal width = cdo.get(ObjectKey.FACE_WIDTH);
        BigDecimal height = cdo.get(ObjectKey.FACE_HEIGHT);
        if (width == null && height == null) {
            return null;
        }
        return new OrderedPair((Number)width, (Number)height);
    }

    public void setTemplateFacet(TemplateFacet templateFacet) {
        this.templateFacet = templateFacet;
    }

    public void setRaceFacet(RaceFacet raceFacet) {
        this.raceFacet = raceFacet;
    }

    public void init() {
        OutputDB.register("face", this);
    }
}

