/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.event.EventListenerList;
import pcgen.base.lang.CaseInsensitiveString;
import pcgen.base.util.FixedStringList;
import pcgen.base.util.FormatManager;
import pcgen.base.util.HashMapToInstanceList;
import pcgen.base.util.Indirect;
import pcgen.base.util.KeyMap;
import pcgen.base.util.ObjectContainer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.content.RollMethod;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ManufacturableFactory;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.UnconstructedEvent;
import pcgen.cdom.reference.UnconstructedListener;
import pcgen.cdom.reference.UnconstructedValidator;
import pcgen.util.Logging;
import pcgen.util.StringPClassUtil;

public abstract class AbstractReferenceManufacturer<T extends Loadable>
implements ReferenceManufacturer<T> {
    private boolean isResolved = false;
    private final ManufacturableFactory<T> factory;
    private CDOMGroupRef<T> allRef;
    private final Map<FixedStringList, WeakReference<CDOMGroupRef<T>>> typeReferences = new TreeMap<FixedStringList, WeakReference<CDOMGroupRef<T>>>(FixedStringList.CASE_INSENSITIVE_ORDER);
    private final Map<String, WeakReference<CDOMSingleRef<T>>> referenced = new TreeMap<String, WeakReference<CDOMSingleRef<T>>>(String.CASE_INSENSITIVE_ORDER);
    private final KeyMap<T> active = new KeyMap();
    private final List<T> derivatives = new ArrayList<T>();
    private final HashMapToInstanceList<CaseInsensitiveString, T> duplicates = new HashMapToInstanceList();
    private final List<String> deferred = new ArrayList<String>();
    private final List<WeakReference<T>> manufactured = new ArrayList<WeakReference<T>>();
    private final transient EventListenerList listenerList = new EventListenerList();

    public AbstractReferenceManufacturer(ManufacturableFactory<T> fac) {
        if (fac == null) {
            throw new IllegalArgumentException("Factory for " + this.getClass().getName() + " cannot be null");
        }
        this.factory = fac;
    }

    @Override
    public CDOMGroupRef<T> getTypeReference(String ... types) {
        CDOMGroupRef trt;
        for (String type : types) {
            if (type == null || type.length() == 0) {
                throw new IllegalArgumentException("Attempt to acquire empty Type (the type String contains a null or empty element)");
            }
            if (type.indexOf(46) != -1) {
                throw new IllegalArgumentException("Cannot build Reference with type conaining a period: " + type);
            }
            if (type.indexOf(61) != -1) {
                throw new IllegalArgumentException("Cannot build Reference with type conaining an equals: " + type);
            }
            if (type.indexOf(44) != -1) {
                throw new IllegalArgumentException("Cannot build Reference with type conaining a comma: " + type);
            }
            if (type.indexOf(124) == -1) continue;
            throw new IllegalArgumentException("Cannot build Reference with type conaining a pipe: " + type);
        }
        Arrays.sort(types);
        FixedStringList typeList = new FixedStringList(types);
        WeakReference<CDOMGroupRef<T>> ref = this.typeReferences.get(typeList);
        if (ref != null && (trt = (CDOMGroupRef)ref.get()) != null) {
            return trt;
        }
        CDOMGroupRef cgr = this.factory.getTypeReference(types);
        this.typeReferences.put(typeList, new WeakReference(cgr));
        return cgr;
    }

    @Override
    public CDOMGroupRef<T> getAllReference() {
        if (this.allRef == null) {
            this.allRef = this.factory.getAllReference();
        }
        return this.allRef;
    }

    @Override
    public Class<T> getReferenceClass() {
        return this.factory.getReferenceClass();
    }

    @Override
    public boolean resolveReferences(UnconstructedValidator validator) {
        boolean resolutionSuccessful = this.resolvePrimitiveReferences(validator);
        resolutionSuccessful &= this.resolveGroupReferences();
        for (WeakReference<CDOMGroupRef<T>> ref : this.typeReferences.values()) {
            CDOMGroupRef trt = (CDOMGroupRef)ref.get();
            if (trt == null || trt.getObjectCount() != 0) continue;
            Logging.errorPrint("Error: No " + this.factory.getReferenceDescription() + " objects of " + trt.getLSTformat(false) + " were loaded but were referred to in the data");
            this.fireUnconstuctedEvent(trt);
            resolutionSuccessful = false;
        }
        this.isResolved = true;
        return resolutionSuccessful;
    }

    private boolean resolvePrimitiveReferences(UnconstructedValidator validator) {
        boolean resolutionSuccessful = true;
        for (Map.Entry<String, WeakReference<CDOMSingleRef<T>>> me1 : this.referenced.entrySet()) {
            CDOMSingleRef value = (CDOMSingleRef)me1.getValue().get();
            if (value == null) continue;
            resolutionSuccessful &= this.factory.resolve(this, me1.getKey(), value, validator);
        }
        return resolutionSuccessful;
    }

    private boolean resolveGroupReferences() {
        for (Loadable obj : this.getAllObjects()) {
            if (this.allRef != null) {
                this.allRef.addResolution(obj);
            }
            for (Map.Entry<FixedStringList, WeakReference<CDOMGroupRef<T>>> me : this.typeReferences.entrySet()) {
                CDOMGroupRef trt = (CDOMGroupRef)me.getValue().get();
                if (trt == null) continue;
                boolean typeOkay = true;
                for (String type : me.getKey()) {
                    if (obj.isType(type)) continue;
                    typeOkay = false;
                    break;
                }
                if (!typeOkay) continue;
                trt.addResolution(obj);
            }
        }
        if (this.allRef != null && this.allRef.getObjectCount() == 0) {
            Logging.errorPrint("Error: No " + this.factory.getReferenceDescription() + " objects were loaded but were referred to in the data");
            this.fireUnconstuctedEvent(this.allRef);
            return false;
        }
        return true;
    }

    @Override
    public void addObject(T item, String key) {
        if (!this.factory.isMember(item)) {
            throw new IllegalArgumentException("Attempted to register a " + item.getClass().getName() + " in " + this.factory.getReferenceDescription());
        }
        Loadable current = (Loadable)this.active.get((Object)key);
        if (current == null) {
            this.active.put(key, item);
        } else {
            this.duplicates.addToListFor((Object)new CaseInsensitiveString(key), item);
        }
    }

    @Override
    public T getActiveObject(String key) {
        return (T)((Loadable)this.active.get((Object)key));
    }

    @Override
    public T getObject(String key) {
        Loadable po = (Loadable)this.active.get((Object)key);
        if (po != null) {
            List list = this.duplicates.getListFor((Object)new CaseInsensitiveString(key));
            if (list != null && !list.isEmpty()) {
                Logging.errorPrint("Reference to Constructed " + this.factory.getReferenceDescription() + " " + key + " is ambiguous");
                StringBuilder sb = new StringBuilder(1000);
                sb.append("Locations: ");
                sb.append(po.getSourceURI());
                for (Loadable dupe : list) {
                    sb.append(", ");
                    sb.append(dupe.getSourceURI());
                }
                Logging.errorPrint(sb.toString());
            }
            return (T)po;
        }
        return null;
    }

    @Override
    public T constructObject(String key) {
        T obj = this.buildObject(key);
        this.addObject(obj, key);
        return obj;
    }

    @Override
    public T buildObject(String key) {
        if (key == null || key.equals("")) {
            throw new IllegalArgumentException("Cannot build empty name");
        }
        T obj = this.factory.newInstance();
        obj.setName(key);
        return obj;
    }

    @Override
    public void renameObject(String key, T item) {
        String oldKey = item.getKeyName();
        if (oldKey.equalsIgnoreCase(key) && Logging.isDebugMode()) {
            Logging.debugPrint("Worthless Key change encountered: " + item.getDisplayName() + " " + oldKey);
            Logging.reportSource(Logging.DEBUG, item.getSourceURI());
        }
        this.forgetObject(item);
        this.addObject(item, key);
    }

    @Override
    public boolean forgetObject(T item) {
        if (!this.factory.isMember(item)) {
            throw new IllegalArgumentException("Object to be forgotten does not match Class of this AbstractReferenceManufacturer");
        }
        String key = this.active.getKeyFor(item);
        if (key == null) {
            CaseInsensitiveString ocik = new CaseInsensitiveString(item.getKeyName());
            this.duplicates.removeFromListFor((Object)ocik, item);
        } else {
            CaseInsensitiveString ocik = new CaseInsensitiveString(key);
            List list = this.duplicates.getListFor((Object)ocik);
            if (list == null) {
                this.active.remove((Object)key);
            } else {
                Loadable newActive = (Loadable)this.duplicates.getElementInList((Object)ocik, 0);
                this.duplicates.removeFromListFor((Object)ocik, (Object)newActive);
                this.active.put(key, (Object)newActive);
            }
        }
        return true;
    }

    @Override
    public boolean containsObject(String key) {
        return this.active.containsKey((Object)key);
    }

    @Override
    public CDOMSingleRef<T> getReference(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Cannot request a reference to null identifier");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("Cannot request a reference to an empty identifier");
        }
        try {
            Integer.parseInt(key);
            throw new IllegalArgumentException("A number cannot be a valid single item: " + key);
        }
        catch (NumberFormatException nfe) {
            CDOMSingleRef ref;
            if (key.contains("=")) {
                throw new IllegalArgumentException("= cannot be a in valid single item (perhaps something like TYPE= is not supported in this token?): " + key);
            }
            if (key.equalsIgnoreCase("ANY")) {
                throw new IllegalArgumentException("Any cannot be a valid single item (not supported in this token?)");
            }
            if (key.equalsIgnoreCase("ALL")) {
                throw new IllegalArgumentException("All cannot be a valid single item (not supported in this token?)");
            }
            if (key.contains(":")) {
                throw new IllegalArgumentException(": cannot exist in a valid single item (did you try to use a PRE where it is not supported?) " + key);
            }
            if (key.equalsIgnoreCase("%LIST")) {
                throw new IllegalArgumentException("%LIST cannot be a valid single item (not supported in this token?)");
            }
            WeakReference<CDOMSingleRef<T>> wr = this.referenced.get(key);
            if (wr != null && (ref = (CDOMDirectSingleRef<Loadable>)wr.get()) != null) {
                return ref;
            }
            if (this.isResolved) {
                Loadable current = (Loadable)this.active.get((Object)key);
                if (current == null) {
                    throw new IllegalArgumentException(key + " is not valid post-resolution " + "because it was never constructed");
                }
                ref = CDOMDirectSingleRef.getRef(current);
            } else {
                CDOMSingleRef lr = this.factory.getReference(key);
                this.referenced.put(key, new WeakReference(lr));
                ref = lr;
            }
            return ref;
        }
    }

    @Override
    public boolean validate(UnconstructedValidator validator) {
        boolean returnGood = true;
        if (validator == null || !validator.allowDuplicates(this.getReferenceClass())) {
            returnGood = this.validateDuplicates();
        }
        returnGood &= this.validateNames();
        return returnGood &= this.validateActive();
    }

    private boolean validateNames() {
        if (!Logging.isLoggable(Logging.LST_WARNING)) {
            return true;
        }
        for (String key : this.active.keySet()) {
            Loadable value = (Loadable)this.active.get((Object)key);
            if (value.isInternal()) continue;
            if (key.indexOf(44) != -1 && this.factory.getReferenceClass() != RollMethod.class) {
                Logging.log(Logging.LST_WARNING, "Found " + this.factory.getReferenceDescription() + " with KEY: " + key + " which contains a comma " + "(prohibited character in a key)");
            }
            if (key.indexOf(124) != -1) {
                Logging.log(Logging.LST_WARNING, "Found " + this.factory.getReferenceDescription() + " with KEY: " + key + " which contains a pipe " + "(prohibited character in a key)");
            }
            if (key.indexOf(92) != -1) {
                Logging.log(Logging.LST_WARNING, "Found " + this.factory.getReferenceDescription() + " with KEY: " + key + " which contains a backslash " + "(prohibited character in a key)");
            }
            if (key.indexOf(58) != -1) {
                Logging.log(Logging.LST_WARNING, "Found " + this.factory.getReferenceDescription() + " with KEY: " + key + " which contains a colon " + "(prohibited character in a key)");
            }
            if (key.indexOf(59) != -1) {
                Logging.log(Logging.LST_WARNING, "Found " + this.factory.getReferenceDescription() + " with KEY: " + key + " which contains a semicolon " + "(prohibited character in a key)");
            }
            if (key.indexOf(37) != -1) {
                Logging.log(Logging.LST_WARNING, "Found " + this.factory.getReferenceDescription() + " with KEY: " + key + " which contains a percent sign " + "(prohibited character in a key)");
            }
            if (key.indexOf(42) != -1) {
                Logging.log(Logging.LST_WARNING, "Found " + this.factory.getReferenceDescription() + " with KEY: " + key + " which contains an asterisk " + "(prohibited character in a key)");
            }
            if (key.indexOf(61) != -1) {
                Logging.log(Logging.LST_WARNING, "Found " + this.factory.getReferenceDescription() + " with KEY: " + key + " which contains an equals sign " + "(prohibited character in a key)");
            }
            if (key.indexOf(91) == -1 && key.indexOf(93) == -1) continue;
            Logging.log(Logging.LST_WARNING, "Found " + this.factory.getReferenceDescription() + " with KEY: " + key + " which contains a bracket  " + "(prohibited character in a key)");
        }
        return true;
    }

    private boolean validateActive() {
        boolean returnGood = true;
        for (Object second : this.active.keySet()) {
            Loadable activeObj = (Loadable)this.active.get(second);
            String keyName = activeObj.getKeyName();
            if (keyName == null) {
                Logging.errorPrint(activeObj.getClass() + " " + activeObj.getDisplayName() + " has a null KeyName");
                continue;
            }
            if (keyName.equalsIgnoreCase(second.toString())) continue;
            Logging.errorPrint(this.getReferenceDescription() + " Magical Key Change: " + second + " to " + keyName);
            returnGood = false;
        }
        return returnGood;
    }

    private boolean validateDuplicates() {
        boolean returnGood = true;
        for (CaseInsensitiveString second : this.duplicates.getKeySet()) {
            List list = this.duplicates.getListFor((Object)second);
            Loadable good = (Loadable)this.active.get((Object)second.toString());
            if (good instanceof CDOMObject) {
                CDOMObject cdo = (CDOMObject)good;
                block1: for (int i = 0; i < list.size(); ++i) {
                    Loadable dupe = (Loadable)list.get(i);
                    if (!cdo.isCDOMEqual((CDOMObject)dupe)) continue;
                    Iterator<WeakReference<T>> it = this.manufactured.iterator();
                    while (it.hasNext()) {
                        WeakReference<T> wr = it.next();
                        Loadable mfg = (Loadable)wr.get();
                        if (mfg == null) {
                            it.remove();
                            continue;
                        }
                        if (mfg != good) continue;
                        this.forgetObject(good);
                        continue block1;
                    }
                }
            }
            if (!this.duplicates.containsListFor((Object)second)) continue;
            Logging.errorPrint("More than one " + this.factory.getReferenceDescription() + " with key/name " + good.getKeyName() + " was built");
            List dupes = this.duplicates.getListFor((Object)second);
            StringBuilder sb = new StringBuilder(1000);
            sb.append("Sources: ");
            sb.append(good.isInternal() ? "<internal>" : good.getSourceURI());
            for (Loadable dupe : dupes) {
                sb.append(", ").append(dupe.isInternal() ? "<internal>" : dupe.getSourceURI());
                if (dupe.getKeyName().equals(good.getKeyName())) continue;
                Logging.errorPrint("Key case differed for " + dupe.getKeyName());
            }
            Logging.errorPrint(sb.toString());
            returnGood = false;
        }
        return returnGood;
    }

    @Override
    public void constructIfNecessary(String key) {
        this.deferred.add(key);
    }

    @Override
    public Collection<T> getAllObjects() {
        return this.active.keySortedValues();
    }

    @Override
    public List<T> getOrderSortedObjects() {
        return this.active.insertOrderValues();
    }

    @Override
    public void buildDeferredObjects() {
        for (String cis : this.deferred) {
            if (this.active.containsKey((Object)cis)) continue;
            this.constructObject(cis);
        }
    }

    protected Collection<CDOMGroupRef<T>> getTypeReferences() {
        ArrayList<CDOMGroupRef<T>> list = new ArrayList<CDOMGroupRef<T>>(this.typeReferences.size());
        Iterator<WeakReference<CDOMGroupRef<T>>> it = this.typeReferences.values().iterator();
        while (it.hasNext()) {
            WeakReference<CDOMGroupRef<T>> wr = it.next();
            CDOMGroupRef trt = (CDOMGroupRef)wr.get();
            if (trt == null) {
                it.remove();
                continue;
            }
            list.add(trt);
        }
        return list;
    }

    @Override
    public Collection<CDOMSingleRef<T>> getReferenced() {
        ArrayList<CDOMSingleRef<T>> list = new ArrayList<CDOMSingleRef<T>>();
        for (WeakReference<CDOMSingleRef<T>> wr : this.referenced.values()) {
            CDOMSingleRef ref = (CDOMSingleRef)wr.get();
            if (ref == null) continue;
            list.add(ref);
        }
        return list;
    }

    @Override
    public void injectConstructed(ReferenceManufacturer<T> arm) {
        for (Loadable value : this.active.insertOrderValues()) {
            arm.addObject(value, this.active.getKeyFor((Object)value));
        }
        for (CaseInsensitiveString cis : this.duplicates.getKeySet()) {
            for (Loadable obj : this.duplicates.getListFor((Object)cis)) {
                arm.addObject(obj, cis.toString());
            }
        }
        for (String s : this.deferred) {
            arm.constructIfNecessary(s);
        }
    }

    @Override
    public T constructNowIfNecessary(String key) {
        Loadable obj = (Loadable)this.active.get((Object)key);
        if (obj == null) {
            obj = this.constructObject(key);
            this.manufactured.add(new WeakReference<Loadable>(obj));
        }
        return (T)obj;
    }

    @Override
    public void addUnconstructedListener(UnconstructedListener listener) {
        this.listenerList.add(UnconstructedListener.class, listener);
    }

    @Override
    public synchronized UnconstructedListener[] getUnconstructedListeners() {
        return (UnconstructedListener[])this.listenerList.getListeners(UnconstructedListener.class);
    }

    @Override
    public void removeUnconstructedListener(UnconstructedListener listener) {
        this.listenerList.remove(UnconstructedListener.class, listener);
    }

    @Override
    public void fireUnconstuctedEvent(CDOMReference<?> ref) {
        Object[] listeners = this.listenerList.getListenerList();
        UnconstructedEvent uEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != UnconstructedListener.class) continue;
            if (uEvent == null) {
                uEvent = new UnconstructedEvent(this, ref);
            }
            ((UnconstructedListener)listeners[i + 1]).unconstructedReferenceFound(uEvent);
        }
    }

    @Override
    public int getConstructedObjectCount() {
        return this.active.size();
    }

    @Override
    public T getItemInOrder(int index) {
        return (T)((Loadable)this.active.getItemInOrder(index));
    }

    @Override
    public ManufacturableFactory<T> getFactory() {
        return this.factory;
    }

    @Override
    public String getReferenceDescription() {
        return this.factory.getReferenceDescription();
    }

    @Override
    public Collection<CDOMReference<T>> getAllReferences() {
        ArrayList<CDOMReference<T>> list = new ArrayList<CDOMReference<T>>();
        if (this.allRef != null) {
            list.add(this.allRef);
        }
        list.addAll(this.getTypeReferences());
        list.addAll(this.getReferenced());
        return list;
    }

    @Override
    public void addDerivativeObject(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Derivative Object cannot be null");
        }
        this.derivatives.add(obj);
    }

    @Override
    public Collection<T> getDerivativeObjects() {
        return new ArrayList<T>(this.derivatives);
    }

    public T convert(String key) {
        return this.getActiveObject(key);
    }

    public Indirect<T> convertIndirect(String key) {
        return this.factory.getReference(key);
    }

    public ObjectContainer<T> convertObjectContainer(String typeStr) {
        if (typeStr.startsWith("TYPE=") || typeStr.startsWith("TYPE.")) {
            return this.factory.getTypeReference(typeStr.substring(5).split("\\."));
        }
        throw new IllegalArgumentException("ObjectContainer does not support: " + typeStr);
    }

    public String getIdentifierType() {
        return StringPClassUtil.getStringFor(this.getManagedClass());
    }

    public Class<T> getManagedClass() {
        return this.factory.getReferenceClass();
    }

    public String unconvert(T arg0) {
        return arg0.getKeyName();
    }

    public FormatManager<?> getComponentManager() {
        return null;
    }
}

