/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.ArrayList;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;

public class OutputNameFormatting {
    public static String parseOutputName(CDOMObject po, PlayerCharacter aPC) {
        return OutputNameFormatting.parseOutputName(OutputNameFormatting.getOutputName(po), aPC);
    }

    private static String parseOutputName(String aString, PlayerCharacter aPC) {
        int varIndex = aString.indexOf(124);
        if (varIndex <= 0) {
            return aString;
        }
        StringTokenizer varTokenizer = new StringTokenizer(aString, "|");
        String preVarStr = varTokenizer.nextToken();
        ArrayList<Float> varArray = new ArrayList<Float>();
        ArrayList<String> tokenList = new ArrayList<String>();
        while (varTokenizer.hasMoreElements()) {
            String token = varTokenizer.nextToken();
            tokenList.add(token.toUpperCase());
            varArray.add(aPC.getVariableValue(token, ""));
        }
        StringBuilder result = new StringBuilder(50);
        int varCount = 0;
        int subIndex = preVarStr.indexOf(37);
        int lastIndex = 0;
        while (subIndex >= 0) {
            if (subIndex > 0) {
                result.append(preVarStr.substring(lastIndex, subIndex));
            }
            String token = (String)tokenList.get(varCount);
            Float val = (Float)varArray.get(varCount);
            if (token.endsWith(".INTVAL")) {
                result.append(String.valueOf(val.intValue()));
            } else {
                result.append(val.toString());
            }
            lastIndex = subIndex + 1;
            ++varCount;
            subIndex = preVarStr.indexOf(37, lastIndex);
        }
        if (preVarStr.length() > lastIndex) {
            result.append(preVarStr.substring(lastIndex));
        }
        return result.toString();
    }

    public static String piString(CDOMObject po, boolean useHeader) {
        String aString = po.toString();
        if (SettingsHandler.guiUsesOutputNameEquipment()) {
            aString = OutputNameFormatting.getOutputName(po);
        }
        if (po.getSafe(ObjectKey.NAME_PI).booleanValue()) {
            StringBuilder sb = new StringBuilder(aString.length() + 30);
            if (useHeader) {
                sb.append("<html>");
            }
            sb.append("<b><i>").append(aString).append("</i></b>");
            if (useHeader) {
                sb.append("</html>");
            }
            return sb.toString();
        }
        return aString;
    }

    private static String getPreFormatedOutputName(String displayName) {
        if (displayName.indexOf(40) < 0 || displayName.indexOf(41) < 0) {
            return displayName;
        }
        String subName = displayName.substring(displayName.indexOf(40) + 1, displayName.lastIndexOf(41));
        StringTokenizer tok = new StringTokenizer(subName, "/");
        StringBuilder newNameBuff = new StringBuilder(subName.length());
        while (tok.hasMoreTokens()) {
            newNameBuff.insert(0, tok.nextToken());
            if (!tok.hasMoreTokens()) continue;
            newNameBuff.insert(0, " ");
        }
        return newNameBuff.toString();
    }

    public static final String getOutputName(CDOMObject po) {
        String outputName = po.get(StringKey.OUTPUT_NAME);
        String displayName = po.getDisplayName();
        if (outputName == null) {
            return displayName;
        }
        if (outputName.equalsIgnoreCase("[BASE]") && displayName.indexOf(40) != -1) {
            outputName = displayName.substring(0, displayName.indexOf(40)).trim();
        }
        if (outputName.indexOf("[NAME]") >= 0) {
            outputName = outputName.replaceAll("\\[NAME\\]", OutputNameFormatting.getPreFormatedOutputName(displayName));
        }
        return outputName;
    }
}

