/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.filter;

import java.util.ArrayList;
import java.util.List;
import pcgen.facade.util.AbstractListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.filter.Filter;

public class FilteredListFacade<C, E>
extends AbstractListFacade<E>
implements ListListener<E> {
    private List<E> data = new ArrayList();
    private ListFacade<E> delegate = null;
    private Filter<? super C, ? super E> filter = null;
    private C context = null;

    @Override
    public E getElementAt(int index) {
        return this.data.get(index);
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    public void setContext(C context) {
        C oldContext = this.context;
        this.context = context;
        if (oldContext != context) {
            this.refilter();
        }
    }

    public void setFilter(Filter<? super C, ? super E> filter) {
        Filter<? super C, ? super E> oldFilter = this.filter;
        this.filter = filter;
        if (oldFilter != filter) {
            this.refilter();
        }
    }

    public void setDelegate(ListFacade<E> list) {
        ListFacade<E> oldList = this.delegate;
        if (oldList != null) {
            oldList.removeListListener(this);
        }
        this.delegate = list;
        if (list != null) {
            list.addListListener(this);
        }
        this.refilter();
    }

    public void refilter() {
        this.data.clear();
        if (this.delegate != null) {
            ArrayList list = new ArrayList(this.delegate.getSize());
            for (Object element : this.delegate) {
                if (this.filter != null && !this.filter.accept(this.context, element)) continue;
                list.add(element);
            }
            this.data.addAll(list);
        }
        this.fireElementsChanged(this);
    }

    @Override
    public void elementAdded(ListEvent<E> e) {
        if (this.filter == null || this.filter.accept(this.context, e.getElement())) {
            int size = this.data.size();
            this.data.add(e.getElement());
            this.fireElementAdded(this, e.getElement(), size);
        }
    }

    @Override
    public void elementRemoved(ListEvent<E> e) {
        int index = this.data.indexOf(e.getElement());
        this.data.remove(e.getElement());
        this.fireElementRemoved(this, e.getElement(), index);
    }

    @Override
    public void elementsChanged(ListEvent<E> e) {
        this.refilter();
    }

    @Override
    public void elementModified(ListEvent<E> e) {
        if (this.data.contains(e.getElement())) {
            if (this.filter != null && !this.filter.accept(this.context, e.getElement())) {
                this.elementRemoved(e);
            }
        } else {
            this.elementAdded(e);
        }
    }
}

