/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs;

import javax.swing.JTabbedPane;
import pcgen.facade.core.CharacterFacade;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.EquipInfoTab;
import pcgen.gui2.tabs.PurchaseInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.TodoHandler;
import pcgen.system.LanguageBundle;
import pcgen.util.enumeration.Tab;

public class InventoryInfoTab
extends JTabbedPane
implements CharacterInfoTab,
TodoHandler {
    private final TabTitle tabTitle = new TabTitle(Tab.INVENTORY);
    private final EquipInfoTab equipTab = new EquipInfoTab();
    private final PurchaseInfoTab purchaseTab = new PurchaseInfoTab();

    public InventoryInfoTab() {
        this.addTab(LanguageBundle.getString("in_purchase"), this.purchaseTab);
        this.addTab(LanguageBundle.getString("in_equipment"), this.equipTab);
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(ModelHandler.class, new ModelHandler(character));
        return models;
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        models.get(ModelHandler.class).restoreModels();
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(ModelHandler.class).storeModels();
    }

    @Override
    public TabTitle getTabTitle() {
        return this.tabTitle;
    }

    @Override
    public void adviseTodo(String fieldName) {
    }

    private class ModelHandler {
        private final CharacterInfoTab.ModelMap equipModelMap;
        private final CharacterInfoTab.ModelMap purchaseModelMap;

        public ModelHandler(CharacterFacade character) {
            this.equipModelMap = InventoryInfoTab.this.equipTab.createModels(character);
            this.purchaseModelMap = InventoryInfoTab.this.purchaseTab.createModels(character);
        }

        public void restoreModels() {
            InventoryInfoTab.this.equipTab.restoreModels(this.equipModelMap);
            InventoryInfoTab.this.purchaseTab.restoreModels(this.purchaseModelMap);
        }

        public void storeModels() {
            InventoryInfoTab.this.equipTab.storeModels(this.equipModelMap);
            InventoryInfoTab.this.purchaseTab.storeModels(this.purchaseModelMap);
        }
    }
}

