/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.models;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pcgen.facade.util.ReferenceFacade;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;

public abstract class TextFieldHandler
implements DocumentListener,
ReferenceListener<String> {
    private JTextField textField;
    private ReferenceFacade<String> ref;

    public TextFieldHandler(JTextField textField, ReferenceFacade<String> ref) {
        this.textField = textField;
        this.ref = ref;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void install() {
        this.textField.setText(this.ref.getReference());
        this.textField.getDocument().addDocumentListener(this);
        this.ref.addReferenceListener(this);
    }

    public void uninstall() {
        this.textField.getDocument().removeDocumentListener(this);
        this.ref.removeReferenceListener(this);
    }

    @Override
    public void referenceChanged(ReferenceEvent<String> e) {
        if (!this.textField.getText().equals(e.getNewReference())) {
            this.textField.getDocument().removeDocumentListener(this);
            this.textField.setText(e.getNewReference());
            this.textField.getDocument().addDocumentListener(this);
        }
    }

    protected abstract void textChanged(String var1);

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.textChanged(this.textField.getText());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textChanged(this.textField.getText());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.textChanged(this.textField.getText());
    }
}

