/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tools;

import java.beans.PropertyChangeEvent;
import javax.swing.table.TableColumn;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.util.table.DefaultDynamicTableColumnModel;
import pcgen.system.PropertyContext;

public class PrefTableColumnModel
extends DefaultDynamicTableColumnModel {
    private final PropertyContext colWidthCtx;
    private final PropertyContext colVisibleCtx;

    public PrefTableColumnModel(String prefKey, int offset) {
        super(offset);
        UIPropertyContext baseContext = UIPropertyContext.createContext("tablePrefs");
        PropertyContext viewPrefsContext = ((PropertyContext)baseContext).createChildContext(prefKey);
        this.colWidthCtx = viewPrefsContext.createChildContext("width");
        this.colVisibleCtx = viewPrefsContext.createChildContext("visible");
    }

    private String normalisePrefsKey(String origKey) {
        return origKey.replaceAll("[^\\w\\.]", "_");
    }

    public void addColumn(TableColumn column, boolean defaultVisibility, int defaultWidth) {
        String prefsKey = this.normalisePrefsKey(column.getIdentifier().toString());
        int width = this.colWidthCtx.initInt(prefsKey, defaultWidth);
        boolean visibility = this.colVisibleCtx.getBoolean(prefsKey, defaultVisibility);
        column.setPreferredWidth(width);
        this.addColumn(column);
        this.setVisible(column, visibility);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String name = evt.getPropertyName();
        if ("width".equals(name)) {
            TableColumn col = (TableColumn)evt.getSource();
            String colKey = col.getIdentifier().toString();
            this.colWidthCtx.setInt(this.normalisePrefsKey(colKey), (Integer)evt.getNewValue());
        }
    }

    @Override
    public void setVisible(TableColumn column, boolean visible) {
        String colKey = column.getIdentifier().toString();
        this.colVisibleCtx.setBoolean(this.normalisePrefsKey(colKey), visible);
        super.setVisible(column, visible);
    }
}

