/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import pcgen.base.util.NamedValue;
import pcgen.core.Globals;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.AbstractExportToken;

public class MovementToken
extends AbstractExportToken {
    @Override
    public String getTokenName() {
        return "MOVEMENT";
    }

    @Override
    public String getToken(String tokenSource, CharacterDisplay display, ExportHandler eh) {
        String retString = "";
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        if (aTok.hasMoreTokens()) {
            String moveType = aTok.nextToken();
            retString = MovementToken.getMoveTypeToken(display, moveType);
        } else {
            retString = MovementToken.getMovementToken(display);
        }
        return retString;
    }

    public static String getMoveTypeToken(CharacterDisplay display, String moveType) {
        String retString = "";
        if (display.hasMovement(moveType)) {
            retString = MovementToken.getRateToken(display.getMovementOfType(moveType));
        }
        return retString;
    }

    public static String getMovementToken(CharacterDisplay display) {
        StringBuilder retString = new StringBuilder();
        boolean firstLine = true;
        for (NamedValue move : display.getMovementValues()) {
            if (!firstLine) {
                retString.append(", ");
            }
            firstLine = false;
            retString.append(move.getName()).append(" ");
            retString.append(MovementToken.getRateToken(move.getWeight()));
        }
        return retString.toString();
    }

    public static String getRateToken(double movement) {
        return Globals.getGameModeUnitSet().displayDistanceInUnitSet(movement) + Globals.getGameModeUnitSet().getDistanceUnit();
    }
}

