/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Campaign;
import pcgen.io.FileAccess;
import pcgen.rules.context.LoadContext;
import pcgen.system.ConfigurationSettings;
import pcgen.util.Logging;

public final class CampaignOutput {
    private CampaignOutput() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void output(LoadContext context, Campaign campaign) {
        File outFile = new File(ConfigurationSettings.getPccFilesDir() + File.separator + campaign.getSafe(StringKey.DESTINATION));
        BufferedWriter out = null;
        try {
            Collection<String> lines;
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
            List<String> commentList = campaign.getListFor(ListKey.COMMENT);
            if (commentList != null) {
                for (String s : commentList) {
                    FileAccess.write(out, "#" + s);
                    FileAccess.newLine(out);
                }
            }
            if ((lines = context.unparse(campaign)) != null) {
                for (String line : lines) {
                    FileAccess.write(out, line);
                    FileAccess.newLine(out);
                }
            }
        }
        catch (FileNotFoundException exc) {
            Logging.errorPrint("Error while writing to " + outFile.toString(), exc);
        }
        catch (UnsupportedEncodingException exc) {
            Logging.errorPrint("Error while writing to " + outFile.toString(), exc);
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException ex) {
                Logging.errorPrint("Can't close " + outFile.toString(), ex);
            }
        }
    }
}

