/*
 * Decompiled with CFR 0.152.
 */
package plugin.overland.model;

import java.io.File;
import java.text.NumberFormat;
import java.text.ParseException;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import pcgen.util.Logging;
import plugin.overland.gui.XMLFilter;
import plugin.overland.model.RoomBoard;
import plugin.overland.model.RoomBoardImplementation;
import plugin.overland.model.TravelMethodFactory;
import plugin.overland.util.PairList;
import plugin.overland.util.RBCost;

public final class RoomBoardFactory {
    private static final String DIR_RNBPRICE = "rnbprice";

    public static RoomBoard load(File dataDir) {
        PairList<RBCost> inns = new PairList<RBCost>();
        PairList<RBCost> foods = new PairList<RBCost>();
        PairList<RBCost> animals = new PairList<RBCost>();
        File path = new File(dataDir, DIR_RNBPRICE);
        if (path.isDirectory()) {
            File[] dataFiles = path.listFiles(new XMLFilter());
            SAXBuilder builder = new SAXBuilder();
            for (int i = 0; i < dataFiles.length; ++i) {
                try {
                    Document methodSet = builder.build(dataFiles[i]);
                    DocType dt = methodSet.getDocType();
                    if (dt.getElementName().equals("RNBPRICE")) {
                        RoomBoardFactory.loadRBData(methodSet, inns, foods, animals);
                    }
                    methodSet = null;
                    dt = null;
                    continue;
                }
                catch (Exception e) {
                    Logging.errorPrintLocalised("XML Error with file {0}", dataFiles[i].getName());
                    Logging.errorPrint(e.getMessage(), e);
                }
            }
        } else {
            Logging.errorPrintLocalised("in_plugin_overland_noDatafile", path.getPath());
        }
        return new RoomBoardImplementation(inns, foods, animals);
    }

    private static void loadRBData(Document methodSet, PairList<RBCost> inns, PairList<RBCost> foods, PairList<RBCost> animals) {
        Element table = methodSet.getRootElement();
        float priceF = 999.0f;
        NumberFormat nf = TravelMethodFactory.getNumberFormat(table);
        for (Object methodObj : table.getChildren("item")) {
            Element method = (Element)methodObj;
            String type = method.getChild("type").getTextTrim();
            String name = method.getChild("name").getTextTrim();
            String priceS = method.getChild("price").getTextTrim();
            try {
                priceF = nf.parse(priceS).floatValue();
            }
            catch (ParseException e1) {
                Logging.errorPrintLocalised("Invalid number formating \"{0}\" in XML File", priceS);
            }
            if (type.equals("Inn")) {
                inns.add(new RBCost(name, priceF));
                continue;
            }
            if (type.equals("Food")) {
                foods.add(new RBCost(name, priceF));
                continue;
            }
            if (!type.equals("Animal")) continue;
            animals.add(new RBCost(name, priceF));
        }
    }
}

