%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  This file is part of Logtalk <https://logtalk.org/>
%  Copyright 1998-2021 Paulo Moura <pmoura@logtalk.org>
%  SPDX-License-Identifier: Apache-2.0
%
%  Licensed under the Apache License, Version 2.0 (the "License");
%  you may not use this file except in compliance with the License.
%  You may obtain a copy of the License at
%
%      http://www.apache.org/licenses/LICENSE-2.0
%
%  Unless required by applicable law or agreed to in writing, software
%  distributed under the License is distributed on an "AS IS" BASIS,
%  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%  See the License for the specific language governing permissions and
%  limitations under the License.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


:- object(tests,
	extends(lgtunit)).

	:- info([
		version is 0:0:0,
		author is 'Paulo Moura',
		date is 2014-05-23,
		comment is 'Unit tests for the "pardicts" example.'
	]).

	test(dicts_1) :-
		obj(Dict)::init([a-1, b-2, c-3]),
		setof(Value, Key^(obj(Dict)::get(Key, Value)), Values),
		Values == [1, 2, 3].

	test(dicts_2) :-
		obj(Dict)::init([a-1, b-2, c-3]),
		obj(Dict)::nb_set(b, 9),
		obj(Dict)::get(b, Value),
		Value == 9.

:- end_object.
