// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package resourcegroups

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCreateGroup = "CreateGroup"

// CreateGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroup for more information on using the CreateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupRequest method.
//    req, resp := client.CreateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/CreateGroup
func (c *ResourceGroups) CreateGroupRequest(input *CreateGroupInput) (req *request.Request, output *CreateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/groups",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	output = &CreateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroup API operation for AWS Resource Groups.
//
// Creates a resource group with the specified name and description. You can
// optionally include a resource query, or a service configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation CreateGroup for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The request includes one or more parameters that violate validation rules.
//
//   * ForbiddenException
//   The caller isn't authorized to make the request. Check permissions.
//
//   * MethodNotAllowedException
//   The request uses an HTTP method that isn't allowed for the specified resource.
//
//   * TooManyRequestsException
//   You've exceeded throttling limits by making too many requests in a period
//   of time.
//
//   * InternalServerErrorException
//   An internal error occurred while processing the request. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/CreateGroup
func (c *ResourceGroups) CreateGroup(input *CreateGroupInput) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	return out, req.Send()
}

// CreateGroupWithContext is the same as CreateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) CreateGroupWithContext(ctx aws.Context, input *CreateGroupInput, opts ...request.Option) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroup = "DeleteGroup"

// DeleteGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroup for more information on using the DeleteGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGroupRequest method.
//    req, resp := client.DeleteGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/DeleteGroup
func (c *ResourceGroups) DeleteGroupRequest(input *DeleteGroupInput) (req *request.Request, output *DeleteGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-group",
	}

	if input == nil {
		input = &DeleteGroupInput{}
	}

	output = &DeleteGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGroup API operation for AWS Resource Groups.
//
// Deletes the specified resource group. Deleting a resource group does not
// delete any resources that are members of the group; it only deletes the group
// structure.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation DeleteGroup for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The request includes one or more parameters that violate validation rules.
//
//   * ForbiddenException
//   The caller isn't authorized to make the request. Check permissions.
//
//   * NotFoundException
//   One or more of the specified resources don't exist.
//
//   * MethodNotAllowedException
//   The request uses an HTTP method that isn't allowed for the specified resource.
//
//   * TooManyRequestsException
//   You've exceeded throttling limits by making too many requests in a period
//   of time.
//
//   * InternalServerErrorException
//   An internal error occurred while processing the request. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/DeleteGroup
func (c *ResourceGroups) DeleteGroup(input *DeleteGroupInput) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	return out, req.Send()
}

// DeleteGroupWithContext is the same as DeleteGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) DeleteGroupWithContext(ctx aws.Context, input *DeleteGroupInput, opts ...request.Option) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroup = "GetGroup"

// GetGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroup for more information on using the GetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGroupRequest method.
//    req, resp := client.GetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetGroup
func (c *ResourceGroups) GetGroupRequest(input *GetGroupInput) (req *request.Request, output *GetGroupOutput) {
	op := &request.Operation{
		Name:       opGetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/get-group",
	}

	if input == nil {
		input = &GetGroupInput{}
	}

	output = &GetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroup API operation for AWS Resource Groups.
//
// Returns information about a specified resource group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation GetGroup for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The request includes one or more parameters that violate validation rules.
//
//   * ForbiddenException
//   The caller isn't authorized to make the request. Check permissions.
//
//   * NotFoundException
//   One or more of the specified resources don't exist.
//
//   * MethodNotAllowedException
//   The request uses an HTTP method that isn't allowed for the specified resource.
//
//   * TooManyRequestsException
//   You've exceeded throttling limits by making too many requests in a period
//   of time.
//
//   * InternalServerErrorException
//   An internal error occurred while processing the request. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetGroup
func (c *ResourceGroups) GetGroup(input *GetGroupInput) (*GetGroupOutput, error) {
	req, out := c.GetGroupRequest(input)
	return out, req.Send()
}

// GetGroupWithContext is the same as GetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) GetGroupWithContext(ctx aws.Context, input *GetGroupInput, opts ...request.Option) (*GetGroupOutput, error) {
	req, out := c.GetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroupConfiguration = "GetGroupConfiguration"

// GetGroupConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetGroupConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroupConfiguration for more information on using the GetGroupConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGroupConfigurationRequest method.
//    req, resp := client.GetGroupConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetGroupConfiguration
func (c *ResourceGroups) GetGroupConfigurationRequest(input *GetGroupConfigurationInput) (req *request.Request, output *GetGroupConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetGroupConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/get-group-configuration",
	}

	if input == nil {
		input = &GetGroupConfigurationInput{}
	}

	output = &GetGroupConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroupConfiguration API operation for AWS Resource Groups.
//
// Returns the service configuration associated with the specified resource
// group. AWS Resource Groups supports configurations for the following resource
// group types:
//
//    * AWS::EC2::CapacityReservationPool - Amazon EC2 capacity reservation
//    pools. For more information, see Working with capacity reservation groups
//    (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html#create-cr-group)
//    in the EC2 Users Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation GetGroupConfiguration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The request includes one or more parameters that violate validation rules.
//
//   * ForbiddenException
//   The caller isn't authorized to make the request. Check permissions.
//
//   * NotFoundException
//   One or more of the specified resources don't exist.
//
//   * MethodNotAllowedException
//   The request uses an HTTP method that isn't allowed for the specified resource.
//
//   * TooManyRequestsException
//   You've exceeded throttling limits by making too many requests in a period
//   of time.
//
//   * InternalServerErrorException
//   An internal error occurred while processing the request. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetGroupConfiguration
func (c *ResourceGroups) GetGroupConfiguration(input *GetGroupConfigurationInput) (*GetGroupConfigurationOutput, error) {
	req, out := c.GetGroupConfigurationRequest(input)
	return out, req.Send()
}

// GetGroupConfigurationWithContext is the same as GetGroupConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroupConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) GetGroupConfigurationWithContext(ctx aws.Context, input *GetGroupConfigurationInput, opts ...request.Option) (*GetGroupConfigurationOutput, error) {
	req, out := c.GetGroupConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroupQuery = "GetGroupQuery"

// GetGroupQueryRequest generates a "aws/request.Request" representing the
// client's request for the GetGroupQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroupQuery for more information on using the GetGroupQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGroupQueryRequest method.
//    req, resp := client.GetGroupQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetGroupQuery
func (c *ResourceGroups) GetGroupQueryRequest(input *GetGroupQueryInput) (req *request.Request, output *GetGroupQueryOutput) {
	op := &request.Operation{
		Name:       opGetGroupQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/get-group-query",
	}

	if input == nil {
		input = &GetGroupQueryInput{}
	}

	output = &GetGroupQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroupQuery API operation for AWS Resource Groups.
//
// Retrieves the resource query associated with the specified resource group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation GetGroupQuery for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The request includes one or more parameters that violate validation rules.
//
//   * ForbiddenException
//   The caller isn't authorized to make the request. Check permissions.
//
//   * NotFoundException
//   One or more of the specified resources don't exist.
//
//   * MethodNotAllowedException
//   The request uses an HTTP method that isn't allowed for the specified resource.
//
//   * TooManyRequestsException
//   You've exceeded throttling limits by making too many requests in a period
//   of time.
//
//   * InternalServerErrorException
//   An internal error occurred while processing the request. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetGroupQuery
func (c *ResourceGroups) GetGroupQuery(input *GetGroupQueryInput) (*GetGroupQueryOutput, error) {
	req, out := c.GetGroupQueryRequest(input)
	return out, req.Send()
}

// GetGroupQueryWithContext is the same as GetGroupQuery with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroupQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) GetGroupQueryWithContext(ctx aws.Context, input *GetGroupQueryInput, opts ...request.Option) (*GetGroupQueryOutput, error) {
	req, out := c.GetGroupQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTags = "GetTags"

// GetTagsRequest generates a "aws/request.Request" representing the
// client's request for the GetTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTags for more information on using the GetTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTagsRequest method.
//    req, resp := client.GetTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetTags
func (c *ResourceGroups) GetTagsRequest(input *GetTagsInput) (req *request.Request, output *GetTagsOutput) {
	op := &request.Operation{
		Name:       opGetTags,
		HTTPMethod: "GET",
		HTTPPath:   "/resources/{Arn}/tags",
	}

	if input == nil {
		input = &GetTagsInput{}
	}

	output = &GetTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTags API operation for AWS Resource Groups.
//
// Returns a list of tags that are associated with a resource group, specified
// by an ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation GetTags for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The request includes one or more parameters that violate validation rules.
//
//   * ForbiddenException
//   The caller isn't authorized to make the request. Check permissions.
//
//   * NotFoundException
//   One or more of the specified resources don't exist.
//
//   * MethodNotAllowedException
//   The request uses an HTTP method that isn't allowed for the specified resource.
//
//   * TooManyRequestsException
//   You've exceeded throttling limits by making too many requests in a period
//   of time.
//
//   * InternalServerErrorException
//   An internal error occurred while processing the request. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetTags
func (c *ResourceGroups) GetTags(input *GetTagsInput) (*GetTagsOutput, error) {
	req, out := c.GetTagsRequest(input)
	return out, req.Send()
}

// GetTagsWithContext is the same as GetTags with the addition of
// the ability to pass a context and additional request options.
//
// See GetTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) GetTagsWithContext(ctx aws.Context, input *GetTagsInput, opts ...request.Option) (*GetTagsOutput, error) {
	req, out := c.GetTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGroupResources = "GroupResources"

// GroupResourcesRequest generates a "aws/request.Request" representing the
// client's request for the GroupResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GroupResources for more information on using the GroupResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GroupResourcesRequest method.
//    req, resp := client.GroupResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GroupResources
func (c *ResourceGroups) GroupResourcesRequest(input *GroupResourcesInput) (req *request.Request, output *GroupResourcesOutput) {
	op := &request.Operation{
		Name:       opGroupResources,
		HTTPMethod: "POST",
		HTTPPath:   "/group-resources",
	}

	if input == nil {
		input = &GroupResourcesInput{}
	}

	output = &GroupResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GroupResources API operation for AWS Resource Groups.
//
// Adds the specified resources to the specified group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation GroupResources for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The request includes one or more parameters that violate validation rules.
//
//   * ForbiddenException
//   The caller isn't authorized to make the request. Check permissions.
//
//   * NotFoundException
//   One or more of the specified resources don't exist.
//
//   * MethodNotAllowedException
//   The request uses an HTTP method that isn't allowed for the specified resource.
//
//   * TooManyRequestsException
//   You've exceeded throttling limits by making too many requests in a period
//   of time.
//
//   * InternalServerErrorException
//   An internal error occurred while processing the request. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GroupResources
func (c *ResourceGroups) GroupResources(input *GroupResourcesInput) (*GroupResourcesOutput, error) {
	req, out := c.GroupResourcesRequest(input)
	return out, req.Send()
}

// GroupResourcesWithContext is the same as GroupResources with the addition of
// the ability to pass a context and additional request options.
//
// See GroupResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) GroupResourcesWithContext(ctx aws.Context, input *GroupResourcesInput, opts ...request.Option) (*GroupResourcesOutput, error) {
	req, out := c.GroupResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroupResources = "ListGroupResources"

// ListGroupResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListGroupResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroupResources for more information on using the ListGroupResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupResourcesRequest method.
//    req, resp := client.ListGroupResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/ListGroupResources
func (c *ResourceGroups) ListGroupResourcesRequest(input *ListGroupResourcesInput) (req *request.Request, output *ListGroupResourcesOutput) {
	op := &request.Operation{
		Name:       opListGroupResources,
		HTTPMethod: "POST",
		HTTPPath:   "/list-group-resources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGroupResourcesInput{}
	}

	output = &ListGroupResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroupResources API operation for AWS Resource Groups.
//
// Returns a list of ARNs of the resources that are members of a specified resource
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation ListGroupResources for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   The request was rejected because it doesn't have valid credentials for the
//   target resource.
//
//   * BadRequestException
//   The request includes one or more parameters that violate validation rules.
//
//   * ForbiddenException
//   The caller isn't authorized to make the request. Check permissions.
//
//   * NotFoundException
//   One or more of the specified resources don't exist.
//
//   * MethodNotAllowedException
//   The request uses an HTTP method that isn't allowed for the specified resource.
//
//   * TooManyRequestsException
//   You've exceeded throttling limits by making too many requests in a period
//   of time.
//
//   * InternalServerErrorException
//   An internal error occurred while processing the request. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/ListGroupResources
func (c *ResourceGroups) ListGroupResources(input *ListGroupResourcesInput) (*ListGroupResourcesOutput, error) {
	req, out := c.ListGroupResourcesRequest(input)
	return out, req.Send()
}

// ListGroupResourcesWithContext is the same as ListGroupResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) ListGroupResourcesWithContext(ctx aws.Context, input *ListGroupResourcesInput, opts ...request.Option) (*ListGroupResourcesOutput, error) {
	req, out := c.ListGroupResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGroupResourcesPages iterates over the pages of a ListGroupResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroupResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGroupResources operation.
//    pageNum := 0
//    err := client.ListGroupResourcesPages(params,
//        func(page *resourcegroups.ListGroupResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ResourceGroups) ListGroupResourcesPages(input *ListGroupResourcesInput, fn func(*ListGroupResourcesOutput, bool) bool) error {
	return c.ListGroupResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGroupResourcesPagesWithContext same as ListGroupResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) ListGroupResourcesPagesWithContext(ctx aws.Context, input *ListGroupResourcesInput, fn func(*ListGroupResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGroupResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGroupResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGroupResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGroups = "ListGroups"

// ListGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroups for more information on using the ListGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupsRequest method.
//    req, resp := client.ListGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/ListGroups
func (c *ResourceGroups) ListGroupsRequest(input *ListGroupsInput) (req *request.Request, output *ListGroupsOutput) {
	op := &request.Operation{
		Name:       opListGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/groups-list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGroupsInput{}
	}

	output = &ListGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroups API operation for AWS Resource Groups.
//
// Returns a list of existing resource groups in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation ListGroups for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The request includes one or more parameters that violate validation rules.
//
//   * ForbiddenException
//   The caller isn't authorized to make the request. Check permissions.
//
//   * MethodNotAllowedException
//   The request uses an HTTP method that isn't allowed for the specified resource.
//
//   * TooManyRequestsException
//   You've exceeded throttling limits by making too many requests in a period
//   of time.
//
//   * InternalServerErrorException
//   An internal error occurred while processing the request. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/ListGroups
func (c *ResourceGroups) ListGroups(input *ListGroupsInput) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	return out, req.Send()
}

// ListGroupsWithContext is the same as ListGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) ListGroupsWithContext(ctx aws.Context, input *ListGroupsInput, opts ...request.Option) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGroupsPages iterates over the pages of a ListGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGroups operation.
//    pageNum := 0
//    err := client.ListGroupsPages(params,
//        func(page *resourcegroups.ListGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ResourceGroups) ListGroupsPages(input *ListGroupsInput, fn func(*ListGroupsOutput, bool) bool) error {
	return c.ListGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGroupsPagesWithContext same as ListGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) ListGroupsPagesWithContext(ctx aws.Context, input *ListGroupsInput, fn func(*ListGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchResources = "SearchResources"

// SearchResourcesRequest generates a "aws/request.Request" representing the
// client's request for the SearchResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchResources for more information on using the SearchResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchResourcesRequest method.
//    req, resp := client.SearchResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/SearchResources
func (c *ResourceGroups) SearchResourcesRequest(input *SearchResourcesInput) (req *request.Request, output *SearchResourcesOutput) {
	op := &request.Operation{
		Name:       opSearchResources,
		HTTPMethod: "POST",
		HTTPPath:   "/resources/search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchResourcesInput{}
	}

	output = &SearchResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchResources API operation for AWS Resource Groups.
//
// Returns a list of AWS resource identifiers that matches the specified query.
// The query uses the same format as a resource query in a CreateGroup or UpdateGroupQuery
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation SearchResources for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   The request was rejected because it doesn't have valid credentials for the
//   target resource.
//
//   * BadRequestException
//   The request includes one or more parameters that violate validation rules.
//
//   * ForbiddenException
//   The caller isn't authorized to make the request. Check permissions.
//
//   * MethodNotAllowedException
//   The request uses an HTTP method that isn't allowed for the specified resource.
//
//   * TooManyRequestsException
//   You've exceeded throttling limits by making too many requests in a period
//   of time.
//
//   * InternalServerErrorException
//   An internal error occurred while processing the request. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/SearchResources
func (c *ResourceGroups) SearchResources(input *SearchResourcesInput) (*SearchResourcesOutput, error) {
	req, out := c.SearchResourcesRequest(input)
	return out, req.Send()
}

// SearchResourcesWithContext is the same as SearchResources with the addition of
// the ability to pass a context and additional request options.
//
// See SearchResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) SearchResourcesWithContext(ctx aws.Context, input *SearchResourcesInput, opts ...request.Option) (*SearchResourcesOutput, error) {
	req, out := c.SearchResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchResourcesPages iterates over the pages of a SearchResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchResources operation.
//    pageNum := 0
//    err := client.SearchResourcesPages(params,
//        func(page *resourcegroups.SearchResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ResourceGroups) SearchResourcesPages(input *SearchResourcesInput, fn func(*SearchResourcesOutput, bool) bool) error {
	return c.SearchResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchResourcesPagesWithContext same as SearchResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) SearchResourcesPagesWithContext(ctx aws.Context, input *SearchResourcesInput, fn func(*SearchResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opTag = "Tag"

// TagRequest generates a "aws/request.Request" representing the
// client's request for the Tag operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Tag for more information on using the Tag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagRequest method.
//    req, resp := client.TagRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/Tag
func (c *ResourceGroups) TagRequest(input *TagInput) (req *request.Request, output *TagOutput) {
	op := &request.Operation{
		Name:       opTag,
		HTTPMethod: "PUT",
		HTTPPath:   "/resources/{Arn}/tags",
	}

	if input == nil {
		input = &TagInput{}
	}

	output = &TagOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Tag API operation for AWS Resource Groups.
//
// Adds tags to a resource group with the specified ARN. Existing tags on a
// resource group are not changed if they are not specified in the request parameters.
//
// Do not store personally identifiable information (PII) or other confidential
// or sensitive information in tags. We use tags to provide you with billing
// and administration services. Tags are not intended to be used for private
// or sensitive data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation Tag for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The request includes one or more parameters that violate validation rules.
//
//   * ForbiddenException
//   The caller isn't authorized to make the request. Check permissions.
//
//   * NotFoundException
//   One or more of the specified resources don't exist.
//
//   * MethodNotAllowedException
//   The request uses an HTTP method that isn't allowed for the specified resource.
//
//   * TooManyRequestsException
//   You've exceeded throttling limits by making too many requests in a period
//   of time.
//
//   * InternalServerErrorException
//   An internal error occurred while processing the request. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/Tag
func (c *ResourceGroups) Tag(input *TagInput) (*TagOutput, error) {
	req, out := c.TagRequest(input)
	return out, req.Send()
}

// TagWithContext is the same as Tag with the addition of
// the ability to pass a context and additional request options.
//
// See Tag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) TagWithContext(ctx aws.Context, input *TagInput, opts ...request.Option) (*TagOutput, error) {
	req, out := c.TagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUngroupResources = "UngroupResources"

// UngroupResourcesRequest generates a "aws/request.Request" representing the
// client's request for the UngroupResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UngroupResources for more information on using the UngroupResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UngroupResourcesRequest method.
//    req, resp := client.UngroupResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/UngroupResources
func (c *ResourceGroups) UngroupResourcesRequest(input *UngroupResourcesInput) (req *request.Request, output *UngroupResourcesOutput) {
	op := &request.Operation{
		Name:       opUngroupResources,
		HTTPMethod: "POST",
		HTTPPath:   "/ungroup-resources",
	}

	if input == nil {
		input = &UngroupResourcesInput{}
	}

	output = &UngroupResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UngroupResources API operation for AWS Resource Groups.
//
// Removes the specified resources from the specified group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation UngroupResources for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The request includes one or more parameters that violate validation rules.
//
//   * ForbiddenException
//   The caller isn't authorized to make the request. Check permissions.
//
//   * NotFoundException
//   One or more of the specified resources don't exist.
//
//   * MethodNotAllowedException
//   The request uses an HTTP method that isn't allowed for the specified resource.
//
//   * TooManyRequestsException
//   You've exceeded throttling limits by making too many requests in a period
//   of time.
//
//   * InternalServerErrorException
//   An internal error occurred while processing the request. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/UngroupResources
func (c *ResourceGroups) UngroupResources(input *UngroupResourcesInput) (*UngroupResourcesOutput, error) {
	req, out := c.UngroupResourcesRequest(input)
	return out, req.Send()
}

// UngroupResourcesWithContext is the same as UngroupResources with the addition of
// the ability to pass a context and additional request options.
//
// See UngroupResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) UngroupResourcesWithContext(ctx aws.Context, input *UngroupResourcesInput, opts ...request.Option) (*UngroupResourcesOutput, error) {
	req, out := c.UngroupResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntag = "Untag"

// UntagRequest generates a "aws/request.Request" representing the
// client's request for the Untag operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Untag for more information on using the Untag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagRequest method.
//    req, resp := client.UntagRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/Untag
func (c *ResourceGroups) UntagRequest(input *UntagInput) (req *request.Request, output *UntagOutput) {
	op := &request.Operation{
		Name:       opUntag,
		HTTPMethod: "PATCH",
		HTTPPath:   "/resources/{Arn}/tags",
	}

	if input == nil {
		input = &UntagInput{}
	}

	output = &UntagOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Untag API operation for AWS Resource Groups.
//
// Deletes tags from a specified resource group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation Untag for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The request includes one or more parameters that violate validation rules.
//
//   * ForbiddenException
//   The caller isn't authorized to make the request. Check permissions.
//
//   * NotFoundException
//   One or more of the specified resources don't exist.
//
//   * MethodNotAllowedException
//   The request uses an HTTP method that isn't allowed for the specified resource.
//
//   * TooManyRequestsException
//   You've exceeded throttling limits by making too many requests in a period
//   of time.
//
//   * InternalServerErrorException
//   An internal error occurred while processing the request. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/Untag
func (c *ResourceGroups) Untag(input *UntagInput) (*UntagOutput, error) {
	req, out := c.UntagRequest(input)
	return out, req.Send()
}

// UntagWithContext is the same as Untag with the addition of
// the ability to pass a context and additional request options.
//
// See Untag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) UntagWithContext(ctx aws.Context, input *UntagInput, opts ...request.Option) (*UntagOutput, error) {
	req, out := c.UntagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGroup = "UpdateGroup"

// UpdateGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGroup for more information on using the UpdateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGroupRequest method.
//    req, resp := client.UpdateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/UpdateGroup
func (c *ResourceGroups) UpdateGroupRequest(input *UpdateGroupInput) (req *request.Request, output *UpdateGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/update-group",
	}

	if input == nil {
		input = &UpdateGroupInput{}
	}

	output = &UpdateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGroup API operation for AWS Resource Groups.
//
// Updates the description for an existing group. You cannot update the name
// of a resource group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation UpdateGroup for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The request includes one or more parameters that violate validation rules.
//
//   * ForbiddenException
//   The caller isn't authorized to make the request. Check permissions.
//
//   * NotFoundException
//   One or more of the specified resources don't exist.
//
//   * MethodNotAllowedException
//   The request uses an HTTP method that isn't allowed for the specified resource.
//
//   * TooManyRequestsException
//   You've exceeded throttling limits by making too many requests in a period
//   of time.
//
//   * InternalServerErrorException
//   An internal error occurred while processing the request. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/UpdateGroup
func (c *ResourceGroups) UpdateGroup(input *UpdateGroupInput) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	return out, req.Send()
}

// UpdateGroupWithContext is the same as UpdateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) UpdateGroupWithContext(ctx aws.Context, input *UpdateGroupInput, opts ...request.Option) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGroupQuery = "UpdateGroupQuery"

// UpdateGroupQueryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroupQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGroupQuery for more information on using the UpdateGroupQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGroupQueryRequest method.
//    req, resp := client.UpdateGroupQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/UpdateGroupQuery
func (c *ResourceGroups) UpdateGroupQueryRequest(input *UpdateGroupQueryInput) (req *request.Request, output *UpdateGroupQueryOutput) {
	op := &request.Operation{
		Name:       opUpdateGroupQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/update-group-query",
	}

	if input == nil {
		input = &UpdateGroupQueryInput{}
	}

	output = &UpdateGroupQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGroupQuery API operation for AWS Resource Groups.
//
// Updates the resource query of a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation UpdateGroupQuery for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The request includes one or more parameters that violate validation rules.
//
//   * ForbiddenException
//   The caller isn't authorized to make the request. Check permissions.
//
//   * NotFoundException
//   One or more of the specified resources don't exist.
//
//   * MethodNotAllowedException
//   The request uses an HTTP method that isn't allowed for the specified resource.
//
//   * TooManyRequestsException
//   You've exceeded throttling limits by making too many requests in a period
//   of time.
//
//   * InternalServerErrorException
//   An internal error occurred while processing the request. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/UpdateGroupQuery
func (c *ResourceGroups) UpdateGroupQuery(input *UpdateGroupQueryInput) (*UpdateGroupQueryOutput, error) {
	req, out := c.UpdateGroupQueryRequest(input)
	return out, req.Send()
}

// UpdateGroupQueryWithContext is the same as UpdateGroupQuery with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroupQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) UpdateGroupQueryWithContext(ctx aws.Context, input *UpdateGroupQueryInput, opts ...request.Option) (*UpdateGroupQueryOutput, error) {
	req, out := c.UpdateGroupQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The request includes one or more parameters that violate validation rules.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateGroupInput struct {
	_ struct{} `type:"structure"`

	// A configuration associates the resource group with an AWS service and specifies
	// how the service can interact with the resources in the group. A configuration
	// is an array of GroupConfigurationItem elements.
	//
	// You can specify either a Configuration or a ResourceQuery in a group, but
	// not both.
	Configuration []*GroupConfigurationItem `type:"list"`

	// The description of the resource group. Descriptions can consist of letters,
	// numbers, hyphens, underscores, periods, and spaces.
	Description *string `type:"string"`

	// The name of the group, which is the identifier of the group in other operations.
	// You can't change the name of a resource group after you create it. A resource
	// group name can consist of letters, numbers, hyphens, periods, and underscores.
	// The name cannot start with AWS or aws; these are reserved. A resource group
	// name must be unique within each AWS Region in your AWS account.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The resource query that determines which AWS resources are members of this
	// group.
	//
	// You can specify either a ResourceQuery or a Configuration, but not both.
	ResourceQuery *ResourceQuery `type:"structure"`

	// The tags to add to the group. A tag is key-value pair string.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s CreateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Configuration != nil {
		for i, v := range s.Configuration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Configuration", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResourceQuery != nil {
		if err := s.ResourceQuery.Validate(); err != nil {
			invalidParams.AddNested("ResourceQuery", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateGroupInput) SetConfiguration(v []*GroupConfigurationItem) *CreateGroupInput {
	s.Configuration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateGroupInput) SetDescription(v string) *CreateGroupInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGroupInput) SetName(v string) *CreateGroupInput {
	s.Name = &v
	return s
}

// SetResourceQuery sets the ResourceQuery field's value.
func (s *CreateGroupInput) SetResourceQuery(v *ResourceQuery) *CreateGroupInput {
	s.ResourceQuery = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateGroupInput) SetTags(v map[string]*string) *CreateGroupInput {
	s.Tags = v
	return s
}

type CreateGroupOutput struct {
	_ struct{} `type:"structure"`

	// The description of the resource group.
	Group *Group `type:"structure"`

	// The service configuration associated with the resource group. AWS Resource
	// Groups supports adding service configurations for the following resource
	// group types:
	//
	//    * AWS::EC2::CapacityReservationPool - Amazon EC2 capacity reservation
	//    pools. For more information, see Working with capacity reservation groups
	//    (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html#create-cr-group)
	//    in the EC2 Users Guide.
	GroupConfiguration *GroupConfiguration `type:"structure"`

	// The resource query associated with the group.
	ResourceQuery *ResourceQuery `type:"structure"`

	// The tags associated with the group.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s CreateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *CreateGroupOutput) SetGroup(v *Group) *CreateGroupOutput {
	s.Group = v
	return s
}

// SetGroupConfiguration sets the GroupConfiguration field's value.
func (s *CreateGroupOutput) SetGroupConfiguration(v *GroupConfiguration) *CreateGroupOutput {
	s.GroupConfiguration = v
	return s
}

// SetResourceQuery sets the ResourceQuery field's value.
func (s *CreateGroupOutput) SetResourceQuery(v *ResourceQuery) *CreateGroupOutput {
	s.ResourceQuery = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateGroupOutput) SetTags(v map[string]*string) *CreateGroupOutput {
	s.Tags = v
	return s
}

type DeleteGroupInput struct {
	_ struct{} `type:"structure"`

	// The name or the ARN of the resource group to delete.
	Group *string `min:"1" type:"string"`

	// Don't use this parameter. Use Group instead.
	//
	// Deprecated: This field is deprecated, use Group instead.
	GroupName *string `min:"1" deprecated:"true" type:"string"`
}

// String returns the string representation
func (s DeleteGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupInput"}
	if s.Group != nil && len(*s.Group) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Group", 1))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroup sets the Group field's value.
func (s *DeleteGroupInput) SetGroup(v string) *DeleteGroupInput {
	s.Group = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *DeleteGroupInput) SetGroupName(v string) *DeleteGroupInput {
	s.GroupName = &v
	return s
}

type DeleteGroupOutput struct {
	_ struct{} `type:"structure"`

	// A full description of the deleted resource group.
	Group *Group `type:"structure"`
}

// String returns the string representation
func (s DeleteGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *DeleteGroupOutput) SetGroup(v *Group) *DeleteGroupOutput {
	s.Group = v
	return s
}

// A resource that failed to be added to or removed from a group.
type FailedResource struct {
	_ struct{} `type:"structure"`

	// The error code associated with the failure.
	ErrorCode *string `min:"1" type:"string"`

	// The error message text associated with the failure.
	ErrorMessage *string `min:"1" type:"string"`

	// The ARN of the resource that failed to be added or removed.
	ResourceArn *string `type:"string"`
}

// String returns the string representation
func (s FailedResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailedResource) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailedResource) SetErrorCode(v string) *FailedResource {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailedResource) SetErrorMessage(v string) *FailedResource {
	s.ErrorMessage = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *FailedResource) SetResourceArn(v string) *FailedResource {
	s.ResourceArn = &v
	return s
}

// The caller isn't authorized to make the request. Check permissions.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetGroupConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name or the ARN of the resource group.
	Group *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetGroupConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupConfigurationInput"}
	if s.Group != nil && len(*s.Group) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Group", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroup sets the Group field's value.
func (s *GetGroupConfigurationInput) SetGroup(v string) *GetGroupConfigurationInput {
	s.Group = &v
	return s
}

type GetGroupConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The configuration associated with the specified group.
	GroupConfiguration *GroupConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetGroupConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupConfigurationOutput) GoString() string {
	return s.String()
}

// SetGroupConfiguration sets the GroupConfiguration field's value.
func (s *GetGroupConfigurationOutput) SetGroupConfiguration(v *GroupConfiguration) *GetGroupConfigurationOutput {
	s.GroupConfiguration = v
	return s
}

type GetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name or the ARN of the resource group to retrieve.
	Group *string `min:"1" type:"string"`

	// Don't use this parameter. Use Group instead.
	//
	// Deprecated: This field is deprecated, use Group instead.
	GroupName *string `min:"1" deprecated:"true" type:"string"`
}

// String returns the string representation
func (s GetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupInput"}
	if s.Group != nil && len(*s.Group) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Group", 1))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroup sets the Group field's value.
func (s *GetGroupInput) SetGroup(v string) *GetGroupInput {
	s.Group = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *GetGroupInput) SetGroupName(v string) *GetGroupInput {
	s.GroupName = &v
	return s
}

type GetGroupOutput struct {
	_ struct{} `type:"structure"`

	// A full description of the resource group.
	Group *Group `type:"structure"`
}

// String returns the string representation
func (s GetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *GetGroupOutput) SetGroup(v *Group) *GetGroupOutput {
	s.Group = v
	return s
}

type GetGroupQueryInput struct {
	_ struct{} `type:"structure"`

	// The name or the ARN of the resource group to query.
	Group *string `min:"1" type:"string"`

	// Don't use this parameter. Use Group instead.
	//
	// Deprecated: This field is deprecated, use Group instead.
	GroupName *string `min:"1" deprecated:"true" type:"string"`
}

// String returns the string representation
func (s GetGroupQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupQueryInput"}
	if s.Group != nil && len(*s.Group) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Group", 1))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroup sets the Group field's value.
func (s *GetGroupQueryInput) SetGroup(v string) *GetGroupQueryInput {
	s.Group = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *GetGroupQueryInput) SetGroupName(v string) *GetGroupQueryInput {
	s.GroupName = &v
	return s
}

type GetGroupQueryOutput struct {
	_ struct{} `type:"structure"`

	// The resource query associated with the specified group.
	GroupQuery *GroupQuery `type:"structure"`
}

// String returns the string representation
func (s GetGroupQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupQueryOutput) GoString() string {
	return s.String()
}

// SetGroupQuery sets the GroupQuery field's value.
func (s *GetGroupQueryOutput) SetGroupQuery(v *GroupQuery) *GetGroupQueryOutput {
	s.GroupQuery = v
	return s
}

type GetTagsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource group whose tags you want to retrieve.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"Arn" min:"12" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTagsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetTagsInput) SetArn(v string) *GetTagsInput {
	s.Arn = &v
	return s
}

type GetTagsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the tagged resource group.
	Arn *string `min:"12" type:"string"`

	// The tags associated with the specified resource group.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagsOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetTagsOutput) SetArn(v string) *GetTagsOutput {
	s.Arn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetTagsOutput) SetTags(v map[string]*string) *GetTagsOutput {
	s.Tags = v
	return s
}

// A resource group that contains AWS resources. You can assign resources to
// the group by associating either of the following elements with the group:
//
//    * ResourceQuery - Use a resource query to specify a set of tag keys and
//    values. All resources in the same AWS Region and AWS account that have
//    those keys with the same values are included in the group. You can add
//    a resource query when you create the group.
//
//    * GroupConfiguration - Use a service configuration to associate the group
//    with an AWS service. The configuration specifies which resource types
//    can be included in the group.
type Group struct {
	_ struct{} `type:"structure"`

	// The description of the resource group.
	Description *string `type:"string"`

	// The ARN of the resource group.
	//
	// GroupArn is a required field
	GroupArn *string `min:"12" type:"string" required:"true"`

	// The name of the resource group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Group) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Group) SetDescription(v string) *Group {
	s.Description = &v
	return s
}

// SetGroupArn sets the GroupArn field's value.
func (s *Group) SetGroupArn(v string) *Group {
	s.GroupArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Group) SetName(v string) *Group {
	s.Name = &v
	return s
}

// A service configuration associated with a resource group. The configuration
// options are determined by the AWS service that defines the Type, and specifies
// which resources can be included in the group. You can add a service configuration
// when you create the group.
type GroupConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration currently associated with the group and in effect.
	Configuration []*GroupConfigurationItem `type:"list"`

	// If present, the reason why a request to update the group configuration failed.
	FailureReason *string `type:"string"`

	// If present, the new configuration that is in the process of being applied
	// to the group.
	ProposedConfiguration []*GroupConfigurationItem `type:"list"`

	// The current status of an attempt to update the group configuration.
	Status *string `type:"string" enum:"GroupConfigurationStatus"`
}

// String returns the string representation
func (s GroupConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupConfiguration) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *GroupConfiguration) SetConfiguration(v []*GroupConfigurationItem) *GroupConfiguration {
	s.Configuration = v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *GroupConfiguration) SetFailureReason(v string) *GroupConfiguration {
	s.FailureReason = &v
	return s
}

// SetProposedConfiguration sets the ProposedConfiguration field's value.
func (s *GroupConfiguration) SetProposedConfiguration(v []*GroupConfigurationItem) *GroupConfiguration {
	s.ProposedConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GroupConfiguration) SetStatus(v string) *GroupConfiguration {
	s.Status = &v
	return s
}

// An item in a group configuration. A group configuration can have one or more
// items.
type GroupConfigurationItem struct {
	_ struct{} `type:"structure"`

	// A collection of parameters for this group configuration item.
	Parameters []*GroupConfigurationParameter `type:"list"`

	// Specifies the type of group configuration item. Each item must have a unique
	// value for type.
	//
	// You can specify the following string values:
	//
	//    * AWS::EC2::CapacityReservationPool For more information about EC2 capacity
	//    reservation groups, see Working with capacity reservation groups (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html#create-cr-group)
	//    in the EC2 Users Guide.
	//
	//    * AWS::ResourceGroups::Generic - Supports parameters that configure the
	//    behavior of resource groups of any type.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GroupConfigurationItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupConfigurationItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GroupConfigurationItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GroupConfigurationItem"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Parameters != nil {
		for i, v := range s.Parameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Parameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameters sets the Parameters field's value.
func (s *GroupConfigurationItem) SetParameters(v []*GroupConfigurationParameter) *GroupConfigurationItem {
	s.Parameters = v
	return s
}

// SetType sets the Type field's value.
func (s *GroupConfigurationItem) SetType(v string) *GroupConfigurationItem {
	s.Type = &v
	return s
}

// A parameter for a group configuration item.
type GroupConfigurationParameter struct {
	_ struct{} `type:"structure"`

	// The name of the group configuration parameter.
	//
	// You can specify the following string values:
	//
	//    * For configuration item type AWS::ResourceGroups::Generic: allowed-resource-types
	//    Specifies the types of resources that you can add to this group by using
	//    the GroupResources operation.
	//
	//    * For configuration item type AWS::EC2::CapacityReservationPool: None
	//    - This configuration item type doesn't support any parameters. For more
	//    information about EC2 capacity reservation groups, see Working with capacity
	//    reservation groups (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html#create-cr-group)
	//    in the EC2 Users Guide.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The values of for this parameter.
	//
	// You can specify the following string value:
	//
	//    * For item type allowed-resource-types: the only supported parameter value
	//    is AWS::EC2::CapacityReservation.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s GroupConfigurationParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupConfigurationParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GroupConfigurationParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GroupConfigurationParameter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GroupConfigurationParameter) SetName(v string) *GroupConfigurationParameter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *GroupConfigurationParameter) SetValues(v []*string) *GroupConfigurationParameter {
	s.Values = v
	return s
}

// A filter collection that you can use to restrict the results from a List
// operation to only those you want to include.
type GroupFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. Filter names are case-sensitive.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"GroupFilterName"`

	// One or more filter values. Allowed filter values vary by group filter name,
	// and are case-sensitive.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s GroupFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GroupFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GroupFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GroupFilter) SetName(v string) *GroupFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *GroupFilter) SetValues(v []*string) *GroupFilter {
	s.Values = v
	return s
}

// The unique identifiers for a resource group.
type GroupIdentifier struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource group.
	GroupArn *string `min:"12" type:"string"`

	// The name of the resource group.
	GroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GroupIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupIdentifier) GoString() string {
	return s.String()
}

// SetGroupArn sets the GroupArn field's value.
func (s *GroupIdentifier) SetGroupArn(v string) *GroupIdentifier {
	s.GroupArn = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *GroupIdentifier) SetGroupName(v string) *GroupIdentifier {
	s.GroupName = &v
	return s
}

// A mapping of a query attached to a resource group that determines the AWS
// resources that are members of the group.
type GroupQuery struct {
	_ struct{} `type:"structure"`

	// The name of the resource group that is associated with the specified resource
	// query.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The resource query that determines which AWS resources are members of the
	// associated resource group.
	//
	// ResourceQuery is a required field
	ResourceQuery *ResourceQuery `type:"structure" required:"true"`
}

// String returns the string representation
func (s GroupQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupQuery) GoString() string {
	return s.String()
}

// SetGroupName sets the GroupName field's value.
func (s *GroupQuery) SetGroupName(v string) *GroupQuery {
	s.GroupName = &v
	return s
}

// SetResourceQuery sets the ResourceQuery field's value.
func (s *GroupQuery) SetResourceQuery(v *ResourceQuery) *GroupQuery {
	s.ResourceQuery = v
	return s
}

type GroupResourcesInput struct {
	_ struct{} `type:"structure"`

	// The name or the ARN of the resource group to add resources to.
	//
	// Group is a required field
	Group *string `min:"1" type:"string" required:"true"`

	// The list of ARNs for resources to be added to the group.
	//
	// ResourceArns is a required field
	ResourceArns []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s GroupResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GroupResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GroupResourcesInput"}
	if s.Group == nil {
		invalidParams.Add(request.NewErrParamRequired("Group"))
	}
	if s.Group != nil && len(*s.Group) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Group", 1))
	}
	if s.ResourceArns == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArns"))
	}
	if s.ResourceArns != nil && len(s.ResourceArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroup sets the Group field's value.
func (s *GroupResourcesInput) SetGroup(v string) *GroupResourcesInput {
	s.Group = &v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *GroupResourcesInput) SetResourceArns(v []*string) *GroupResourcesInput {
	s.ResourceArns = v
	return s
}

type GroupResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The ARNs of the resources that failed to be added to the group by this operation.
	Failed []*FailedResource `type:"list"`

	// The ARNs of the resources that were successfully added to the group by this
	// operation.
	Succeeded []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s GroupResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupResourcesOutput) GoString() string {
	return s.String()
}

// SetFailed sets the Failed field's value.
func (s *GroupResourcesOutput) SetFailed(v []*FailedResource) *GroupResourcesOutput {
	s.Failed = v
	return s
}

// SetSucceeded sets the Succeeded field's value.
func (s *GroupResourcesOutput) SetSucceeded(v []*string) *GroupResourcesOutput {
	s.Succeeded = v
	return s
}

// An internal error occurred while processing the request. Try again later.
type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListGroupResourcesInput struct {
	_ struct{} `type:"structure"`

	// Filters, formatted as ResourceFilter objects, that you want to apply to a
	// ListGroupResources operation. Filters the results to include only those of
	// the specified resource types.
	//
	//    * resource-type - Filter resources by their type. Specify up to five resource
	//    types in the format AWS::ServiceCode::ResourceType. For example, AWS::EC2::Instance,
	//    or AWS::S3::Bucket.
	//
	// When you specify a resource-type filter for ListGroupResources, AWS Resource
	// Groups validates your filter resource types against the types that are defined
	// in the query associated with the group. For example, if a group contains
	// only S3 buckets because its query specifies only that resource type, but
	// your resource-type filter includes EC2 instances, AWS Resource Groups does
	// not filter for EC2 instances. In this case, a ListGroupResources request
	// returns a BadRequestException error with a message similar to the following:
	//
	// The resource types specified as filters in the request are not valid.
	//
	// The error includes a list of resource types that failed the validation because
	// they are not part of the query associated with the group. This validation
	// doesn't occur when the group query specifies AWS::AllSupported, because a
	// group based on such a query can contain any of the allowed resource types
	// for the query type (tag-based or AWS CloudFormation stack-based queries).
	Filters []*ResourceFilter `type:"list"`

	// The name or the ARN of the resource group
	Group *string `min:"1" type:"string"`

	// Don't use this parameter. Use Group instead.
	//
	// Deprecated: This field is deprecated, use Group instead.
	GroupName *string `min:"1" deprecated:"true" type:"string"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that the service
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value provided by a previous
	// call's NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListGroupResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupResourcesInput"}
	if s.Group != nil && len(*s.Group) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Group", 1))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListGroupResourcesInput) SetFilters(v []*ResourceFilter) *ListGroupResourcesInput {
	s.Filters = v
	return s
}

// SetGroup sets the Group field's value.
func (s *ListGroupResourcesInput) SetGroup(v string) *ListGroupResourcesInput {
	s.Group = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *ListGroupResourcesInput) SetGroupName(v string) *ListGroupResourcesInput {
	s.GroupName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupResourcesInput) SetMaxResults(v int64) *ListGroupResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupResourcesInput) SetNextToken(v string) *ListGroupResourcesInput {
	s.NextToken = &v
	return s
}

type ListGroupResourcesOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`

	// A list of QueryError objects. Each error is an object that contains ErrorCode
	// and Message structures. Possible values for ErrorCode are CLOUDFORMATION_STACK_INACTIVE
	// and CLOUDFORMATION_STACK_NOT_EXISTING.
	QueryErrors []*QueryError `type:"list"`

	// The ARNs and resource types of resources that are members of the group that
	// you specified.
	ResourceIdentifiers []*ResourceIdentifier `type:"list"`
}

// String returns the string representation
func (s ListGroupResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupResourcesOutput) SetNextToken(v string) *ListGroupResourcesOutput {
	s.NextToken = &v
	return s
}

// SetQueryErrors sets the QueryErrors field's value.
func (s *ListGroupResourcesOutput) SetQueryErrors(v []*QueryError) *ListGroupResourcesOutput {
	s.QueryErrors = v
	return s
}

// SetResourceIdentifiers sets the ResourceIdentifiers field's value.
func (s *ListGroupResourcesOutput) SetResourceIdentifiers(v []*ResourceIdentifier) *ListGroupResourcesOutput {
	s.ResourceIdentifiers = v
	return s
}

type ListGroupsInput struct {
	_ struct{} `type:"structure"`

	// Filters, formatted as GroupFilter objects, that you want to apply to a ListGroups
	// operation.
	//
	//    * resource-type - Filter the results to include only those of the specified
	//    resource types. Specify up to five resource types in the format AWS::ServiceCode::ResourceType
	//    . For example, AWS::EC2::Instance, or AWS::S3::Bucket.
	//
	//    * configuration-type - Filter the results to include only those groups
	//    that have the specified configuration types attached. The current supported
	//    values are: AWS:EC2::CapacityReservationPool
	Filters []*GroupFilter `type:"list"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that the service
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value provided by a previous
	// call's NextToken response to indicate where the output should continue from.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListGroupsInput) SetFilters(v []*GroupFilter) *ListGroupsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupsInput) SetMaxResults(v int64) *ListGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsInput) SetNextToken(v string) *ListGroupsInput {
	s.NextToken = &v
	return s
}

type ListGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of GroupIdentifier objects. Each identifier is an object that contains
	// both the Name and the GroupArn.
	GroupIdentifiers []*GroupIdentifier `type:"list"`

	// This output element is deprecated and shouldn't be used. Refer to GroupIdentifiers
	// instead.
	//
	// Deprecated: This field is deprecated, use GroupIdentifiers instead.
	Groups []*Group `deprecated:"true" type:"list"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsOutput) GoString() string {
	return s.String()
}

// SetGroupIdentifiers sets the GroupIdentifiers field's value.
func (s *ListGroupsOutput) SetGroupIdentifiers(v []*GroupIdentifier) *ListGroupsOutput {
	s.GroupIdentifiers = v
	return s
}

// SetGroups sets the Groups field's value.
func (s *ListGroupsOutput) SetGroups(v []*Group) *ListGroupsOutput {
	s.Groups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsOutput) SetNextToken(v string) *ListGroupsOutput {
	s.NextToken = &v
	return s
}

// The request uses an HTTP method that isn't allowed for the specified resource.
type MethodNotAllowedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s MethodNotAllowedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MethodNotAllowedException) GoString() string {
	return s.String()
}

func newErrorMethodNotAllowedException(v protocol.ResponseMetadata) error {
	return &MethodNotAllowedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MethodNotAllowedException) Code() string {
	return "MethodNotAllowedException"
}

// Message returns the exception's message.
func (s *MethodNotAllowedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MethodNotAllowedException) OrigErr() error {
	return nil
}

func (s *MethodNotAllowedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MethodNotAllowedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MethodNotAllowedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One or more of the specified resources don't exist.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A two-part error structure that can occur in ListGroupResources or SearchResources
// operations on CloudFormation stack-based queries. The error occurs if the
// CloudFormation stack on which the query is based either does not exist, or
// has a status that renders the stack inactive. A QueryError occurrence does
// not necessarily mean that AWS Resource Groups could not complete the operation,
// but the resulting group might have no member resources.
type QueryError struct {
	_ struct{} `type:"structure"`

	// Possible values are CLOUDFORMATION_STACK_INACTIVE and CLOUDFORMATION_STACK_NOT_EXISTING.
	ErrorCode *string `type:"string" enum:"QueryErrorCode"`

	// A message that explains the ErrorCode value. Messages might state that the
	// specified CloudFormation stack does not exist (or no longer exists). For
	// CLOUDFORMATION_STACK_INACTIVE, the message typically states that the CloudFormation
	// stack has a status that is not (or no longer) active, such as CREATE_FAILED.
	Message *string `type:"string"`
}

// String returns the string representation
func (s QueryError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *QueryError) SetErrorCode(v string) *QueryError {
	s.ErrorCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *QueryError) SetMessage(v string) *QueryError {
	s.Message = &v
	return s
}

// A filter name and value pair that is used to obtain more specific results
// from a list of resources.
type ResourceFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. Filter names are case-sensitive.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"ResourceFilterName"`

	// One or more filter values. Allowed filter values vary by resource filter
	// name, and are case-sensitive.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s ResourceFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ResourceFilter) SetName(v string) *ResourceFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ResourceFilter) SetValues(v []*string) *ResourceFilter {
	s.Values = v
	return s
}

// The ARN of a resource, and its resource type.
type ResourceIdentifier struct {
	_ struct{} `type:"structure"`

	// The ARN of a resource.
	ResourceArn *string `type:"string"`

	// The resource type of a resource, such as AWS::EC2::Instance.
	ResourceType *string `type:"string"`
}

// String returns the string representation
func (s ResourceIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceIdentifier) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ResourceIdentifier) SetResourceArn(v string) *ResourceIdentifier {
	s.ResourceArn = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceIdentifier) SetResourceType(v string) *ResourceIdentifier {
	s.ResourceType = &v
	return s
}

// The query that is used to define a resource group or a search for resources.
// A query specifies both a query type and a query string as a JSON object.
// See the examples section for example JSON strings.
//
// The examples that follow are shown as standard JSON strings. If you include
// such a string as a parameter to the AWS CLI or an SDK API, you might need
// to 'escape' the string into a single line. For example, see the Quoting strings
// (https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-quoting-strings.html)
// in the AWS CLI User Guide.
//
// Example 1
//
// The following generic example shows a resource query JSON string that includes
// only resources that meet the following criteria:
//
//    * The resource type must be either resource_type1 or resource_type2.
//
//    * The resource must have a tag Key1 with a value of either ValueA or ValueB.
//
//    * The resource must have a tag Key2 with a value of either ValueC or ValueD.
//
// { "Type": "TAG_FILTERS_1_0", "Query": { "ResourceTypeFilters": [ "resource_type1",
// "resource_type2"], "TagFilters": [ { "Key": "Key1", "Values": ["ValueA","ValueB"]
// }, { "Key":"Key2", "Values":["ValueC","ValueD"] } ] } }
//
// This has the equivalent "shortcut" syntax of the following:
//
// { "Type": "TAG_FILTERS_1_0", "Query": { "ResourceTypeFilters": [ "resource_type1",
// "resource_type2"], "TagFilters": [ { "Key1": ["ValueA","ValueB"] }, { "Key2":
// ["ValueC","ValueD"] } ] } }
//
// Example 2
//
// The following example shows a resource query JSON string that includes only
// Amazon EC2 instances that are tagged Stage with a value of Test.
//
// { "Type": "TAG_FILTERS_1_0", "Query": "{ "ResourceTypeFilters": "AWS::EC2::Instance",
// "TagFilters": { "Stage": "Test" } } }
//
// Example 3
//
// The following example shows a resource query JSON string that includes resource
// of any supported type as long as it is tagged Stage with a value of Prod.
//
// { "Type": "TAG_FILTERS_1_0", "Query": { "ResourceTypeFilters": "AWS::AllSupported",
// "TagFilters": { "Stage": "Prod" } } }
//
// Example 4
//
// The following example shows a resource query JSON string that includes only
// Amazon EC2 instances and Amazon S3 buckets that are part of the specified
// AWS CloudFormation stack.
//
// { "Type": "CLOUDFORMATION_STACK_1_0", "Query": { "ResourceTypeFilters": [
// "AWS::EC2::Instance", "AWS::S3::Bucket" ], "StackIdentifier": "arn:aws:cloudformation:us-west-2:123456789012:stack/AWStestuseraccount/fb0d5000-aba8-00e8-aa9e-50d5cEXAMPLE"
// } }
type ResourceQuery struct {
	_ struct{} `type:"structure"`

	// The query that defines a group or a search.
	//
	// Query is a required field
	Query *string `type:"string" required:"true"`

	// The type of the query. You can use the following values:
	//
	//    * CLOUDFORMATION_STACK_1_0: Specifies that the Query contains an ARN for
	//    a CloudFormation stack.
	//
	//    * TAG_FILTERS_1_0: Specifies that the Query parameter contains a JSON
	//    string that represents a collection of simple tag filters for resource
	//    types and tags. The JSON string uses a syntax similar to the GetResources
	//    (https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html)
	//    operation, but uses only the ResourceTypeFilters (https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html#resourcegrouptagging-GetResources-request-ResourceTypeFilters)
	//    and TagFilters (https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html#resourcegrouptagging-GetResources-request-TagFiltersTagFilters)
	//    fields. If you specify more than one tag key, only resources that match
	//    all tag keys, and at least one value of each specified tag key, are returned
	//    in your query. If you specify more than one value for a tag key, a resource
	//    matches the filter if it has a tag key value that matches any of the specified
	//    values. For example, consider the following sample query for resources
	//    that have two tags, Stage and Version, with two values each: [{"Stage":["Test","Deploy"]},{"Version":["1","2"]}]
	//    The results of this query could include the following. An EC2 instance
	//    that has the following two tags: {"Stage":"Deploy"}, and {"Version":"2"}
	//    An S3 bucket that has the following two tags: {"Stage":"Test"}, and {"Version":"1"}
	//    The query would not include the following items in the results, however.
	//    An EC2 instance that has only the following tag: {"Stage":"Deploy"}. The
	//    instance does not have all of the tag keys specified in the filter, so
	//    it is excluded from the results. An RDS database that has the following
	//    two tags: {"Stage":"Archived"} and {"Version":"4"} The database has all
	//    of the tag keys, but none of those keys has an associated value that matches
	//    at least one of the specified values in the filter.
	//
	// Type is a required field
	Type *string `min:"1" type:"string" required:"true" enum:"QueryType"`
}

// String returns the string representation
func (s ResourceQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceQuery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceQuery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceQuery"}
	if s.Query == nil {
		invalidParams.Add(request.NewErrParamRequired("Query"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQuery sets the Query field's value.
func (s *ResourceQuery) SetQuery(v string) *ResourceQuery {
	s.Query = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResourceQuery) SetType(v string) *ResourceQuery {
	s.Type = &v
	return s
}

type SearchResourcesInput struct {
	_ struct{} `type:"structure"`

	// The total number of results that you want included on each page of the response.
	// If you do not include this parameter, it defaults to a value that is specific
	// to the operation. If additional items exist beyond the maximum you specify,
	// the NextToken response element is present and has a value (is not null).
	// Include that value as the NextToken request parameter in the next call to
	// the operation to get the next part of the results. Note that the service
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that
	// you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more
	// output is available. Set this parameter to the value provided by a previous
	// call's NextToken response to indicate where the output should continue from.
	NextToken *string `type:"string"`

	// The search query, using the same formats that are supported for resource
	// group definition. For more information, see CreateGroup.
	//
	// ResourceQuery is a required field
	ResourceQuery *ResourceQuery `type:"structure" required:"true"`
}

// String returns the string representation
func (s SearchResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceQuery"))
	}
	if s.ResourceQuery != nil {
		if err := s.ResourceQuery.Validate(); err != nil {
			invalidParams.AddNested("ResourceQuery", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchResourcesInput) SetMaxResults(v int64) *SearchResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchResourcesInput) SetNextToken(v string) *SearchResourcesInput {
	s.NextToken = &v
	return s
}

// SetResourceQuery sets the ResourceQuery field's value.
func (s *SearchResourcesInput) SetResourceQuery(v *ResourceQuery) *SearchResourcesInput {
	s.ResourceQuery = v
	return s
}

type SearchResourcesOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You
	// should repeat this until the NextToken response element comes back as null.
	NextToken *string `type:"string"`

	// A list of QueryError objects. Each error is an object that contains ErrorCode
	// and Message structures. Possible values for ErrorCode are CLOUDFORMATION_STACK_INACTIVE
	// and CLOUDFORMATION_STACK_NOT_EXISTING.
	QueryErrors []*QueryError `type:"list"`

	// The ARNs and resource types of resources that are members of the group that
	// you specified.
	ResourceIdentifiers []*ResourceIdentifier `type:"list"`
}

// String returns the string representation
func (s SearchResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchResourcesOutput) SetNextToken(v string) *SearchResourcesOutput {
	s.NextToken = &v
	return s
}

// SetQueryErrors sets the QueryErrors field's value.
func (s *SearchResourcesOutput) SetQueryErrors(v []*QueryError) *SearchResourcesOutput {
	s.QueryErrors = v
	return s
}

// SetResourceIdentifiers sets the ResourceIdentifiers field's value.
func (s *SearchResourcesOutput) SetResourceIdentifiers(v []*ResourceIdentifier) *SearchResourcesOutput {
	s.ResourceIdentifiers = v
	return s
}

type TagInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource group to which to add tags.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"Arn" min:"12" type:"string" required:"true"`

	// The tags to add to the specified resource group. A tag is a string-to-string
	// map of key-value pairs.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation
func (s TagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 12))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *TagInput) SetArn(v string) *TagInput {
	s.Arn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagInput) SetTags(v map[string]*string) *TagInput {
	s.Tags = v
	return s
}

type TagOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the tagged resource.
	Arn *string `min:"12" type:"string"`

	// The tags that have been added to the specified resource group.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s TagOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *TagOutput) SetArn(v string) *TagOutput {
	s.Arn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagOutput) SetTags(v map[string]*string) *TagOutput {
	s.Tags = v
	return s
}

// You've exceeded throttling limits by making too many requests in a period
// of time.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because it doesn't have valid credentials for the
// target resource.
type UnauthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s UnauthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnauthorizedException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedException(v protocol.ResponseMetadata) error {
	return &UnauthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedException) Code() string {
	return "UnauthorizedException"
}

// Message returns the exception's message.
func (s *UnauthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedException) OrigErr() error {
	return nil
}

func (s *UnauthorizedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UngroupResourcesInput struct {
	_ struct{} `type:"structure"`

	// The name or the ARN of the resource group from which to remove the resources.
	//
	// Group is a required field
	Group *string `min:"1" type:"string" required:"true"`

	// The ARNs of the resources to be removed from the group.
	//
	// ResourceArns is a required field
	ResourceArns []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UngroupResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UngroupResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UngroupResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UngroupResourcesInput"}
	if s.Group == nil {
		invalidParams.Add(request.NewErrParamRequired("Group"))
	}
	if s.Group != nil && len(*s.Group) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Group", 1))
	}
	if s.ResourceArns == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArns"))
	}
	if s.ResourceArns != nil && len(s.ResourceArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroup sets the Group field's value.
func (s *UngroupResourcesInput) SetGroup(v string) *UngroupResourcesInput {
	s.Group = &v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *UngroupResourcesInput) SetResourceArns(v []*string) *UngroupResourcesInput {
	s.ResourceArns = v
	return s
}

type UngroupResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The resources that failed to be removed from the group.
	Failed []*FailedResource `type:"list"`

	// The ARNs of the resources that were successfully removed from the group.
	Succeeded []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s UngroupResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UngroupResourcesOutput) GoString() string {
	return s.String()
}

// SetFailed sets the Failed field's value.
func (s *UngroupResourcesOutput) SetFailed(v []*FailedResource) *UngroupResourcesOutput {
	s.Failed = v
	return s
}

// SetSucceeded sets the Succeeded field's value.
func (s *UngroupResourcesOutput) SetSucceeded(v []*string) *UngroupResourcesOutput {
	s.Succeeded = v
	return s
}

type UntagInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource group from which to remove tags. The command removed
	// both the specified keys and any values associated with those keys.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"Arn" min:"12" type:"string" required:"true"`

	// The keys of the tags to be removed.
	//
	// Keys is a required field
	Keys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 12))
	}
	if s.Keys == nil {
		invalidParams.Add(request.NewErrParamRequired("Keys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UntagInput) SetArn(v string) *UntagInput {
	s.Arn = &v
	return s
}

// SetKeys sets the Keys field's value.
func (s *UntagInput) SetKeys(v []*string) *UntagInput {
	s.Keys = v
	return s
}

type UntagOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource group from which tags have been removed.
	Arn *string `min:"12" type:"string"`

	// The keys of the tags that were removed.
	Keys []*string `type:"list"`
}

// String returns the string representation
func (s UntagOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UntagOutput) SetArn(v string) *UntagOutput {
	s.Arn = &v
	return s
}

// SetKeys sets the Keys field's value.
func (s *UntagOutput) SetKeys(v []*string) *UntagOutput {
	s.Keys = v
	return s
}

type UpdateGroupInput struct {
	_ struct{} `type:"structure"`

	// The new description that you want to update the resource group with. Descriptions
	// can contain letters, numbers, hyphens, underscores, periods, and spaces.
	Description *string `type:"string"`

	// The name or the ARN of the resource group to modify.
	Group *string `min:"1" type:"string"`

	// Don't use this parameter. Use Group instead.
	//
	// Deprecated: This field is deprecated, use Group instead.
	GroupName *string `min:"1" deprecated:"true" type:"string"`
}

// String returns the string representation
func (s UpdateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGroupInput"}
	if s.Group != nil && len(*s.Group) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Group", 1))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateGroupInput) SetDescription(v string) *UpdateGroupInput {
	s.Description = &v
	return s
}

// SetGroup sets the Group field's value.
func (s *UpdateGroupInput) SetGroup(v string) *UpdateGroupInput {
	s.Group = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *UpdateGroupInput) SetGroupName(v string) *UpdateGroupInput {
	s.GroupName = &v
	return s
}

type UpdateGroupOutput struct {
	_ struct{} `type:"structure"`

	// The update description of the resource group.
	Group *Group `type:"structure"`
}

// String returns the string representation
func (s UpdateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *UpdateGroupOutput) SetGroup(v *Group) *UpdateGroupOutput {
	s.Group = v
	return s
}

type UpdateGroupQueryInput struct {
	_ struct{} `type:"structure"`

	// The name or the ARN of the resource group to query.
	Group *string `min:"1" type:"string"`

	// Don't use this parameter. Use Group instead.
	//
	// Deprecated: This field is deprecated, use Group instead.
	GroupName *string `min:"1" deprecated:"true" type:"string"`

	// The resource query to determine which AWS resources are members of this resource
	// group.
	//
	// ResourceQuery is a required field
	ResourceQuery *ResourceQuery `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateGroupQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGroupQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGroupQueryInput"}
	if s.Group != nil && len(*s.Group) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Group", 1))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.ResourceQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceQuery"))
	}
	if s.ResourceQuery != nil {
		if err := s.ResourceQuery.Validate(); err != nil {
			invalidParams.AddNested("ResourceQuery", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroup sets the Group field's value.
func (s *UpdateGroupQueryInput) SetGroup(v string) *UpdateGroupQueryInput {
	s.Group = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *UpdateGroupQueryInput) SetGroupName(v string) *UpdateGroupQueryInput {
	s.GroupName = &v
	return s
}

// SetResourceQuery sets the ResourceQuery field's value.
func (s *UpdateGroupQueryInput) SetResourceQuery(v *ResourceQuery) *UpdateGroupQueryInput {
	s.ResourceQuery = v
	return s
}

type UpdateGroupQueryOutput struct {
	_ struct{} `type:"structure"`

	// The updated resource query associated with the resource group after the update.
	GroupQuery *GroupQuery `type:"structure"`
}

// String returns the string representation
func (s UpdateGroupQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupQueryOutput) GoString() string {
	return s.String()
}

// SetGroupQuery sets the GroupQuery field's value.
func (s *UpdateGroupQueryOutput) SetGroupQuery(v *GroupQuery) *UpdateGroupQueryOutput {
	s.GroupQuery = v
	return s
}

const (
	// GroupConfigurationStatusUpdating is a GroupConfigurationStatus enum value
	GroupConfigurationStatusUpdating = "UPDATING"

	// GroupConfigurationStatusUpdateComplete is a GroupConfigurationStatus enum value
	GroupConfigurationStatusUpdateComplete = "UPDATE_COMPLETE"

	// GroupConfigurationStatusUpdateFailed is a GroupConfigurationStatus enum value
	GroupConfigurationStatusUpdateFailed = "UPDATE_FAILED"
)

// GroupConfigurationStatus_Values returns all elements of the GroupConfigurationStatus enum
func GroupConfigurationStatus_Values() []string {
	return []string{
		GroupConfigurationStatusUpdating,
		GroupConfigurationStatusUpdateComplete,
		GroupConfigurationStatusUpdateFailed,
	}
}

const (
	// GroupFilterNameResourceType is a GroupFilterName enum value
	GroupFilterNameResourceType = "resource-type"

	// GroupFilterNameConfigurationType is a GroupFilterName enum value
	GroupFilterNameConfigurationType = "configuration-type"
)

// GroupFilterName_Values returns all elements of the GroupFilterName enum
func GroupFilterName_Values() []string {
	return []string{
		GroupFilterNameResourceType,
		GroupFilterNameConfigurationType,
	}
}

const (
	// QueryErrorCodeCloudformationStackInactive is a QueryErrorCode enum value
	QueryErrorCodeCloudformationStackInactive = "CLOUDFORMATION_STACK_INACTIVE"

	// QueryErrorCodeCloudformationStackNotExisting is a QueryErrorCode enum value
	QueryErrorCodeCloudformationStackNotExisting = "CLOUDFORMATION_STACK_NOT_EXISTING"
)

// QueryErrorCode_Values returns all elements of the QueryErrorCode enum
func QueryErrorCode_Values() []string {
	return []string{
		QueryErrorCodeCloudformationStackInactive,
		QueryErrorCodeCloudformationStackNotExisting,
	}
}

const (
	// QueryTypeTagFilters10 is a QueryType enum value
	QueryTypeTagFilters10 = "TAG_FILTERS_1_0"

	// QueryTypeCloudformationStack10 is a QueryType enum value
	QueryTypeCloudformationStack10 = "CLOUDFORMATION_STACK_1_0"
)

// QueryType_Values returns all elements of the QueryType enum
func QueryType_Values() []string {
	return []string{
		QueryTypeTagFilters10,
		QueryTypeCloudformationStack10,
	}
}

const (
	// ResourceFilterNameResourceType is a ResourceFilterName enum value
	ResourceFilterNameResourceType = "resource-type"
)

// ResourceFilterName_Values returns all elements of the ResourceFilterName enum
func ResourceFilterName_Values() []string {
	return []string{
		ResourceFilterNameResourceType,
	}
}
