/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.bsd;

import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.bsd.RExecClient;
import org.apache.commons.net.io.SocketInputStream;

public class RCommandClient
extends RExecClient {
    public static final int DEFAULT_PORT = 514;
    public static final int MIN_CLIENT_PORT = 512;
    public static final int MAX_CLIENT_PORT = 1023;

    public RCommandClient() {
        this.setDefaultPort(514);
    }

    @Override
    public void connect(InetAddress host, int port) throws SocketException, IOException {
        this.connect(host, port, InetAddress.getLocalHost());
    }

    public void connect(InetAddress host, int port, InetAddress localAddr) throws SocketException, BindException, IOException {
        int localPort;
        for (localPort = 1023; localPort >= 512; --localPort) {
            try {
                this._socket_ = this._socketFactory_.createSocket(host, port, localAddr, localPort);
                break;
            }
            catch (SocketException e) {
                continue;
            }
        }
        if (localPort < 512) {
            throw new BindException("All ports in use or insufficient permssion.");
        }
        this._connectAction_();
    }

    @Override
    public void connect(InetAddress host, int port, InetAddress localAddr, int localPort) throws SocketException, IOException, IllegalArgumentException {
        if (localPort < 512 || localPort > 1023) {
            throw new IllegalArgumentException("Invalid port number " + localPort);
        }
        super.connect(host, port, localAddr, localPort);
    }

    @Override
    public void connect(String hostname, int port) throws SocketException, IOException, UnknownHostException {
        this.connect(InetAddress.getByName(hostname), port, InetAddress.getLocalHost());
    }

    public void connect(String hostname, int port, InetAddress localAddr) throws SocketException, IOException {
        this.connect(InetAddress.getByName(hostname), port, localAddr);
    }

    @Override
    public void connect(String hostname, int port, InetAddress localAddr, int localPort) throws SocketException, IOException, IllegalArgumentException, UnknownHostException {
        if (localPort < 512 || localPort > 1023) {
            throw new IllegalArgumentException("Invalid port number " + localPort);
        }
        super.connect(hostname, port, localAddr, localPort);
    }

    @Override
    InputStream createErrorStream() throws IOException {
        Socket socket;
        try (ServerSocket server = this.createServer();){
            this._output_.write(Integer.toString(server.getLocalPort()).getBytes(StandardCharsets.UTF_8));
            this._output_.write(0);
            this._output_.flush();
            socket = server.accept();
        }
        if (this.isRemoteVerificationEnabled() && !this.verifyRemote(socket)) {
            String hostAddress = RCommandClient.getHostAddress(socket);
            IOUtils.closeQuietly((Socket)socket);
            throw new IOException("Security violation: unexpected connection attempt by " + hostAddress);
        }
        return new SocketInputStream(socket, socket.getInputStream());
    }

    private ServerSocket createServer() throws IOException {
        for (int localPort = 1023; localPort >= 512; --localPort) {
            try {
                return this._serverSocketFactory_.createServerSocket(localPort, 1, this.getLocalAddress());
            }
            catch (SocketException e) {
                continue;
            }
        }
        throw new BindException("All ports in use.");
    }

    public void rcommand(String localUser, String remoteUser, String command) throws IOException {
        this.rcommand(localUser, remoteUser, command, false);
    }

    public void rcommand(String localUser, String remoteUser, String command, boolean separateErrorStream) throws IOException {
        this.rexec(localUser, remoteUser, command, separateErrorStream);
    }
}

