## upterm session current

Display the current terminal session

### Synopsis

Display the current terminal session.

By default, reads the admin socket path from $UPTERM_ADMIN_SOCKET (automatically set
when you run 'upterm host').

Sockets are stored in: /run/user/1000/upterm

Follows the XDG Base Directory Specification with fallback to $HOME/.upterm
in constrained environments where XDG directories are unavailable.

Output formats:
  -o json                           JSON output
  -o go-template='{{.ClientCount}}' Custom Go template

Template variables: SessionID, ClientCount, Host, Command, ForceCommand

```
upterm session current [flags]
```

### Examples

```
  # Display the active session as defined in $UPTERM_ADMIN_SOCKET:
  upterm session current

  # Output as JSON:
  upterm session current -o json

  # Custom format for shell prompt (outputs nothing if not in session):
  upterm session current -o go-template='🆙 {{.ClientCount}} '

  # For terminal title:
  upterm session current -o go-template='upterm: {{.ClientCount}} clients | {{.SessionID}}'
```

### Options

```
      --admin-socket string   Admin socket path (required).
  -h, --help                  help for current
      --hide-client-ip        Hide client IP addresses from output (auto-enabled in CI environments).
  -o, --output string         Output format: json or go-template='...'
```

### Options inherited from parent commands

```
      --debug   enable debug level logging (log file: /home/user/.local/state/upterm/upterm.log).
```

### SEE ALSO

* [upterm session](upterm_session.md)	 - Display and manage terminal sessions

###### Auto generated by spf13/cobra on 12-Jan-2026
