// The below polyfills are from open-source libraries
//
// XMLDOM
// https://github.com/xmldom/xmldom
// MIT license: https://github.com/xmldom/xmldom/blob/master/LICENSE
//
// WGXPATH
// https://github.com/google/wicked-good-xpath
// MIT license: https://github.com/google/wicked-good-xpath/blob/master/LICENSE
//
function find(e,t,n){if(void 0===n&&(n=Array.prototype),e&&"function"==typeof n.find)return n.find.call(e,t);for(var r=0;r<e.length;r++)if(Object.prototype.hasOwnProperty.call(e,r)){var o=e[r];if(t.call(void 0,o,r,e))return o}}function freeze(e,t){return void 0===t&&(t=Object),t&&"function"==typeof t.freeze?t.freeze(e):e}function assign(e,t){if(null===e||"object"!=typeof e)throw new TypeError("target is not an object");for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[n]=t[n]);return e}var MIME_TYPE=freeze({HTML:"text/html",isHTML:function(e){return e===MIME_TYPE.HTML},XML_APPLICATION:"application/xml",XML_TEXT:"text/xml",XML_XHTML_APPLICATION:"application/xhtml+xml",XML_SVG_IMAGE:"image/svg+xml"}),NAMESPACE=freeze({HTML:"http://www.w3.org/1999/xhtml",isHTML:function(e){return e===NAMESPACE.HTML},SVG:"http://www.w3.org/2000/svg",XML:"http://www.w3.org/XML/1998/namespace",XMLNS:"http://www.w3.org/2000/xmlns/"});function notEmptyString(e){return""!==e}function splitOnASCIIWhitespace(e){return e?e.split(/[\t\n\f\r ]+/).filter(notEmptyString):[]}function orderedSetReducer(e,t){return e.hasOwnProperty(t)||(e[t]=!0),e}function toOrderedSet(e){if(!e)return[];e=splitOnASCIIWhitespace(e);return Object.keys(e.reduce(orderedSetReducer,{}))}function arrayIncludes(t){return function(e){return t&&-1!==t.indexOf(e)}}function copy(e,t){for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n])}function _extends(e,t){var n=e.prototype;function r(){}n instanceof t||(r.prototype=t.prototype,copy(n,r=new r),e.prototype=n=r),n.constructor!=e&&("function"!=typeof e&&console.error("unknown Class:"+e),n.constructor=e)}var NodeType={},ELEMENT_NODE=NodeType.ELEMENT_NODE=1,ATTRIBUTE_NODE=NodeType.ATTRIBUTE_NODE=2,TEXT_NODE=NodeType.TEXT_NODE=3,CDATA_SECTION_NODE=NodeType.CDATA_SECTION_NODE=4,ENTITY_REFERENCE_NODE=NodeType.ENTITY_REFERENCE_NODE=5,ENTITY_NODE=NodeType.ENTITY_NODE=6,PROCESSING_INSTRUCTION_NODE=NodeType.PROCESSING_INSTRUCTION_NODE=7,COMMENT_NODE=NodeType.COMMENT_NODE=8,DOCUMENT_NODE=NodeType.DOCUMENT_NODE=9,DOCUMENT_TYPE_NODE=NodeType.DOCUMENT_TYPE_NODE=10,DOCUMENT_FRAGMENT_NODE=NodeType.DOCUMENT_FRAGMENT_NODE=11,NOTATION_NODE=NodeType.NOTATION_NODE=12,ExceptionCode={},ExceptionMessage={},INDEX_SIZE_ERR=ExceptionCode.INDEX_SIZE_ERR=(ExceptionMessage[1]="Index size error",1),DOMSTRING_SIZE_ERR=ExceptionCode.DOMSTRING_SIZE_ERR=(ExceptionMessage[2]="DOMString size error",2),HIERARCHY_REQUEST_ERR=ExceptionCode.HIERARCHY_REQUEST_ERR=(ExceptionMessage[3]="Hierarchy request error",3),WRONG_DOCUMENT_ERR=ExceptionCode.WRONG_DOCUMENT_ERR=(ExceptionMessage[4]="Wrong document",4),INVALID_CHARACTER_ERR=ExceptionCode.INVALID_CHARACTER_ERR=(ExceptionMessage[5]="Invalid character",5),NO_DATA_ALLOWED_ERR=ExceptionCode.NO_DATA_ALLOWED_ERR=(ExceptionMessage[6]="No data allowed",6),NO_MODIFICATION_ALLOWED_ERR=ExceptionCode.NO_MODIFICATION_ALLOWED_ERR=(ExceptionMessage[7]="No modification allowed",7),NOT_FOUND_ERR=ExceptionCode.NOT_FOUND_ERR=(ExceptionMessage[8]="Not found",8),NOT_SUPPORTED_ERR=ExceptionCode.NOT_SUPPORTED_ERR=(ExceptionMessage[9]="Not supported",9),INUSE_ATTRIBUTE_ERR=ExceptionCode.INUSE_ATTRIBUTE_ERR=(ExceptionMessage[10]="Attribute in use",10),INVALID_STATE_ERR=ExceptionCode.INVALID_STATE_ERR=(ExceptionMessage[11]="Invalid state",11),SYNTAX_ERR=ExceptionCode.SYNTAX_ERR=(ExceptionMessage[12]="Syntax error",12),INVALID_MODIFICATION_ERR=ExceptionCode.INVALID_MODIFICATION_ERR=(ExceptionMessage[13]="Invalid modification",13),NAMESPACE_ERR=ExceptionCode.NAMESPACE_ERR=(ExceptionMessage[14]="Invalid namespace",14),INVALID_ACCESS_ERR=ExceptionCode.INVALID_ACCESS_ERR=(ExceptionMessage[15]="Invalid access",15);function DOMException(e,t){var n;return t instanceof Error?n=t:(n=this,Error.call(this,ExceptionMessage[e]),this.message=ExceptionMessage[e],Error.captureStackTrace&&Error.captureStackTrace(this,DOMException)),n.code=e,t&&(this.message=this.message+": "+t),n}function NodeList(){}function LiveNodeList(e,t){this._node=e,this._refresh=t,_updateLiveList(this)}function _updateLiveList(e){var t,n=e._node._inc||e._node.ownerDocument._inc;e._inc!=n&&(t=e._refresh(e._node),__set__(e,"length",t.length),copy(t,e),e._inc=n)}function NamedNodeMap(){}function _findNodeIndex(e,t){for(var n=e.length;n--;)if(e[n]===t)return n}function _addNamedNode(e,t,n,r){r?t[_findNodeIndex(t,r)]=n:t[t.length++]=n,!e||(t=(n.ownerElement=e).ownerDocument)&&(r&&_onRemoveAttribute(t,e,r),_onAddAttribute(t,e,n))}function _removeNamedNode(e,t,n){var r=_findNodeIndex(t,n);if(!(0<=r))throw new DOMException(NOT_FOUND_ERR,new Error(e.tagName+"@"+n));for(var o,i=t.length-1;r<i;)t[r]=t[++r];t.length=i,!e||(o=e.ownerDocument)&&(_onRemoveAttribute(o,e,n),n.ownerElement=null)}function DOMImplementation(){}function Node(){}function _xmlEncoder(e){return("<"==e?"&lt;":">"==e&&"&gt;")||"&"==e&&"&amp;"||'"'==e&&"&quot;"||"&#"+e.charCodeAt()+";"}function _visitNode(e,t){if(t(e))return!0;if(e=e.firstChild)do{if(_visitNode(e,t))return!0}while(e=e.nextSibling)}function Document(){this.ownerDocument=this}function _onAddAttribute(e,t,n){e&&e._inc++,n.namespaceURI===NAMESPACE.XMLNS&&(t._nsMap[n.prefix?n.localName:""]=n.value)}function _onRemoveAttribute(e,t,n,r){e&&e._inc++,n.namespaceURI===NAMESPACE.XMLNS&&delete t._nsMap[n.prefix?n.localName:""]}function _onUpdateChild(e,t,n){if(e&&e._inc){e._inc++;var r=t.childNodes;if(n)r[r.length++]=n;else{for(var o=t.firstChild,i=0;o;)o=(r[i++]=o).nextSibling;r.length=i,delete r[r.length]}}}function _removeChild(e,t){var n=t.previousSibling,r=t.nextSibling;return n?n.nextSibling=r:e.firstChild=r,r?r.previousSibling=n:e.lastChild=n,t.parentNode=null,t.previousSibling=null,t.nextSibling=null,_onUpdateChild(e.ownerDocument,e),t}function hasValidParentNodeType(e){return e&&(e.nodeType===Node.DOCUMENT_NODE||e.nodeType===Node.DOCUMENT_FRAGMENT_NODE||e.nodeType===Node.ELEMENT_NODE)}function hasInsertableNodeType(e){return e&&(isElementNode(e)||isTextNode(e)||isDocTypeNode(e)||e.nodeType===Node.DOCUMENT_FRAGMENT_NODE||e.nodeType===Node.COMMENT_NODE||e.nodeType===Node.PROCESSING_INSTRUCTION_NODE)}function isDocTypeNode(e){return e&&e.nodeType===Node.DOCUMENT_TYPE_NODE}function isElementNode(e){return e&&e.nodeType===Node.ELEMENT_NODE}function isTextNode(e){return e&&e.nodeType===Node.TEXT_NODE}function isElementInsertionPossible(e,t){var n=e.childNodes||[];if(find(n,isElementNode)||isDocTypeNode(t))return!1;e=find(n,isDocTypeNode);return!(t&&e&&n.indexOf(e)>n.indexOf(t))}function isElementReplacementPossible(e,t){var n=e.childNodes||[];if(find(n,function(e){return isElementNode(e)&&e!==t}))return!1;e=find(n,isDocTypeNode);return!(t&&e&&n.indexOf(e)>n.indexOf(t))}function assertPreInsertionValidity1to5(e,t,n){if(!hasValidParentNodeType(e))throw new DOMException(HIERARCHY_REQUEST_ERR,"Unexpected parent node type "+e.nodeType);if(n&&n.parentNode!==e)throw new DOMException(NOT_FOUND_ERR,"child not in parent");if(!hasInsertableNodeType(t)||isDocTypeNode(t)&&e.nodeType!==Node.DOCUMENT_NODE)throw new DOMException(HIERARCHY_REQUEST_ERR,"Unexpected node type "+t.nodeType+" for parent node type "+e.nodeType)}function assertPreInsertionValidityInDocument(e,t,n){var r=e.childNodes||[],o=t.childNodes||[];if(t.nodeType===Node.DOCUMENT_FRAGMENT_NODE){var i=o.filter(isElementNode);if(1<i.length||find(o,isTextNode))throw new DOMException(HIERARCHY_REQUEST_ERR,"More than one element or text in fragment");if(1===i.length&&!isElementInsertionPossible(e,n))throw new DOMException(HIERARCHY_REQUEST_ERR,"Element in fragment can not be inserted before doctype")}if(isElementNode(t)&&!isElementInsertionPossible(e,n))throw new DOMException(HIERARCHY_REQUEST_ERR,"Only one element can be added and only after doctype");if(isDocTypeNode(t)){if(find(r,isDocTypeNode))throw new DOMException(HIERARCHY_REQUEST_ERR,"Only one doctype is allowed");t=find(r,isElementNode);if(n&&r.indexOf(t)<r.indexOf(n))throw new DOMException(HIERARCHY_REQUEST_ERR,"Doctype can only be inserted before an element");if(!n&&t)throw new DOMException(HIERARCHY_REQUEST_ERR,"Doctype can not be appended since element is present")}}function assertPreReplacementValidityInDocument(e,t,n){var r=e.childNodes||[],o=t.childNodes||[];if(t.nodeType===Node.DOCUMENT_FRAGMENT_NODE){var i=o.filter(isElementNode);if(1<i.length||find(o,isTextNode))throw new DOMException(HIERARCHY_REQUEST_ERR,"More than one element or text in fragment");if(1===i.length&&!isElementReplacementPossible(e,n))throw new DOMException(HIERARCHY_REQUEST_ERR,"Element in fragment can not be inserted before doctype")}if(isElementNode(t)&&!isElementReplacementPossible(e,n))throw new DOMException(HIERARCHY_REQUEST_ERR,"Only one element can be added and only after doctype");if(isDocTypeNode(t)){if(find(r,function(e){return isDocTypeNode(e)&&e!==n}))throw new DOMException(HIERARCHY_REQUEST_ERR,"Only one doctype is allowed");t=find(r,isElementNode);if(n&&r.indexOf(t)<r.indexOf(n))throw new DOMException(HIERARCHY_REQUEST_ERR,"Doctype can only be inserted before an element")}}function _insertBefore(e,t,n,r){assertPreInsertionValidity1to5(e,t,n),e.nodeType===Node.DOCUMENT_NODE&&(r||assertPreInsertionValidityInDocument)(e,t,n);r=t.parentNode;if(r&&r.removeChild(t),t.nodeType===DOCUMENT_FRAGMENT_NODE){var o=t.firstChild;if(null==o)return t;var i=t.lastChild}else o=i=t;r=n?n.previousSibling:e.lastChild;for(o.previousSibling=r,i.nextSibling=n,r?r.nextSibling=o:e.firstChild=o,null==n?e.lastChild=i:n.previousSibling=i;o.parentNode=e,o!==i&&(o=o.nextSibling););return _onUpdateChild(e.ownerDocument||e,e),t.nodeType==DOCUMENT_FRAGMENT_NODE&&(t.firstChild=t.lastChild=null),t}function _appendSingleChild(e,t){return t.parentNode&&t.parentNode.removeChild(t),t.parentNode=e,t.previousSibling=e.lastChild,t.nextSibling=null,t.previousSibling?t.previousSibling.nextSibling=t:e.firstChild=t,e.lastChild=t,_onUpdateChild(e.ownerDocument,e,t),t}function Element(){this._nsMap={}}function Attr(){}function CharacterData(){}function Text(){}function Comment(){}function CDATASection(){}function DocumentType(){}function Notation(){}function Entity(){}function EntityReference(){}function DocumentFragment(){}function ProcessingInstruction(){}function XMLSerializer(){}function nodeSerializeToString(e,t){var n,r=[],o=9==this.nodeType&&this.documentElement||this,i=o.prefix,a=o.namespaceURI;return a&&null==i&&null==(i=o.lookupPrefix(a))&&(n=[{namespace:a,prefix:null}]),serializeToString(this,r,e,t,n),r.join("")}function needNamespaceDefine(e,t,n){var r=e.prefix||"",o=e.namespaceURI;if(!o)return!1;if("xml"===r&&o===NAMESPACE.XML||o===NAMESPACE.XMLNS)return!1;for(var i=n.length;i--;){var a=n[i];if(a.prefix===r)return a.namespace!==o}return!0}function addSerializedAttribute(e,t,n){e.push(" ",t,'="',n.replace(/[<>&"\t\n\r]/g,_xmlEncoder),'"')}function serializeToString(e,t,n,r,o){if(o=o||[],r){if(!(e=r(e)))return;if("string"==typeof e)return void t.push(e)}switch(e.nodeType){case ELEMENT_NODE:var i=e.attributes,a=i.length,s=e.firstChild,c=e.tagName,u=c;if(!(n=NAMESPACE.isHTML(e.namespaceURI)||n)&&!e.prefix&&e.namespaceURI){for(var l,d=0;d<i.length;d++)if("xmlns"===i.item(d).name){l=i.item(d).value;break}if(!l)for(var p=o.length-1;0<=p;p--)if(""===(E=o[p]).prefix&&E.namespace===e.namespaceURI){l=E.namespace;break}if(l!==e.namespaceURI)for(var E,p=o.length-1;0<=p;p--)if((E=o[p]).namespace===e.namespaceURI){E.prefix&&(u=E.prefix+":"+c);break}}t.push("<",u);for(var N=0;N<a;N++)"xmlns"==(m=i.item(N)).prefix?o.push({prefix:m.localName,namespace:m.value}):"xmlns"==m.nodeName&&o.push({prefix:"",namespace:m.value});for(var m,f,h,N=0;N<a;N++)needNamespaceDefine(m=i.item(N),n,o)&&(addSerializedAttribute(t,(f=m.prefix||"")?"xmlns:"+f:"xmlns",h=m.namespaceURI),o.push({prefix:f,namespace:h})),serializeToString(m,t,n,r,o);if(c===u&&needNamespaceDefine(e,n,o)&&(addSerializedAttribute(t,(f=e.prefix||"")?"xmlns:"+f:"xmlns",h=e.namespaceURI),o.push({prefix:f,namespace:h})),s||n&&!/^(?:meta|link|img|br|hr|input)$/i.test(c)){if(t.push(">"),n&&/^script$/i.test(c))for(;s;)s.data?t.push(s.data):serializeToString(s,t,n,r,o.slice()),s=s.nextSibling;else for(;s;)serializeToString(s,t,n,r,o.slice()),s=s.nextSibling;t.push("</",u,">")}else t.push("/>");return;case DOCUMENT_NODE:case DOCUMENT_FRAGMENT_NODE:for(s=e.firstChild;s;)serializeToString(s,t,n,r,o.slice()),s=s.nextSibling;return;case ATTRIBUTE_NODE:return addSerializedAttribute(t,e.name,e.value);case TEXT_NODE:return t.push(e.data.replace(/[<&>]/g,_xmlEncoder));case CDATA_SECTION_NODE:return t.push("<![CDATA[",e.data,"]]>");case COMMENT_NODE:return t.push("\x3c!--",e.data,"--\x3e");case DOCUMENT_TYPE_NODE:var T=e.publicId,_=e.systemId;return t.push("<!DOCTYPE ",e.name),void(T?(t.push(" PUBLIC ",T),_&&"."!=_&&t.push(" ",_),t.push(">")):_&&"."!=_?t.push(" SYSTEM ",_,">"):((_=e.internalSubset)&&t.push(" [",_,"]"),t.push(">")));case PROCESSING_INSTRUCTION_NODE:return t.push("<?",e.target," ",e.data,"?>");case ENTITY_REFERENCE_NODE:return t.push("&",e.nodeName,";");default:t.push("??",e.nodeName)}}function importNode(e,t,n){var r;switch(t.nodeType){case ELEMENT_NODE:(r=t.cloneNode(!1)).ownerDocument=e;case DOCUMENT_FRAGMENT_NODE:break;case ATTRIBUTE_NODE:n=!0}if((r=r||t.cloneNode(!1)).ownerDocument=e,r.parentNode=null,n)for(var o=t.firstChild;o;)r.appendChild(importNode(e,o,n)),o=o.nextSibling;return r}function cloneNode(e,t,n){var r,o,i=new t.constructor;for(r in t)!Object.prototype.hasOwnProperty.call(t,r)||"object"!=typeof(o=t[r])&&o!=i[r]&&(i[r]=o);switch(t.childNodes&&(i.childNodes=new NodeList),i.ownerDocument=e,i.nodeType){case ELEMENT_NODE:var a=t.attributes,s=i.attributes=new NamedNodeMap,c=a.length;s._ownerElement=i;for(var u=0;u<c;u++)i.setAttributeNode(cloneNode(e,a.item(u),!0));break;case ATTRIBUTE_NODE:n=!0}if(n)for(var l=t.firstChild;l;)i.appendChild(cloneNode(e,l,n)),l=l.nextSibling;return i}function __set__(e,t,n){e[t]=n}DOMException.prototype=Error.prototype,copy(ExceptionCode,DOMException),NodeList.prototype={length:0,item:function(e){return this[e]||null},toString:function(e,t){for(var n=[],r=0;r<this.length;r++)serializeToString(this[r],n,e,t);return n.join("")},filter:function(e){return Array.prototype.filter.call(this,e)},indexOf:function(e){return Array.prototype.indexOf.call(this,e)}},LiveNodeList.prototype.item=function(e){return _updateLiveList(this),this[e]},_extends(LiveNodeList,NodeList),NamedNodeMap.prototype={length:0,item:NodeList.prototype.item,getNamedItem:function(e){for(var t=this.length;t--;){var n=this[t];if(n.nodeName==e)return n}},setNamedItem:function(e){var t=e.ownerElement;if(t&&t!=this._ownerElement)throw new DOMException(INUSE_ATTRIBUTE_ERR);t=this.getNamedItem(e.nodeName);return _addNamedNode(this._ownerElement,this,e,t),t},setNamedItemNS:function(e){var t=e.ownerElement;if(t&&t!=this._ownerElement)throw new DOMException(INUSE_ATTRIBUTE_ERR);return t=this.getNamedItemNS(e.namespaceURI,e.localName),_addNamedNode(this._ownerElement,this,e,t),t},removeNamedItem:function(e){e=this.getNamedItem(e);return _removeNamedNode(this._ownerElement,this,e),e},removeNamedItemNS:function(e,t){t=this.getNamedItemNS(e,t);return _removeNamedNode(this._ownerElement,this,t),t},getNamedItemNS:function(e,t){for(var n=this.length;n--;){var r=this[n];if(r.localName==t&&r.namespaceURI==e)return r}return null}},DOMImplementation.prototype={hasFeature:function(e,t){return!0},createDocument:function(e,t,n){var r=new Document;return r.implementation=this,r.childNodes=new NodeList,r.doctype=n||null,n&&r.appendChild(n),t&&(t=r.createElementNS(e,t),r.appendChild(t)),r},createDocumentType:function(e,t,n){var r=new DocumentType;return r.name=e,r.nodeName=e,r.publicId=t||"",r.systemId=n||"",r}},Node.prototype={firstChild:null,lastChild:null,previousSibling:null,nextSibling:null,attributes:null,parentNode:null,childNodes:null,ownerDocument:null,nodeValue:null,namespaceURI:null,prefix:null,localName:null,insertBefore:function(e,t){return _insertBefore(this,e,t)},replaceChild:function(e,t){_insertBefore(this,e,t,assertPreReplacementValidityInDocument),t&&this.removeChild(t)},removeChild:function(e){return _removeChild(this,e)},appendChild:function(e){return this.insertBefore(e,null)},hasChildNodes:function(){return null!=this.firstChild},cloneNode:function(e){return cloneNode(this.ownerDocument||this,this,e)},normalize:function(){for(var e=this.firstChild;e;){var t=e.nextSibling;t&&t.nodeType==TEXT_NODE&&e.nodeType==TEXT_NODE?(this.removeChild(t),e.appendData(t.data)):(e.normalize(),e=t)}},isSupported:function(e,t){return this.ownerDocument.implementation.hasFeature(e,t)},hasAttributes:function(){return 0<this.attributes.length},lookupPrefix:function(e){for(var t=this;t;){var n=t._nsMap;if(n)for(var r in n)if(Object.prototype.hasOwnProperty.call(n,r)&&n[r]===e)return r;t=t.nodeType==ATTRIBUTE_NODE?t.ownerDocument:t.parentNode}return null},lookupNamespaceURI:function(e){for(var t=this;t;){var n=t._nsMap;if(n&&Object.prototype.hasOwnProperty.call(n,e))return n[e];t=t.nodeType==ATTRIBUTE_NODE?t.ownerDocument:t.parentNode}return null},isDefaultNamespace:function(e){return null==this.lookupPrefix(e)}},copy(NodeType,Node),copy(NodeType,Node.prototype),Document.prototype={nodeName:"#document",nodeType:DOCUMENT_NODE,doctype:null,documentElement:null,_inc:1,insertBefore:function(e,t){if(e.nodeType!=DOCUMENT_FRAGMENT_NODE)return _insertBefore(this,e,t),null===(e.ownerDocument=this).documentElement&&e.nodeType===ELEMENT_NODE&&(this.documentElement=e),e;for(var n=e.firstChild;n;){var r=n.nextSibling;this.insertBefore(n,t),n=r}return e},removeChild:function(e){return this.documentElement==e&&(this.documentElement=null),_removeChild(this,e)},replaceChild:function(e,t){_insertBefore(this,e,t,assertPreReplacementValidityInDocument),e.ownerDocument=this,t&&this.removeChild(t),isElementNode(e)&&(this.documentElement=e)},importNode:function(e,t){return importNode(this,e,t)},getElementById:function(t){var n=null;return _visitNode(this.documentElement,function(e){if(e.nodeType==ELEMENT_NODE&&e.getAttribute("id")==t)return n=e,!0}),n},getElementsByClassName:function(i){var a=toOrderedSet(i);return new LiveNodeList(this,function(r){var o=[];return 0<a.length&&_visitNode(r.documentElement,function(e){var t,n;e===r||e.nodeType!==ELEMENT_NODE||(t=e.getAttribute("class"))&&((n=i===t)||(t=toOrderedSet(t),n=a.every(arrayIncludes(t))),n&&o.push(e))}),o})},createElement:function(e){var t=new Element;return t.ownerDocument=this,t.nodeName=e,t.tagName=e,t.localName=e,t.childNodes=new NodeList,(t.attributes=new NamedNodeMap)._ownerElement=t},createDocumentFragment:function(){var e=new DocumentFragment;return e.ownerDocument=this,e.childNodes=new NodeList,e},createTextNode:function(e){var t=new Text;return t.ownerDocument=this,t.appendData(e),t},createComment:function(e){var t=new Comment;return t.ownerDocument=this,t.appendData(e),t},createCDATASection:function(e){var t=new CDATASection;return t.ownerDocument=this,t.appendData(e),t},createProcessingInstruction:function(e,t){var n=new ProcessingInstruction;return n.ownerDocument=this,n.tagName=n.target=e,n.nodeValue=n.data=t,n},createAttribute:function(e){var t=new Attr;return t.ownerDocument=this,t.name=e,t.nodeName=e,t.localName=e,t.specified=!0,t},createEntityReference:function(e){var t=new EntityReference;return t.ownerDocument=this,t.nodeName=e,t},createElementNS:function(e,t){var n=new Element,r=t.split(":"),o=n.attributes=new NamedNodeMap;return n.childNodes=new NodeList,n.ownerDocument=this,n.nodeName=t,n.tagName=t,n.namespaceURI=e,2==r.length?(n.prefix=r[0],n.localName=r[1]):n.localName=t,o._ownerElement=n},createAttributeNS:function(e,t){var n=new Attr,r=t.split(":");return n.ownerDocument=this,n.nodeName=t,n.name=t,n.namespaceURI=e,n.specified=!0,2==r.length?(n.prefix=r[0],n.localName=r[1]):n.localName=t,n}},_extends(Document,Node),Element.prototype={nodeType:ELEMENT_NODE,hasAttribute:function(e){return null!=this.getAttributeNode(e)},getAttribute:function(e){e=this.getAttributeNode(e);return e&&e.value||""},getAttributeNode:function(e){return this.attributes.getNamedItem(e)},setAttribute:function(e,t){e=this.ownerDocument.createAttribute(e);e.value=e.nodeValue=""+t,this.setAttributeNode(e)},removeAttribute:function(e){e=this.getAttributeNode(e);e&&this.removeAttributeNode(e)},appendChild:function(e){return e.nodeType===DOCUMENT_FRAGMENT_NODE?this.insertBefore(e,null):_appendSingleChild(this,e)},setAttributeNode:function(e){return this.attributes.setNamedItem(e)},setAttributeNodeNS:function(e){return this.attributes.setNamedItemNS(e)},removeAttributeNode:function(e){return this.attributes.removeNamedItem(e.nodeName)},removeAttributeNS:function(e,t){t=this.getAttributeNodeNS(e,t);t&&this.removeAttributeNode(t)},hasAttributeNS:function(e,t){return null!=this.getAttributeNodeNS(e,t)},getAttributeNS:function(e,t){t=this.getAttributeNodeNS(e,t);return t&&t.value||""},setAttributeNS:function(e,t,n){t=this.ownerDocument.createAttributeNS(e,t);t.value=t.nodeValue=""+n,this.setAttributeNode(t)},getAttributeNodeNS:function(e,t){return this.attributes.getNamedItemNS(e,t)},getElementsByTagName:function(r){return new LiveNodeList(this,function(t){var n=[];return _visitNode(t,function(e){e===t||e.nodeType!=ELEMENT_NODE||"*"!==r&&e.tagName!=r||n.push(e)}),n})},getElementsByTagNameNS:function(r,o){return new LiveNodeList(this,function(t){var n=[];return _visitNode(t,function(e){e===t||e.nodeType!==ELEMENT_NODE||"*"!==r&&e.namespaceURI!==r||"*"!==o&&e.localName!=o||n.push(e)}),n})}},Document.prototype.getElementsByTagName=Element.prototype.getElementsByTagName,Document.prototype.getElementsByTagNameNS=Element.prototype.getElementsByTagNameNS,_extends(Element,Node),Attr.prototype.nodeType=ATTRIBUTE_NODE,_extends(Attr,Node),CharacterData.prototype={data:"",substringData:function(e,t){return this.data.substring(e,e+t)},appendData:function(e){e=this.data+e,this.nodeValue=this.data=e,this.length=e.length},insertData:function(e,t){this.replaceData(e,0,t)},appendChild:function(e){throw new Error(ExceptionMessage[HIERARCHY_REQUEST_ERR])},deleteData:function(e,t){this.replaceData(e,t,"")},replaceData:function(e,t,n){n=this.data.substring(0,e)+n+this.data.substring(e+t),this.nodeValue=this.data=n,this.length=n.length}},_extends(CharacterData,Node),Text.prototype={nodeName:"#text",nodeType:TEXT_NODE,splitText:function(e){var t=(n=this.data).substring(e),n=n.substring(0,e);this.data=this.nodeValue=n,this.length=n.length;t=this.ownerDocument.createTextNode(t);return this.parentNode&&this.parentNode.insertBefore(t,this.nextSibling),t}},_extends(Text,CharacterData),Comment.prototype={nodeName:"#comment",nodeType:COMMENT_NODE},_extends(Comment,CharacterData),CDATASection.prototype={nodeName:"#cdata-section",nodeType:CDATA_SECTION_NODE},_extends(CDATASection,CharacterData),DocumentType.prototype.nodeType=DOCUMENT_TYPE_NODE,_extends(DocumentType,Node),Notation.prototype.nodeType=NOTATION_NODE,_extends(Notation,Node),Entity.prototype.nodeType=ENTITY_NODE,_extends(Entity,Node),EntityReference.prototype.nodeType=ENTITY_REFERENCE_NODE,_extends(EntityReference,Node),DocumentFragment.prototype.nodeName="#document-fragment",DocumentFragment.prototype.nodeType=DOCUMENT_FRAGMENT_NODE,_extends(DocumentFragment,Node),ProcessingInstruction.prototype.nodeType=PROCESSING_INSTRUCTION_NODE,_extends(ProcessingInstruction,Node),XMLSerializer.prototype.serializeToString=function(e,t,n){return nodeSerializeToString.call(e,t,n)},Node.prototype.toString=nodeSerializeToString;try{function getTextContent(e){switch(e.nodeType){case ELEMENT_NODE:case DOCUMENT_FRAGMENT_NODE:var t=[];for(e=e.firstChild;e;)7!==e.nodeType&&8!==e.nodeType&&t.push(getTextContent(e)),e=e.nextSibling;return t.join("");default:return e.nodeValue}}Object.defineProperty&&(Object.defineProperty(LiveNodeList.prototype,"length",{get:function(){return _updateLiveList(this),this.$$length}}),Object.defineProperty(Node.prototype,"textContent",{get:function(){return getTextContent(this)},set:function(e){switch(this.nodeType){case ELEMENT_NODE:case DOCUMENT_FRAGMENT_NODE:for(;this.firstChild;)this.removeChild(this.firstChild);(e||String(e))&&this.appendChild(this.ownerDocument.createTextNode(e));break;default:this.data=e,this.value=e,this.nodeValue=e}}}),__set__=function(e,t,n){e["$$"+t]=n})}catch(e){}XML_ENTITIES=freeze({amp:"&",apos:"'",gt:">",lt:"<",quot:'"'}),HTML_ENTITIES=freeze({lt:"<",gt:">",amp:"&",quot:'"',apos:"'",Agrave:"À",Aacute:"Á",Acirc:"Â",Atilde:"Ã",Auml:"Ä",Aring:"Å",AElig:"Æ",Ccedil:"Ç",Egrave:"È",Eacute:"É",Ecirc:"Ê",Euml:"Ë",Igrave:"Ì",Iacute:"Í",Icirc:"Î",Iuml:"Ï",ETH:"Ð",Ntilde:"Ñ",Ograve:"Ò",Oacute:"Ó",Ocirc:"Ô",Otilde:"Õ",Ouml:"Ö",Oslash:"Ø",Ugrave:"Ù",Uacute:"Ú",Ucirc:"Û",Uuml:"Ü",Yacute:"Ý",THORN:"Þ",szlig:"ß",agrave:"à",aacute:"á",acirc:"â",atilde:"ã",auml:"ä",aring:"å",aelig:"æ",ccedil:"ç",egrave:"è",eacute:"é",ecirc:"ê",euml:"ë",igrave:"ì",iacute:"í",icirc:"î",iuml:"ï",eth:"ð",ntilde:"ñ",ograve:"ò",oacute:"ó",ocirc:"ô",otilde:"õ",ouml:"ö",oslash:"ø",ugrave:"ù",uacute:"ú",ucirc:"û",uuml:"ü",yacute:"ý",thorn:"þ",yuml:"ÿ",nbsp:" ",iexcl:"¡",cent:"¢",pound:"£",curren:"¤",yen:"¥",brvbar:"¦",sect:"§",uml:"¨",copy:"©",ordf:"ª",laquo:"«",not:"¬",shy:"­­",reg:"®",macr:"¯",deg:"°",plusmn:"±",sup2:"²",sup3:"³",acute:"´",micro:"µ",para:"¶",middot:"·",cedil:"¸",sup1:"¹",ordm:"º",raquo:"»",frac14:"¼",frac12:"½",frac34:"¾",iquest:"¿",times:"×",divide:"÷",forall:"∀",part:"∂",exist:"∃",empty:"∅",nabla:"∇",isin:"∈",notin:"∉",ni:"∋",prod:"∏",sum:"∑",minus:"−",lowast:"∗",radic:"√",prop:"∝",infin:"∞",ang:"∠",and:"∧",or:"∨",cap:"∩",cup:"∪",int:"∫",there4:"∴",sim:"∼",cong:"≅",asymp:"≈",ne:"≠",equiv:"≡",le:"≤",ge:"≥",sub:"⊂",sup:"⊃",nsub:"⊄",sube:"⊆",supe:"⊇",oplus:"⊕",otimes:"⊗",perp:"⊥",sdot:"⋅",Alpha:"Α",Beta:"Β",Gamma:"Γ",Delta:"Δ",Epsilon:"Ε",Zeta:"Ζ",Eta:"Η",Theta:"Θ",Iota:"Ι",Kappa:"Κ",Lambda:"Λ",Mu:"Μ",Nu:"Ν",Xi:"Ξ",Omicron:"Ο",Pi:"Π",Rho:"Ρ",Sigma:"Σ",Tau:"Τ",Upsilon:"Υ",Phi:"Φ",Chi:"Χ",Psi:"Ψ",Omega:"Ω",alpha:"α",beta:"β",gamma:"γ",delta:"δ",epsilon:"ε",zeta:"ζ",eta:"η",theta:"θ",iota:"ι",kappa:"κ",lambda:"λ",mu:"μ",nu:"ν",xi:"ξ",omicron:"ο",pi:"π",rho:"ρ",sigmaf:"ς",sigma:"σ",tau:"τ",upsilon:"υ",phi:"φ",chi:"χ",psi:"ψ",omega:"ω",thetasym:"ϑ",upsih:"ϒ",piv:"ϖ",OElig:"Œ",oelig:"œ",Scaron:"Š",scaron:"š",Yuml:"Ÿ",fnof:"ƒ",circ:"ˆ",tilde:"˜",ensp:" ",emsp:" ",thinsp:" ",zwnj:"‌",zwj:"‍",lrm:"‎",rlm:"‏",ndash:"–",mdash:"—",lsquo:"‘",rsquo:"’",sbquo:"‚",ldquo:"“",rdquo:"”",bdquo:"„",dagger:"†",Dagger:"‡",bull:"•",hellip:"…",permil:"‰",prime:"′",Prime:"″",lsaquo:"‹",rsaquo:"›",oline:"‾",euro:"€",trade:"™",larr:"←",uarr:"↑",rarr:"→",darr:"↓",harr:"↔",crarr:"↵",lceil:"⌈",rceil:"⌉",lfloor:"⌊",rfloor:"⌋",loz:"◊",spades:"♠",clubs:"♣",hearts:"♥",diams:"♦"});var nameStartChar=/[A-Z_a-z\xC0-\xD6\xD8-\xF6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/,nameChar=new RegExp("[\\-\\.0-9"+nameStartChar.source.slice(1,-1)+"\\u00B7\\u0300-\\u036F\\u203F-\\u2040]"),tagNamePattern=new RegExp("^"+nameStartChar.source+nameChar.source+"*(?::"+nameStartChar.source+nameChar.source+"*)?$"),S_TAG=0,S_ATTR=1,S_ATTR_SPACE=2,S_EQ=3,S_ATTR_NOQUOT_VALUE=4,S_ATTR_END=5,S_TAG_SPACE=6,S_TAG_CLOSE=7;function ParseError(e,t){this.message=e,this.locator=t,Error.captureStackTrace&&Error.captureStackTrace(this,ParseError)}function XMLReader(){}function parse(n,e,r,o,i){function a(e){var t=e.slice(1,-1);return Object.hasOwnProperty.call(r,t)?r[t]:"#"===t.charAt(0)?function(e){if(65535<e){var t=55296+((e-=65536)>>10),n=56320+(1023&e);return String.fromCharCode(t,n)}return String.fromCharCode(e)}(parseInt(t.substr(1).replace("x","0x"))):(i.error("entity not found:"+e),e)}function t(e){var t;N<e&&(t=n.substring(N,e).replace(/&#?\w+;/g,a),d&&s(N),o.characters(t,0,e-N),N=e)}function s(e,t){for(;u<=e&&(t=l.exec(n));)c=t.index,u=c+t[0].length,d.lineNumber++;d.columnNumber=e-c+1}for(var c=0,u=0,l=/.*(?:\r\n?|\n)|.*$/g,d=o.locator,p=[{currentNSMap:e}],E={},N=0;;){try{var m,f,h=n.indexOf("<",N);if(h<0)return void(n.substr(N).match(/^\s*$/)||(f=(m=o.doc).createTextNode(n.substr(N)),m.appendChild(f),o.currentElement=f));switch(N<h&&t(h),n.charAt(h+1)){case"/":var T=n.indexOf(">",h+3),_=n.substring(h+2,T).replace(/[ \t\n\r]+$/g,""),g=p.pop();T<0?(_=n.substring(h+2).replace(/[\s<].*/,""),i.error("end tag name: "+_+" is not complete:"+g.tagName),T=h+1+_.length):_.match(/\s</)&&(_=_.replace(/[\s<].*/,""),i.error("end tag name: "+_+" maybe not complete"),T=h+1+_.length);var D=g.localNSMap,O=g.tagName==_;if(O||g.tagName&&g.tagName.toLowerCase()==_.toLowerCase()){if(o.endElement(g.uri,g.localName,_),D)for(var A in D)Object.prototype.hasOwnProperty.call(D,A)&&o.endPrefixMapping(A);O||i.fatalError("end tag name: "+_+" is not match the current start tagName:"+g.tagName)}else p.push(g);T++;break;case"?":d&&s(h),T=parseInstruction(n,h,o);break;case"!":d&&s(h),T=parseDCC(n,h,o,i);break;default:d&&s(h);var S=new ElementAttributes,_=p[p.length-1].currentNSMap,T=parseElementStartPart(n,h,S,_,a,i),R=S.length;if(!S.closed&&fixSelfClosed(n,T,S.tagName,E)&&(S.closed=!0,r.nbsp||i.warning("unclosed xml attribute")),d&&R){for(var g=copyLocator(d,{}),y=0;y<R;y++){var C=S[y];s(C.offset),C.locator=copyLocator(d,{})}o.locator=g,appendElement(S,o,_)&&p.push(S),o.locator=d}else appendElement(S,o,_)&&p.push(S);NAMESPACE.isHTML(S.uri)&&!S.closed?T=parseHtmlSpecialContent(n,T,S.tagName,a,o):T++}}catch(e){if(e instanceof ParseError)throw e;i.error("element parse error: "+e),T=-1}N<T?N=T:t(Math.max(h,N)+1)}}function copyLocator(e,t){return t.lineNumber=e.lineNumber,t.columnNumber=e.columnNumber,t}function parseElementStartPart(e,t,r,n,o,i){function a(e,t,n){r.attributeNames.hasOwnProperty(e)&&i.fatalError("Attribute "+e+" redefined"),r.addValue(e,t.replace(/[\t\n\r]/g," ").replace(/&#?\w+;/g,o),n)}for(var s,c=++t,u=S_TAG;;){var l=e.charAt(c);switch(l){case"=":if(u===S_ATTR)s=e.slice(t,c),u=S_EQ;else{if(u!==S_ATTR_SPACE)throw new Error("attribute equal must after attrName");u=S_EQ}break;case"'":case'"':if(u===S_EQ||u===S_ATTR){if(u===S_ATTR&&(i.warning('attribute value must after "="'),s=e.slice(t,c)),t=c+1,!(0<(c=e.indexOf(l,t))))throw new Error("attribute value no end '"+l+"' match");a(s,d=e.slice(t,c),t-1),u=S_ATTR_END}else{if(u!=S_ATTR_NOQUOT_VALUE)throw new Error('attribute value must after "="');a(s,d=e.slice(t,c),t),i.warning('attribute "'+s+'" missed start quot('+l+")!!"),t=c+1,u=S_ATTR_END}break;case"/":switch(u){case S_TAG:r.setTagName(e.slice(t,c));case S_ATTR_END:case S_TAG_SPACE:case S_TAG_CLOSE:u=S_TAG_CLOSE,r.closed=!0;case S_ATTR_NOQUOT_VALUE:case S_ATTR:case S_ATTR_SPACE:break;default:throw new Error("attribute invalid close char('/')")}break;case"":return i.error("unexpected end of input"),u==S_TAG&&r.setTagName(e.slice(t,c)),c;case">":switch(u){case S_TAG:r.setTagName(e.slice(t,c));case S_ATTR_END:case S_TAG_SPACE:case S_TAG_CLOSE:break;case S_ATTR_NOQUOT_VALUE:case S_ATTR:"/"===(d=e.slice(t,c)).slice(-1)&&(r.closed=!0,d=d.slice(0,-1));case S_ATTR_SPACE:u===S_ATTR_SPACE&&(d=s),u==S_ATTR_NOQUOT_VALUE?(i.warning('attribute "'+d+'" missed quot(")!'),a(s,d,t)):(NAMESPACE.isHTML(n[""])&&d.match(/^(?:disabled|checked|selected)$/i)||i.warning('attribute "'+d+'" missed value!! "'+d+'" instead!!'),a(d,d,t));break;case S_EQ:throw new Error("attribute value missed!!")}return c;case"":l=" ";default:if(l<=" ")switch(u){case S_TAG:r.setTagName(e.slice(t,c)),u=S_TAG_SPACE;break;case S_ATTR:s=e.slice(t,c),u=S_ATTR_SPACE;break;case S_ATTR_NOQUOT_VALUE:var d=e.slice(t,c);i.warning('attribute "'+d+'" missed quot(")!!'),a(s,d,t);case S_ATTR_END:u=S_TAG_SPACE}else switch(u){case S_ATTR_SPACE:r.tagName;NAMESPACE.isHTML(n[""])&&s.match(/^(?:disabled|checked|selected)$/i)||i.warning('attribute "'+s+'" missed value!! "'+s+'" instead2!!'),a(s,s,t),t=c,u=S_ATTR;break;case S_ATTR_END:i.warning('attribute space is required"'+s+'"!!');case S_TAG_SPACE:u=S_ATTR,t=c;break;case S_EQ:u=S_ATTR_NOQUOT_VALUE,t=c;break;case S_TAG_CLOSE:throw new Error("elements closed character '/' and '>' must be connected to")}}c++}}function appendElement(e,t,n){for(var r=e.tagName,o=null,i=e.length;i--;){var a=e[i],s=a.qName,c=a.value,s=0<(l=s.indexOf(":"))?(u=a.prefix=s.slice(0,l),d=s.slice(l+1),"xmlns"===u&&d):(u=null,"xmlns"===(d=s)&&"");a.localName=d,!1!==s&&(null==o&&(o={},_copy(n,n={})),n[s]=o[s]=c,a.uri=NAMESPACE.XMLNS,t.startPrefixMapping(s,c))}for(var u,i=e.length;i--;)(u=(a=e[i]).prefix)&&("xml"===u&&(a.uri=NAMESPACE.XML),"xmlns"!==u&&(a.uri=n[u||""]));var l,d=0<(l=r.indexOf(":"))?(u=e.prefix=r.slice(0,l),e.localName=r.slice(l+1)):(u=null,e.localName=r),p=e.uri=n[u||""];if(t.startElement(p,d,r,e),!e.closed)return e.currentNSMap=n,e.localNSMap=o,!0;if(t.endElement(p,d,r),o)for(u in o)Object.prototype.hasOwnProperty.call(o,u)&&t.endPrefixMapping(u)}function parseHtmlSpecialContent(e,t,n,r,o){if(/^(?:script|textarea)$/i.test(n)){var i=e.indexOf("</"+n+">",t),e=e.substring(t+1,i);if(/[&<]/.test(e))return/^script$/i.test(n)||(e=e.replace(/&#?\w+;/g,r)),o.characters(e,0,e.length),i}return t+1}function fixSelfClosed(e,t,n,r){var o=r[n];return null==o&&((o=e.lastIndexOf("</"+n+">"))<t&&(o=e.lastIndexOf("</"+n)),r[n]=o),o<t}function _copy(e,t){for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n])}function parseDCC(e,t,n,r){var o=e.charAt(t+2);if("-"===o)return"-"!==e.charAt(t+3)?-1:t<(i=e.indexOf("--\x3e",t+4))?(n.comment(e,t+4,i-t-4),i+3):(r.error("Unclosed comment"),-1);if("CDATA["==e.substr(t+3,6)){var i=e.indexOf("]]>",t+9);return n.startCDATA(),n.characters(e,t+9,i-t-9),n.endCDATA(),i+3}o=split(e,t),r=o.length;if(1<r&&/!doctype/i.test(o[0][0])){i=o[1][0],e=!1,t=!1;3<r&&(/^public$/i.test(o[2][0])?(e=o[3][0],t=4<r&&o[4][0]):/^system$/i.test(o[2][0])&&(t=o[3][0]));r=o[r-1];return n.startDTD(i,e,t),n.endDTD(),r.index+r[0].length}return-1}function parseInstruction(e,t,n){var r=e.indexOf("?>",t);if(r){t=e.substring(t,r).match(/^<\?(\S*)\s*([\s\S]*?)\s*$/);if(t){t[0].length;return n.processingInstruction(t[1],t[2]),r+2}return-1}return-1}function ElementAttributes(){this.attributeNames={}}function split(e,t){var n,r=[],o=/'[^']+'|"[^"]+"|[^\s<>\/=]+=?|(\/?\s*>|<)/g;for(o.lastIndex=t,o.exec(e);n=o.exec(e);)if(r.push(n),n[1])return r}function normalizeLineEndings(e){return e.replace(/\r[\n\u0085]/g,"\n").replace(/[\r\u0085\u2028]/g,"\n")}function DOMParser(e){this.options=e||{locator:{}}}function buildErrorHandler(r,e,o){if(!r){if(e instanceof DOMHandler)return e;r=e}var i={},a=r instanceof Function;function t(t){var n=r[t];!n&&a&&(n=2==r.length?function(e){r(t,e)}:r),i[t]=n?function(e){n("[xmldom "+t+"]\t"+e+_locator(o))}:function(){}}return o=o||{},t("warning"),t("error"),t("fatalError"),i}function DOMHandler(){this.cdata=!1}function position(e,t){t.lineNumber=e.lineNumber,t.columnNumber=e.columnNumber}function _locator(e){if(e)return"\n@"+(e.systemId||"")+"#[line:"+e.lineNumber+",col:"+e.columnNumber+"]"}function _toString(e,t,n){return"string"==typeof e?e.substr(t,n):e.length>=t+n||t?new java.lang.String(e,t,n)+"":e}function appendElement(e,t){(e.currentElement||e.doc).appendChild(t)}ParseError.prototype=new Error,ParseError.prototype.name=ParseError.name,XMLReader.prototype={parse:function(e,t,n){var r=this.domBuilder;r.startDocument(),_copy(t,t={}),parse(e,t,n,r,this.errorHandler),r.endDocument()}},ElementAttributes.prototype={setTagName:function(e){if(!tagNamePattern.test(e))throw new Error("invalid tagName:"+e);this.tagName=e},addValue:function(e,t,n){if(!tagNamePattern.test(e))throw new Error("invalid attribute:"+e);this.attributeNames[e]=this.length,this[this.length++]={qName:e,value:t,offset:n}},length:0,getLocalName:function(e){return this[e].localName},getLocator:function(e){return this[e].locator},getQName:function(e){return this[e].qName},getURI:function(e){return this[e].uri},getValue:function(e){return this[e].value}},DOMParser.prototype.parseFromString=function(e,t){var n=this.options,r=new XMLReader,o=n.domBuilder||new DOMHandler,i=n.errorHandler,a=n.locator,s=n.xmlns||{},c=/\/x?html?$/.test(t),t=c?entities.HTML_ENTITIES:entities.XML_ENTITIES;a&&o.setDocumentLocator(a),r.errorHandler=buildErrorHandler(i,o,a),r.domBuilder=n.domBuilder||o,c&&(s[""]=NAMESPACE.HTML),s.xml=s.xml||NAMESPACE.XML;n=n.normalizeLineEndings||normalizeLineEndings;return e&&"string"==typeof e?r.parse(n(e),s,t):r.errorHandler.error("invalid doc source"),o.doc},DOMHandler.prototype={startDocument:function(){this.doc=(new DOMImplementation).createDocument(null,null,null),this.locator&&(this.doc.documentURI=this.locator.systemId)},startElement:function(e,t,n,r){var o=this.doc,i=o.createElementNS(e,n||t),a=r.length;appendElement(this,i),this.currentElement=i,this.locator&&position(this.locator,i);for(var s=0;s<a;s++){var e=r.getURI(s),c=r.getValue(s),n=r.getQName(s),u=o.createAttributeNS(e,n);this.locator&&position(r.getLocator(s),u),u.value=u.nodeValue=c,i.setAttributeNode(u)}},endElement:function(e,t,n){var r=this.currentElement;r.tagName;this.currentElement=r.parentNode},startPrefixMapping:function(e,t){},endPrefixMapping:function(e){},processingInstruction:function(e,t){t=this.doc.createProcessingInstruction(e,t);this.locator&&position(this.locator,t),appendElement(this,t)},ignorableWhitespace:function(e,t,n){},characters:function(e,t,n){var r;(e=_toString.apply(this,arguments))&&(r=this.cdata?this.doc.createCDATASection(e):this.doc.createTextNode(e),this.currentElement?this.currentElement.appendChild(r):/^\s*$/.test(e)&&this.doc.appendChild(r),this.locator&&position(this.locator,r))},skippedEntity:function(e){},endDocument:function(){this.doc.normalize()},setDocumentLocator:function(e){(this.locator=e)&&(e.lineNumber=0)},comment:function(e,t,n){e=_toString.apply(this,arguments);var r=this.doc.createComment(e);this.locator&&position(this.locator,r),appendElement(this,r)},startCDATA:function(){this.cdata=!0},endCDATA:function(){this.cdata=!1},startDTD:function(e,t,n){var r=this.doc.implementation;r&&r.createDocumentType&&(n=r.createDocumentType(e,t,n),this.locator&&position(this.locator,n),appendElement(this,n),this.doc.doctype=n)},warning:function(e){console.warn("[xmldom warning]\t"+e,_locator(this.locator))},error:function(e){console.error("[xmldom error]\t"+e,_locator(this.locator))},fatalError:function(e){throw new ParseError(e,this.locator)}},"endDTD,startEntity,endEntity,attributeDecl,elementDecl,externalEntityDecl,internalEntityDecl,resolveEntity,getExternalSubset,notationDecl,unparsedEntityDecl".replace(/\w+/g,function(e){DOMHandler.prototype[e]=function(){return null}});

__DOMHandler = DOMHandler;

(function(){'use strict';var k=this;
function aa(a){var b=typeof a;if("object"==b)if(a){if(a instanceof Array)return"array";if(a instanceof Object)return b;var c=Object.prototype.toString.call(a);if("[object Window]"==c)return"object";if("[object Array]"==c||"number"==typeof a.length&&"undefined"!=typeof a.splice&&"undefined"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable("splice"))return"array";if("[object Function]"==c||"undefined"!=typeof a.call&&"undefined"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable("call"))return"function"}else return"null";else if("function"==
b&&"undefined"==typeof a.call)return"object";return b}function l(a){return"string"==typeof a}function ba(a,b,c){return a.call.apply(a.bind,arguments)}function ca(a,b,c){if(!a)throw Error();if(2<arguments.length){var d=Array.prototype.slice.call(arguments,2);return function(){var c=Array.prototype.slice.call(arguments);Array.prototype.unshift.apply(c,d);return a.apply(b,c)}}return function(){return a.apply(b,arguments)}}
function da(a,b,c){da=Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf("native code")?ba:ca;return da.apply(null,arguments)}function ea(a,b){var c=Array.prototype.slice.call(arguments,1);return function(){var b=c.slice();b.push.apply(b,arguments);return a.apply(this,b)}}
function m(a){var b=n;function c(){}c.prototype=b.prototype;a.G=b.prototype;a.prototype=new c;a.prototype.constructor=a;a.F=function(a,c,f){for(var g=Array(arguments.length-2),h=2;h<arguments.length;h++)g[h-2]=arguments[h];return b.prototype[c].apply(a,g)}};

var fa=String.prototype.trim?function(a){return a.trim()}:function(a){return a.replace(/^[\s\xa0]+|[\s\xa0]+$/g,"")};function q(a,b){return-1!=a.indexOf(b)}function ga(a,b){return a<b?-1:a>b?1:0};var ha=Array.prototype.indexOf?function(a,b,c){return Array.prototype.indexOf.call(a,b,c)}:function(a,b,c){c=null==c?0:0>c?Math.max(0,a.length+c):c;if(l(a))return l(b)&&1==b.length?a.indexOf(b,c):-1;for(;c<a.length;c++)if(c in a&&a[c]===b)return c;return-1},r=Array.prototype.forEach?function(a,b,c){Array.prototype.forEach.call(a,b,c)}:function(a,b,c){for(var d=a.length,e=l(a)?a.split(""):a,f=0;f<d;f++)f in e&&b.call(c,e[f],f,a)},ia=Array.prototype.filter?function(a,b,c){return Array.prototype.filter.call(a,
b,c)}:function(a,b,c){for(var d=a.length,e=[],f=0,g=l(a)?a.split(""):a,h=0;h<d;h++)if(h in g){var p=g[h];b.call(c,p,h,a)&&(e[f++]=p)}return e},t=Array.prototype.reduce?function(a,b,c,d){d&&(b=da(b,d));return Array.prototype.reduce.call(a,b,c)}:function(a,b,c,d){var e=c;r(a,function(c,g){e=b.call(d,e,c,g,a)});return e},ja=Array.prototype.some?function(a,b,c){return Array.prototype.some.call(a,b,c)}:function(a,b,c){for(var d=a.length,e=l(a)?a.split(""):a,f=0;f<d;f++)if(f in e&&b.call(c,e[f],f,a))return!0;
return!1};function ka(a,b){var c;a:{c=a.length;for(var d=l(a)?a.split(""):a,e=0;e<c;e++)if(e in d&&b.call(void 0,d[e],e,a)){c=e;break a}c=-1}return 0>c?null:l(a)?a.charAt(c):a[c]}function la(a){return Array.prototype.concat.apply(Array.prototype,arguments)}function ma(a,b,c){return 2>=arguments.length?Array.prototype.slice.call(a,b):Array.prototype.slice.call(a,b,c)};var u;a:{var na=k.navigator;if(na){var oa=na.userAgent;if(oa){u=oa;break a}}u=""};var pa=q(u,"Opera")||q(u,"OPR"),v=q(u,"Trident")||q(u,"MSIE"),qa=q(u,"Edge"),ra=q(u,"Gecko")&&!(q(u.toLowerCase(),"webkit")&&!q(u,"Edge"))&&!(q(u,"Trident")||q(u,"MSIE"))&&!q(u,"Edge"),sa=q(u.toLowerCase(),"webkit")&&!q(u,"Edge");function ta(){var a=k.document;return a?a.documentMode:void 0}var ua;
a:{var va="",wa=function(){var a=u;if(ra)return/rv\:([^\);]+)(\)|;)/.exec(a);if(qa)return/Edge\/([\d\.]+)/.exec(a);if(v)return/\b(?:MSIE|rv)[: ]([^\);]+)(\)|;)/.exec(a);if(sa)return/WebKit\/(\S+)/.exec(a);if(pa)return/(?:Version)[ \/]?(\S+)/.exec(a)}();wa&&(va=wa?wa[1]:"");if(v){var xa=ta();if(null!=xa&&xa>parseFloat(va)){ua=String(xa);break a}}ua=va}var ya={};
function za(a){if(!ya[a]){for(var b=0,c=fa(String(ua)).split("."),d=fa(String(a)).split("."),e=Math.max(c.length,d.length),f=0;0==b&&f<e;f++){var g=c[f]||"",h=d[f]||"",p=/(\d*)(\D*)/g,y=/(\d*)(\D*)/g;do{var D=p.exec(g)||["","",""],X=y.exec(h)||["","",""];if(0==D[0].length&&0==X[0].length)break;b=ga(0==D[1].length?0:parseInt(D[1],10),0==X[1].length?0:parseInt(X[1],10))||ga(0==D[2].length,0==X[2].length)||ga(D[2],X[2])}while(0==b)}ya[a]=0<=b}}
var Aa=k.document,Ba=Aa&&v?ta()||("CSS1Compat"==Aa.compatMode?parseInt(ua,10):5):void 0;var w=v&&!(9<=Number(Ba)),Ca=v&&!(8<=Number(Ba));function x(a,b,c,d){this.a=a;this.nodeName=c;this.nodeValue=d;this.nodeType=2;this.parentNode=this.ownerElement=b}function Da(a,b){var c=Ca&&"href"==b.nodeName?a.getAttribute(b.nodeName,2):b.nodeValue;return new x(b,a,b.nodeName,c)};function z(a){var b=null,c=a.nodeType;1==c&&(b=a.textContent,b=void 0==b||null==b?a.innerText:b,b=void 0==b||null==b?"":b);if("string"!=typeof b)if(w&&"title"==a.nodeName.toLowerCase()&&1==c)b=a.text;else if(9==c||1==c){a=9==c?a.documentElement:a.firstChild;for(var c=0,d=[],b="";a;){do 1!=a.nodeType&&(b+=a.nodeValue),w&&"title"==a.nodeName.toLowerCase()&&(b+=a.text),d[c++]=a;while(a=a.firstChild);for(;c&&!(a=d[--c].nextSibling););}}else b=a.nodeValue;return""+b}
function A(a,b,c){if(null===b)return!0;try{if(!a.getAttribute)return!1}catch(d){return!1}Ca&&"class"==b&&(b="className");return null==c?!!a.getAttribute(b):a.getAttribute(b,2)==c}function B(a,b,c,d,e){return(w?Ea:Fa).call(null,a,b,l(c)?c:null,l(d)?d:null,e||new C)}
function Ea(a,b,c,d,e){if(a instanceof E||8==a.b||c&&null===a.b){var f=b.all;if(!f)return e;a=Ga(a);if("*"!=a&&(f=b.getElementsByTagName(a),!f))return e;if(c){for(var g=[],h=0;b=f[h++];)A(b,c,d)&&g.push(b);f=g}for(h=0;b=f[h++];)"*"==a&&"!"==b.tagName||F(e,b);return e}Ha(a,b,c,d,e);return e}
function Fa(a,b,c,d,e){b.getElementsByName&&d&&"name"==c&&!v?(b=b.getElementsByName(d),r(b,function(b){a.a(b)&&F(e,b)})):b.getElementsByClassName&&d&&"class"==c?(b=b.getElementsByClassName(d),r(b,function(b){b.className==d&&a.a(b)&&F(e,b)})):a instanceof G?Ha(a,b,c,d,e):b.getElementsByTagName&&(b=b.getElementsByTagName(a.f()),r(b,function(a){A(a,c,d)&&F(e,a)}));return e}
function Ia(a,b,c,d,e){var f;if((a instanceof E||8==a.b||c&&null===a.b)&&(f=b.childNodes)){var g=Ga(a);if("*"!=g&&(f=ia(f,function(a){return a.tagName&&a.tagName.toLowerCase()==g}),!f))return e;c&&(f=ia(f,function(a){return A(a,c,d)}));r(f,function(a){"*"==g&&("!"==a.tagName||"*"==g&&1!=a.nodeType)||F(e,a)});return e}return Ja(a,b,c,d,e)}function Ja(a,b,c,d,e){for(b=b.firstChild;b;b=b.nextSibling)A(b,c,d)&&a.a(b)&&F(e,b);return e}
function Ha(a,b,c,d,e){for(b=b.firstChild;b;b=b.nextSibling)A(b,c,d)&&a.a(b)&&F(e,b),Ha(a,b,c,d,e)}function Ga(a){if(a instanceof G){if(8==a.b)return"!";if(null===a.b)return"*"}return a.f()};!ra&&!v||v&&9<=Number(Ba)||ra&&za("1.9.1");v&&za("9");function Ka(a,b){if(!a||!b)return!1;if(a.contains&&1==b.nodeType)return a==b||a.contains(b);if("undefined"!=typeof a.compareDocumentPosition)return a==b||!!(a.compareDocumentPosition(b)&16);for(;b&&a!=b;)b=b.parentNode;return b==a}
function La(a,b){if(a==b)return 0;if(a.compareDocumentPosition)return a.compareDocumentPosition(b)&2?1:-1;if(v&&!(9<=Number(Ba))){if(9==a.nodeType)return-1;if(9==b.nodeType)return 1}if("sourceIndex"in a||a.parentNode&&"sourceIndex"in a.parentNode){var c=1==a.nodeType,d=1==b.nodeType;if(c&&d)return a.sourceIndex-b.sourceIndex;var e=a.parentNode,f=b.parentNode;return e==f?Ma(a,b):!c&&Ka(e,b)?-1*Na(a,b):!d&&Ka(f,a)?Na(b,a):(c?a.sourceIndex:e.sourceIndex)-(d?b.sourceIndex:f.sourceIndex)}d=9==a.nodeType?
a:a.ownerDocument||a.document;c=d.createRange();c.selectNode(a);c.collapse(!0);d=d.createRange();d.selectNode(b);d.collapse(!0);return c.compareBoundaryPoints(k.Range.START_TO_END,d)}function Na(a,b){var c=a.parentNode;if(c==b)return-1;for(var d=b;d.parentNode!=c;)d=d.parentNode;return Ma(d,a)}function Ma(a,b){for(var c=b;c=c.previousSibling;)if(c==a)return-1;return 1};function C(){this.b=this.a=null;this.l=0}function Oa(a){this.node=a;this.a=this.b=null}function Pa(a,b){if(!a.a)return b;if(!b.a)return a;for(var c=a.a,d=b.a,e=null,f=null,g=0;c&&d;){var f=c.node,h=d.node;f==h||f instanceof x&&h instanceof x&&f.a==h.a?(f=c,c=c.a,d=d.a):0<La(c.node,d.node)?(f=d,d=d.a):(f=c,c=c.a);(f.b=e)?e.a=f:a.a=f;e=f;g++}for(f=c||d;f;)f.b=e,e=e.a=f,g++,f=f.a;a.b=e;a.l=g;return a}function Qa(a,b){var c=new Oa(b);c.a=a.a;a.b?a.a.b=c:a.a=a.b=c;a.a=c;a.l++}
function F(a,b){var c=new Oa(b);c.b=a.b;a.a?a.b.a=c:a.a=a.b=c;a.b=c;a.l++}function Ra(a){return(a=a.a)?a.node:null}function Sa(a){return(a=Ra(a))?z(a):""}function H(a,b){return new Ta(a,!!b)}function Ta(a,b){this.f=a;this.b=(this.c=b)?a.b:a.a;this.a=null}function I(a){var b=a.b;if(null==b)return null;var c=a.a=b;a.b=a.c?b.b:b.a;return c.node};function n(a){this.i=a;this.b=this.g=!1;this.f=null}function J(a){return"\n  "+a.toString().split("\n").join("\n  ")}function Ua(a,b){a.g=b}function Va(a,b){a.b=b}function K(a,b){var c=a.a(b);return c instanceof C?+Sa(c):+c}function L(a,b){var c=a.a(b);return c instanceof C?Sa(c):""+c}function M(a,b){var c=a.a(b);return c instanceof C?!!c.l:!!c};function N(a,b,c){n.call(this,a.i);this.c=a;this.h=b;this.o=c;this.g=b.g||c.g;this.b=b.b||c.b;this.c==Wa&&(c.b||c.g||4==c.i||0==c.i||!b.f?b.b||b.g||4==b.i||0==b.i||!c.f||(this.f={name:c.f.name,s:b}):this.f={name:b.f.name,s:c})}m(N);
function O(a,b,c,d,e){b=b.a(d);c=c.a(d);var f;if(b instanceof C&&c instanceof C){b=H(b);for(d=I(b);d;d=I(b))for(e=H(c),f=I(e);f;f=I(e))if(a(z(d),z(f)))return!0;return!1}if(b instanceof C||c instanceof C){b instanceof C?(e=b,d=c):(e=c,d=b);f=H(e);for(var g=typeof d,h=I(f);h;h=I(f)){switch(g){case "number":h=+z(h);break;case "boolean":h=!!z(h);break;case "string":h=z(h);break;default:throw Error("Illegal primitive type for comparison.");}if(e==b&&a(h,d)||e==c&&a(d,h))return!0}return!1}return e?"boolean"==
typeof b||"boolean"==typeof c?a(!!b,!!c):"number"==typeof b||"number"==typeof c?a(+b,+c):a(b,c):a(+b,+c)}N.prototype.a=function(a){return this.c.m(this.h,this.o,a)};N.prototype.toString=function(){var a="Binary Expression: "+this.c,a=a+J(this.h);return a+=J(this.o)};function Xa(a,b,c,d){this.a=a;this.w=b;this.i=c;this.m=d}Xa.prototype.toString=function(){return this.a};var Ya={};
function P(a,b,c,d){if(Ya.hasOwnProperty(a))throw Error("Binary operator already created: "+a);a=new Xa(a,b,c,d);return Ya[a.toString()]=a}P("div",6,1,function(a,b,c){return K(a,c)/K(b,c)});P("mod",6,1,function(a,b,c){return K(a,c)%K(b,c)});P("*",6,1,function(a,b,c){return K(a,c)*K(b,c)});P("+",5,1,function(a,b,c){return K(a,c)+K(b,c)});P("-",5,1,function(a,b,c){return K(a,c)-K(b,c)});P("<",4,2,function(a,b,c){return O(function(a,b){return a<b},a,b,c)});
P(">",4,2,function(a,b,c){return O(function(a,b){return a>b},a,b,c)});P("<=",4,2,function(a,b,c){return O(function(a,b){return a<=b},a,b,c)});P(">=",4,2,function(a,b,c){return O(function(a,b){return a>=b},a,b,c)});var Wa=P("=",3,2,function(a,b,c){return O(function(a,b){return a==b},a,b,c,!0)});P("!=",3,2,function(a,b,c){return O(function(a,b){return a!=b},a,b,c,!0)});P("and",2,2,function(a,b,c){return M(a,c)&&M(b,c)});P("or",1,2,function(a,b,c){return M(a,c)||M(b,c)});function Q(a,b,c){this.a=a;this.b=b||1;this.f=c||1};function Za(a,b){if(b.a.length&&4!=a.i)throw Error("Primary expression must evaluate to nodeset if filter has predicate(s).");n.call(this,a.i);this.c=a;this.h=b;this.g=a.g;this.b=a.b}m(Za);Za.prototype.a=function(a){a=this.c.a(a);return $a(this.h,a)};Za.prototype.toString=function(){var a;a="Filter:"+J(this.c);return a+=J(this.h)};function ab(a,b){if(b.length<a.A)throw Error("Function "+a.j+" expects at least"+a.A+" arguments, "+b.length+" given");if(null!==a.v&&b.length>a.v)throw Error("Function "+a.j+" expects at most "+a.v+" arguments, "+b.length+" given");a.B&&r(b,function(b,d){if(4!=b.i)throw Error("Argument "+d+" to function "+a.j+" is not of type Nodeset: "+b);});n.call(this,a.i);this.h=a;this.c=b;Ua(this,a.g||ja(b,function(a){return a.g}));Va(this,a.D&&!b.length||a.C&&!!b.length||ja(b,function(a){return a.b}))}m(ab);
ab.prototype.a=function(a){return this.h.m.apply(null,la(a,this.c))};ab.prototype.toString=function(){var a="Function: "+this.h;if(this.c.length)var b=t(this.c,function(a,b){return a+J(b)},"Arguments:"),a=a+J(b);return a};function bb(a,b,c,d,e,f,g,h,p){this.j=a;this.i=b;this.g=c;this.D=d;this.C=e;this.m=f;this.A=g;this.v=void 0!==h?h:g;this.B=!!p}bb.prototype.toString=function(){return this.j};var cb={};
function R(a,b,c,d,e,f,g,h){if(cb.hasOwnProperty(a))throw Error("Function already created: "+a+".");cb[a]=new bb(a,b,c,d,!1,e,f,g,h)}R("boolean",2,!1,!1,function(a,b){return M(b,a)},1);R("ceiling",1,!1,!1,function(a,b){return Math.ceil(K(b,a))},1);R("concat",3,!1,!1,function(a,b){return t(ma(arguments,1),function(b,d){return b+L(d,a)},"")},2,null);R("contains",2,!1,!1,function(a,b,c){return q(L(b,a),L(c,a))},2);R("count",1,!1,!1,function(a,b){return b.a(a).l},1,1,!0);
R("false",2,!1,!1,function(){return!1},0);R("floor",1,!1,!1,function(a,b){return Math.floor(K(b,a))},1);R("id",4,!1,!1,function(a,b){function c(a){if(w){var b=e.all[a];if(b){if(b.nodeType&&a==b.id)return b;if(b.length)return ka(b,function(b){return a==b.id})}return null}return e.getElementById(a)}var d=a.a,e=9==d.nodeType?d:d.ownerDocument,d=L(b,a).split(/\s+/),f=[];r(d,function(a){a=c(a);!a||0<=ha(f,a)||f.push(a)});f.sort(La);var g=new C;r(f,function(a){F(g,a)});return g},1);
R("lang",2,!1,!1,function(){return!1},1);R("last",1,!0,!1,function(a){if(1!=arguments.length)throw Error("Function last expects ()");return a.f},0);R("local-name",3,!1,!0,function(a,b){var c=b?Ra(b.a(a)):a.a;return c?c.localName||c.nodeName.toLowerCase():""},0,1,!0);R("name",3,!1,!0,function(a,b){var c=b?Ra(b.a(a)):a.a;return c?c.nodeName.toLowerCase():""},0,1,!0);R("namespace-uri",3,!0,!1,function(){return""},0,1,!0);
R("normalize-space",3,!1,!0,function(a,b){return(b?L(b,a):z(a.a)).replace(/[\s\xa0]+/g," ").replace(/^\s+|\s+$/g,"")},0,1);R("not",2,!1,!1,function(a,b){return!M(b,a)},1);R("number",1,!1,!0,function(a,b){return b?K(b,a):+z(a.a)},0,1);R("position",1,!0,!1,function(a){return a.b},0);R("round",1,!1,!1,function(a,b){return Math.round(K(b,a))},1);R("starts-with",2,!1,!1,function(a,b,c){b=L(b,a);a=L(c,a);return 0==b.lastIndexOf(a,0)},2);R("string",3,!1,!0,function(a,b){return b?L(b,a):z(a.a)},0,1);
R("string-length",1,!1,!0,function(a,b){return(b?L(b,a):z(a.a)).length},0,1);R("substring",3,!1,!1,function(a,b,c,d){c=K(c,a);if(isNaN(c)||Infinity==c||-Infinity==c)return"";d=d?K(d,a):Infinity;if(isNaN(d)||-Infinity===d)return"";c=Math.round(c)-1;var e=Math.max(c,0);a=L(b,a);return Infinity==d?a.substring(e):a.substring(e,c+Math.round(d))},2,3);R("substring-after",3,!1,!1,function(a,b,c){b=L(b,a);a=L(c,a);c=b.indexOf(a);return-1==c?"":b.substring(c+a.length)},2);
R("substring-before",3,!1,!1,function(a,b,c){b=L(b,a);a=L(c,a);a=b.indexOf(a);return-1==a?"":b.substring(0,a)},2);R("sum",1,!1,!1,function(a,b){for(var c=H(b.a(a)),d=0,e=I(c);e;e=I(c))d+=+z(e);return d},1,1,!0);R("translate",3,!1,!1,function(a,b,c,d){b=L(b,a);c=L(c,a);var e=L(d,a);a={};for(d=0;d<c.length;d++){var f=c.charAt(d);f in a||(a[f]=e.charAt(d))}c="";for(d=0;d<b.length;d++)f=b.charAt(d),c+=f in a?a[f]:f;return c},3);R("true",2,!1,!1,function(){return!0},0);function G(a,b){this.h=a;this.c=void 0!==b?b:null;this.b=null;switch(a){case "comment":this.b=8;break;case "text":this.b=3;break;case "processing-instruction":this.b=7;break;case "node":break;default:throw Error("Unexpected argument");}}function db(a){return"comment"==a||"text"==a||"processing-instruction"==a||"node"==a}G.prototype.a=function(a){return null===this.b||this.b==a.nodeType};G.prototype.f=function(){return this.h};
G.prototype.toString=function(){var a="Kind Test: "+this.h;null===this.c||(a+=J(this.c));return a};function eb(a){this.b=a;this.a=0}function fb(a){a=a.match(gb);for(var b=0;b<a.length;b++)hb.test(a[b])&&a.splice(b,1);return new eb(a)}var gb=/\$?(?:(?![0-9-\.])(?:\*|[\w-\.]+):)?(?![0-9-\.])(?:\*|[\w-\.]+)|\/\/|\.\.|::|\d+(?:\.\d*)?|\.\d+|"[^"]*"|'[^']*'|[!<>]=|\s+|./g,hb=/^\s/;function S(a,b){return a.b[a.a+(b||0)]}function T(a){return a.b[a.a++]}function ib(a){return a.b.length<=a.a};function jb(a){n.call(this,3);this.c=a.substring(1,a.length-1)}m(jb);jb.prototype.a=function(){return this.c};jb.prototype.toString=function(){return"Literal: "+this.c};function E(a,b){this.j=a.toLowerCase();var c;c="*"==this.j?"*":"http://www.w3.org/1999/xhtml";this.c=b?b.toLowerCase():c}E.prototype.a=function(a){var b=a.nodeType;if(1!=b&&2!=b)return!1;b=void 0!==a.localName?a.localName:a.nodeName;return"*"!=this.j&&this.j!=b.toLowerCase()?!1:"*"==this.c?!0:this.c==(a.namespaceURI?a.namespaceURI.toLowerCase():"http://www.w3.org/1999/xhtml")};E.prototype.f=function(){return this.j};
E.prototype.toString=function(){return"Name Test: "+("http://www.w3.org/1999/xhtml"==this.c?"":this.c+":")+this.j};function kb(a,b){n.call(this,a.i);this.h=a;this.c=b;this.g=a.g;this.b=a.b;if(1==this.c.length){var c=this.c[0];c.u||c.c!=lb||(c=c.o,"*"!=c.f()&&(this.f={name:c.f(),s:null}))}}m(kb);function mb(){n.call(this,4)}m(mb);mb.prototype.a=function(a){var b=new C;a=a.a;9==a.nodeType?F(b,a):F(b,a.ownerDocument);return b};mb.prototype.toString=function(){return"Root Helper Expression"};function nb(){n.call(this,4)}m(nb);nb.prototype.a=function(a){var b=new C;F(b,a.a);return b};nb.prototype.toString=function(){return"Context Helper Expression"};
function ob(a){return"/"==a||"//"==a}kb.prototype.a=function(a){var b=this.h.a(a);if(!(b instanceof C))throw Error("Filter expression must evaluate to nodeset.");a=this.c;for(var c=0,d=a.length;c<d&&b.l;c++){var e=a[c],f=H(b,e.c.a),g;if(e.g||e.c!=pb)if(e.g||e.c!=qb)for(g=I(f),b=e.a(new Q(g));null!=(g=I(f));)g=e.a(new Q(g)),b=Pa(b,g);else g=I(f),b=e.a(new Q(g));else{for(g=I(f);(b=I(f))&&(!g.contains||g.contains(b))&&b.compareDocumentPosition(g)&8;g=b);b=e.a(new Q(g))}}return b};
kb.prototype.toString=function(){var a;a="Path Expression:"+J(this.h);if(this.c.length){var b=t(this.c,function(a,b){return a+J(b)},"Steps:");a+=J(b)}return a};function rb(a){n.call(this,4);this.c=a;Ua(this,ja(this.c,function(a){return a.g}));Va(this,ja(this.c,function(a){return a.b}))}m(rb);rb.prototype.a=function(a){var b=new C;r(this.c,function(c){c=c.a(a);if(!(c instanceof C))throw Error("Path expression must evaluate to NodeSet.");b=Pa(b,c)});return b};rb.prototype.toString=function(){return t(this.c,function(a,b){return a+J(b)},"Union Expression:")};function sb(a,b){this.a=a;this.b=!!b}
function $a(a,b,c){for(c=c||0;c<a.a.length;c++)for(var d=a.a[c],e=H(b),f=b.l,g,h=0;g=I(e);h++){var p=a.b?f-h:h+1;g=d.a(new Q(g,p,f));if("number"==typeof g)p=p==g;else if("string"==typeof g||"boolean"==typeof g)p=!!g;else if(g instanceof C)p=0<g.l;else throw Error("Predicate.evaluate returned an unexpected type.");if(!p){p=e;g=p.f;var y=p.a;if(!y)throw Error("Next must be called at least once before remove.");var D=y.b,y=y.a;D?D.a=y:g.a=y;y?y.b=D:g.b=D;g.l--;p.a=null}}return b}
sb.prototype.toString=function(){return t(this.a,function(a,b){return a+J(b)},"Predicates:")};function U(a,b,c,d){n.call(this,4);this.c=a;this.o=b;this.h=c||new sb([]);this.u=!!d;b=this.h;b=0<b.a.length?b.a[0].f:null;a.b&&b&&(a=b.name,a=w?a.toLowerCase():a,this.f={name:a,s:b.s});a:{a=this.h;for(b=0;b<a.a.length;b++)if(c=a.a[b],c.g||1==c.i||0==c.i){a=!0;break a}a=!1}this.g=a}m(U);
U.prototype.a=function(a){var b=a.a,c=null,c=this.f,d=null,e=null,f=0;c&&(d=c.name,e=c.s?L(c.s,a):null,f=1);if(this.u)if(this.g||this.c!=tb)if(a=H((new U(ub,new G("node"))).a(a)),b=I(a))for(c=this.m(b,d,e,f);null!=(b=I(a));)c=Pa(c,this.m(b,d,e,f));else c=new C;else c=B(this.o,b,d,e),c=$a(this.h,c,f);else c=this.m(a.a,d,e,f);return c};U.prototype.m=function(a,b,c,d){a=this.c.f(this.o,a,b,c);return a=$a(this.h,a,d)};
U.prototype.toString=function(){var a;a="Step:"+J("Operator: "+(this.u?"//":"/"));this.c.j&&(a+=J("Axis: "+this.c));a+=J(this.o);if(this.h.a.length){var b=t(this.h.a,function(a,b){return a+J(b)},"Predicates:");a+=J(b)}return a};function vb(a,b,c,d){this.j=a;this.f=b;this.a=c;this.b=d}vb.prototype.toString=function(){return this.j};var wb={};function V(a,b,c,d){if(wb.hasOwnProperty(a))throw Error("Axis already created: "+a);b=new vb(a,b,c,!!d);return wb[a]=b}
V("ancestor",function(a,b){for(var c=new C,d=b;d=d.parentNode;)a.a(d)&&Qa(c,d);return c},!0);V("ancestor-or-self",function(a,b){var c=new C,d=b;do a.a(d)&&Qa(c,d);while(d=d.parentNode);return c},!0);
var lb=V("attribute",function(a,b){var c=new C,d=a.f();if("style"==d&&w&&b.style)return F(c,new x(b.style,b,"style",b.style.cssText)),c;var e=b.attributes;if(e)if(a instanceof G&&null===a.b||"*"==d)for(var d=0,f;f=e[d];d++)w?f.nodeValue&&F(c,Da(b,f)):F(c,f);else(f=e.getNamedItem(d))&&(w?f.nodeValue&&F(c,Da(b,f)):F(c,f));return c},!1),tb=V("child",function(a,b,c,d,e){return(w?Ia:Ja).call(null,a,b,l(c)?c:null,l(d)?d:null,e||new C)},!1,!0);V("descendant",B,!1,!0);
var ub=V("descendant-or-self",function(a,b,c,d){var e=new C;A(b,c,d)&&a.a(b)&&F(e,b);return B(a,b,c,d,e)},!1,!0),pb=V("following",function(a,b,c,d){var e=new C;do for(var f=b;f=f.nextSibling;)A(f,c,d)&&a.a(f)&&F(e,f),e=B(a,f,c,d,e);while(b=b.parentNode);return e},!1,!0);V("following-sibling",function(a,b){for(var c=new C,d=b;d=d.nextSibling;)a.a(d)&&F(c,d);return c},!1);V("namespace",function(){return new C},!1);
var xb=V("parent",function(a,b){var c=new C;if(9==b.nodeType)return c;if(2==b.nodeType)return F(c,b.ownerElement),c;var d=b.parentNode;a.a(d)&&F(c,d);return c},!1),qb=V("preceding",function(a,b,c,d){var e=new C,f=[];do f.unshift(b);while(b=b.parentNode);for(var g=1,h=f.length;g<h;g++){var p=[];for(b=f[g];b=b.previousSibling;)p.unshift(b);for(var y=0,D=p.length;y<D;y++)b=p[y],A(b,c,d)&&a.a(b)&&F(e,b),e=B(a,b,c,d,e)}return e},!0,!0);
V("preceding-sibling",function(a,b){for(var c=new C,d=b;d=d.previousSibling;)a.a(d)&&Qa(c,d);return c},!0);var yb=V("self",function(a,b){var c=new C;a.a(b)&&F(c,b);return c},!1);function zb(a){n.call(this,1);this.c=a;this.g=a.g;this.b=a.b}m(zb);zb.prototype.a=function(a){return-K(this.c,a)};zb.prototype.toString=function(){return"Unary Expression: -"+J(this.c)};function Ab(a){n.call(this,1);this.c=a}m(Ab);Ab.prototype.a=function(){return this.c};Ab.prototype.toString=function(){return"Number: "+this.c};function Bb(a,b){this.a=a;this.b=b}function Cb(a){for(var b,c=[];;){W(a,"Missing right hand side of binary expression.");b=Db(a);var d=T(a.a);if(!d)break;var e=(d=Ya[d]||null)&&d.w;if(!e){a.a.a--;break}for(;c.length&&e<=c[c.length-1].w;)b=new N(c.pop(),c.pop(),b);c.push(b,d)}for(;c.length;)b=new N(c.pop(),c.pop(),b);return b}function W(a,b){if(ib(a.a))throw Error(b);}function Eb(a,b){var c=T(a.a);if(c!=b)throw Error("Bad token, expected: "+b+" got: "+c);}
function Fb(a){a=T(a.a);if(")"!=a)throw Error("Bad token: "+a);}function Gb(a){a=T(a.a);if(2>a.length)throw Error("Unclosed literal string");return new jb(a)}
function Hb(a){var b,c=[],d;if(ob(S(a.a))){b=T(a.a);d=S(a.a);if("/"==b&&(ib(a.a)||"."!=d&&".."!=d&&"@"!=d&&"*"!=d&&!/(?![0-9])[\w]/.test(d)))return new mb;d=new mb;W(a,"Missing next location step.");b=Ib(a,b);c.push(b)}else{a:{b=S(a.a);d=b.charAt(0);switch(d){case "$":throw Error("Variable reference not allowed in HTML XPath");case "(":T(a.a);b=Cb(a);W(a,'unclosed "("');Eb(a,")");break;case '"':case "'":b=Gb(a);break;default:if(isNaN(+b))if(!db(b)&&/(?![0-9])[\w]/.test(d)&&"("==S(a.a,1)){b=T(a.a);
b=cb[b]||null;T(a.a);for(d=[];")"!=S(a.a);){W(a,"Missing function argument list.");d.push(Cb(a));if(","!=S(a.a))break;T(a.a)}W(a,"Unclosed function argument list.");Fb(a);b=new ab(b,d)}else{b=null;break a}else b=new Ab(+T(a.a))}"["==S(a.a)&&(d=new sb(Jb(a)),b=new Za(b,d))}if(b)if(ob(S(a.a)))d=b;else return b;else b=Ib(a,"/"),d=new nb,c.push(b)}for(;ob(S(a.a));)b=T(a.a),W(a,"Missing next location step."),b=Ib(a,b),c.push(b);return new kb(d,c)}
function Ib(a,b){var c,d,e;if("/"!=b&&"//"!=b)throw Error('Step op should be "/" or "//"');if("."==S(a.a))return d=new U(yb,new G("node")),T(a.a),d;if(".."==S(a.a))return d=new U(xb,new G("node")),T(a.a),d;var f;if("@"==S(a.a))f=lb,T(a.a),W(a,"Missing attribute name");else if("::"==S(a.a,1)){if(!/(?![0-9])[\w]/.test(S(a.a).charAt(0)))throw Error("Bad token: "+T(a.a));c=T(a.a);f=wb[c]||null;if(!f)throw Error("No axis with name: "+c);T(a.a);W(a,"Missing node name")}else f=tb;c=S(a.a);if(/(?![0-9])[\w\*]/.test(c.charAt(0)))if("("==
S(a.a,1)){if(!db(c))throw Error("Invalid node type: "+c);c=T(a.a);if(!db(c))throw Error("Invalid type name: "+c);Eb(a,"(");W(a,"Bad nodetype");e=S(a.a).charAt(0);var g=null;if('"'==e||"'"==e)g=Gb(a);W(a,"Bad nodetype");Fb(a);c=new G(c,g)}else if(c=T(a.a),e=c.indexOf(":"),-1==e)c=new E(c);else{var g=c.substring(0,e),h;if("*"==g)h="*";else if(h=a.b(g),!h)throw Error("Namespace prefix not declared: "+g);c=c.substr(e+1);c=new E(c,h)}else throw Error("Bad token: "+T(a.a));e=new sb(Jb(a),f.a);return d||
new U(f,c,e,"//"==b)}function Jb(a){for(var b=[];"["==S(a.a);){T(a.a);W(a,"Missing predicate expression.");var c=Cb(a);b.push(c);W(a,"Unclosed predicate expression.");Eb(a,"]")}return b}function Db(a){if("-"==S(a.a))return T(a.a),new zb(Db(a));var b=Hb(a);if("|"!=S(a.a))a=b;else{for(b=[b];"|"==T(a.a);)W(a,"Missing next union location path."),b.push(Hb(a));a.a.a--;a=new rb(b)}return a};function Kb(a){switch(a.nodeType){case 1:return ea(Lb,a);case 9:return Kb(a.documentElement);case 11:case 10:case 6:case 12:return Mb;default:return a.parentNode?Kb(a.parentNode):Mb}}function Mb(){return null}function Lb(a,b){if(a.prefix==b)return a.namespaceURI||"http://www.w3.org/1999/xhtml";var c=a.getAttributeNode("xmlns:"+b);return c&&c.specified?c.value||null:a.parentNode&&9!=a.parentNode.nodeType?Lb(a.parentNode,b):null};function Nb(a,b){if(!a.length)throw Error("Empty XPath expression.");var c=fb(a);if(ib(c))throw Error("Invalid XPath expression.");b?"function"==aa(b)||(b=da(b.lookupNamespaceURI,b)):b=function(){return null};var d=Cb(new Bb(c,b));if(!ib(c))throw Error("Bad token: "+T(c));this.evaluate=function(a,b){var c=d.a(new Q(a));return new Y(c,b)}}
function Y(a,b){if(0==b)if(a instanceof C)b=4;else if("string"==typeof a)b=2;else if("number"==typeof a)b=1;else if("boolean"==typeof a)b=3;else throw Error("Unexpected evaluation result.");if(2!=b&&1!=b&&3!=b&&!(a instanceof C))throw Error("value could not be converted to the specified type");this.resultType=b;var c;switch(b){case 2:this.stringValue=a instanceof C?Sa(a):""+a;break;case 1:this.numberValue=a instanceof C?+Sa(a):+a;break;case 3:this.booleanValue=a instanceof C?0<a.l:!!a;break;case 4:case 5:case 6:case 7:var d=
H(a);c=[];for(var e=I(d);e;e=I(d))c.push(e instanceof x?e.a:e);this.snapshotLength=a.l;this.invalidIteratorState=!1;break;case 8:case 9:d=Ra(a);this.singleNodeValue=d instanceof x?d.a:d;break;default:throw Error("Unknown XPathResult type.");}var f=0;this.iterateNext=function(){if(4!=b&&5!=b)throw Error("iterateNext called with wrong result type");return f>=c.length?null:c[f++]};this.snapshotItem=function(a){if(6!=b&&7!=b)throw Error("snapshotItem called with wrong result type");return a>=c.length||
0>a?null:c[a]}}Y.ANY_TYPE=0;Y.NUMBER_TYPE=1;Y.STRING_TYPE=2;Y.BOOLEAN_TYPE=3;Y.UNORDERED_NODE_ITERATOR_TYPE=4;Y.ORDERED_NODE_ITERATOR_TYPE=5;Y.UNORDERED_NODE_SNAPSHOT_TYPE=6;Y.ORDERED_NODE_SNAPSHOT_TYPE=7;Y.ANY_UNORDERED_NODE_TYPE=8;Y.FIRST_ORDERED_NODE_TYPE=9;function Ob(a){this.lookupNamespaceURI=Kb(a)}
function Pb(a,b){var c=a||k,d=c.Document&&c.Document.prototype||c.document;if(!d.evaluate||b)c.XPathResult=Y,d.evaluate=function(a,b,c,d){return(new Nb(a,c)).evaluate(b,d)},d.createExpression=function(a,b){return new Nb(a,b)},d.createNSResolver=function(a){return new Ob(a)}}var Qb=["wgxpath","install"],Z=k;Qb[0]in Z||!Z.execScript||Z.execScript("var "+Qb[0]);for(var Rb;Qb.length&&(Rb=Qb.shift());)Qb.length||void 0===Pb?Z[Rb]?Z=Z[Rb]:Z=Z[Rb]={}:Z[Rb]=Pb;}).call(this)
