//! This file is auto-generated by tools/update_cpu_features.zig.

const std = @import("../std.zig");
const CpuFeature = std.Target.Cpu.Feature;
const CpuModel = std.Target.Cpu.Model;

pub const Feature = enum {
    @"64bit",
    a,
    c,
    d,
    e,
    experimental_zbe,
    experimental_zbf,
    experimental_zbm,
    experimental_zbp,
    experimental_zbr,
    experimental_zbt,
    experimental_zvfh,
    f,
    lui_addi_fusion,
    m,
    no_default_unroll,
    no_rvc_hints,
    relax,
    reserve_x1,
    reserve_x10,
    reserve_x11,
    reserve_x12,
    reserve_x13,
    reserve_x14,
    reserve_x15,
    reserve_x16,
    reserve_x17,
    reserve_x18,
    reserve_x19,
    reserve_x2,
    reserve_x20,
    reserve_x21,
    reserve_x22,
    reserve_x23,
    reserve_x24,
    reserve_x25,
    reserve_x26,
    reserve_x27,
    reserve_x28,
    reserve_x29,
    reserve_x3,
    reserve_x30,
    reserve_x31,
    reserve_x4,
    reserve_x5,
    reserve_x6,
    reserve_x7,
    reserve_x8,
    reserve_x9,
    save_restore,
    unaligned_scalar_mem,
    v,
    zba,
    zbb,
    zbc,
    zbkb,
    zbkc,
    zbkx,
    zbs,
    zdinx,
    zfh,
    zfhmin,
    zfinx,
    zhinx,
    zhinxmin,
    zicbom,
    zicbop,
    zicboz,
    zihintpause,
    zk,
    zkn,
    zknd,
    zkne,
    zknh,
    zkr,
    zks,
    zksed,
    zksh,
    zkt,
    zmmul,
    zve32f,
    zve32x,
    zve64d,
    zve64f,
    zve64x,
    zvl1024b,
    zvl128b,
    zvl16384b,
    zvl2048b,
    zvl256b,
    zvl32768b,
    zvl32b,
    zvl4096b,
    zvl512b,
    zvl64b,
    zvl8192b,
};

pub const featureSet = CpuFeature.feature_set_fns(Feature).featureSet;
pub const featureSetHas = CpuFeature.feature_set_fns(Feature).featureSetHas;
pub const featureSetHasAny = CpuFeature.feature_set_fns(Feature).featureSetHasAny;
pub const featureSetHasAll = CpuFeature.feature_set_fns(Feature).featureSetHasAll;

pub const all_features = blk: {
    const len = @typeInfo(Feature).Enum.fields.len;
    std.debug.assert(len <= CpuFeature.Set.needed_bit_count);
    var result: [len]CpuFeature = undefined;
    result[@enumToInt(Feature.@"64bit")] = .{
        .llvm_name = "64bit",
        .description = "Implements RV64",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.a)] = .{
        .llvm_name = "a",
        .description = "'A' (Atomic Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.c)] = .{
        .llvm_name = "c",
        .description = "'C' (Compressed Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.d)] = .{
        .llvm_name = "d",
        .description = "'D' (Double-Precision Floating-Point)",
        .dependencies = featureSet(&[_]Feature{
            .f,
        }),
    };
    result[@enumToInt(Feature.e)] = .{
        .llvm_name = "e",
        .description = "Implements RV32E (provides 16 rather than 32 GPRs)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.experimental_zbe)] = .{
        .llvm_name = "experimental-zbe",
        .description = "'Zbe' (Extract-Deposit 'Zb' Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.experimental_zbf)] = .{
        .llvm_name = "experimental-zbf",
        .description = "'Zbf' (Bit-Field 'Zb' Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.experimental_zbm)] = .{
        .llvm_name = "experimental-zbm",
        .description = "'Zbm' (Matrix 'Zb' Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.experimental_zbp)] = .{
        .llvm_name = "experimental-zbp",
        .description = "'Zbp' (Permutation 'Zb' Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.experimental_zbr)] = .{
        .llvm_name = "experimental-zbr",
        .description = "'Zbr' (Polynomial Reduction 'Zb' Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.experimental_zbt)] = .{
        .llvm_name = "experimental-zbt",
        .description = "'Zbt' (Ternary 'Zb' Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.experimental_zvfh)] = .{
        .llvm_name = "experimental-zvfh",
        .description = "'Zvfh' (Vector Half-Precision Floating-Point)",
        .dependencies = featureSet(&[_]Feature{
            .zve32f,
        }),
    };
    result[@enumToInt(Feature.f)] = .{
        .llvm_name = "f",
        .description = "'F' (Single-Precision Floating-Point)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.lui_addi_fusion)] = .{
        .llvm_name = "lui-addi-fusion",
        .description = "Enable LUI+ADDI macrofusion",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.m)] = .{
        .llvm_name = "m",
        .description = "'M' (Integer Multiplication and Division)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.no_default_unroll)] = .{
        .llvm_name = "no-default-unroll",
        .description = "Disable default unroll preference.",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.no_rvc_hints)] = .{
        .llvm_name = "no-rvc-hints",
        .description = "Disable RVC Hint Instructions.",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.relax)] = .{
        .llvm_name = "relax",
        .description = "Enable Linker relaxation.",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x1)] = .{
        .llvm_name = "reserve-x1",
        .description = "Reserve X1",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x10)] = .{
        .llvm_name = "reserve-x10",
        .description = "Reserve X10",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x11)] = .{
        .llvm_name = "reserve-x11",
        .description = "Reserve X11",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x12)] = .{
        .llvm_name = "reserve-x12",
        .description = "Reserve X12",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x13)] = .{
        .llvm_name = "reserve-x13",
        .description = "Reserve X13",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x14)] = .{
        .llvm_name = "reserve-x14",
        .description = "Reserve X14",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x15)] = .{
        .llvm_name = "reserve-x15",
        .description = "Reserve X15",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x16)] = .{
        .llvm_name = "reserve-x16",
        .description = "Reserve X16",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x17)] = .{
        .llvm_name = "reserve-x17",
        .description = "Reserve X17",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x18)] = .{
        .llvm_name = "reserve-x18",
        .description = "Reserve X18",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x19)] = .{
        .llvm_name = "reserve-x19",
        .description = "Reserve X19",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x2)] = .{
        .llvm_name = "reserve-x2",
        .description = "Reserve X2",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x20)] = .{
        .llvm_name = "reserve-x20",
        .description = "Reserve X20",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x21)] = .{
        .llvm_name = "reserve-x21",
        .description = "Reserve X21",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x22)] = .{
        .llvm_name = "reserve-x22",
        .description = "Reserve X22",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x23)] = .{
        .llvm_name = "reserve-x23",
        .description = "Reserve X23",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x24)] = .{
        .llvm_name = "reserve-x24",
        .description = "Reserve X24",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x25)] = .{
        .llvm_name = "reserve-x25",
        .description = "Reserve X25",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x26)] = .{
        .llvm_name = "reserve-x26",
        .description = "Reserve X26",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x27)] = .{
        .llvm_name = "reserve-x27",
        .description = "Reserve X27",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x28)] = .{
        .llvm_name = "reserve-x28",
        .description = "Reserve X28",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x29)] = .{
        .llvm_name = "reserve-x29",
        .description = "Reserve X29",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x3)] = .{
        .llvm_name = "reserve-x3",
        .description = "Reserve X3",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x30)] = .{
        .llvm_name = "reserve-x30",
        .description = "Reserve X30",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x31)] = .{
        .llvm_name = "reserve-x31",
        .description = "Reserve X31",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x4)] = .{
        .llvm_name = "reserve-x4",
        .description = "Reserve X4",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x5)] = .{
        .llvm_name = "reserve-x5",
        .description = "Reserve X5",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x6)] = .{
        .llvm_name = "reserve-x6",
        .description = "Reserve X6",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x7)] = .{
        .llvm_name = "reserve-x7",
        .description = "Reserve X7",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x8)] = .{
        .llvm_name = "reserve-x8",
        .description = "Reserve X8",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.reserve_x9)] = .{
        .llvm_name = "reserve-x9",
        .description = "Reserve X9",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.save_restore)] = .{
        .llvm_name = "save-restore",
        .description = "Enable save/restore.",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.unaligned_scalar_mem)] = .{
        .llvm_name = "unaligned-scalar-mem",
        .description = "Has reasonably performant unaligned scalar loads and stores",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.v)] = .{
        .llvm_name = "v",
        .description = "'V' (Vector Extension for Application Processors)",
        .dependencies = featureSet(&[_]Feature{
            .d,
            .zve64d,
            .zvl128b,
        }),
    };
    result[@enumToInt(Feature.zba)] = .{
        .llvm_name = "zba",
        .description = "'Zba' (Address Generation Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zbb)] = .{
        .llvm_name = "zbb",
        .description = "'Zbb' (Basic Bit-Manipulation)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zbc)] = .{
        .llvm_name = "zbc",
        .description = "'Zbc' (Carry-Less Multiplication)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zbkb)] = .{
        .llvm_name = "zbkb",
        .description = "'Zbkb' (Bitmanip instructions for Cryptography)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zbkc)] = .{
        .llvm_name = "zbkc",
        .description = "'Zbkc' (Carry-less multiply instructions for Cryptography)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zbkx)] = .{
        .llvm_name = "zbkx",
        .description = "'Zbkx' (Crossbar permutation instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zbs)] = .{
        .llvm_name = "zbs",
        .description = "'Zbs' (Single-Bit Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zdinx)] = .{
        .llvm_name = "zdinx",
        .description = "'Zdinx' (Double in Integer)",
        .dependencies = featureSet(&[_]Feature{
            .zfinx,
        }),
    };
    result[@enumToInt(Feature.zfh)] = .{
        .llvm_name = "zfh",
        .description = "'Zfh' (Half-Precision Floating-Point)",
        .dependencies = featureSet(&[_]Feature{
            .f,
        }),
    };
    result[@enumToInt(Feature.zfhmin)] = .{
        .llvm_name = "zfhmin",
        .description = "'Zfhmin' (Half-Precision Floating-Point Minimal)",
        .dependencies = featureSet(&[_]Feature{
            .f,
        }),
    };
    result[@enumToInt(Feature.zfinx)] = .{
        .llvm_name = "zfinx",
        .description = "'Zfinx' (Float in Integer)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zhinx)] = .{
        .llvm_name = "zhinx",
        .description = "'Zhinx' (Half Float in Integer)",
        .dependencies = featureSet(&[_]Feature{
            .zfinx,
        }),
    };
    result[@enumToInt(Feature.zhinxmin)] = .{
        .llvm_name = "zhinxmin",
        .description = "'Zhinxmin' (Half Float in Integer Minimal)",
        .dependencies = featureSet(&[_]Feature{
            .zfinx,
        }),
    };
    result[@enumToInt(Feature.zicbom)] = .{
        .llvm_name = "zicbom",
        .description = "'Zicbom' (Cache-Block Management Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zicbop)] = .{
        .llvm_name = "zicbop",
        .description = "'Zicbop' (Cache-Block Prefetch Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zicboz)] = .{
        .llvm_name = "zicboz",
        .description = "'Zicboz' (Cache-Block Zero Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zihintpause)] = .{
        .llvm_name = "zihintpause",
        .description = "'zihintpause' (Pause Hint)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zk)] = .{
        .llvm_name = "zk",
        .description = "'Zk' (Standard scalar cryptography extension)",
        .dependencies = featureSet(&[_]Feature{
            .zkn,
            .zkr,
            .zkt,
        }),
    };
    result[@enumToInt(Feature.zkn)] = .{
        .llvm_name = "zkn",
        .description = "'Zkn' (NIST Algorithm Suite)",
        .dependencies = featureSet(&[_]Feature{
            .zbkb,
            .zbkc,
            .zbkx,
            .zknd,
            .zkne,
            .zknh,
        }),
    };
    result[@enumToInt(Feature.zknd)] = .{
        .llvm_name = "zknd",
        .description = "'Zknd' (NIST Suite: AES Decryption)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zkne)] = .{
        .llvm_name = "zkne",
        .description = "'Zkne' (NIST Suite: AES Encryption)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zknh)] = .{
        .llvm_name = "zknh",
        .description = "'Zknh' (NIST Suite: Hash Function Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zkr)] = .{
        .llvm_name = "zkr",
        .description = "'Zkr' (Entropy Source Extension)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zks)] = .{
        .llvm_name = "zks",
        .description = "'Zks' (ShangMi Algorithm Suite)",
        .dependencies = featureSet(&[_]Feature{
            .zbkb,
            .zbkc,
            .zbkx,
            .zksed,
            .zksh,
        }),
    };
    result[@enumToInt(Feature.zksed)] = .{
        .llvm_name = "zksed",
        .description = "'Zksed' (ShangMi Suite: SM4 Block Cipher Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zksh)] = .{
        .llvm_name = "zksh",
        .description = "'Zksh' (ShangMi Suite: SM3 Hash Function Instructions)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zkt)] = .{
        .llvm_name = "zkt",
        .description = "'Zkt' (Data Independent Execution Latency)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zmmul)] = .{
        .llvm_name = "zmmul",
        .description = "'Zmmul' (Integer Multiplication)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zve32f)] = .{
        .llvm_name = "zve32f",
        .description = "'Zve32f' (Vector Extensions for Embedded Processors with maximal 32 EEW and F extension)",
        .dependencies = featureSet(&[_]Feature{
            .zve32x,
        }),
    };
    result[@enumToInt(Feature.zve32x)] = .{
        .llvm_name = "zve32x",
        .description = "'Zve32x' (Vector Extensions for Embedded Processors with maximal 32 EEW)",
        .dependencies = featureSet(&[_]Feature{
            .zvl32b,
        }),
    };
    result[@enumToInt(Feature.zve64d)] = .{
        .llvm_name = "zve64d",
        .description = "'Zve64d' (Vector Extensions for Embedded Processors with maximal 64 EEW, F and D extension)",
        .dependencies = featureSet(&[_]Feature{
            .zve64f,
        }),
    };
    result[@enumToInt(Feature.zve64f)] = .{
        .llvm_name = "zve64f",
        .description = "'Zve64f' (Vector Extensions for Embedded Processors with maximal 64 EEW and F extension)",
        .dependencies = featureSet(&[_]Feature{
            .zve32f,
            .zve64x,
        }),
    };
    result[@enumToInt(Feature.zve64x)] = .{
        .llvm_name = "zve64x",
        .description = "'Zve64x' (Vector Extensions for Embedded Processors with maximal 64 EEW)",
        .dependencies = featureSet(&[_]Feature{
            .zve32x,
            .zvl64b,
        }),
    };
    result[@enumToInt(Feature.zvl1024b)] = .{
        .llvm_name = "zvl1024b",
        .description = "'Zvl' (Minimum Vector Length) 1024",
        .dependencies = featureSet(&[_]Feature{
            .zvl512b,
        }),
    };
    result[@enumToInt(Feature.zvl128b)] = .{
        .llvm_name = "zvl128b",
        .description = "'Zvl' (Minimum Vector Length) 128",
        .dependencies = featureSet(&[_]Feature{
            .zvl64b,
        }),
    };
    result[@enumToInt(Feature.zvl16384b)] = .{
        .llvm_name = "zvl16384b",
        .description = "'Zvl' (Minimum Vector Length) 16384",
        .dependencies = featureSet(&[_]Feature{
            .zvl8192b,
        }),
    };
    result[@enumToInt(Feature.zvl2048b)] = .{
        .llvm_name = "zvl2048b",
        .description = "'Zvl' (Minimum Vector Length) 2048",
        .dependencies = featureSet(&[_]Feature{
            .zvl1024b,
        }),
    };
    result[@enumToInt(Feature.zvl256b)] = .{
        .llvm_name = "zvl256b",
        .description = "'Zvl' (Minimum Vector Length) 256",
        .dependencies = featureSet(&[_]Feature{
            .zvl128b,
        }),
    };
    result[@enumToInt(Feature.zvl32768b)] = .{
        .llvm_name = "zvl32768b",
        .description = "'Zvl' (Minimum Vector Length) 32768",
        .dependencies = featureSet(&[_]Feature{
            .zvl16384b,
        }),
    };
    result[@enumToInt(Feature.zvl32b)] = .{
        .llvm_name = "zvl32b",
        .description = "'Zvl' (Minimum Vector Length) 32",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@enumToInt(Feature.zvl4096b)] = .{
        .llvm_name = "zvl4096b",
        .description = "'Zvl' (Minimum Vector Length) 4096",
        .dependencies = featureSet(&[_]Feature{
            .zvl2048b,
        }),
    };
    result[@enumToInt(Feature.zvl512b)] = .{
        .llvm_name = "zvl512b",
        .description = "'Zvl' (Minimum Vector Length) 512",
        .dependencies = featureSet(&[_]Feature{
            .zvl256b,
        }),
    };
    result[@enumToInt(Feature.zvl64b)] = .{
        .llvm_name = "zvl64b",
        .description = "'Zvl' (Minimum Vector Length) 64",
        .dependencies = featureSet(&[_]Feature{
            .zvl32b,
        }),
    };
    result[@enumToInt(Feature.zvl8192b)] = .{
        .llvm_name = "zvl8192b",
        .description = "'Zvl' (Minimum Vector Length) 8192",
        .dependencies = featureSet(&[_]Feature{
            .zvl4096b,
        }),
    };
    const ti = @typeInfo(Feature);
    for (result) |*elem, i| {
        elem.index = i;
        elem.name = ti.Enum.fields[i].name;
    }
    break :blk result;
};

pub const cpu = struct {
    pub const baseline_rv32 = CpuModel{
        .name = "baseline_rv32",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .a,
            .c,
            .d,
            .m,
        }),
    };
    pub const baseline_rv64 = CpuModel{
        .name = "baseline_rv64",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .d,
            .m,
        }),
    };
    pub const generic = CpuModel{
        .name = "generic",
        .llvm_name = "generic",
        .features = featureSet(&[_]Feature{}),
    };
    pub const generic_rv32 = CpuModel{
        .name = "generic_rv32",
        .llvm_name = "generic-rv32",
        .features = featureSet(&[_]Feature{}),
    };
    pub const generic_rv64 = CpuModel{
        .name = "generic_rv64",
        .llvm_name = "generic-rv64",
        .features = featureSet(&[_]Feature{
            .@"64bit",
        }),
    };
    pub const rocket_rv32 = CpuModel{
        .name = "rocket_rv32",
        .llvm_name = "rocket-rv32",
        .features = featureSet(&[_]Feature{}),
    };
    pub const rocket_rv64 = CpuModel{
        .name = "rocket_rv64",
        .llvm_name = "rocket-rv64",
        .features = featureSet(&[_]Feature{
            .@"64bit",
        }),
    };
    pub const sifive_7_rv32 = CpuModel{
        .name = "sifive_7_rv32",
        .llvm_name = "sifive-7-rv32",
        .features = featureSet(&[_]Feature{
            .no_default_unroll,
        }),
    };
    pub const sifive_7_rv64 = CpuModel{
        .name = "sifive_7_rv64",
        .llvm_name = "sifive-7-rv64",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .no_default_unroll,
        }),
    };
    pub const sifive_e20 = CpuModel{
        .name = "sifive_e20",
        .llvm_name = "sifive-e20",
        .features = featureSet(&[_]Feature{
            .c,
            .m,
        }),
    };
    pub const sifive_e21 = CpuModel{
        .name = "sifive_e21",
        .llvm_name = "sifive-e21",
        .features = featureSet(&[_]Feature{
            .a,
            .c,
            .m,
        }),
    };
    pub const sifive_e24 = CpuModel{
        .name = "sifive_e24",
        .llvm_name = "sifive-e24",
        .features = featureSet(&[_]Feature{
            .a,
            .c,
            .f,
            .m,
        }),
    };
    pub const sifive_e31 = CpuModel{
        .name = "sifive_e31",
        .llvm_name = "sifive-e31",
        .features = featureSet(&[_]Feature{
            .a,
            .c,
            .m,
        }),
    };
    pub const sifive_e34 = CpuModel{
        .name = "sifive_e34",
        .llvm_name = "sifive-e34",
        .features = featureSet(&[_]Feature{
            .a,
            .c,
            .f,
            .m,
        }),
    };
    pub const sifive_e76 = CpuModel{
        .name = "sifive_e76",
        .llvm_name = "sifive-e76",
        .features = featureSet(&[_]Feature{
            .a,
            .c,
            .f,
            .m,
            .no_default_unroll,
        }),
    };
    pub const sifive_s21 = CpuModel{
        .name = "sifive_s21",
        .llvm_name = "sifive-s21",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .m,
        }),
    };
    pub const sifive_s51 = CpuModel{
        .name = "sifive_s51",
        .llvm_name = "sifive-s51",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .m,
        }),
    };
    pub const sifive_s54 = CpuModel{
        .name = "sifive_s54",
        .llvm_name = "sifive-s54",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .d,
            .m,
        }),
    };
    pub const sifive_s76 = CpuModel{
        .name = "sifive_s76",
        .llvm_name = "sifive-s76",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .d,
            .m,
            .no_default_unroll,
        }),
    };
    pub const sifive_u54 = CpuModel{
        .name = "sifive_u54",
        .llvm_name = "sifive-u54",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .d,
            .m,
        }),
    };
    pub const sifive_u74 = CpuModel{
        .name = "sifive_u74",
        .llvm_name = "sifive-u74",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .a,
            .c,
            .d,
            .m,
            .no_default_unroll,
        }),
    };
};
