// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/index_endpoint_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_INDEX_ENDPOINT_TRACING_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_INDEX_ENDPOINT_TRACING_STUB_H

#include "google/cloud/aiplatform/v1/internal/index_endpoint_stub.h"
#include "google/cloud/internal/trace_propagator.h"
#include "google/cloud/options.h"
#include "google/cloud/version.h"

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class IndexEndpointServiceTracingStub : public IndexEndpointServiceStub {
 public:
  ~IndexEndpointServiceTracingStub() override = default;

  explicit IndexEndpointServiceTracingStub(
      std::shared_ptr<IndexEndpointServiceStub> child);

  future<StatusOr<google::longrunning::Operation>> AsyncCreateIndexEndpoint(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::aiplatform::v1::CreateIndexEndpointRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::IndexEndpoint> GetIndexEndpoint(
      grpc::ClientContext& context,
      google::cloud::aiplatform::v1::GetIndexEndpointRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::ListIndexEndpointsResponse>
  ListIndexEndpoints(
      grpc::ClientContext& context,
      google::cloud::aiplatform::v1::ListIndexEndpointsRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::IndexEndpoint> UpdateIndexEndpoint(
      grpc::ClientContext& context,
      google::cloud::aiplatform::v1::UpdateIndexEndpointRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteIndexEndpoint(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::aiplatform::v1::DeleteIndexEndpointRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeployIndex(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::aiplatform::v1::DeployIndexRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncUndeployIndex(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::aiplatform::v1::UndeployIndexRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncMutateDeployedIndex(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::aiplatform::v1::MutateDeployedIndexRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::shared_ptr<IndexEndpointServiceStub> child_;
  std::shared_ptr<opentelemetry::context::propagation::TextMapPropagator>
      propagator_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Applies the tracing decorator to the given stub.
 *
 * The stub is only decorated if the library has been compiled with
 * OpenTelemetry.
 */
std::shared_ptr<IndexEndpointServiceStub> MakeIndexEndpointServiceTracingStub(
    std::shared_ptr<IndexEndpointServiceStub> stub);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_INDEX_ENDPOINT_TRACING_STUB_H
