// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/pipeline_service.proto

#include "google/cloud/aiplatform/v1/internal/pipeline_connection_impl.h"
#include "google/cloud/aiplatform/v1/internal/pipeline_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<aiplatform_v1::PipelineServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<aiplatform_v1::PipelineServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<aiplatform_v1::PipelineServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<aiplatform_v1::PipelineServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<aiplatform_v1::PipelineServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<aiplatform_v1::PipelineServicePollingPolicyOption>()
      ->clone();
}

}  // namespace

PipelineServiceConnectionImpl::PipelineServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<aiplatform_v1_internal::PipelineServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      PipelineServiceConnection::options())) {}

StatusOr<google::cloud::aiplatform::v1::TrainingPipeline>
PipelineServiceConnectionImpl::CreateTrainingPipeline(
    google::cloud::aiplatform::v1::CreateTrainingPipelineRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateTrainingPipeline(request),
      [this](grpc::ClientContext& context,
             google::cloud::aiplatform::v1::CreateTrainingPipelineRequest const&
                 request) {
        return stub_->CreateTrainingPipeline(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::aiplatform::v1::TrainingPipeline>
PipelineServiceConnectionImpl::GetTrainingPipeline(
    google::cloud::aiplatform::v1::GetTrainingPipelineRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetTrainingPipeline(request),
      [this](grpc::ClientContext& context,
             google::cloud::aiplatform::v1::GetTrainingPipelineRequest const&
                 request) {
        return stub_->GetTrainingPipeline(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::aiplatform::v1::TrainingPipeline>
PipelineServiceConnectionImpl::ListTrainingPipelines(
    google::cloud::aiplatform::v1::ListTrainingPipelinesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListTrainingPipelines(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::aiplatform::v1::TrainingPipeline>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<aiplatform_v1::PipelineServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::aiplatform::v1::ListTrainingPipelinesRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::aiplatform::v1::
                       ListTrainingPipelinesRequest const& request) {
              return stub->ListTrainingPipelines(context, request);
            },
            r, function_name);
      },
      [](google::cloud::aiplatform::v1::ListTrainingPipelinesResponse r) {
        std::vector<google::cloud::aiplatform::v1::TrainingPipeline> result(
            r.training_pipelines().size());
        auto& messages = *r.mutable_training_pipelines();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
PipelineServiceConnectionImpl::DeleteTrainingPipeline(
    google::cloud::aiplatform::v1::DeleteTrainingPipelineRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::DeleteOperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::DeleteTrainingPipelineRequest const&
              request) {
        return stub->AsyncDeleteTrainingPipeline(cq, std::move(context),
                                                 options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::aiplatform::v1::DeleteOperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteTrainingPipeline(request),
      polling_policy(*current), __func__);
}

Status PipelineServiceConnectionImpl::CancelTrainingPipeline(
    google::cloud::aiplatform::v1::CancelTrainingPipelineRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CancelTrainingPipeline(request),
      [this](grpc::ClientContext& context,
             google::cloud::aiplatform::v1::CancelTrainingPipelineRequest const&
                 request) {
        return stub_->CancelTrainingPipeline(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::aiplatform::v1::PipelineJob>
PipelineServiceConnectionImpl::CreatePipelineJob(
    google::cloud::aiplatform::v1::CreatePipelineJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreatePipelineJob(request),
      [this](grpc::ClientContext& context,
             google::cloud::aiplatform::v1::CreatePipelineJobRequest const&
                 request) {
        return stub_->CreatePipelineJob(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::aiplatform::v1::PipelineJob>
PipelineServiceConnectionImpl::GetPipelineJob(
    google::cloud::aiplatform::v1::GetPipelineJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetPipelineJob(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::aiplatform::v1::GetPipelineJobRequest const& request) {
        return stub_->GetPipelineJob(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::aiplatform::v1::PipelineJob>
PipelineServiceConnectionImpl::ListPipelineJobs(
    google::cloud::aiplatform::v1::ListPipelineJobsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListPipelineJobs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::aiplatform::v1::PipelineJob>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<aiplatform_v1::PipelineServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::aiplatform::v1::ListPipelineJobsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::aiplatform::v1::ListPipelineJobsRequest const&
                       request) {
              return stub->ListPipelineJobs(context, request);
            },
            r, function_name);
      },
      [](google::cloud::aiplatform::v1::ListPipelineJobsResponse r) {
        std::vector<google::cloud::aiplatform::v1::PipelineJob> result(
            r.pipeline_jobs().size());
        auto& messages = *r.mutable_pipeline_jobs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
PipelineServiceConnectionImpl::DeletePipelineJob(
    google::cloud::aiplatform::v1::DeletePipelineJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::DeleteOperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::DeletePipelineJobRequest const&
              request) {
        return stub->AsyncDeletePipelineJob(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::aiplatform::v1::DeleteOperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeletePipelineJob(request),
      polling_policy(*current), __func__);
}

Status PipelineServiceConnectionImpl::CancelPipelineJob(
    google::cloud::aiplatform::v1::CancelPipelineJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CancelPipelineJob(request),
      [this](grpc::ClientContext& context,
             google::cloud::aiplatform::v1::CancelPipelineJobRequest const&
                 request) {
        return stub_->CancelPipelineJob(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
